/*
 * Decompiled with CFR 0.152.
 */
package project;

public class ColorProcessor {
    public static int[] crc_table;

    public static byte[] getImage(byte[] data, int offset, int colorLen) {
        int checksum = ColorProcessor.checksum(data, offset - 4, colorLen + 4);
        data[offset + colorLen] = (byte)(checksum >> 24 & 0xFF);
        data[offset + colorLen + 1] = (byte)(checksum >> 16 & 0xFF);
        data[offset + colorLen + 2] = (byte)(checksum >> 8 & 0xFF);
        data[offset + colorLen + 3] = (byte)(checksum & 0xFF);
        return data;
    }

    private static int checksum(byte[] buf, int off, int len) {
        return ~ColorProcessor.update_crc(buf, off, len);
    }

    private static int update_crc(byte[] buf, int off, int len) {
        int c = -1;
        if (crc_table == null) {
            ColorProcessor.make_crc_table();
        }
        int n = off;
        while (n < len + off) {
            c = crc_table[(c ^ buf[n]) & 0xFF] ^ c >>> 8;
            ++n;
        }
        return c;
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1) == 1 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                ++k;
            }
            ColorProcessor.crc_table[n] = c;
            ++n;
        }
    }

    public static byte[] ChangeColor(byte[] ImageData, int[] color) throws IndexOutOfBoundsException {
        int offset = 0;
        int colorLen = 0;
        byte[] res = null;
        int i = 0;
        while (i < ImageData.length) {
            if (ImageData[i] == 80 && ImageData[i + 1] == 76 && ImageData[i + 2] == 84 && ImageData[i + 3] == 69) {
                offset = i + 4;
                break;
            }
            ++i;
        }
        i = 3;
        while (i >= 0) {
            colorLen |= (ImageData[offset - 5 - i] & 0xFF) << (i << 3);
            --i;
        }
        if (colorLen / 3 != color.length) {
            throw new IndexOutOfBoundsException();
        }
        int[] oldColor = new int[color.length];
        int j = 0;
        while (j < color.length) {
            oldColor[j] = (ImageData[offset + j * 3] & 0xFF) << 16 | (ImageData[offset + j * 3 + 1] & 0xFF) << 8 | ImageData[offset + j * 3 + 2] & 0xFF;
            ++j;
        }
        boolean notChange = true;
        int i2 = 0;
        while (i2 < color.length) {
            notChange &= oldColor[i2] == color[i2];
            ++i2;
        }
        if (!notChange) {
            i2 = 0;
            while (i2 < color.length) {
                ImageData[offset + i2 * 3] = (byte)(color[i2] >> 16 & 0xFF);
                ImageData[offset + i2 * 3 + 1] = (byte)(color[i2] >> 8 & 0xFF);
                ImageData[offset + i2 * 3 + 2] = (byte)(color[i2] & 0xFF);
                ++i2;
            }
            res = ColorProcessor.getImage(ImageData, offset, colorLen);
        }
        return res;
    }
}

