/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.ui;

import com.jarbull.efw.manager.Action;
import com.jarbull.efw.manager.Advertisement;
import com.jarbull.efw.manager.GameModeHandler;
import com.jarbull.efw.text.TextWriter;
import com.jarbull.efw.ui.Component;
import com.jarbull.efw.ui.IFocusable;
import com.jarbull.efw.util.StringEx;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AdPanel
extends Component
implements IFocusable {
    private boolean selected = false;
    private Advertisement advertisement;
    private int adStartX;
    private int adStartY;
    private int adEndX;
    private int adEndY;

    public AdPanel(String id) {
        super(id);
        this.width = 150;
        this.height = 150;
        this.x = 0;
        this.y = 0;
    }

    Advertisement getAdvertisement() {
        return this.advertisement;
    }

    void setAdvertisement(Advertisement advertisement) {
        if (advertisement == null) {
            return;
        }
        this.advertisement = advertisement;
    }

    public void paint(Graphics g) {
        if (!this.visible || GameModeHandler.getInstance().getMode() != 2 && GameModeHandler.getInstance().getMode() != 0) {
            return;
        }
        g.translate(this.x, this.y);
        this.saveClip(g);
        if (this.clipRegionActivated) {
            g.setClip(this.compClipX, this.compClipY, this.compClipW, this.compClipH);
        } else {
            g.setClip(0, 0, this.width, this.height);
        }
        if (this.bgColor != -1) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.width, this.height);
        }
        if (this.bg != null) {
            this.bg.paint(g);
        }
        long currentTime = System.currentTimeMillis();
        if (this.advertisement == null) {
            this.adStartX = 0;
            this.adStartY = 0;
            this.adEndX = 0;
            this.adEndY = 0;
            this.setAdvertisement(GameModeHandler.getInstance().getAd());
        } else if (!GameModeHandler.getInstance().isAlive(this.advertisement, true)) {
            this.advertisement = null;
            if (!GameModeHandler.getInstance().isLoadingAds()) {
                this.setAdvertisement(GameModeHandler.getInstance().getAd());
            }
        } else if (this.advertisement.getAdType() == 1) {
            Image adImage = (Image)this.advertisement.getAdData();
            if (adImage.getWidth() > this.width) {
                this.adStartX = 0;
                this.adEndX = this.width;
            } else {
                this.adStartX = (this.width - adImage.getWidth()) / 2;
                this.adEndX = (this.width + adImage.getWidth()) / 2;
            }
            if (adImage.getHeight() > this.height) {
                this.adStartY = 0;
                this.adEndY = this.height;
            } else {
                this.adStartY = (this.height - adImage.getHeight()) / 2;
                this.adEndY = (this.height + adImage.getHeight()) / 2;
            }
            g.drawImage(adImage, this.adStartX, this.adStartY, 0);
            adImage = null;
        } else if (this.advertisement.getAdType() == 0) {
            TextWriter.getInstance().saveState();
            TextWriter.getInstance().setWriterType(2);
            g.setColor(this.fgColor);
            String adText = (String)this.advertisement.getAdData();
            int adTextWidth = TextWriter.getInstance().getTextWidth(adText);
            int adTextHeight = TextWriter.getInstance().getTextHeight(adText);
            if (adTextWidth <= this.width) {
                this.adStartX = (this.width - adTextWidth) / 2;
                this.adStartY = (this.height - adTextHeight) / 2;
                this.adEndX = (this.width + adTextWidth) / 2;
                this.adEndY = (this.height + adTextHeight) / 2;
                TextWriter.getInstance().drawText(g, adText, this.adStartX, this.adStartY);
            } else {
                int startY;
                String[] words = StringEx.split(adText, " ");
                int rowNo = adTextWidth % this.width == 0 ? adTextWidth / this.width : adTextWidth / this.width + 1;
                int startX = 0;
                this.adStartX = 0;
                this.adEndX = this.width;
                this.adStartY = startY = (this.height - rowNo * adTextHeight) / 2;
                this.adEndY = (this.height + rowNo * adTextHeight) / 2;
                for (int i = 0; i < words.length; ++i) {
                    TextWriter.getInstance().drawText(g, words[i], startX, startY);
                    if (i + 2 > words.length || (startX += TextWriter.getInstance().getTextWidth(words[i] + " ")) + TextWriter.getInstance().getTextWidth(words[i + 1] + " ") <= this.width) continue;
                    startY += TextWriter.getInstance().getTextHeight(" ");
                    startX = 0;
                }
            }
            TextWriter.getInstance().restoreState();
        }
        if (this.fg != null) {
            this.fg.paint(g);
        }
        g.setColor(this.borderColor);
        for (int i = 0; i < this.borderSize; ++i) {
            g.drawRect(i, i, this.width - 2 * i - 1, this.height - 2 * i - 1);
        }
        if (this.selected) {
            g.setColor(255, 0, 0);
            g.drawRect(this.adStartX, this.adStartY, this.adEndX - this.adStartX, this.adEndY - this.adStartY);
        }
        this.restoreClip(g);
        g.translate(-this.x, -this.y);
    }

    public void setFocused(boolean focused) {
        if (focused && this.enabled && this.advertisement != null) {
            Action action = new Action(this, "OPENURL", this.advertisement.getAddress());
            action.doAction();
        }
    }

    public boolean isFocused() {
        return false;
    }

    public void setSelected(boolean selected) {
        if (GameModeHandler.getInstance().getMode() != 2 && GameModeHandler.getInstance().getMode() != 0) {
            this.selected = false;
            return;
        }
        if (this.actionListener != null && this.selected != selected) {
            if (selected) {
                this.actionListener.onSelected();
            } else {
                this.actionListener.onDeselected();
            }
        }
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public final void keyPressed(int keyCode) {
    }
}

