/*
 * Decompiled with CFR 0.152.
 */
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.SoundHandler;
import com.jarbull.efw.game.EFLayerManager;
import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.game.EFTiledLayer;
import com.jarbull.efw.game.LevelHolder;
import com.jarbull.efw.game.TimerHolder;
import com.jarbull.efw.io.KeyValuePair;
import com.jarbull.efw.manager.Action;
import com.jarbull.efw.manager.EGameCanvas;
import com.jarbull.efw.manager.EMidlet;
import com.jarbull.efw.manager.GameModeHandler;
import com.jarbull.efw.manager.Settings;
import com.jarbull.efw.text.TextWriter;
import constants.Data;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.TiledLayer;
import level.Level;
import subjects.Bomb;
import subjects.Charge;
import subjects.Enemy;
import subjects.Explosion;
import subjects.Gun;
import subjects.Hero;
import subjects.Mines;
import utilities.Background;
import utilities.Bar;
import utilities.Utils;
import utilities.ViewWindow;

class OperationTornadoCanvas
extends EGameCanvas {
    private int widthDisplay;
    private int heightDisplay;
    private int widthFon;
    private int heightFon;
    ViewWindow viewWindow;
    ViewWindow middleLm;
    EFLayerManager lm;
    private int index = 0;
    private int startIndex = 0;
    private int x_ViewWindow;
    private int y_ViewWindow;
    private int mx_ViewWindow;
    private int my_ViewWindow;
    private EFSprite levelComplete;
    private EFSprite meteor;
    Image barImg;
    TiledLayer backgroundBoard;
    Image fonImage;
    private Hero hero;
    private Enemy enemy;
    private Gun gun;
    private Charge charge;
    private Mines mine;
    private Bomb bomb;
    private Explosion explosion;
    private Background background;
    private Background middleBackground;
    private EFTiledLayer fon;
    private EFTiledLayer middleFon;
    private int animateSpaceTile1;
    private int animateSpaceTile3;
    private int animateSpaceTile5;
    private int scoreFon1 = 0;
    private int scoreFon3 = 0;
    private int scoreFon5 = 0;
    private Vector vectorCharges;
    private Vector vectorEnemies;
    private Vector vectorGuns;
    private Vector vectorMines;
    private Vector vectorBomb;
    private Vector vectorExplosion;
    private Vector vectorMeteors;
    private int[] arr = new int[]{31, 32, 33, 34, 35, 36};
    private Level level = new Level();
    private Bar bar;
    private boolean levelControl;
    private boolean gameOverControl;
    private char direction = (char)110;
    private boolean mainMove;
    private int[] seqCharges = new int[]{0, 1, 2, 3, 4, 5};
    private int[] seqMines = new int[]{6, 7, 8, 9, 10, 11};
    private int[] seqEnemies = new int[]{12, 13, 14, 15, 16, 17};
    private int[] seqMeteors = new int[]{18, 19, 20, 21, 22, 23};
    int l;
    private int vx;
    private int vy;
    private int fonPosX = 30;
    private int fonPosY = 10;
    private int score = 0;
    private int i = 0;
    private boolean isPlay;
    private int levelCursor;
    private boolean finishedLoading;
    private int[][] BACKFON = new int[][]{{1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 3, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1}, {1, 3, 3, 1, 3, 1, 1, 3, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {5, 6, 5, 6, 6, 6, 6, 1, 1, 1, 2, 1}, {1, 1, 2, 6, 1, 3, 6, 1, 3, 1, 2, 2}, {1, 3, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 6, 1, 2, 3, 1, 1, 1, 1, 3}, {1, 1, 1, 1, 1, 1, 6, 2, 1, 1, 3, 2}, {2, 2, 1, 1, 1, 1, 5, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 1, 1, 1, 3, 3, 2, 2, 1}, {2, 6, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1}, {2, 1, 1, 2, 2, 1, 1, 2, 1, 1, 5, 1}, {1, 3, 2, 1, 2, 3, 5, 5, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 5, 5, 1, 1}};

    public void levelChanged(int newLevel) {
        ImageHandler.getInstance().load("/img/backgroundBoard.png");
        this.fonImage = ImageHandler.getInstance().getImage("/img/backgroundBoard.png");
        this.backgroundBoard = new TiledLayer(12, 16, this.fonImage, 20, 20);
        for (int i = 0; i < this.BACKFON.length; ++i) {
            for (int j = 0; j < this.BACKFON[i].length; ++j) {
                this.backgroundBoard.setCell(j, i, this.BACKFON[i][j]);
            }
        }
        if (newLevel == 1) {
            if (this.fonImage != null) {
                System.out.println("clear FON IMAGE");
                ImageHandler.getInstance().clear("/img/backgroundBoard.png");
            }
            this.finishedLoading = false;
            System.out.println("LEVEL CHANGED");
            this.l = this.levelCursor + 1;
            this.score = 1;
            this.isPlay = true;
            this.i = 0;
            this.widthDisplay = this.getWidth();
            this.heightDisplay = this.getHeight();
            this.x_ViewWindow = 0;
            this.y_ViewWindow = 0;
            this.mx_ViewWindow = 0;
            this.my_ViewWindow = 0;
            this.level.setLevel(this.l);
            int life = 121;
            this.bar = new Bar(29, 300, 13, 200.0, life);
            this.bar.setHorizontal();
            this.initLevel(this.level.getLevel());
            this.levelControl = true;
            this.gameOverControl = true;
            this.mainMove = true;
            this.finishedLoading = true;
            SoundHandler.getInstance().play("/res/framework/sounds/menu.mid");
        }
    }

    public void setPause(boolean flag) {
        this.isPlay = flag;
    }

    private void downloadPictures() {
        this.barImg = ImageHandler.getInstance().getImage("/img/bar.png");
    }

    private void initLevel(int currentLevel) {
        this.downloadPictures();
        this.startLevel(currentLevel);
    }

    private void startLevel(int currentLevel) {
        int i;
        System.out.println("LEVEL = " + this.level.getLevel());
        System.out.println("*****");
        this.finishedLoading = false;
        EMidlet.getInstance().getSettings().add(new KeyValuePair("lastlevel", Integer.toString(((OperationTornado)OperationTornado.getInstance()).lastLevelValue)));
        if (currentLevel > 4 && GameModeHandler.getInstance().getMode() == 0) {
            new Action(this, "OPENMENU", "activationscreen").doAction();
            return;
        }
        this.fonPosX = 75;
        this.fonPosY = 60;
        this.levelComplete = new EFSprite("/img/level_complete.png");
        this.levelComplete.setPosition(this.widthDisplay / 6, -50);
        this.background = new Background();
        this.background.setFonParametres(Data.FON[currentLevel - 1], 20, 20);
        this.middleBackground = new Background();
        this.middleBackground.setFonParametres(Data.MIDDLE_FON[currentLevel - 1], 20, 20);
        this.fon = this.background.getLayer();
        this.middleFon = this.middleBackground.getLayer();
        this.animateSpaceTile1 = this.middleFon.createAnimatedTile(1);
        this.animateSpaceTile3 = this.middleFon.createAnimatedTile(3);
        this.animateSpaceTile5 = this.middleFon.createAnimatedTile(5);
        int[][] tiledInt = Data.MIDDLE_FON[currentLevel - 1];
        for (i = 0; i < tiledInt.length; ++i) {
            for (int ji = 0; ji < tiledInt[i].length; ++ji) {
                if (this.middleFon.getCell(ji, i) == 1) {
                    this.middleFon.setCell(ji, i, this.animateSpaceTile1);
                }
                if (this.middleFon.getCell(ji, i) == 3) {
                    this.middleFon.setCell(ji, i, this.animateSpaceTile3);
                }
                if (this.middleFon.getCell(ji, i) != 5) continue;
                this.middleFon.setCell(ji, i, this.animateSpaceTile5);
            }
        }
        this.widthFon = this.fon.getWidth();
        this.heightFon = this.fon.getHeight();
        this.hero = new Hero();
        this.hero.setSpeed(6);
        this.hero.setLife(121);
        this.hero.setPosition(300, 300);
        this.mainInitVector(currentLevel, Data.NUMBER_OBJECT[currentLevel - 1][0], Data.NUMBER_OBJECT[currentLevel - 1][1]);
        this.mainViewWindowAppend();
        this.viewWindow.insert(this.hero, this.index);
        for (i = this.vectorExplosion.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((EFSprite)this.vectorExplosion.elementAt(i), this.index);
        }
        this.viewWindow.insert(this.fon, this.viewWindow.getSize());
        this.finishedLoading = true;
    }

    private void mainInitVector(int currentLevel, int enemyN, int mineN) {
        int j;
        int i;
        int bombN = 3;
        int chargeN = 4;
        this.vectorMeteors = new Vector();
        this.vectorExplosion = new Vector();
        this.vectorMines = new Vector();
        this.vectorBomb = new Vector();
        this.vectorEnemies = new Vector();
        this.vectorGuns = new Vector();
        this.vectorCharges = new Vector();
        for (i = 4; i >= 0; --i) {
            this.meteor = new EFSprite("/img/meteor.png", 20, 20);
            this.meteor.setPosition((i + 1) * 100, -20);
            this.vectorMeteors.addElement(this.meteor);
        }
        for (i = 10; i >= 0; --i) {
            this.explosion = new Explosion("/img/explosion.png");
            this.explosion.setExpVisible(false);
            this.vectorExplosion.addElement(this.explosion);
        }
        for (i = mineN; i >= 0; --i) {
            if (Data.MINES_AUTO[currentLevel - 1][i] == 1) {
                this.mine = new Mines("/img/mine_1.png");
                this.mine.setAUTO(true);
            } else {
                this.mine = new Mines("/img/mine.png");
            }
            this.vectorMines.addElement(this.mine);
            this.mine.setMinePosition(i, currentLevel - 1);
            this.mine.setID(i + 1);
            for (j = bombN; j >= 0; --j) {
                this.bomb = new Bomb("/img/charge.png");
                this.bomb.setBombPosition(i, currentLevel - 1);
                this.bomb.setSpeed(3);
                this.bomb.setID(i + 1);
                this.bomb.setBombID(j + 1);
                this.vectorBomb.addElement(this.bomb);
            }
        }
        for (i = 0; i <= 2; ++i) {
            if (Data.ENEMIES_MOVE[currentLevel - 1][i] == 1) {
                this.enemy = new Enemy("/img/enemy2.png", 0, 0, this.widthFon, this.heightFon);
                this.enemy.setMoveEnemy(true);
            } else {
                this.enemy = new Enemy("/img/enemy.png", 0, 0, this.widthFon, this.heightFon);
            }
            this.enemy.setChaoticSpeed(2);
            this.enemy.setFrame(0);
            this.enemy.setID(i + 1);
            this.enemy.setEnemyPosition(i, currentLevel - 1);
            this.vectorEnemies.addElement(this.enemy);
            this.enemy.setObjectsNumber(enemyN + 1);
            this.gun = new Gun("/img/gun.png");
            this.gun.setFrame(0);
            this.gun.setGunPosition(i, currentLevel - 1);
            this.gun.setID(i + 1);
            this.vectorGuns.addElement(this.gun);
            for (j = chargeN; j >= 0; --j) {
                this.charge = new Charge("/img/charge.png");
                this.charge.setSpeed(5);
                this.charge.setID(i + 1);
                this.charge.setChargeID(j + 1);
                this.vectorCharges.addElement(this.charge);
            }
        }
    }

    private void mainViewWindowAppend() {
        int i;
        this.startIndex = 3;
        this.viewWindow = new ViewWindow(this.widthDisplay, this.heightDisplay, this.widthFon, this.heightFon);
        this.lm = new EFLayerManager();
        this.middleLm = new ViewWindow(this.widthDisplay, this.heightDisplay, this.widthFon, this.heightFon);
        this.lm.append(this.levelComplete);
        this.middleLm.append(this.middleFon);
        for (i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((EFSprite)this.vectorMeteors.elementAt(i), this.index);
        }
        for (i = this.vectorMines.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((Mines)this.vectorMines.elementAt(i), this.index);
        }
        for (i = this.vectorBomb.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((Bomb)this.vectorBomb.elementAt(i), this.index);
        }
        for (i = this.vectorCharges.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((Charge)this.vectorCharges.elementAt(i), this.index);
        }
        for (i = this.vectorEnemies.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((Enemy)this.vectorEnemies.elementAt(i), this.index);
        }
        for (i = this.vectorGuns.size() - 1; i >= 0; --i) {
            this.viewWindow.insert((Gun)this.vectorGuns.elementAt(i), this.index);
        }
    }

    private void dinamicReplace(int currentLevel, int enemyN) {
        int chargeN = 4;
        for (int i = this.startIndex; i <= this.startIndex; ++i) {
            if (Data.ENEMIES_MOVE[currentLevel - 1][i] == 1) {
                this.enemy = new Enemy("/img/enemy2.png", 0, 0, this.widthFon, this.heightFon);
                this.enemy.setMoveEnemy(true);
            } else {
                this.enemy = new Enemy("/img/enemy.png", 0, 0, this.widthFon, this.heightFon);
            }
            this.enemy.setChaoticSpeed(2);
            this.enemy.setFrame(0);
            this.enemy.setID(i + 1);
            this.enemy.setEnemyPosition(i, currentLevel - 1);
            this.vectorEnemies.addElement(this.enemy);
            this.enemy.setObjectsNumber(enemyN + 1);
            this.viewWindow.insert(this.enemy, this.index);
            this.gun = new Gun("/img/gun.png");
            this.gun.setFrame(0);
            this.gun.setGunPosition(i, currentLevel - 1);
            this.gun.setID(i + 1);
            this.vectorGuns.addElement(this.gun);
            this.viewWindow.insert(this.gun, this.index);
            for (int j = chargeN; j >= 0; --j) {
                this.charge = new Charge("/img/charge.png");
                this.charge.setSpeed(5);
                this.charge.setID(i + 1);
                this.charge.setChargeID(j + 1);
                this.vectorCharges.addElement(this.charge);
                this.viewWindow.insert(this.charge, this.index);
            }
        }
        ++this.startIndex;
    }

    private void moveChaoticEnemy() {
        for (int i = this.vectorEnemies.size() - 1; i >= 0; --i) {
            Enemy enemyVector = (Enemy)this.vectorEnemies.elementAt(i);
            enemyVector.setChaoticMovement();
        }
    }

    private void moveMines() {
        for (int i = this.vectorMines.size() - 1; i >= 0; --i) {
            Mines mineVector = (Mines)this.vectorMines.elementAt(i);
            if (!mineVector.getActivity()) continue;
            int id = mineVector.getID();
            for (int j = this.vectorBomb.size() - 1; j >= 0; --j) {
                Bomb bombVector = (Bomb)this.vectorBomb.elementAt(j);
                if (bombVector.getID() != id) continue;
                bombVector.setActivity(true);
            }
        }
        for (int j = this.vectorBomb.size() - 1; j >= 0; --j) {
            Bomb bombVector = (Bomb)this.vectorBomb.elementAt(j);
            bombVector.moveBomb(this.hero.getX(), this.hero.getY());
        }
    }

    private void rotateGun() {
        for (int i = this.vectorGuns.size() - 1; i >= 0; --i) {
            Gun gunVector = (Gun)this.vectorGuns.elementAt(i);
            Enemy enemyVector = (Enemy)this.vectorEnemies.elementAt(i);
            gunVector.setPosition(enemyVector.getX(), enemyVector.getY());
            gunVector.setGunFrame(this.hero.getXCenterHero(), this.hero.getYCenterHero());
        }
    }

    private void setChargePosition() {
        for (int i = this.vectorEnemies.size() - 1; i >= 0; --i) {
            Enemy enemyVector = (Enemy)this.vectorEnemies.elementAt(i);
            for (int j = this.vectorCharges.size() - 1; j >= 0; --j) {
                Charge chargeVector = (Charge)this.vectorCharges.elementAt(j);
                if (enemyVector.getID() != chargeVector.getID()) continue;
                chargeVector.setChargePosition(enemyVector.getXCenterEnemy(), enemyVector.getYCenterEnemy());
            }
        }
    }

    private void shotCharge() {
        for (int i = this.vectorCharges.size() - 1; i >= 0; --i) {
            Charge chargeVector = (Charge)this.vectorCharges.elementAt(i);
            chargeVector.moveCharge(this.hero.getX(), this.hero.getY(), chargeVector.getX(), chargeVector.getY());
            boolean is = this.isIdInGunVector(chargeVector.getID());
            if (chargeVector.getLifeTime() != 0 || is) continue;
            chargeVector.setID(0);
            chargeVector.setActivity(false);
        }
    }

    private void collisionWithHero() {
        Charge chargeVector;
        int i;
        int x_hero = this.hero.getX();
        int y_hero = this.hero.getY();
        for (i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            EFSprite metVector = (EFSprite)this.vectorMeteors.elementAt(i);
            if (!this.hero.collidesWith(metVector, false)) continue;
            this.explosion(x_hero, y_hero, 'b');
            this.hero.setMinusLife(10);
            metVector.setPosition(0, this.heightFon + 10);
        }
        for (i = this.vectorCharges.size() - 1; i >= 0; --i) {
            chargeVector = (Charge)this.vectorCharges.elementAt(i);
            if (!chargeVector.collisionWithHero(this.hero)) continue;
            this.explosion(x_hero, y_hero, 'c');
            this.hero.setMinusLife(1);
            boolean is = this.isIdInGunVector(chargeVector.getID());
            if (is) continue;
            chargeVector.setID(0);
            chargeVector.setActivity(false);
        }
        for (i = this.vectorBomb.size() - 1; i >= 0; --i) {
            Bomb bombVector = (Bomb)this.vectorBomb.elementAt(i);
            if (!this.hero.collidesWith(bombVector, false)) continue;
            this.hero.setMinusLife(3);
            bombVector.setVisible(false);
            this.explosion(x_hero, y_hero, 'b');
        }
        for (int j = this.vectorMines.size() - 1; j >= 0; --j) {
            Mines mineVector = (Mines)this.vectorMines.elementAt(j);
            if (!this.hero.collidesWith(mineVector, false)) continue;
            if (!mineVector.getActivity()) {
                this.hero.setMinusLife(10);
                this.explosion(mineVector.getX(), mineVector.getY(), 'c');
            }
            mineVector.setActivity(true);
        }
        if (this.hero.getLife() <= 0) {
            this.gameOverControl = false;
            this.hero.setVisible(false);
            for (i = this.vectorCharges.size() - 1; i >= 0; --i) {
                chargeVector = (Charge)this.vectorCharges.elementAt(i);
                chargeVector.switchOffChargeTimer();
                this.viewWindow.remove((EFSprite)this.vectorCharges.elementAt(i));
                this.vectorCharges.removeElementAt(i);
            }
            this.removeFromLayer();
            LevelHolder.getInstance().getLevel(0).setCurrentScore(this.getTotalScore());
            LevelHolder.getInstance().getLevel(0).saveLevelInfo();
            Action gameOverAction = new Action(this, "OPENMENU", "gameoverscreen");
            gameOverAction.doAction();
        } else if (this.hero.getLife() > 0 && this.vectorCharges.size() == 0) {
            this.levelControl = false;
            this.removeFromLayer();
            if (this.levelComplete.getY() <= this.heightDisplay / 2) {
                this.levelComplete.move(0, 10);
            }
            if (this.level.getLevel() == 15) {
                this.putScore(this.level.getLevel(), this.score);
                LevelHolder.getInstance().getLevel(0).setCurrentScore(this.getTotalScore());
                LevelHolder.getInstance().getLevel(0).saveLevelInfo();
                Action win = new Action(this, "OPENMENU", "youwinscreen");
                win.doAction();
            }
        } else {
            ++this.i;
        }
    }

    private boolean isIdInGunVector(int id) {
        boolean is = false;
        if (id != 0) {
            for (int i = this.vectorGuns.size() - 1; i >= 0; --i) {
                Gun gunVector = (Gun)this.vectorGuns.elementAt(i);
                if (gunVector.getID() != id) continue;
                is = true;
            }
        }
        return is;
    }

    private void setRadius() {
        for (int j = this.vectorGuns.size() - 1; j >= 0; --j) {
            Gun gunVector = (Gun)this.vectorGuns.elementAt(j);
            for (int i = this.vectorCharges.size() - 1; i >= 0; --i) {
                Charge chargeVector = (Charge)this.vectorCharges.elementAt(i);
                if (chargeVector.getID() != gunVector.getID()) continue;
                chargeVector.setChargeRadius(gunVector.getXCenterGun(), gunVector.getYCenterGun());
            }
        }
    }

    private void collisionWithMeteors() {
        EFSprite metVector;
        int i;
        for (i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            metVector = (EFSprite)this.vectorMeteors.elementAt(i);
            for (int j = this.vectorCharges.size() - 1; j >= 0; --j) {
                Charge chargeVector = (Charge)this.vectorCharges.elementAt(j);
                if (!metVector.collidesWith(chargeVector, false)) continue;
                this.explosion(chargeVector.getX(), chargeVector.getY(), 'b');
                metVector.setPosition(0, this.heightFon + 10);
                chargeVector.setActivity(false);
            }
        }
        for (i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            metVector = (EFSprite)this.vectorMeteors.elementAt(i);
            for (int k = this.vectorBomb.size() - 1; k >= 0; --k) {
                Bomb bombVector = (Bomb)this.vectorBomb.elementAt(k);
                if (!metVector.collidesWith(bombVector, false)) continue;
                bombVector.setVisible(false);
                this.explosion(bombVector.getX(), bombVector.getY(), 'b');
                metVector.setPosition(0, this.heightFon + 10);
                bombVector.setActivity(false);
            }
        }
        for (i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            metVector = (EFSprite)this.vectorMeteors.elementAt(i);
            if (metVector.getX() >= 20 && metVector.getX() <= this.widthFon - 40 && metVector.getY() <= this.heightFon - 40) continue;
            this.explosion(metVector.getX(), metVector.getY(), 'b');
            metVector.setPosition(0, this.heightFon + 10);
        }
    }

    private void collisionWithEnemy() {
        Enemy enemyVector;
        int j;
        for (j = this.vectorGuns.size() - 1; j >= 0; --j) {
            Gun gunVector = (Gun)this.vectorGuns.elementAt(j);
            Enemy enemyVector2 = (Enemy)this.vectorEnemies.elementAt(j);
            for (int i = this.vectorCharges.size() - 1; i >= 0; --i) {
                Charge chargeVector = (Charge)this.vectorCharges.elementAt(i);
                if (!chargeVector.collidesWith(gunVector, false)) continue;
                this.explosion(enemyVector2.getX(), enemyVector2.getY(), 'e');
                boolean is = this.isIdInGunVector(chargeVector.getID());
                if (!is) {
                    chargeVector.setID(0);
                    chargeVector.setActivity(false);
                }
                gunVector.setOFF();
                enemyVector2.setID(0);
                enemyVector2.setMoveEnemy(false);
                enemyVector2.setVisible(false);
                for (int k = 0; k <= this.viewWindow.getSize(); ++k) {
                    if (this.viewWindow.getLayerAt(k) != enemyVector2) continue;
                    this.index = k;
                    break;
                }
                this.removeChargesFromLayer(gunVector.getID());
                enemyVector2.switchOffEnemyTimer();
                this.viewWindow.remove((EFSprite)this.vectorEnemies.elementAt(j));
                this.vectorEnemies.removeElementAt(j);
                this.viewWindow.remove((EFSprite)this.vectorGuns.elementAt(j));
                this.vectorGuns.removeElementAt(j);
                if (this.startIndex >= Data.NUMBER_OBJECT[this.level.getLevel() - 1][0] + 1) continue;
                this.dinamicReplace(this.level.getLevel(), Data.NUMBER_OBJECT[this.level.getLevel() - 1][0]);
            }
        }
        for (int i = this.vectorBomb.size() - 1; i >= 0; --i) {
            Bomb bombVector = (Bomb)this.vectorBomb.elementAt(i);
            for (int j2 = this.vectorGuns.size() - 1; j2 >= 0; --j2) {
                Gun gunVector = (Gun)this.vectorGuns.elementAt(j2);
                enemyVector = (Enemy)this.vectorEnemies.elementAt(j2);
                if (!bombVector.collidesWith(gunVector, false)) continue;
                this.explosion(enemyVector.getX(), enemyVector.getY(), 'e');
                gunVector.setOFF();
                enemyVector.setID(0);
                enemyVector.setMoveEnemy(false);
                enemyVector.setVisible(false);
                for (int k = 0; k <= this.viewWindow.getSize(); ++k) {
                    if (this.viewWindow.getLayerAt(k) != enemyVector) continue;
                    this.index = k;
                    break;
                }
                enemyVector.switchOffEnemyTimer();
                this.viewWindow.remove((EFSprite)this.vectorEnemies.elementAt(j2));
                this.vectorEnemies.removeElementAt(j2);
                this.viewWindow.remove((EFSprite)this.vectorGuns.elementAt(j2));
                this.vectorGuns.removeElementAt(j2);
                System.out.println("DEAD");
                System.out.println("");
                if (this.startIndex >= Data.NUMBER_OBJECT[this.level.getLevel() - 1][0] + 1) continue;
                this.dinamicReplace(this.level.getLevel(), Data.NUMBER_OBJECT[this.level.getLevel() - 1][0]);
            }
        }
        for (j = this.vectorMines.size() - 1; j >= 0; --j) {
            Mines mineVector = (Mines)this.vectorMines.elementAt(j);
            for (int i = this.vectorGuns.size() - 1; i >= 0; --i) {
                Gun gunVector = (Gun)this.vectorGuns.elementAt(i);
                enemyVector = (Enemy)this.vectorEnemies.elementAt(i);
                if (!gunVector.collidesWith(mineVector, false) || mineVector.getActivity()) continue;
                this.explosion(mineVector.getX(), mineVector.getY(), 'c');
                mineVector.setActivity(true);
                gunVector.setOFF();
                enemyVector.setID(0);
                enemyVector.setMoveEnemy(false);
                enemyVector.setVisible(false);
                enemyVector.switchOffEnemyTimer();
            }
        }
    }

    private void collisionWithMine() {
        int i;
        for (i = this.vectorCharges.size() - 1; i >= 0; --i) {
            Charge chargeVector = (Charge)this.vectorCharges.elementAt(i);
            for (int j = this.vectorMines.size() - 1; j >= 0; --j) {
                Mines mineVector = (Mines)this.vectorMines.elementAt(j);
                if (!chargeVector.collidesWith(mineVector, false) || mineVector.getActivity()) continue;
                this.explosion(mineVector.getX(), mineVector.getY(), 'm');
                boolean is = this.isIdInGunVector(chargeVector.getID());
                if (!is) {
                    chargeVector.setID(0);
                    chargeVector.setActivity(false);
                }
                mineVector.setActivity(true);
                mineVector.switchOffMinesTimer();
                chargeVector.setActivity(false);
            }
        }
        for (i = this.vectorMines.size() - 1; i >= 0; --i) {
            Mines mineVector = (Mines)this.vectorMines.elementAt(i);
            for (int k = this.vectorBomb.size() - 1; k >= 0; --k) {
                Bomb bombVector = (Bomb)this.vectorBomb.elementAt(k);
                if (!mineVector.collidesWith(bombVector, false)) continue;
                bombVector.setVisible(false);
                this.explosion(bombVector.getX(), bombVector.getY(), 'b');
                mineVector.setPosition(0, this.heightFon + 10);
                mineVector.switchOffMinesTimer();
            }
        }
    }

    private void explosion(int x, int y, char t) {
        for (int j = this.vectorExplosion.size() - 1; j >= 0; --j) {
            boolean k = false;
            Explosion expVector = (Explosion)this.vectorExplosion.elementAt(j);
            if (t == 'c') {
                expVector.setFrameSequence(this.seqCharges);
            } else if (t == 'm') {
                expVector.setFrameSequence(this.seqMeteors);
            } else if (t == 'b') {
                expVector.setFrameSequence(this.seqMines);
            } else if (t == 'e') {
                expVector.setFrameSequence(this.seqEnemies);
            }
            if (!expVector.getVisible()) {
                expVector.setPosition(x - 5, y - 5);
                expVector.setExpVisible(true);
                k = true;
                break;
            }
            if (k) break;
        }
    }

    private void removeChargesFromLayer() {
        for (int i = this.vectorCharges.size() - 1; i >= 0; --i) {
            Charge chargeVector = (Charge)this.vectorCharges.elementAt(i);
            if (chargeVector.getID() != 0) continue;
            chargeVector.switchOffChargeTimer();
            this.viewWindow.remove((EFSprite)this.vectorCharges.elementAt(i));
            this.vectorCharges.removeElementAt(i);
        }
    }

    private void removeChargesFromLayer(int id) {
        for (int i = this.vectorCharges.size() - 1; i >= 0; --i) {
            Charge chargeVector = (Charge)this.vectorCharges.elementAt(i);
            if (chargeVector.getID() != id) continue;
            chargeVector.switchOffChargeTimer();
            this.viewWindow.remove((EFSprite)this.vectorCharges.elementAt(i));
            this.vectorCharges.removeElementAt(i);
        }
    }

    private void removeBombFromLayer() {
        for (int i = this.vectorBomb.size() - 1; i >= 0; --i) {
            Bomb bombVector = (Bomb)this.vectorBomb.elementAt(i);
            if (bombVector.getScoreVisible() != 300) continue;
            this.viewWindow.remove((EFSprite)this.vectorBomb.elementAt(i));
            this.vectorBomb.removeElementAt(i);
        }
    }

    private void removeFromLayer() {
        int i;
        for (i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            this.viewWindow.remove((EFSprite)this.vectorMeteors.elementAt(i));
            this.vectorMeteors.removeElementAt(i);
        }
        for (i = this.vectorExplosion.size() - 1; i >= 0; --i) {
            Explosion expVector = (Explosion)this.vectorExplosion.elementAt(i);
            expVector.switchOffExplosionTimer();
            this.viewWindow.remove((EFSprite)this.vectorExplosion.elementAt(i));
            this.vectorExplosion.removeElementAt(i);
        }
        for (i = this.vectorMines.size() - 1; i >= 0; --i) {
            this.viewWindow.remove((EFSprite)this.vectorMines.elementAt(i));
            this.vectorMines.removeElementAt(i);
        }
    }

    private void verifyGame() {
        this.spaceAnimation();
        this.moveMines();
        this.rotateGun();
        this.moveChaoticEnemy();
        this.setRadius();
        this.shotCharge();
        this.setChargePosition();
        this.collisionWithHero();
        if (this.levelControl) {
            this.collisionWithEnemy();
            this.collisionWithMine();
            this.collisionWithMeteors();
        }
        this.removeChargesFromLayer();
        this.removeBombFromLayer();
    }

    private void inputKey() {
        int keyStates = this.getKeyStates();
        if (keyStates == 0) {
            if (this.direction == 'u') {
                this.hero.setFrameSequence(Hero.UP);
            } else if (this.direction == '1') {
                this.hero.setFrameSequence(Hero.UP_RIGTH);
            } else if (this.direction == 'r') {
                this.hero.setFrameSequence(Hero.RIGTH);
            } else if (this.direction == '2') {
                this.hero.setFrameSequence(Hero.RIGTH_DOWN);
            } else if (this.direction == 'd') {
                this.hero.setFrameSequence(Hero.DOWN);
            } else if (this.direction == '4') {
                this.hero.setFrameSequence(Hero.DOWN_LEFT);
            } else if (this.direction == 'l') {
                this.hero.setFrameSequence(Hero.LEFT);
            } else if (this.direction == '3') {
                this.hero.setFrameSequence(Hero.LEFT_UP);
            }
        }
        this.hero.setXYHeroPosition(this.hero.getX(), this.hero.getY());
        int koeff = 3;
        if ((keyStates & 0x20) != 0 && (keyStates & 2) != 0) {
            if (this.direction != '1') {
                this.hero.setFrameSequence(Hero.UP_RIGTH);
                this.direction = (char)49;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), this.hero.getSpeed(), -this.hero.getSpeed(), 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveUpRight(this.mainMove);
                this.vx = this.hero.getSpeed() / koeff;
                this.vy = -this.hero.getSpeed() / koeff;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 0x20) != 0 && (keyStates & 0x40) != 0) {
            if (this.direction != '2') {
                this.hero.setFrameSequence(Hero.RIGTH_DOWN);
                this.direction = (char)50;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), this.hero.getSpeed(), this.hero.getSpeed(), 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveDownRight(this.mainMove);
                this.vx = this.hero.getSpeed() / koeff;
                this.vy = this.hero.getSpeed() / koeff;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 4) != 0 && (keyStates & 2) != 0) {
            if (this.direction != '3') {
                this.hero.setFrameSequence(Hero.LEFT_UP);
                this.direction = (char)51;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), -this.hero.getSpeed(), -this.hero.getSpeed(), 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveUpLeft(this.mainMove);
                this.vx = -this.hero.getSpeed() / koeff;
                this.vy = -this.hero.getSpeed() / koeff;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 4) != 0 && (keyStates & 0x40) != 0) {
            if (this.direction != '4') {
                this.hero.setFrameSequence(Hero.DOWN_LEFT);
                this.direction = (char)52;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), -this.hero.getSpeed(), this.hero.getSpeed(), 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveDownLeft(this.mainMove);
                this.vx = -this.hero.getSpeed() / koeff;
                this.vy = this.hero.getSpeed() / koeff;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 0x20) != 0) {
            if (this.direction != 'r') {
                this.hero.setFrameSequence(Hero.RIGTH);
                this.direction = (char)114;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), this.hero.getSpeed(), 0, 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveRigth(this.mainMove);
                this.vx = this.hero.getSpeed() / koeff;
                this.vy = 0;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 4) != 0) {
            if (this.direction != 'l') {
                this.hero.setFrameSequence(Hero.LEFT);
                this.direction = (char)108;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), -this.hero.getSpeed(), 0, 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveLeft(this.mainMove);
                this.vx = -this.hero.getSpeed() / koeff;
                this.vy = 0;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 2) != 0) {
            if (this.direction != 'u') {
                this.hero.setFrameSequence(Hero.UP);
                this.direction = (char)117;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), 0, -this.hero.getSpeed(), 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveUp(this.mainMove);
                this.vy = -this.hero.getSpeed() / koeff;
                this.vx = 0;
            } else {
                this.hero.move(0, 0);
            }
        } else if ((keyStates & 0x40) != 0) {
            if (this.direction != 'd') {
                this.hero.setFrameSequence(Hero.DOWN);
                this.direction = (char)100;
            }
            if (!Utils.tileCollideWith(this.hero.getX(), this.hero.getY(), this.hero.getWidth(), this.hero.getHeight(), 0, this.hero.getSpeed(), 20, 20, this.arr, Data.FON[this.level.getLevel() - 1])) {
                this.hero.moveDown(this.mainMove);
                this.vy = this.hero.getSpeed() / koeff;
                this.vx = 0;
            } else {
                this.hero.move(0, 0);
            }
        }
        if ((keyStates & 0x100) != 0) {
            if (!this.levelControl) {
                this.putScore(this.level.getLevel(), this.score);
                if (GameModeHandler.getInstance().getMode() == 0) {
                    System.out.println("DEMO VERSION..............");
                    this.level.nextLevel();
                }
                this.level.nextLevel();
                ++this.levelCursor;
                if (this.levelCursor >= ((OperationTornado)OperationTornado.getInstance()).lastLevelValue) {
                    ++((OperationTornado)OperationTornado.getInstance()).lastLevelValue;
                }
                this.levelControl = true;
                this.index = 0;
                this.startIndex = 0;
                TimerHolder.getInstance().clearAll();
                this.startLevel(this.level.getLevel());
            }
            if (!this.gameOverControl) {
                this.gameOverControl = true;
                this.level.gameOver();
                this.index = 0;
                this.startIndex = 0;
                this.startLevel(this.level.getLevel());
            }
        }
    }

    private void spaceAnimation() {
        Random rnd = new Random();
        for (int i = this.vectorMeteors.size() - 1; i >= 0; --i) {
            EFSprite metVector = (EFSprite)this.vectorMeteors.elementAt(i);
            if (i == 0) {
                metVector.move(1, 2);
            } else if (i == 1) {
                metVector.move(-1, 2);
            } else if (i == 2) {
                metVector.move(1, 2);
            } else if (i == 3) {
                metVector.move(-1, 2);
            } else if (i == 4) {
                metVector.move(1, 2);
            }
            metVector.nextFrame();
            if (metVector.getY() <= this.heightFon) continue;
            metVector.setPosition(rnd.nextInt(this.widthFon), -20);
        }
        if (this.scoreFon1 == 0) {
            this.middleFon.setAnimatedTile(this.animateSpaceTile1, 2);
        } else if (this.scoreFon1 == 10) {
            this.middleFon.setAnimatedTile(this.animateSpaceTile1, 1);
        }
        ++this.scoreFon1;
        if (this.scoreFon1 == 20) {
            this.scoreFon1 = 0;
        }
        if (this.scoreFon3 == 0) {
            this.middleFon.setAnimatedTile(this.animateSpaceTile3, 4);
        } else if (this.scoreFon3 == 2) {
            this.middleFon.setAnimatedTile(this.animateSpaceTile3, 3);
        }
        ++this.scoreFon3;
        if (this.scoreFon3 == 4) {
            this.scoreFon3 = 0;
        }
        if (this.scoreFon5 == 0) {
            this.middleFon.setAnimatedTile(this.animateSpaceTile5, 6);
        } else if (this.scoreFon5 == 2) {
            this.middleFon.setAnimatedTile(this.animateSpaceTile5, 5);
        }
        ++this.scoreFon5;
        if (this.scoreFon5 == 4) {
            this.scoreFon5 = 0;
        }
    }

    public void keyPressed(int keyCode) {
        if (LevelHolder.getInstance().getCurrentLevel() != 0) {
            return;
        }
        switch (keyCode) {
            case 202: 
            case 221: {
                if (--this.levelCursor >= 0) break;
                this.levelCursor = ((OperationTornado)OperationTornado.getInstance()).lastLevelValue - 1;
                break;
            }
            case 208: 
            case 222: {
                if (++this.levelCursor <= ((OperationTornado)OperationTornado.getInstance()).lastLevelValue - 1) break;
                this.levelCursor = 0;
                break;
            }
            case -203: 
            case 205: 
            case 225: {
                if (this.levelCursor > 3 && GameModeHandler.getInstance().getMode() == 0) {
                    new Action(this, "OPENMENU", "activationscreen").doAction();
                    break;
                }
                Action action = new Action(this, "SETCURRENTLEVEL", "next");
                action.doAction();
            }
        }
    }

    public void paint(Graphics g) {
        if (LevelHolder.getInstance().getCurrentLevel() == 0) {
            this.widthDisplay = this.getWidth();
            this.heightDisplay = this.getHeight();
            g.setColor(0);
            g.fillRect(0, 0, this.widthDisplay, this.heightDisplay);
            int posY = 0;
            TextWriter.getInstance().setWriterType(2);
            this.backgroundBoard.paint(g);
            g.drawImage(ImageHandler.getInstance().getImage("/img/planet.png"), 65, 100, 0);
            int offsetX = (this.widthDisplay - ImageHandler.getInstance().getImage("/img/1.png").getWidth() - TextWriter.getInstance().getTextWidth("Level N - 0") - 5) / 2;
            int offsetY = (this.heightDisplay - (ImageHandler.getInstance().getImage("/img/1.png").getHeight() + 1) * 14) / 2;
            for (int j = 0; j < 15; ++j) {
                Image image = null;
                StringBuffer buffer = new StringBuffer("Level ").append(j + 1);
                if (GameModeHandler.getInstance().getMode() == 0 && j > 2) {
                    buffer.append(" - ").append("BUY");
                } else {
                    buffer.append(" - ").append(this.getScore(j + 1));
                }
                if (j >= ((OperationTornado)OperationTornado.getInstance()).lastLevelValue) {
                    image = ImageHandler.getInstance().getImage("/img/1.png");
                    g.setColor(1293536);
                } else if (this.levelCursor == j) {
                    image = ImageHandler.getInstance().getImage("/img/3.png");
                    g.setColor(0xFF0000);
                } else {
                    image = ImageHandler.getInstance().getImage("/img/2.png");
                    g.setColor(0xFFFFFF);
                }
                g.drawImage(image, offsetX, offsetY + posY, 0);
                if (this.levelCursor == j) {
                    g.drawRect(offsetX, offsetY + posY, image.getWidth(), image.getHeight());
                }
                TextWriter.getInstance().drawText(g, buffer.toString(), offsetX + image.getWidth() + 5, offsetY + posY + 1);
                posY += image.getHeight() + 1;
            }
            g.setColor(0xFFFFFF);
            return;
        }
        g.setColor(0);
        g.fillRect(0, 0, this.widthFon, this.heightFon);
        this.backgroundBoard.paint(g);
        this.middleLm.setXYPoints(this.hero.getX(), this.hero.getY());
        this.mx_ViewWindow = this.middleLm.getX_ViewWindow();
        this.my_ViewWindow = this.middleLm.getY_ViewWindow();
        this.middleLm.paint(g, 0, 0);
        this.fonPosX = this.mx_ViewWindow > 0 && this.mx_ViewWindow < 360 ? (this.fonPosX += this.vx) : (this.fonPosX += this.vx / 2);
        this.fonPosY = this.my_ViewWindow > 0 && this.my_ViewWindow < 280 ? (this.fonPosY += this.vy) : (this.fonPosY += this.vy / 2);
        this.middleLm.setViewWindow(this.fonPosX, this.fonPosY, this.widthDisplay, this.heightDisplay);
        this.vx = 0;
        this.vy = 0;
        this.viewWindow.setXYPoints(this.hero.getX(), this.hero.getY());
        this.x_ViewWindow = this.viewWindow.getX_ViewWindow();
        this.y_ViewWindow = this.viewWindow.getY_ViewWindow();
        this.viewWindow.paint(g, 0, 0);
        this.viewWindow.setViewWindow(this.x_ViewWindow, this.y_ViewWindow, this.widthDisplay, this.heightDisplay);
        this.lm.paint(g, 0, 0);
        g.drawImage(this.barImg, 0, this.heightDisplay - this.barImg.getWidth(), 0);
        this.bar.setPower(this.hero.getLife());
        this.bar.paint(g);
    }

    public void tick() {
        if (this.isPlay) {
            if (LevelHolder.getInstance().getCurrentLevel() == 0 || !this.finishedLoading) {
                return;
            }
            this.verifyGame();
            this.inputKey();
            this.score = this.level.getLevel() * 100000 - this.i + this.hero.getLife();
        }
    }

    private void putScore(int level, int score) {
        Settings settings = EMidlet.getInstance().getSettings();
        String id = "scorelevel" + level;
        int lastBest = 0;
        try {
            lastBest = Integer.parseInt(settings.get(id));
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (score > lastBest) {
            settings.add(new KeyValuePair(id, Integer.toString(score)));
        }
    }

    private int getTotalScore() {
        Settings settings = EMidlet.getInstance().getSettings();
        int totalScore = 0;
        for (int j = 1; j < 16; ++j) {
            try {
                totalScore += Integer.parseInt(settings.get("scorelevel" + j));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return totalScore;
    }

    private int getScore(int level) {
        int score = 0;
        try {
            score = Integer.parseInt(EMidlet.getInstance().getSettings().get("scorelevel" + level));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return score;
    }
}

