/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.efw.manager;

import com.hellomoto.fullscreen.game.GAMECANVAS;
import com.jarbull.efw.controller.AnimationHolder;
import com.jarbull.efw.controller.ImageHandler;
import com.jarbull.efw.controller.ResolutionHandler;
import com.jarbull.efw.controller.SoundHandler;
import com.jarbull.efw.input.KeyCodeAdapter;
import com.jarbull.efw.manager.EMidlet;
import com.jarbull.efw.manager.ScreenFactory;
import com.jarbull.efw.ui.IScreen;
import com.jarbull.efw.ui.ProgressBar;
import com.jarbull.efw.ui.Screen;
import com.jarbull.efw.ui.ScreenHolder;
import javax.microedition.lcdui.Graphics;

class InternalCanvas
extends GAMECANVAS
implements Runnable {
    protected static final int MENU_REFRESH_PERIOD = 50;
    public static final int MENU = 0;
    public static final int GAME = 1;
    EMidlet midlet;
    public boolean running;
    public boolean paused;
    public boolean loading;
    boolean sizeChanged;
    int state;
    int screenOffsetX;
    int screenOffsetY;
    Graphics g;
    int bgColor;

    public InternalCanvas(EMidlet midlet) {
        super(false);
        this.midlet = midlet;
        this.running = true;
        this.paused = false;
        this.loading = true;
        this.sizeChanged = false;
        this.setFullScreenMode(true);
        ResolutionHandler.getInstance().setScreenSize(this.getWidth(), this.getHeight());
        this.screenOffsetX = (this.getWidth() - ResolutionHandler.getInstance().getCurrentWidth()) / 2;
        this.screenOffsetY = (this.getHeight() - ResolutionHandler.getInstance().getCurrentHeight()) / 2;
        this.state = 0;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void stop() {
        this.running = false;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    protected void hideNotify() {
        this.paused = true;
        if (this.state == 1 && this.midlet.processor != null) {
            ScreenHolder.getInstance().setActiveScreenId("pausemenuscreen");
            this.midlet.processor.setPaused(true);
            this.midlet.pause();
        } else {
            String active = SoundHandler.getInstance().getActiveFile();
            if (active != null) {
                SoundHandler.getInstance().pause(active);
            }
        }
    }

    protected void showNotify() {
        this.paused = false;
        if (this.state == 1 && this.midlet.processor != null) {
            this.midlet.resume();
        } else {
            String active = SoundHandler.getInstance().getActiveFile();
            if (active != null) {
                SoundHandler.getInstance().play(active);
            }
        }
    }

    protected void sizeChanged(int w, int h) {
        this.sizeChanged = w != ResolutionHandler.getInstance().getScreenWidth() && h != ResolutionHandler.getInstance().getScreenHeight();
    }

    private void tick() {
        if (this.sizeChanged) {
            return;
        }
        if (this.loading) {
            Screen screen = (Screen)ScreenHolder.getInstance().getScreen("loadingscreen");
            if (screen == null) {
                return;
            }
            ProgressBar progressBar = (ProgressBar)screen.getChild("loading_bar");
            if (progressBar == null) {
                return;
            }
            int percentage = ImageHandler.getInstance().getTotalCount();
            if (percentage > 0) {
                percentage = ImageHandler.getInstance().getLoadedCount() * 100 / percentage;
            }
            progressBar.setValue(percentage);
        } else {
            int time = AnimationHolder.getInstance().getLastWorldTime() + 50;
            AnimationHolder.getInstance().animate(time);
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.loading || this.sizeChanged) {
            return;
        }
        keyCode = KeyCodeAdapter.getInstance().adaptKeyCode(keyCode);
        block0 : switch (this.state) {
            case 0: {
                String id = ScreenHolder.getInstance().getActiveScreenId();
                IScreen activeScreen = ScreenHolder.getInstance().getScreen(id);
                activeScreen.keyPressed(keyCode);
                break;
            }
            case 1: {
                switch (keyCode) {
                    case -202: {
                        this.midlet.processor.setPaused(true);
                        this.midlet.pause();
                        this.midlet.userCanvas.setAutoCenterMenu(true);
                        this.midlet.canvas.setPaused(false);
                        ScreenHolder.getInstance().setActiveScreenId("pausemenuscreen");
                        break block0;
                    }
                }
                if (EMidlet.getInstance().canvas.loading) {
                    return;
                }
                if (this.midlet.processor != null && this.midlet.processor.isPaused()) {
                    String activeId = ScreenHolder.getInstance().getActiveScreenId();
                    ScreenHolder.getInstance().getScreen(activeId).keyPressed(keyCode);
                    break;
                }
                if (EMidlet.getInstance().canvas.loading) break;
                this.midlet.userCanvas.keyPressed(keyCode);
            }
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.loading || this.sizeChanged) {
            return;
        }
        keyCode = KeyCodeAdapter.getInstance().adaptKeyCode(keyCode);
        switch (this.state) {
            case 0: {
                String id = ScreenHolder.getInstance().getActiveScreenId();
                IScreen activeScreen = ScreenHolder.getInstance().getScreen(id);
                activeScreen.keyRepeated(keyCode);
                break;
            }
            case 1: {
                if (this.midlet.processor != null && this.midlet.processor.isPaused()) {
                    String activeId = ScreenHolder.getInstance().getActiveScreenId();
                    ScreenHolder.getInstance().getScreen(activeId).keyRepeated(keyCode);
                }
                if (this.state != 1 || this.midlet.processor == null || this.midlet.processor.isPaused()) break;
                this.midlet.userCanvas.keyRepeated(keyCode);
            }
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.loading || this.sizeChanged) {
            return;
        }
        keyCode = KeyCodeAdapter.getInstance().adaptKeyCode(keyCode);
        switch (this.state) {
            case 0: {
                String id = ScreenHolder.getInstance().getActiveScreenId();
                IScreen activeScreen = ScreenHolder.getInstance().getScreen(id);
                activeScreen.keyReleased(keyCode);
                break;
            }
            case 1: {
                if (this.midlet.processor != null && this.midlet.processor.isPaused()) {
                    String activeId = ScreenHolder.getInstance().getActiveScreenId();
                    ScreenHolder.getInstance().getScreen(activeId).keyReleased(keyCode);
                }
                if (this.state != 1 || this.midlet.processor == null || this.midlet.processor.isPaused()) break;
                this.midlet.userCanvas.keyReleased(keyCode);
            }
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.loading || this.sizeChanged) {
            return;
        }
        switch (this.state) {
            case 0: {
                String id = ScreenHolder.getInstance().getActiveScreenId();
                IScreen activeScreen = ScreenHolder.getInstance().getScreen(id);
                activeScreen.pointerPressed(x - this.screenOffsetX, y - this.screenOffsetY);
                break;
            }
            case 1: {
                if (this.midlet.processor != null && this.midlet.processor.isPaused()) {
                    String activeId = ScreenHolder.getInstance().getActiveScreenId();
                    IScreen pauseScreen = ScreenHolder.getInstance().getScreen(activeId);
                    pauseScreen.pointerPressed(x - this.screenOffsetX, y - this.screenOffsetY);
                    break;
                }
                if (this.midlet.userCanvas.autoCenterMenu) {
                    this.midlet.userCanvas.pointerPressed(x - this.screenOffsetX, y - this.screenOffsetY);
                    break;
                }
                this.midlet.userCanvas.pointerPressed(x, y);
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        if (this.loading || this.sizeChanged) {
            return;
        }
        switch (this.state) {
            case 0: {
                String id = ScreenHolder.getInstance().getActiveScreenId();
                IScreen activeScreen = ScreenHolder.getInstance().getScreen(id);
                activeScreen.pointerDragged(x - this.screenOffsetX, y - this.screenOffsetY);
                break;
            }
            case 1: {
                if (this.midlet.processor != null && this.midlet.processor.isPaused()) {
                    String activeId = ScreenHolder.getInstance().getActiveScreenId();
                    IScreen pauseScreen = ScreenHolder.getInstance().getScreen(activeId);
                    pauseScreen.pointerDragged(x - this.screenOffsetX, y - this.screenOffsetY);
                    break;
                }
                if (this.midlet.userCanvas.autoCenterMenu) {
                    this.midlet.userCanvas.pointerDragged(x - this.screenOffsetX, y - this.screenOffsetY);
                    break;
                }
                this.midlet.userCanvas.pointerDragged(x, y);
            }
        }
    }

    protected void pointerReleased(int x, int y) {
        if (this.loading || this.sizeChanged) {
            return;
        }
        switch (this.state) {
            case 0: {
                String id = ScreenHolder.getInstance().getActiveScreenId();
                IScreen activeScreen = ScreenHolder.getInstance().getScreen(id);
                activeScreen.pointerReleased(x - this.screenOffsetX, y - this.screenOffsetY);
                break;
            }
            case 1: {
                if (this.midlet.processor != null && this.midlet.processor.isPaused()) {
                    String activeId = ScreenHolder.getInstance().getActiveScreenId();
                    IScreen pauseScreen = ScreenHolder.getInstance().getScreen(activeId);
                    pauseScreen.pointerReleased(x - this.screenOffsetX, y - this.screenOffsetY);
                    break;
                }
                if (this.midlet.userCanvas.autoCenterMenu) {
                    this.midlet.userCanvas.pointerReleased(x - this.screenOffsetX, y - this.screenOffsetY);
                    break;
                }
                this.midlet.userCanvas.pointerReleased(x, y);
            }
        }
    }

    public void paint(Graphics g) {
        if (this.g == null) {
            this.g = this.getGraphics();
        }
        g.setColor(this.bgColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.sizeChanged) {
            g.setColor(0xFFFFFF);
            g.drawString(ResolutionHandler.getInstance().getScreenWidth() + "x" + ResolutionHandler.getInstance().getScreenHeight(), this.getWidth() / 2, this.getHeight() / 2 - 30, 65);
            g.drawString(this.getWidth() + "x" + this.getHeight(), this.getWidth() / 2, this.getHeight() / 2 + 30, 65);
            return;
        }
        switch (this.state) {
            case 0: {
                IScreen screen;
                g.translate(this.screenOffsetX, this.screenOffsetY);
                g.setClip(0, 0, ResolutionHandler.getInstance().getCurrentWidth(), ResolutionHandler.getInstance().getCurrentHeight());
                if (this.loading) {
                    Screen loadingScreen = (Screen)ScreenHolder.getInstance().getScreen("loadingscreen");
                    if (loadingScreen == null) {
                        loadingScreen = ScreenFactory.createLoadingScreen();
                    }
                    loadingScreen.paint(g);
                    break;
                }
                String id = ScreenHolder.getInstance().getActiveScreenId();
                if (id == null || (screen = ScreenHolder.getInstance().getScreen(id)) == null) break;
                screen.paint(g);
                break;
            }
            case 1: {
                try {
                    String id;
                    if (this.midlet.userCanvas.paintOnPause) {
                        if (this.midlet.userCanvas.autoCenterGame) {
                            g.translate(this.screenOffsetX, this.screenOffsetY);
                        }
                        if (this.midlet.userCanvas.autoClipGame) {
                            g.setClip(0, 0, ResolutionHandler.getInstance().getCurrentWidth(), ResolutionHandler.getInstance().getCurrentHeight());
                        }
                        this.midlet.userCanvas.paint(g);
                        if (this.midlet.userCanvas.autoCenterGame) {
                            g.translate(-this.screenOffsetX, -this.screenOffsetY);
                        }
                    }
                    if (!this.midlet.processor.isPaused()) break;
                    if (this.midlet.userCanvas.autoCenterMenu) {
                        g.translate(this.screenOffsetX, this.screenOffsetY);
                    }
                    if (this.midlet.userCanvas.autoClip) {
                        g.setClip(0, 0, ResolutionHandler.getInstance().getCurrentWidth(), ResolutionHandler.getInstance().getCurrentHeight());
                    }
                    id = (id = ScreenHolder.getInstance().getActiveScreenId()) == null ? "pausemenuscreen" : id;
                    ScreenHolder.getInstance().getScreen(id).paint(g);
                    break;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public void run() {
        while (this.running) {
            long frameStart = System.currentTimeMillis();
            if (!this.paused) {
                switch (this.state) {
                    case 0: {
                        this.tick();
                        break;
                    }
                    case 1: {
                        if (this.midlet.processor == null || !this.midlet.processor.isPaused()) break;
                        int time = AnimationHolder.getInstance().getLastWorldTime() + 50;
                        AnimationHolder.getInstance().animate(time);
                    }
                }
                this.repaint();
            }
            try {
                switch (this.state) {
                    case 0: {
                        Thread.sleep(Math.max(1L, 50L - System.currentTimeMillis() + frameStart));
                        break;
                    }
                    case 1: {
                        Thread.sleep(Math.max(1L, (long)this.midlet.userCanvas.paintDuration - System.currentTimeMillis() + frameStart));
                    }
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

