/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyFont {
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FACE_SYSTEM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_SMALL = 8;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_UNDERLINED = 0;
    short[][] cf;
    Image font;
    int fsx = 1;
    int fsy = 1;
    final byte[] mas_index_uni = new byte[]{0, 4, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 10, 0, 0, 0, 0, 0, 12, 0, 0, 2, 0, 0, 0, 16, 0, 3, 17, 0, 1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 10, 0, 0, 0, 0, 0, 12, 0, 0, 2, 0, 0, 0, 16, 0, 3, 17, 1, 0, 0, 0, 5, 5, 19, 19, 20, 20, 0, 0, 0, 0, 6, 6, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 21, 21, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 22, 23, 23, 0, 0, 11, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 13, 24, 24, 0, 0, 0, 0, 14, 14, 0, 0, 15, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 25, 26, 26, 18, 18, 0, 0, 0};
    int msf_e = 127;
    String nCf = "";
    String nFnt = "";
    final int st_ind_uni;

    public MyFont() {
        this.st_ind_uni = 192;
        if (this.cf == null) {
            this.create_cf();
        }
        if (this.font == null) {
            this.create_font();
        }
    }

    private final int[] calc_anc(String txt, int anc, int offset, int len) {
        int[] otp = new int[2];
        int fh = this.getHeight();
        int fw = this.substringWidth(txt, offset, len);
        if ((anc & 0x20) > 0) {
            otp[1] = otp[1] - fh;
        }
        if ((anc & 2) > 0) {
            otp[1] = otp[1] - (fh >> 1);
        }
        if ((anc & 8) > 0) {
            otp[0] = otp[0] - fw;
        }
        if ((anc & 1) > 0) {
            otp[0] = otp[0] - (fw >> 1);
        }
        return otp;
    }

    public int charWidth(char ch) {
        int otp = this.fsx + this.cf[2][this.get_cf(ch)];
        if (ch == '\n' || ch == '\r') {
            otp = 0;
        }
        return otp;
    }

    public int charsWidth(char[] ch, int offset, int length) {
        int otp = 0;
        int a = 0;
        while (a < length) {
            otp += this.charWidth(ch[a + offset]);
            ++a;
        }
        return otp;
    }

    private final void create_cf() {
        byte[] mas_load = Uni.uni.load_pack("cf" + this.nCf, -1);
        int tt = mas_load.length / 6;
        if (this.msf_e < tt) {
            this.msf_e = tt;
        }
        this.cf = new short[6][this.msf_e + 2];
        int nl = 0;
        int ny = 0;
        while (ny < this.msf_e) {
            int nx = 0;
            while (nx < 6) {
                this.cf[nx][ny] = mas_load[nl];
                ++nl;
                ++nx;
            }
            if (this.cf[0][ny] < 0) {
                short[] sArray = this.cf[0];
                int n = ny;
                sArray[n] = (short)(sArray[n] + 256);
            }
            if (this.cf[1][ny] < 0) {
                short[] sArray = this.cf[1];
                int n = ny;
                sArray[n] = (short)(sArray[n] + 256);
            }
            if (nl >= mas_load.length) break;
            ++ny;
        }
        if (this.cf[2][0] == 0) {
            this.cf[2][0] = this.cf[2][16];
        }
        this.cf[3][0] = 0;
    }

    private final void create_font() {
        try {
            this.font = Uni.createImage("/fnt" + this.nFnt + ".png");
        }
        catch (Exception ex) {
        }
    }

    public final int drawChar(Graphics g, char ch, int x, int y) {
        int sc1 = g.getClipX();
        int sc2 = g.getClipY();
        int sc3 = g.getClipWidth();
        int sc4 = g.getClipHeight();
        if (x < 132) {
            int nim = this.get_cf(ch);
            short ht = this.cf[3][nim];
            int w = this.cf[2][nim];
            int h = this.cf[3][nim];
            int xc = x += this.cf[4][nim];
            int yc = y -= this.cf[5][nim] + ht;
            if (xc < sc1) {
                w -= sc1 - xc;
                xc = sc1;
            }
            if (yc < sc2) {
                h -= sc2 - yc;
                yc = sc2;
            }
            if (xc + w > sc1 + sc3) {
                w = sc1 + sc3 - xc;
            }
            if (yc + h > sc2 + sc4) {
                h = sc2 + sc4 - yc;
            }
            if (w > 0 && h > 0) {
                g.setClip(xc, yc, w, h);
                g.drawImage(this.font, x - this.cf[0][nim], y - this.cf[1][nim], 20);
            }
        }
        g.setClip(sc1, sc2, sc3, sc4);
        return this.charWidth(ch);
    }

    public final void drawChars(Graphics g, char[] txt, int offset, int len, int xx, int yy, int anc) {
        int x = xx;
        int y = yy + this.getHeight() - this.fsy;
        String tx = new String(txt, offset, len);
        int[] korr = this.calc_anc(tx, anc, 0, len);
        x += korr[0];
        y += korr[1];
        int a = offset;
        while (a < offset + len) {
            x += this.drawChar(g, txt[a], x, y);
            ++a;
        }
    }

    public final void drawString(Graphics g, String txt, int xx, int yy, int anc) {
        this.drawSubstring(g, txt, 0, txt.length(), xx, yy, anc);
    }

    public final void drawSubstring(Graphics g, String txt, int offset, int len, int xx, int yy, int anc) {
        int x = xx;
        int y = yy + this.getHeight() - this.fsy;
        int[] korr = this.calc_anc(txt, anc, offset, len);
        x += korr[0];
        y += korr[1];
        int a = offset;
        while (a < offset + len) {
            x += this.drawChar(g, txt.charAt(a), x, y);
            ++a;
        }
    }

    public int getBaselinePosition() {
        return 0;
    }

    public static MyFont getDefaultFont() {
        return new MyFont();
    }

    public static MyFont getFont(int face, int style, int size, String n_fnt, String n_cf) {
        MyFont myFont = new MyFont();
        myFont.nFnt = n_fnt;
        myFont.nCf = n_cf;
        myFont.cf = null;
        myFont.create_cf();
        myFont.font = null;
        myFont.create_font();
        return myFont;
    }

    public static MyFont getFont(int face, int style, int size, String n_fnt) {
        MyFont myFont = new MyFont();
        myFont.nFnt = n_fnt;
        myFont.font = null;
        myFont.create_font();
        return myFont;
    }

    public static MyFont getFont(int face, int style, int size) {
        return new MyFont();
    }

    public int getHeight() {
        return this.fsy + this.cf[3][this.get_cf(1062)];
    }

    private int get_cf(int inp) {
        int aa = inp;
        if (aa == 946) {
            aa = 223;
        }
        if (aa >= 192 && aa - 192 < this.mas_index_uni.length) {
            return 100 + this.mas_index_uni[aa - 192];
        }
        if (aa > 848) {
            aa -= 848;
        }
        if (aa >= 97 && aa <= 122) {
            aa -= 32;
        } else if (aa >= 192 && aa <= 223) {
            aa -= 96;
        } else if (aa >= 224 && aa <= 255) {
            aa -= 128;
        }
        if ((aa -= 32) < 0 || aa >= this.msf_e) {
            aa = 0;
        }
        return aa;
    }

    public void setFont(MyFont font) {
    }

    public int stringWidth(String str) {
        int otp = 0;
        int length = str.length();
        int a = 0;
        while (a < length) {
            otp += this.charWidth(str.charAt(a));
            ++a;
        }
        return otp;
    }

    public int substringWidth(String str, int offset, int len) {
        int otp = 0;
        int a = 0;
        while (a < len) {
            otp += this.charWidth(str.charAt(a + offset));
            ++a;
        }
        return otp;
    }
}

