/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class MainGameCanvas
extends GameCanvas
implements Runnable {
    private GameMidlet midlet = null;
    private Graphics graphics = null;
    private volatile Thread animationThread = null;
    private LayerManager gameManager = null;
    private Background background = null;
    private Ship ship = null;
    private int fps = 50;
    int screenWidth = 0;
    int screenHeight = 0;
    int gameState = 0;
    private Image imageGameContinue = null;
    private Image imageGameEnd = null;
    private Image imageComandContinue = null;
    private Image imageComandMenu = null;
    private Meteorite[] meteor = new Meteorite[4];
    private Shot runShotShip = null;
    private Shot shootingShip = null;
    private Vector shotShip = null;
    int updateShot = 0;
    private Random random = null;
    private Explosion explosion = null;
    private Image lifeShip = null;
    int score = 0;
    private Player pExplosion = null;

    public MainGameCanvas(GameMidlet midlet) throws Exception {
        super(true);
        this.midlet = midlet;
        this.setFullScreenMode(true);
        this.graphics = this.getGraphics();
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.gameManager = new LayerManager();
        this.random = new Random();
        this.createGame();
    }

    public void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (currentThread == this.animationThread) {
                long endTime;
                long startTime = System.currentTimeMillis();
                if (this.isShown()) {
                    this.updateGame();
                    this.draw();
                    this.flushGraphics();
                }
                if ((endTime = System.currentTimeMillis() - startTime) < (long)this.fps) {
                    MainGameCanvas mainGameCanvas = this;
                    synchronized (mainGameCanvas) {
                        this.wait((long)this.fps - endTime);
                        continue;
                    }
                }
                currentThread.yield();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.animationThread = null;
    }

    public void keyPressed(int keyCode) {
        switch (this.gameState) {
            case 0: {
                if (keyCode != -6 && keyCode != -7) break;
                this.stop();
                this.midlet.gameMenu();
                break;
            }
            case 1: {
                if (keyCode == -6) {
                    this.stop();
                    this.midlet.gameMenu();
                }
                if (keyCode != -7) break;
                this.stop();
                this.midlet.loadingGame();
                break;
            }
            case 2: {
                if (keyCode == -6) {
                    this.stop();
                    this.midlet.gameMenu();
                }
                if (keyCode != -7) break;
                this.stop();
                this.midlet.loadingGame();
            }
        }
    }

    private void draw() {
        this.graphics.setColor(250, 250, 250);
        this.graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        this.gameManager.paint(this.graphics, 0, 0);
        this.ship.drawLifeShip(this.graphics, this.ship.lifeShip);
        this.graphics.drawImage(this.lifeShip, 1, 2, 0);
        switch (this.gameState) {
            case 1: {
                this.graphics.drawImage(this.imageGameContinue, this.screenWidth / 2, this.screenHeight / 2, 3);
                this.graphics.drawImage(this.imageComandMenu, 0, this.screenHeight - this.imageComandMenu.getHeight(), 0);
                this.graphics.drawImage(this.imageComandContinue, this.screenWidth - this.imageComandContinue.getWidth(), this.screenHeight - this.imageComandContinue.getHeight(), 0);
                this.graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
                this.graphics.setColor(0, 0, 0);
                this.graphics.drawString("" + this.score, 130, 150, 0);
                break;
            }
            case 2: {
                this.graphics.drawImage(this.imageGameEnd, this.screenWidth / 2, this.screenHeight / 2, 3);
                this.graphics.drawImage(this.imageComandMenu, 0, this.screenHeight - this.imageComandMenu.getHeight(), 0);
                this.graphics.drawImage(this.imageComandContinue, this.screenWidth - this.imageComandContinue.getWidth(), this.screenHeight - this.imageComandContinue.getHeight(), 0);
                this.graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
                this.graphics.setColor(0, 0, 0);
                this.graphics.drawString("" + this.score, 130, 150, 0);
            }
        }
        this.graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
    }

    public void createGame() throws Exception {
        this.pExplosion = this.createSound("/Explosion.wav", "audio/X-wav");
        try {
            Image imageBackground = Image.createImage((String)"/Background.png");
            this.background = new Background(10, 50, imageBackground, 24, 32);
            this.background.setVisible(false);
        }
        catch (Exception ex) {
            System.err.println("Background it is not loaded");
        }
        try {
            this.imageGameContinue = Image.createImage((String)"/Continue.png");
            this.imageGameEnd = Image.createImage((String)"/GameEnd.png");
            this.imageComandMenu = Image.createImage((String)"/comandMenu.png");
            this.imageComandContinue = Image.createImage((String)"/comandContinue.png");
            Image imageExplosion = Image.createImage((String)"/Explosion.png");
            this.explosion = new Explosion(imageExplosion, 44, 44);
            this.explosion.setVisible(false);
            imageExplosion = null;
            this.lifeShip = Image.createImage((String)"/Life.png");
        }
        catch (Exception ex) {
            System.err.println("Image it is not loaded");
        }
        try {
            Image imageShip = Image.createImage((String)"/Ship.png");
            this.ship = new Ship(this, imageShip, 46, 51);
            this.ship.setVisible(false);
            imageShip = null;
        }
        catch (Exception ex) {
            System.err.println("Ship.png it is not loaded");
        }
        this.shotShip = new Vector();
        try {
            Image imageMeteorite1 = Image.createImage((String)"/Meteorite1.png");
            Image imageMeteorite2 = Image.createImage((String)"/Meteorite2.png");
            this.meteor[0] = new Meteorite(imageMeteorite1, 40, 35);
            this.meteor[1] = new Meteorite(imageMeteorite1, 40, 35);
            this.meteor[2] = new Meteorite(imageMeteorite2, 40, 35);
            this.meteor[3] = new Meteorite(imageMeteorite2, 40, 35);
            imageMeteorite1 = null;
            Object var2_6 = null;
        }
        catch (Exception ex) {
            System.err.println("meteor images are not loaded");
        }
    }

    public void setGame() {
        this.gameState = 0;
        this.score = 0;
        this.ship.lifeShip = 100;
        this.background.createBackground();
        this.background.setPosition(0, -this.background.getHeight() + this.screenHeight);
        this.background.setVisible(true);
        this.ship.setPosition(this.screenWidth / 2 - 46 / 2, this.screenHeight - 51 - 10);
        this.ship.setVisible(true);
        this.updateShot = 900;
        this.meteor[0].setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - this.meteor[0].WIDTH)), -100);
        this.meteor[1].setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - this.meteor[1].WIDTH)), -400);
        this.meteor[2].setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - this.meteor[2].WIDTH)), -700);
        this.meteor[3].setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - this.meteor[3].WIDTH)), -1000);
        this.gameManager.append((Layer)this.explosion);
        int i = 4;
        while (--i >= 0) {
            this.gameManager.append((Layer)this.meteor[i]);
        }
        this.gameManager.append((Layer)this.ship);
        this.gameManager.append((Layer)this.background);
    }

    public void updateGame() {
        if (this.background.getY() > -1) {
            this.background.move(0, 0);
            this.gameState = 1;
        } else {
            this.background.move(0, 1);
        }
        if (this.ship.lifeShip <= 0) {
            this.gameState = 2;
        }
        switch (this.gameState) {
            case 0: {
                int keyStates = this.getKeyStates();
                if ((keyStates & 0x40) != 0) {
                    this.ship.moveShip(1);
                } else if ((keyStates & 2) != 0) {
                    this.ship.moveShip(2);
                } else if ((keyStates & 4) != 0) {
                    this.ship.moveShip(3);
                } else if ((keyStates & 0x20) != 0) {
                    this.ship.moveShip(4);
                } else {
                    this.ship.moveShip(0);
                }
                int i = 4;
                while (--i >= 0) {
                    this.meteor[i].moveMeteorite(15);
                    if (this.screenHeight >= this.meteor[i].getY()) continue;
                    this.meteor[i].setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - this.meteor[i].WIDTH)), -200);
                }
                try {
                    this.firingShip();
                }
                catch (Exception exc) {
                    System.err.println("Not fire");
                }
                this.moveShotShip();
                i = 4;
                while (--i >= 0) {
                    this.overlapsShipMeteor(this.meteor[i]);
                    this.checkCollisions(this.meteor[i]);
                }
                if (!this.explosion.isVisible()) break;
                this.explosion.updateExplosion();
            }
        }
    }

    protected void firingShip() throws Exception {
        this.shootingShip = this.ship.createShot(this.updateShot);
        if (this.shootingShip != null) {
            this.shotShip.addElement(this.shootingShip);
            this.gameManager.insert((Layer)this.shootingShip, 1);
        }
    }

    protected void moveShotShip() {
        block0: for (int i = 0; i < this.shotShip.size(); ++i) {
            for (int j = 0; j < 2; ++j) {
                this.runShotShip = (Shot)((Object)this.shotShip.elementAt(i));
                this.runShotShip.shotShip();
                if (this.runShotShip.getY() >= 20) continue;
                this.shotShip.removeElementAt(i);
                this.gameManager.remove((Layer)this.runShotShip);
                continue block0;
            }
        }
    }

    public void checkCollisions(Sprite sprite) {
        if (this.ship.collidesWith(sprite, true)) {
            this.ship.lifeShip -= 20;
            this.soundExplosion();
            if (!this.explosion.isVisible()) {
                this.explosion.explosion(sprite);
            }
            sprite.setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - 50)), -200);
        }
    }

    boolean overlapsShipMeteor(Sprite sprite) {
        return this.collidesShotMeteor(sprite, this.shotShip.size());
    }

    boolean collidesShotMeteor(Sprite sprite, int count) {
        for (int i = 0; i < count; ++i) {
            Shot m = (Shot)((Object)this.shotShip.elementAt(i));
            if (!sprite.collidesWith((Sprite)m, true)) continue;
            this.score += 10;
            m.setVisible(false);
            this.soundExplosion();
            if (!this.explosion.isVisible()) {
                this.explosion.explosion(sprite);
            }
            sprite.setPosition(Math.abs(this.random.nextInt() % (this.screenWidth - 50)), -150);
        }
        return true;
    }

    private Player createSound(String file, String format) {
        Player player = null;
        try {
            InputStream input = this.getClass().getResourceAsStream(file);
            player = Manager.createPlayer((InputStream)input, (String)format);
            player.prefetch();
        }
        catch (IOException ex) {
        }
        catch (MediaException ex) {
            // empty catch block
        }
        return player;
    }

    private void soundExplosion() {
        if (this.pExplosion != null) {
            try {
                this.pExplosion.stop();
                this.pExplosion.setMediaTime(0L);
                this.pExplosion.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }
}

