/*
 * Decompiled with CFR 0.152.
 */
package thaptuchinh.image;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import thaptuchinh.data.TtcGameDesign;

public class Images {
    public static Sprite whiteSquare;
    public static Sprite greenSquare;
    public static Sprite fireEnemy;
    public static Sprite fireShip;
    public static Sprite breakShip;

    public static void Init() {
        try {
            fireShip = TtcGameDesign.getM_FireShip();
            fireShip.setFrameSequence(TtcGameDesign.fireShip1);
            fireEnemy = TtcGameDesign.getM_enemy();
            fireEnemy.setFrameSequence(TtcGameDesign.fireEnemy1);
            breakShip = TtcGameDesign.getSquare();
            breakShip.setFrame(2);
            greenSquare = TtcGameDesign.getSquare();
            greenSquare.setFrame(1);
            whiteSquare = TtcGameDesign.getSquare();
            whiteSquare.setFrame(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Image rotateImage(Image image, int angle) throws Exception {
        if (angle == 0) {
            return image;
        }
        if (angle != 180 && angle != 90 && angle != 270) {
            throw new Exception("Invalid angle");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rowData = new int[width];
        int[] rotatedData = new int[width * height];
        int rotatedIndex = 0;
        for (int i = 0; i < height; ++i) {
            image.getRGB(rowData, 0, width, 0, i, width, 1);
            for (int j = 0; j < width; ++j) {
                rotatedIndex = angle == 90 ? height - i - 1 + j * height : (angle == 270 ? i + height * (width - j - 1) : width * height - (i * width + j) - 1);
                rotatedData[rotatedIndex] = rowData[j];
            }
        }
        if (angle == 90 || angle == 270) {
            return Image.createRGBImage((int[])rotatedData, (int)height, (int)width, (boolean)true);
        }
        return Image.createRGBImage((int[])rotatedData, (int)width, (int)height, (boolean)true);
    }

    public static Image rotateImage(Image src, float angle, Graphics g) {
        int sw = src.getWidth();
        int sh = src.getHeight();
        int[] srcData = new int[sw * sh];
        src.getRGB(srcData, 0, sw, 0, 0, sw, sh);
        int[] dstData = new int[sw * sh];
        double rads = (double)angle * Math.PI / 180.0;
        float sa = (float)Math.sin(rads);
        float ca = (float)Math.cos(rads);
        int isa = (int)(256.0f * sa);
        int ica = (int)(256.0f * ca);
        int my = -(sh >> 1);
        for (int i = 0; i < sh; ++i) {
            int mx = -(sw >> 1);
            for (int j = 0; j < sw; ++j) {
                int srcx = mx * ica + my * isa >> 8;
                int srcy = -mx * isa + my * ica >> 8;
                srcy += sh >> 1;
                if ((srcx += sw >> 1) < 0) {
                    srcx = 0;
                }
                if (srcy < 0) {
                    srcy = 0;
                }
                if (srcx > sw - 1) {
                    srcx = sw - 1;
                }
                if (srcy > sh - 1) {
                    srcy = sh - 1;
                }
                dstData[j + i * sw] = srcData[srcx + srcy * sw];
                ++mx;
            }
            ++my;
        }
        return Image.createRGBImage((int[])dstData, (int)sw, (int)sh, (boolean)true);
    }
}

