/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.screen;

import com.bgate.core.Screen;
import com.bgate.game.MainGame;
import com.bgate.screen.LevelScreen;
import com.bgate.utils.PiPoDesigner;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HighScoreScreen
extends Screen {
    int count;
    Image img;
    int postX;
    int postY;
    public int stage;
    private String[] option = new String[]{"Spring Season", "Summer Season", "Autumn Season", "Winter Season"};

    public HighScoreScreen(MainGame game) {
        super(game);
        this.init();
    }

    public void init() {
        this.stage = 1;
    }

    public void setState(int stage) {
        this.stage = stage;
    }

    public void setData() {
        try {
            this.img = this.getHeight() > 260 ? Image.createImage((String)"/img/menu.png") : Image.createImage((String)"/img/menu2.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.postX = this.getWidth() / 2 - this.img.getWidth() / 2;
        this.postY = this.getHeight() / 2 - this.img.getHeight() / 2;
    }

    public void update() {
        ++this.count;
    }

    public void present(Graphics g) {
        g.setColor(255, 255, 255);
        g.drawImage(this.img, this.postX, this.postY, 0);
        PiPoDesigner.drawCenterString(g, this.option[this.stage - 1], -16777216, -1, this.getWidth() / 2, 20);
        PiPoDesigner.drawCenterString(g, "Back", -16777216, -1, this.getWidth() - 25, this.getHeight() - 20);
        g.setColor(255, 0, 0);
        g.fillTriangle(this.getWidth() - 20, 20, this.getWidth() - 20, 40, this.getWidth() - 10, 30);
        g.fillTriangle(20, 20, 20, 40, 10, 30);
        for (int i = 0; i < 10; ++i) {
            try {
                int j;
                int k = this.Star(this.stage, i + 1, MainGame.highScore.getValues()[(this.stage - 1) * 10 + i]);
                if (i + 1 == LevelScreen.choice && this.stage == MainGame.stage) {
                    if (this.count % 4 == 0) continue;
                    for (j = 0; j < k; ++j) {
                        PiPoDesigner.drawCenterString(g, "*", -16777216, -1, this.getWidth() / 2 - 10 + 10 * j, 20 + (i + 1) * this.getHeight() / 12);
                    }
                    PiPoDesigner.drawCenterString(g, "Lv", -16777216, -1, this.getWidth() / 2 - 78, 20 + (i + 1) * this.getHeight() / 12);
                    this.drawAddScore(g, i + 1 + "", this.getWidth() / 2 - 70, 20 + (i + 1) * this.getHeight() / 12);
                    this.drawAddScore(g, MainGame.highScore.getValues()[(this.stage - 1) * 10 + i] + "", this.getWidth() / 2 + 50, 20 + (i + 1) * this.getHeight() / 12);
                    continue;
                }
                for (j = 0; j < k; ++j) {
                    PiPoDesigner.drawCenterString(g, "*", -16777216, -1, this.getWidth() / 2 - 10 + 10 * j, 20 + (i + 1) * this.getHeight() / 12);
                }
                PiPoDesigner.drawCenterString(g, "Lv", -16777216, -1, this.getWidth() / 2 - 78, 20 + (i + 1) * this.getHeight() / 12);
                this.drawAddScore(g, i + 1 + "", this.getWidth() / 2 - 70, 20 + (i + 1) * this.getHeight() / 12);
                this.drawAddScore(g, MainGame.highScore.getValues()[(this.stage - 1) * 10 + i] + "", this.getWidth() / 2 + 50, 20 + (i + 1) * this.getHeight() / 12);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void pause() {
    }

    public void resume() {
    }

    public void dispose() {
        this.img = null;
    }

    public void handleSms(boolean success) {
    }

    public void switchScreen() {
    }

    public void upKeyPressed() {
    }

    public void downKeyPressed() {
    }

    public void rightKeyPressed() {
        this.stage = this.stage < 4 ? ++this.stage : 1;
    }

    public void leftKeyPressed() {
        this.stage = this.stage > 1 ? --this.stage : 4;
    }

    public void fireKeyPressed() {
        this.img = null;
        this.game.setScreen(new LevelScreen((MainGame)this.game));
    }

    public void softKeyLeftPressed() {
    }

    public void softKeyRightPressed() {
        this.img = null;
        this.game.setScreen(new LevelScreen((MainGame)this.game));
    }

    public void numberKeyPressed(int keyCode) {
    }

    public void upKeyRealeased() {
    }

    public void downKeyRealeased() {
    }

    public void rightKeyRealeased() {
    }

    public void leftKeyRealeased() {
    }

    public void upKeytRepeated() {
    }

    public void downKeyRepeated() {
    }

    public void rightKeyRepeated() {
    }

    public void leftKeyRepeated() {
    }

    public void pointerPressed(int x, int y) {
        if (x >= this.getWidth() - 35 && x <= this.getWidth() && y >= this.getHeight() - 25 && y <= this.getHeight()) {
            this.game.setScreen(new LevelScreen((MainGame)this.game));
        } else if (x >= this.getWidth() - 20 && x <= this.getWidth() && y >= 20 && y <= 40) {
            this.rightKeyPressed();
        } else if (x >= 20 && x <= 40 && y >= 20 && y <= 40) {
            this.leftKeyPressed();
        }
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerDragged(int x, int y) {
    }

    protected void paint(Graphics grphcs) {
        this.present(grphcs);
    }

    public int Star(int stage, int level, int score) {
        int star = 0;
        if (level == 1) {
            if (score >= 300) {
                star = 3;
            } else if (score >= 250 && score < 300) {
                star = 2;
            } else if (score >= 200 && score < 250) {
                star = 1;
            } else if (star < 200) {
                star = 0;
            }
        } else if (level == 2) {
            if (score >= 350) {
                star = 3;
            } else if (score >= 300 && score < 350) {
                star = 2;
            } else if (score >= 250 && score < 300) {
                star = 1;
            } else if (star < 250) {
                star = 0;
            }
        } else if (level == 3) {
            if (score >= 400) {
                star = 3;
            } else if (score >= 350 && score < 400) {
                star = 2;
            } else if (score >= 300 && score < 350) {
                star = 1;
            } else if (star < 300) {
                star = 0;
            }
        } else if (level == 4) {
            if (score >= 450) {
                star = 3;
            } else if (score >= 400 && score < 450) {
                star = 2;
            } else if (score >= 350 && score < 400) {
                star = 1;
            } else if (star < 350) {
                star = 0;
            }
        } else if (level == 5) {
            if (score >= 500) {
                star = 3;
            } else if (score >= 350 && score < 500) {
                star = 2;
            } else if (score >= 400 && score < 450) {
                star = 1;
            } else if (star < 400) {
                star = 0;
            }
        } else if (level == 6) {
            if (score >= 600) {
                star = 3;
            } else if (score >= 550 && score < 600) {
                star = 2;
            } else if (score >= 450 && score < 550) {
                star = 1;
            } else if (star < 450) {
                star = 0;
            }
        } else if (level == 7) {
            if (score >= 700) {
                star = 3;
            } else if (score >= 600 && score < 700) {
                star = 2;
            } else if (score >= 500 && score < 600) {
                star = 1;
            } else if (star < 500) {
                star = 0;
            }
        } else if (level == 8) {
            if (score >= 750) {
                star = 3;
            } else if (score >= 700 && score < 750) {
                star = 2;
            } else if (score >= 600 && score < 700) {
                star = 1;
            } else if (star < 600) {
                star = 0;
            }
        } else if (level == 9) {
            if (score >= 900) {
                star = 3;
            } else if (score >= 800 && score < 900) {
                star = 2;
            } else if (score >= 700 && score < 800) {
                star = 1;
            } else if (star < 700) {
                star = 0;
            }
        } else if (level == 10) {
            if (score >= 1200) {
                star = 3;
            } else if (score >= 1000 && score < 1200) {
                star = 2;
            } else if (score >= 800 && score < 1000) {
                star = 1;
            } else if (star < 800) {
                star = 0;
            }
        }
        return star;
    }

    public void drawAddScore(Graphics g, String line, int x, int y) throws IOException {
        Image imgNoAddScore = Image.createImage((String)"/img/number.png");
        int offset = imgNoAddScore.getWidth() / 12;
        for (int i = 0; i < line.length(); ++i) {
            char character = line.charAt(i);
            if (character == ' ') {
                x += offset;
                continue;
            }
            int srcX = 0;
            int srcWidth = 0;
            if (character == '+') {
                srcX = 0;
                srcWidth = offset;
            } else if (character == '-') {
                srcX = offset;
                srcWidth = offset;
            } else if (character == '$') {
                srcX = 12 * offset;
                srcWidth = offset;
            } else {
                srcX = (character - 48) * offset + 2 * offset;
                srcWidth = offset;
            }
            g.drawRegion(imgNoAddScore, srcX, 0, srcWidth, imgNoAddScore.getHeight(), 0, x, y, 20);
            x += srcWidth + 1;
        }
    }
}

