/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.game;

import com.bgate.game.BaseRMS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class UserInfoRMS
extends BaseRMS {
    public int[] level = new int[4];
    public int isGameActive = 0;
    public int isSound = 0;

    public UserInfoRMS(String rmsName) {
        super(rmsName);
        this.initValues();
        this.loadInfo();
    }

    public void loadInfo() {
        try {
            this.open();
            this.loadData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveGameLevel(int stage, int level) {
        try {
            this.open();
            this.level[stage - 1] = level;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveGameActive(int isActive) {
        try {
            this.open();
            this.isGameActive = isActive;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveGameSound(int isSound) {
        try {
            this.open();
            this.isSound = isSound;
            this.updateData();
            if (this.getRecordStore() != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getGameLevel() {
        return this.level;
    }

    public int getGameActive() {
        return this.isGameActive;
    }

    public int getGameSound() {
        return this.isSound;
    }

    public void reset() throws Exception {
        this.open();
        this.initValues();
        this.updateData();
        if (this.getRecordStore() != null) {
            this.close();
        }
    }

    void loadData() {
        try {
            byte[] record = this.getRecordStore().getRecord(1);
            DataInputStream istream = new DataInputStream(new ByteArrayInputStream(record, 0, record.length));
            this.level[0] = istream.readInt();
            this.level[1] = istream.readInt();
            this.level[2] = istream.readInt();
            this.level[3] = istream.readInt();
            this.isGameActive = istream.readInt();
            this.isSound = istream.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void createDefaultData() {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(28);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this.level[0]);
            ostream.writeInt(this.level[1]);
            ostream.writeInt(this.level[2]);
            ostream.writeInt(this.level[3]);
            ostream.writeInt(this.isGameActive);
            ostream.writeInt(this.isSound);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().addRecord(record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void updateData() {
        try {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(28);
            DataOutputStream ostream = new DataOutputStream(bstream);
            ostream.writeInt(this.level[0]);
            ostream.writeInt(this.level[1]);
            ostream.writeInt(this.level[2]);
            ostream.writeInt(this.level[3]);
            ostream.writeInt(this.isGameActive);
            ostream.writeInt(this.isSound);
            ostream.flush();
            ostream.close();
            byte[] record = bstream.toByteArray();
            this.getRecordStore().setRecord(1, record, 0, record.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initValues() {
        for (int i = 0; i < 4; ++i) {
            this.level[i] = 1;
        }
    }
}

