/*
 * Decompiled with CFR 0.152.
 */
package com.iplay.framework;

import com.iplay.framework.ZLIBUtils;

public class PNGUtils {
    private static int[] CRC_TABLE;
    public static final int SIZE_PNG_SIGNATURE = 8;
    private static final int PNG_SIGNATURE_1 = -1991225785;
    private static final int PNG_SIGNATURE_2 = 218765834;
    public static final int SIZE_CHUNK_LENGTH = 4;
    public static final int SIZE_CHUNK_NAME = 4;
    public static final int SIZE_CHUNK_CRC = 4;
    private static final int SIZE_IHDR_WIDTH = 4;
    private static final int SIZE_IHDR_HEIGHT = 4;
    private static final int SIZE_IHDR_BIT_DEPTH = 1;
    private static final int SIZE_IHDR_COLOR_TYPE = 1;
    private static final int SIZE_IHDR_COMPRESSION_METHOD = 1;
    private static final int SIZE_IHDR_FILTER_METHOD = 1;
    private static final int SIZE_IHDR_INTERLACE_METHOD = 1;
    private static final int POSITION_IHDR_WIDTH = 16;
    private static final int POSITION_IHDR_HEIGHT = 20;
    private static final int POSITION_IHDR_BIT_DEPTH = 24;
    private static final int POSITION_IHDR_COLOR_TYPE = 25;
    private static final int POSITION_IHDR_COMPRESSION_METHOD = 26;
    private static final int POSITION_IHDR_FILTER_METHOD = 27;
    private static final int POSITION_IHDR_INTERLACE_METHOD = 28;
    public static final int COLOR_TYPE_GREYSCALE = 0;
    public static final int COLOR_TYPE_RGB = 2;
    public static final int COLOR_TYPE_PAL = 3;
    public static final int COLOR_TYPE_GREYSCALE_ALPHA = 4;
    public static final int COLOR_TYPE_RGB_ALPHA = 6;
    private static final int COMPRESSION_METHOD_BASIC_DEFLATE = 0;
    private static final int FILTER_METHOD_BASIC_ADAPTIVE = 0;
    static final int FILTER_TYPE_NONE = 0;
    static final int FILTER_TYPE_SUB = 1;
    static final int FILTER_TYPE_UP = 2;
    static final int FILTER_TYPE_AVERAGE = 3;
    static final int FILTER_TYPE_PAETH = 4;
    private static final int INTERLACE_METHOD_NONE = 0;
    private static final int INTERLACE_METHOD_ADAM7 = 1;
    private static final int SIZE_IHDR = 13;
    private static final int SIZE_IEND = 0;
    public static final int CHUNKNAME_IHDR = 1229472850;
    public static final int CHUNKNAME_IDAT = 1229209940;
    public static final int CHUNKNAME_PLTE = 1347179589;
    public static final int CHUNKNAME_tRNS = 1951551059;
    public static final int CHUNKNAME_IEND = 1229278788;
    public static final int PALETTE_MODULATE = 0;
    public static final int PALETTE_XOR = 1;
    public static final int PALETTE_XOR_MODULATE = 2;
    public static final int PALETTE_MODULATE_XOR = 3;

    public static void releaseCRCTable() {
        CRC_TABLE = null;
    }

    private static void allocateCRCTable() {
        if (CRC_TABLE == null) {
            int[] crcTable = new int[256];
            for (int n2 = 0; n2 < 256; ++n2) {
                int c2 = n2;
                for (int k2 = 0; k2 < 8; ++k2) {
                    if ((c2 & 1) != 0) {
                        c2 = 0xEDB88320 ^ c2 >>> 1;
                        continue;
                    }
                    c2 >>>= 1;
                }
                crcTable[n2] = c2;
            }
            CRC_TABLE = crcTable;
        }
    }

    public static int getHeaderAttribute(byte[] pngData, int field) {
        return pngData[16 + field];
    }

    public static int getChunkIndex(byte[] pngData, int startIndex, int targetChunkName) {
        int chunkName;
        while ((chunkName = PNGUtils.getChunkName(pngData, startIndex)) != targetChunkName && (startIndex = PNGUtils.getNextChunkStart(pngData, startIndex)) != -1) {
        }
        return startIndex;
    }

    public static int getNextChunkStart(byte[] pngData, int chunkStart) {
        int chunkLength = PNGUtils.getChunkLength(pngData, chunkStart);
        int nextChunkStart = chunkStart + 4 + 4 + chunkLength + 4;
        if (nextChunkStart >= pngData.length) {
            nextChunkStart = -1;
        }
        return nextChunkStart;
    }

    public static int getChunkLength(byte[] pngData, int chunkStart) {
        int chunkLength = MSB.readInt(pngData, chunkStart);
        return chunkLength;
    }

    public static int getChunkCRC(byte[] pngData, int chunkStart) {
        return chunkStart + 4 + 4 + PNGUtils.getChunkLength(pngData, chunkStart);
    }

    public static int getChunkName(byte[] pngData, int chunkStart) {
        int chunkName = MSB.readInt(pngData, chunkStart + 4);
        return chunkName;
    }

    public static void applyTransform(byte[] pngData, int transform) {
    }

    private static int getChunkCount(byte[] pngData, int chunkName) {
        int currentChunkName;
        int chunkCount = 0;
        int chunkOffset = 8;
        do {
            if ((currentChunkName = PNGUtils.getChunkName(pngData, chunkOffset)) == chunkName) {
                ++chunkCount;
            }
            chunkOffset = PNGUtils.getNextChunkStart(pngData, chunkOffset);
        } while (currentChunkName != 1229278788);
        return chunkCount;
    }

    public static byte[] injectChunkData(byte[] pngData, int chunkStart, byte[] chunkData) {
        byte[] target;
        int chunkLength = PNGUtils.getChunkLength(pngData, chunkStart);
        int chunkDataStart = chunkStart + 4 + 4;
        if (chunkLength != chunkData.length) {
            target = new byte[pngData.length + chunkData.length - chunkLength];
            System.arraycopy(pngData, 0, target, 0, chunkDataStart);
            System.arraycopy(pngData, chunkDataStart + chunkLength, target, chunkDataStart + chunkData.length, target.length - chunkDataStart - chunkData.length);
            MSB.writeInt(chunkData.length + 4, target, chunkStart);
        } else {
            target = pngData;
        }
        System.arraycopy(chunkData, 0, target, chunkDataStart, chunkData.length);
        int crc = PNGUtils.generateCRC(target, chunkStart + 4, chunkDataStart + chunkData.length);
        MSB.writeInt(crc, target, chunkDataStart + chunkData.length);
        return target;
    }

    public static void modifyPalette(byte[] pngData, int operation, int modColor) {
        int palChunkStart = PNGUtils.getChunkIndex(pngData, 8, 1347179589);
        int palChunkLength = PNGUtils.getChunkLength(pngData, palChunkStart);
        int palDataStart = palChunkStart + 4 + 4;
        int palDataEnd = palDataStart + palChunkLength;
        block6: for (int i2 = palDataStart; i2 < palDataEnd; ++i2) {
            int componentIndex = (i2 - palDataStart) % 3;
            int componentShift = (2 - componentIndex) * 8;
            int modComponent = modColor >> componentShift & 0xFF;
            switch (operation) {
                case 0: {
                    pngData[i2] = (byte)((pngData[i2] & 0xFF) * modComponent / 255);
                    continue block6;
                }
                case 1: {
                    pngData[i2] = (byte)(pngData[i2] ^ 0xFF);
                    continue block6;
                }
                case 2: {
                    pngData[i2] = (byte)(pngData[i2] & 0xFF ^ 0xFF);
                    pngData[i2] = (byte)((pngData[i2] & 0xFF) * modComponent / 255);
                    continue block6;
                }
                case 3: {
                    pngData[i2] = (byte)((pngData[i2] & 0xFF) * modComponent / 255);
                    pngData[i2] = (byte)(pngData[i2] & 0xFF ^ 0xFF);
                }
            }
        }
        int palCRC = PNGUtils.generateCRC(pngData, palChunkStart + 4, palDataEnd);
        MSB.writeInt(palCRC, pngData, palDataEnd);
    }

    public static int getWidth(byte[] pngData, int offset) {
        return MSB.readInt(pngData, offset + 16);
    }

    public static int getHeight(byte[] pngData, int offset) {
        return MSB.readInt(pngData, offset + 20);
    }

    public static int getBitDepth(byte[] pngData, int offset) {
        return MSB.readByte(pngData, offset + 24);
    }

    public static int getColorType(byte[] pngData, int offset) {
        return MSB.readByte(pngData, offset + 25);
    }

    public static int getCompressionMethod(byte[] pngData, int offset) {
        return MSB.readByte(pngData, offset + 26);
    }

    public static int getFilterMethod(byte[] pngData, int offset) {
        return MSB.readByte(pngData, offset + 27);
    }

    public static int getInterlaceMethod(byte[] pngData, int offset) {
        return MSB.readByte(pngData, offset + 28);
    }

    public static int[] getARGB(byte[] pngData, int offset, int[] argbData) {
        int imgWidth = PNGUtils.getWidth(pngData, offset);
        int imgHeight = PNGUtils.getHeight(pngData, offset);
        if (argbData == null || argbData.length != imgWidth * imgHeight) {
            argbData = new int[imgWidth * imgHeight];
        }
        if (PNGUtils.getColorType(pngData, offset) != 3) {
            return null;
        }
        if (PNGUtils.getBitDepth(pngData, offset) != 8) {
            return null;
        }
        int plteChunkStart = PNGUtils.getChunkIndex(pngData, offset, 1347179589);
        int paletteStart = plteChunkStart + 4 + 4;
        int paletteCount = MSB.readInt(pngData, plteChunkStart) / 3;
        int trnsChunkStart = PNGUtils.getChunkIndex(pngData, offset, 1951551059);
        if (trnsChunkStart != -1) {
            int transStart = trnsChunkStart + 4 + 4;
            int transCount = MSB.readInt(pngData, trnsChunkStart);
        } else {
            boolean transStart = false;
            boolean transCount = false;
        }
        throw new RuntimeException("Not implemented yet!");
    }

    public static byte[] createPNG(int[] rgbData, int width, int height, boolean processAlpha) {
        int bpp = processAlpha ? 4 : 3;
        int USHORT_MAX_VALUE = 65535;
        int uncompressedDataLength = (width * bpp + 1) * height;
        int blocksNeeded = (uncompressedDataLength + 65535 - 1) / 65535;
        int SIZE_IDAT = 2 + blocksNeeded * 5 + uncompressedDataLength + 4;
        int pngLength = 41 + SIZE_IDAT + 4 + 4 + 4 + 0 + 4;
        byte[] dstData = new byte[pngLength];
        int insertPoint = 0;
        MSB.writeInt(-1991225785, dstData, insertPoint);
        MSB.writeInt(218765834, dstData, insertPoint += 4);
        MSB.writeInt(13, dstData, insertPoint += 4);
        int IHDR_CRC_START = insertPoint += 4;
        MSB.writeInt(1229472850, dstData, insertPoint);
        MSB.writeInt(width, dstData, insertPoint += 4);
        MSB.writeInt(height, dstData, insertPoint += 4);
        dstData[insertPoint += 4] = 8;
        dstData[++insertPoint] = processAlpha ? 6 : 2;
        dstData[++insertPoint] = 0;
        dstData[++insertPoint] = 0;
        dstData[++insertPoint] = 0;
        MSB.writeInt(PNGUtils.generateCRC(dstData, IHDR_CRC_START, ++insertPoint), dstData, insertPoint);
        MSB.writeInt(SIZE_IDAT, dstData, insertPoint += 4);
        int IDAT_CRC_START = insertPoint += 4;
        MSB.writeInt(1229209940, dstData, insertPoint);
        ZLIBUtils.writeUncompressedRGBA(rgbData, width, height, processAlpha, dstData, insertPoint += 4);
        MSB.writeInt(PNGUtils.generateCRC(dstData, IDAT_CRC_START, insertPoint += SIZE_IDAT), dstData, insertPoint);
        MSB.writeInt(0, dstData, insertPoint += 4);
        int IEND_CRC_START = insertPoint += 4;
        MSB.writeInt(1229278788, dstData, insertPoint);
        MSB.writeInt(PNGUtils.generateCRC(dstData, IEND_CRC_START, insertPoint += 4), dstData, insertPoint);
        return dstData;
    }

    public static boolean hasAlpha(byte[] pngData, int offset) {
        int colorType = PNGUtils.getColorType(pngData, offset);
        boolean hasAlpha = colorType == 4 || colorType == 6 ? true : PNGUtils.getChunkIndex(pngData, offset + 8, 1951551059) != -1;
        return hasAlpha;
    }

    public static int generateCRC(byte[] data, int startIndex, int endIndex) {
        PNGUtils.allocateCRCTable();
        int crc = -1;
        int BASE = 65521;
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            crc = CRC_TABLE[(crc ^ data[i2]) & 0xFF] ^ crc >>> 8;
        }
        return crc ^= 0xFFFFFFFF;
    }

    public static class MSB {
        public static int readInt(byte[] src, int index) {
            int retValue = (src[index] & 0xFF) << 24 | (src[index + 1] & 0xFF) << 16 | (src[index + 2] & 0xFF) << 8 | src[index + 3] & 0xFF;
            return retValue;
        }

        public static int readShort(byte[] src, int index) {
            int retValue = ((src[index] & 0xFF) << 8 | src[index + 1] & 0xFF) & 0xFFFF;
            return retValue;
        }

        public static int readByte(byte[] src, int index) {
            int retValue = src[index] & 0xFF;
            return retValue;
        }

        public static void writeInt(int val, byte[] dst, int index) {
            dst[index] = (byte)(val >> 24);
            dst[index + 1] = (byte)(val >> 16);
            dst[index + 2] = (byte)(val >> 8);
            dst[index + 3] = (byte)val;
        }

        public static void writeShort(int val, byte[] dst, int index) {
            dst[index] = (byte)(val >> 8);
            dst[index + 1] = (byte)val;
        }

        public static void writeByte(int val, byte[] dst, int index) {
            dst[index] = (byte)val;
        }
    }

    public static class LSB {
        public static int readInt(byte[] src, int index) {
            int retValue = src[index] & 0xFF | (src[index + 1] & 0xFF) << 8 | (src[index + 2] & 0xFF) << 16 | (src[index + 3] & 0xFF) << 24;
            return retValue;
        }

        public static int readShort(byte[] src, int index) {
            int retValue = (src[index] & 0xFF | (src[index + 1] & 0xFF) << 8) & 0xFFFF;
            return retValue;
        }

        public static int readByte(byte[] src, int index) {
            int retValue = src[index] & 0xFF;
            return retValue;
        }

        public static void writeInt(int val, byte[] dst, int index) {
            dst[index] = (byte)val;
            dst[index + 1] = (byte)(val >> 8);
            dst[index + 2] = (byte)(val >> 16);
            dst[index + 3] = (byte)(val >> 24);
        }

        public static void writeShort(int val, byte[] dst, int index) {
            dst[index] = (byte)val;
            dst[index + 1] = (byte)(val >> 8);
        }

        public static void writeByte(int val, byte[] dst, int index) {
            dst[index] = (byte)val;
        }
    }
}

