/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public final class BitmapFont {
    static BitmapFont[] m_Instances;
    short[] m_GlyphWidths;
    short[] m_GlyphOffsets;
    int m_Height;
    Image m_Bitmap;

    BitmapFont(DataInputStream dataInputStream) throws IOException {
        this.loadFromStream(dataInputStream);
    }

    static void loadFonts(InputStream inputStream, int n) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        m_Instances = new BitmapFont[n];
        for (int i = 0; i < n; ++i) {
            BitmapFont bitmapFont = BitmapFont.m_Instances[i] = new BitmapFont(dataInputStream);
            bitmapFont.m_Bitmap = Image.createImage((InputStream)g5.g_app.getClass().getResourceAsStream("/Font" + i + ".png"));
            bitmapFont.m_Height = bitmapFont.m_Bitmap.getHeight();
        }
        inputStream.close();
    }

    static BitmapFont getFont(int n) {
        return m_Instances[n];
    }

    static BitmapFont getFont(int n, int n2, int n3) {
        return BitmapFont.getDefaultFont();
    }

    static BitmapFont getDefaultFont() {
        return BitmapFont.getFont(0);
    }

    int getHeight() {
        return this.m_Height;
    }

    int charsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            n3 += this.m_GlyphWidths[cArray[i] & 0xFF];
        }
        return n3;
    }

    int charWidth(char c) {
        return this.m_GlyphWidths[c & 0xFF];
    }

    int stringWidth(String string) {
        return this.substringWidth(string, 0, string.length());
    }

    int substringWidth(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        return this.charsWidth(cArray, n, n2);
    }

    void drawChars(Renderer renderer, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = 0;
        int n10 = this.m_Height;
        n10 = Math.min(n9 + n10, n4 + n6);
        if ((n10 -= (n9 = Math.max(n9, n4))) <= 0) {
            return;
        }
        int n11 = 0;
        for (int i = 0; i < n2; ++i) {
            int n12 = cArray[n + i] & 0xFF;
            int n13 = this.m_GlyphOffsets[n12];
            int n14 = this.m_GlyphWidths[n12];
            int n15 = Math.max(n11, n3);
            int n16 = Math.min(n11 + n14, n3 + n5);
            if ((n14 = n16 - n15) > 0) {
                renderer.drawRegion(this.m_Bitmap, n13 += n15 - n11, n9, n14, n10, n7, n8, false, false, null);
                n7 += n14;
            }
            n11 += this.m_GlyphWidths[n12];
        }
    }

    protected void loadFromStream(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        this.m_GlyphWidths = new short[n];
        this.m_GlyphOffsets = new short[n];
        for (int i = 0; i < n; ++i) {
            this.m_GlyphOffsets[i] = dataInputStream.readShort();
            dataInputStream.readShort();
            this.m_GlyphWidths[i] = dataInputStream.readShort();
            dataInputStream.readShort();
            dataInputStream.readShort();
            dataInputStream.readShort();
            dataInputStream.readByte();
        }
        dataInputStream.readShort();
    }
}

