/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class CEffectPattern
implements EffectTypes {
    byte m_Type;
    byte m_Layer;
    byte m_System;
    int m_Duration;
    protected static int[] m_coords1 = new int[3];
    protected static int[] m_coords2 = new int[3];
    protected static int[] m_coords3 = new int[3];
    protected static int[] m_coords = new int[3];
    short[][] m_Clip;
    static final int COMPLEX_PlaceX = 0;
    static final int COMPLEX_PlaceY = 1;
    static final int COMPLEX_PlaceZ = 2;
    static final int COMPLEX_PatternID = 3;
    static final int COMPLEX_SpawnRate = 4;
    static final int COMPLEX_Max = 5;
    int[][] m_Complex;
    static final int CONTROL_Type = 0;
    static final int CONTROL_Shift = 1;
    static final int CONTROL_Var1 = 2;
    static final int CONTROL_Var2 = 3;
    static final int CONTROL_Max = 4;
    static final int PARAM_Value = 0;
    static final int PARAM_Dispersion = 1;
    static final int PARAM_Max = 2;
    CEffectPattern m_Pattern;
    int[] m_Controls;
    int[][] m_Params;
    int m_Color;
    int m_Size;
    int m_Length;
    int m_Detail;
    int m_ColorAux;
    int[][] m_AuxVectors;

    CEffectPattern() {
    }

    void Init(DataInputStream dataInputStream) throws IOException {
        this.m_Type = (byte)dataInputStream.readInt();
        this.m_Layer = (byte)dataInputStream.readInt();
        this.m_System = (byte)dataInputStream.readInt();
        this.m_Duration = dataInputStream.readUnsignedShort();
        switch (this.m_Type) {
            case 0: {
                this.Simple_Init(dataInputStream);
                break;
            }
            case 1: {
                this.Complex_Init(dataInputStream);
                break;
            }
            case 2: {
                this.Dynamic_Init(dataInputStream);
                break;
            }
            case 3: {
                this.Point_Init(dataInputStream);
                break;
            }
            case 4: {
                this.Trace_Init(dataInputStream);
                break;
            }
            case 5: {
                this.Ray_Init(dataInputStream);
                break;
            }
            case 6: {
                this.Rail_Init(dataInputStream);
            }
        }
    }

    void Create(CEffectObject cEffectObject, int[] nArray, Object object) {
        cEffectObject.Host = object;
        g5.Math_CopyVector3D(cEffectObject.Position, cEffectObject.GetHostPosition());
        if (null != nArray) {
            switch (this.m_System) {
                case 0: {
                    g5.Math_SubVector3D(cEffectObject.Position, nArray, cEffectObject.GetHostPosition());
                    break;
                }
                case 1: {
                    g5.Math_CopyVector3D(cEffectObject.Position, nArray);
                }
            }
        }
        this.GetPosition(cEffectObject, cEffectObject.AuxPosition);
        switch (this.m_Type) {
            case 2: {
                this.Dynamic_Create(cEffectObject, nArray, object);
            }
        }
    }

    boolean Update(CEffectObject cEffectObject, int n) {
        n = Math.min(this.m_Duration - cEffectObject.LifeTime, n);
        switch (this.m_Type) {
            case 1: {
                this.Complex_Update(cEffectObject, n);
                break;
            }
            case 2: {
                return this.Dynamic_Update(cEffectObject, n);
            }
        }
        cEffectObject.LifeTime += n;
        return cEffectObject.LifeTime < this.m_Duration;
    }

    void Render(CEffectObject cEffectObject, Graphics graphics, byte by) {
        if (by != this.m_Layer) {
            return;
        }
        switch (this.m_Type) {
            case 0: {
                this.Simple_Render(cEffectObject, graphics);
                break;
            }
            case 2: {
                this.Dynamic_Render(cEffectObject, graphics);
                break;
            }
            case 3: {
                this.Point_Render(cEffectObject, graphics);
                break;
            }
            case 4: {
                this.Trace_Render(cEffectObject, graphics);
                break;
            }
            case 5: {
                this.Ray_Render(cEffectObject, graphics);
                break;
            }
            case 6: {
                this.Rail_Render(cEffectObject, graphics);
            }
        }
    }

    void GetPosition(CEffectObject cEffectObject, int[] nArray) {
        int[] nArray2 = m_coords;
        switch (this.m_System) {
            case 0: {
                g5.Math_AddVector3D(nArray2, cEffectObject.Position, cEffectObject.GetHostPosition());
                break;
            }
            case 1: {
                nArray2 = cEffectObject.Position;
            }
        }
        g5.Math_AddVector3D(nArray, nArray2, cEffectObject.Placement);
    }

    void Simple_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Clip = g5.Clip_GetClip(dataInputStream.readInt());
    }

    void Simple_Render(CEffectObject cEffectObject, Graphics graphics) {
        if (null == this.m_Clip || 0 == this.m_Clip.length) {
            return;
        }
        this.GetPosition(cEffectObject, m_coords1);
        if (m_coords1[2] < 0) {
            return;
        }
        short[] sArray = this.m_Clip[0];
        short s = sArray[Math.max(0, cEffectObject.LifeTime) * sArray.length / this.m_Duration];
        CGameScene.RenderTile(graphics, s, CGameScene.WorldToScreenX(m_coords1), CGameScene.WorldToScreenY(m_coords1));
    }

    void Complex_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Complex = new int[dataInputStream.readShort()][];
        for (int i = 0; i < this.m_Complex.length; ++i) {
            this.m_Complex[i] = new int[5];
            int[] nArray = this.m_Complex[i];
            nArray[3] = dataInputStream.readInt();
            nArray[4] = dataInputStream.readUnsignedShort();
            nArray[0] = dataInputStream.readInt();
            nArray[1] = dataInputStream.readInt();
            nArray[2] = dataInputStream.readInt();
        }
    }

    boolean Complex_Update(CEffectObject cEffectObject, int n) {
        this.GetPosition(cEffectObject, m_coords1);
        for (int i = 0; i < this.m_Complex.length; ++i) {
            int[] nArray = cEffectObject.AuxData;
            int[] nArray2 = this.m_Complex[i];
            g5.Math_AddVector3D(m_coords2, m_coords1, nArray2);
            int n2 = i;
            nArray[n2] = nArray[n2] - n;
            while (nArray[i] < 0) {
                CGameScene.Effects_Create(nArray2[3], m_coords2, cEffectObject.Host);
                int n3 = i;
                nArray[n3] = nArray[n3] + nArray2[4];
            }
        }
        return true;
    }

    void Dynamic_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Pattern = CGameScene.m_EffectPatterns[dataInputStream.readInt()];
        this.m_Params = new int[dataInputStream.readShort()][];
        this.m_Controls = new int[4 * this.m_Params.length];
        for (int i = 0; i < this.m_Params.length; ++i) {
            this.m_Controls[i * 4 + 0] = dataInputStream.readInt();
            this.m_Controls[i * 4 + 1] = dataInputStream.readInt();
            this.m_Controls[i * 4 + 2] = dataInputStream.readInt();
            this.m_Controls[i * 4 + 3] = dataInputStream.readInt();
            this.m_Params[i] = new int[2 * dataInputStream.readShort()];
            for (int j = 0; j < this.m_Params[i].length; ++j) {
                this.m_Params[i][j] = dataInputStream.readInt();
            }
        }
    }

    void Dynamic_Create(CEffectObject cEffectObject, int[] nArray, Object object) {
        for (int i = 0; i < this.m_Params.length; ++i) {
            int[] nArray2 = this.m_Params[i];
            int[] nArray3 = cEffectObject.ParamData[i];
            for (int j = 0; j < nArray2.length; j += 2) {
                int n = nArray2[j + 1];
                nArray3[j / 2] = nArray2[j + 0] + g5.Math_GetRandomInt(n * 2) - n;
            }
            switch (this.m_Controls[i * 4 + 0]) {
                case 2: {
                    nArray3[3] = -g5.Math_Parabola(nArray3[2], nArray3[0], nArray3[1]);
                }
            }
        }
    }

    boolean Dynamic_Update(CEffectObject cEffectObject, int n) {
        int n2 = cEffectObject.LifeTime + n;
        for (int i = 0; i < this.m_Params.length; ++i) {
            int n3 = i * 4;
            this.Dynamic_UpdateControl(cEffectObject, this.m_Controls[n3 + 1] + n2, this.m_Controls[n3 + 0], this.m_Controls[n3 + 2], this.m_Controls[n3 + 3], cEffectObject.ParamData[i]);
        }
        cEffectObject.LifeTime %= this.m_Pattern.m_Duration;
        this.m_Pattern.Update(cEffectObject, n);
        cEffectObject.LifeTime = n2;
        return cEffectObject.LifeTime < this.m_Duration;
    }

    void Dynamic_Render(CEffectObject cEffectObject, Graphics graphics) {
        int n = cEffectObject.LifeTime;
        byte by = this.m_Pattern.m_System;
        cEffectObject.LifeTime %= this.m_Pattern.m_Duration;
        this.m_Pattern.m_System = this.m_System;
        this.m_Pattern.Render(cEffectObject, graphics, this.m_Pattern.m_Layer);
        this.m_Pattern.m_System = by;
        cEffectObject.LifeTime = n;
    }

    void Dynamic_UpdateControl(CEffectObject cEffectObject, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = 0;
        int n6 = 0;
        switch (n2) {
            case 0: {
                n5 = nArray[0] * n / 1000 + nArray[1];
                break;
            }
            case 1: {
                g5.Math_PolarToOrthogonalFlt(nArray[0], nArray[1] * n / 1000);
                n5 = g5.ret_rPolarToOrthogonal_rX;
                n6 = g5.ret_rPolarToOrthogonal_rY;
                break;
            }
            case 2: {
                n5 = g5.Math_Parabola(nArray[2] + 65536 * n / 1000, nArray[0], nArray[1]) + nArray[3];
                break;
            }
            case 3: {
                n5 = g5.Math_MulFlt(g5.Math_MulFlt(nArray[1], Math.abs(g5.Math_SinFlt(nArray[0] * n / 1000))), g5.Math_Exp(nArray[2] * n / 1000));
            }
        }
        cEffectObject.SetValue(n3, n5);
        cEffectObject.SetValue(n4, n6);
    }

    void Point_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Color = dataInputStream.readInt();
        this.m_Size = dataInputStream.readUnsignedByte();
    }

    void Point_Render(CEffectObject cEffectObject, Graphics graphics) {
        this.GetPosition(cEffectObject, m_coords1);
        if (m_coords1[2] < 0) {
            return;
        }
        graphics.setColor(this.m_Color);
        graphics.fillRect(CGameScene.WorldToScreenX(m_coords1) - this.m_Size / 2, CGameScene.WorldToScreenY(m_coords1) - this.m_Size / 2, this.m_Size, this.m_Size);
    }

    void Trace_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Color = dataInputStream.readInt();
        this.m_Length = dataInputStream.readInt();
    }

    void Trace_Render(CEffectObject cEffectObject, Graphics graphics) {
        this.GetPosition(cEffectObject, m_coords1);
        if (m_coords1[2] < 0) {
            return;
        }
        int n = g5.Math_GetMagnitudeFast3DFlt(m_coords1[0] - cEffectObject.AuxPosition[0], m_coords1[1] - cEffectObject.AuxPosition[1], m_coords1[2] - cEffectObject.AuxPosition[2]);
        g5.Math_InterpolateVector3D(m_coords2, cEffectObject.AuxPosition, m_coords1, -n, 0, -this.m_Length);
        if (n > 65) {
            g5.Math_CopyVector3D(cEffectObject.AuxPosition, m_coords1);
        }
        graphics.setColor(this.m_Color);
        graphics.drawLine(CGameScene.WorldToScreenX(m_coords2), CGameScene.WorldToScreenY(m_coords2), CGameScene.WorldToScreenX(m_coords1), CGameScene.WorldToScreenY(m_coords1));
    }

    void Ray_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Color = dataInputStream.readInt();
    }

    void Ray_Render(CEffectObject cEffectObject, Graphics graphics) {
        this.GetPosition(cEffectObject, m_coords1);
        if (m_coords1[2] < 0) {
            return;
        }
        graphics.setColor(this.m_Color);
        graphics.drawLine(CGameScene.WorldToScreenX(cEffectObject.AuxPosition), CGameScene.WorldToScreenY(cEffectObject.AuxPosition), CGameScene.WorldToScreenX(m_coords1), CGameScene.WorldToScreenY(m_coords1));
    }

    void Rail_Init(DataInputStream dataInputStream) throws IOException {
        this.m_Color = dataInputStream.readInt();
        this.m_ColorAux = dataInputStream.readInt();
        this.m_Length = dataInputStream.readInt();
        this.m_Size = dataInputStream.readInt();
        this.m_Detail = dataInputStream.readUnsignedByte();
        this.m_AuxVectors = new int[this.m_Detail + 1][3];
    }

    void Rail_Render(CEffectObject cEffectObject, Graphics graphics) {
        int n;
        int n2;
        this.GetPosition(cEffectObject, m_coords1);
        if (m_coords1[2] < 0) {
            return;
        }
        g5.Math_SubVector3D(m_coords2, m_coords1, cEffectObject.AuxPosition);
        int n3 = g5.Math_ArctanFlt(m_coords2[0], m_coords2[1]) + 102944;
        for (n2 = 0; n2 < this.m_Detail; ++n2) {
            int[] nArray = this.m_AuxVectors[n2];
            g5.Math_PolarToOrthogonalFlt(n2 * 411776 / this.m_Detail, 65536);
            n = g5.Math_MulFlt(cEffectObject.SizeFactor[1], g5.ret_rPolarToOrthogonal_rX);
            nArray[0] = g5.Math_MulFlt(n, g5.Math_CosFlt(n3));
            nArray[1] = g5.Math_MulFlt(n, g5.Math_SinFlt(n3));
            nArray[2] = g5.Math_MulFlt(cEffectObject.SizeFactor[2], g5.ret_rPolarToOrthogonal_rY);
        }
        n2 = g5.Math_GetMagnitudeFast3D(m_coords2);
        int n4 = g5.Math_MulFlt(cEffectObject.SizeFactor[0], this.m_Length) / this.m_Detail;
        n = 0;
        int n5 = 0;
        while (n < n2) {
            g5.Math_InterpolateVector3D(m_coords, cEffectObject.AuxPosition, m_coords1, 0, n2, n);
            int n6 = g5.Math_DivFlt(g5.Math_MulFlt(n2 - n, this.m_Size), n2);
            g5.Math_MulVector3D(m_coords2, this.m_AuxVectors[n5 % this.m_Detail], n6);
            g5.Math_AddVector3D(m_coords, m_coords, m_coords2);
            graphics.setColor(g5.Math_InterpolateColor(this.m_Color, this.m_ColorAux, 0, this.m_Detail, n5 % this.m_Detail));
            graphics.fillRect(CGameScene.WorldToScreenX(m_coords), CGameScene.WorldToScreenY(m_coords), 2, 2);
            n += n4;
            ++n5;
        }
    }
}

