/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class CGameObject {
    public static final int COORD_X = 0;
    public static final int COORD_Y = 1;
    public static final int COORD_Z = 2;
    public static final int COORD_R = 2;
    public static final int COORD_MAX = 3;
    public static final int RECTINFO_L = 0;
    public static final int RECTINFO_T = 1;
    public static final int RECTINFO_R = 2;
    public static final int RECTINFO_B = 3;
    public static final int RECTINFO_MAX = 4;
    public CGameStats m_stats;
    public int m_iUID = -1;
    public short m_life;
    public byte m_camera;
    public int m_flags;
    public int m_Tag;
    public byte m_Layer;
    private int m_State = 1;
    private int m_StateLast = 0;
    private int m_PlayedState = 0;
    private int m_PlayedStateTime = 0;
    private boolean m_StateLocked = false;
    public byte m_InventoryObjectType = (byte)-1;
    public byte m_InventoryAmount = 0;
    protected int m_FlickerFrequency = 0;
    protected int m_FlickerTime = 0;
    protected int m_TimeOut = 0;
    protected byte m_AuxCounter = 0;
    protected int m_ModifiedMaxSpeed;
    public int m_ActiveComponents;
    protected static int[] m_coords11 = new int[3];
    protected static int[] m_coords12 = new int[3];
    protected static int[] m_coords21 = new int[3];
    protected static int[] m_coords22 = new int[3];
    protected static int[] m_coords31 = new int[3];
    protected static int[] m_coords32 = new int[3];
    protected static int[] m_coords33 = new int[3];
    protected static int[] m_coords51 = new int[3];
    protected static int[] m_coords52 = new int[3];
    protected static int[] m_coords61 = new int[3];
    protected static int[] m_frect1 = new int[5];
    protected static int[] m_frect2 = new int[5];
    public static short m_Armour;
    public int m_angle;
    protected int m_angleLast = Integer.MIN_VALUE;
    public int[] m_position = new int[3];
    protected int[] m_positionLast = new int[3];
    protected short[][] m_AnimClip;
    protected byte m_AnimClipChannel;
    protected int m_AnimClipTime;
    protected int m_AnimClipTotalTime;
    protected static final int[][] COLLISION_SlidingVectors;
    protected static final int PROGRESS_None = 0;
    protected static final int PROGRESS_Active = 1;
    protected static final int PROGRESS_Active2 = 2;
    protected static final int PROGRESS_Active3 = 3;
    protected static final int PROGRESS_Active4 = 4;
    protected static final int PROGRESS_Max = 1000;
    static final int AIMING_CLIP_ID = 37;
    protected CGameObject m_ObjectLinked;
    protected int m_ContextProgress;
    protected int m_AuxProgress;
    protected int m_AuxData = 0;
    protected int[] m_AuxVector = new int[5];
    public int[] m_bfight;
    static int m_AimingTime;
    static int m_AimingHeadshotTime;
    static short[] m_AimingTiles;
    static boolean m_PlayerDodgeEnabled;
    public static final int EVENT_None = 0;
    public static final int EVENT_Activate = 1;
    public static final int EVENT_SetFlicker = 2;
    public static final int EVENT_Attack = 3;
    public static final int EVENT_ChangeHitPoints = 4;
    public static final int EVENT_SetFlags = 5;
    public static final int EVENT_ClearFlags = 6;
    public static final int EVENT_SetState = 7;
    public static final int EVENT_MoveTo = 8;
    public static final int EVENT_RotateTo = 9;
    public static final int EVENT_SwitchStatsType = 12;
    public static final int EVENT_SetCamera = 13;
    public static final int EVENT_Teleport = 14;
    public static final int EVENT_Respawn = 15;
    public static final int EVENT_InvulnerableOnRespawn = 16;
    public static final int EVENT_ChangeSpeed = 17;
    public static final int EVENT_PauseBehavior = 18;
    public static final int EVENT_ClipReloaded = 19;
    public static final int ROUTEPOINT_X = 0;
    public static final int ROUTEPOINT_Y = 1;
    public static final int ROUTEPOINT_Z = 2;
    public static final int ROUTEPOINT_TYPE = 3;
    public static final int ROUTEPOINT_LEN = 4;
    public static final int ROUTEPOINT_MAX = 5;
    public static final int ROUTEPOINTTYPE_NONE = 0;
    public static final int ROUTEPOINTTYPE_NORMAL = 1;
    public static final int ROUTEPOINTTYPE_CYCLE = 2;
    public static final int ROUTEPOINTTYPE_DIE = 3;
    public static final int ROUTEPOINTTYPE_PAUSE = 4;
    public int[][] m_route;
    public int m_route_progress;
    protected int m_route_length;
    protected boolean m_route_paused;
    public int m_Speed;
    public int[][] m_RouteExtra;
    public int[] m_zone = null;
    public static final int BEHAVIOR_TYPE_NONE = 0;
    public static final int BEHAVIOR_TYPE_MOVER = 2;
    public static final int BEHAVIOR_TYPE_WARRIOR = 4;
    public static final int BEHAVIOR_TYPE_MOVER_CAM = 18;
    public static final int BEHAVIOR_MOVER_2POINTS = 2;
    public static final int BEHAVIOR_MOVER_3POINTS = 3;
    public static final int BEHAVIOR_MOVER_POINT_0 = 0;
    public static final int BEHAVIOR_MOVER_POINT_1 = 1;
    public static final int BEHAVIOR_MOVER_POINT_2 = 2;
    protected int m_BehaviorType = 0;
    protected CGameObject m_BehaviorMoverCam_Object;
    private int m_WarriorAttackTimeout;
    private boolean m_WarriorInactive;
    static final int BEHSTATE_Idle = 0;
    static final int BEHSTATE_Attacking = 0;
    public int m_WeaponCurrent;
    public int[] m_WeaponAmmo;
    public int[] m_WeaponAmmoInClip;
    public int[] m_AvailableWeapons;
    public int[] m_Momentum = new int[3];
    CGameObject m_ObjectTarget = null;
    private Vector m_Targets = new Vector();
    private int m_SelectedTarget = 0;

    public void Positionable_InitPosition(int[] nArray) {
        this.Positionable_SetPosition(nArray);
        g5.Math_CopyVector3D(this.m_positionLast, this.m_position);
    }

    protected void Positionable_GetPosition(int[] nArray, int n) {
        switch (n) {
            case 2: {
                if (this.m_stats.isPlayer()) {
                    g5.Math_PolarToOrthogonalFlt(this.m_angle, 24576);
                    nArray[0] = this.m_position[0] + g5.ret_rPolarToOrthogonal_rX;
                    nArray[1] = this.m_position[1] + g5.ret_rPolarToOrthogonal_rY;
                    nArray[2] = this.m_position[2];
                    break;
                }
            }
            case 0: {
                nArray[0] = this.m_position[0];
                nArray[1] = this.m_position[1];
                nArray[2] = this.m_position[2];
                break;
            }
            case 1: {
                nArray[0] = CGameScene.WorldToScreenX(this.m_position);
                nArray[1] = CGameScene.WorldToScreenY(this.m_position);
            }
        }
    }

    public void Positionable_SetPosition(int[] nArray) {
        this.Positionable_SetPosition(nArray[0], nArray[1], nArray[2]);
    }

    public void Positionable_SetPosition(int n, int n2, int n3) {
        this.m_position[0] = n;
        this.m_position[1] = n2;
        this.m_position[2] = n3;
    }

    public void Positionable_SetDirection(int[] nArray) {
        this.Positionable_SetDirection(nArray[0], nArray[1]);
    }

    public void Positionable_SetDirection(int n, int n2) {
        g5.Math_OrthogonalToPolarFlt(n - this.m_position[0], n2 - this.m_position[1]);
        this.Positionable_SetDirection(g5.ret_rOrthogonalToPolar_rAngle);
    }

    public void Positionable_SetDirection(int n) {
        this.m_angle = g5.Math_NormalizeAngle_0_2Pi_Flt(n);
    }

    public int Positionable_GetFastDistanceTo(CGameObject cGameObject) {
        return Math.max(Math.abs(cGameObject.m_position[0] - this.m_position[0]), Math.abs(cGameObject.m_position[1] - this.m_position[1]));
    }

    public int Positionable_GetFastDistanceTo(int[] nArray) {
        return Math.max(Math.abs(nArray[0] - this.m_position[0]), Math.abs(nArray[1] - this.m_position[1]));
    }

    public int Positionable_GetDistanceTo(CGameObject cGameObject) {
        return g5.Math_GetMagnitudeFast2DFlt(cGameObject.m_position[0] - this.m_position[0], cGameObject.m_position[1] - this.m_position[1]);
    }

    public void Animateable_Init() {
        this.Animateable_Update(0);
    }

    public void Animateable_Update(int n) {
        if (0 == this.m_stats.m_Animators.length) {
            return;
        }
        int n2 = this.getState();
        if (n2 != this.m_StateLast) {
            for (int i = 0; i < this.m_stats.m_Animators.length; ++i) {
                int[] nArray = this.m_stats.m_Animators[i];
                if (nArray[0] != n2) continue;
                this.m_AnimClip = g5.Clip_GetClip(nArray[1]);
                this.m_AnimClipTime = 0;
                this.m_AnimClipTotalTime = nArray[2];
                break;
            }
            if (null == this.m_AnimClip) {
                Debug.Println("Animateable_Update: unknown state " + n2 + " for class " + this.m_stats.m_type);
            }
        } else {
            switch (CGameStats.STATE_Type[n2]) {
                case 0: {
                    this.m_AnimClipTime += n;
                }
                case 1: {
                    this.m_AnimClipTime %= this.m_AnimClipTotalTime;
                    break;
                }
                case 2: {
                    this.m_AnimClipTime = Math.min(this.m_AnimClipTime + n, this.m_AnimClipTotalTime - 1);
                }
            }
        }
        if (null == this.m_AnimClip || 0 == this.m_AnimClip.length) {
            return;
        }
        if (this.m_angle != this.m_angleLast || n2 != this.m_StateLast) {
            this.m_AnimClipChannel = (byte)g5.Math_AngleToDirectionFlt(this.m_angle, this.m_AnimClip.length, (this.m_stats.m_flags_ex & 8) != 0);
        }
    }

    protected void Animateable_Render(Graphics graphics, byte by) {
        boolean bl;
        if (by != this.m_Layer) {
            return;
        }
        if (null == this.m_AnimClip || 0 == this.m_AnimClip.length) {
            return;
        }
        short[] sArray = this.m_AnimClip[this.m_AnimClipChannel];
        if (sArray.length == 0) {
            return;
        }
        short s = sArray[this.m_AnimClipTime * sArray.length / this.m_AnimClipTotalTime];
        this.Positionable_GetPosition(m_coords31, 1);
        boolean bl2 = bl = this.m_position[2] < 0;
        if (bl) {
            g5.graphicsGetClip(graphics, m_frect1);
            g5.Tile_GetScreenRect(s, m_coords31[0], m_coords31[1] + (this.m_position[2] >> 12), m_frect2, 0);
            g5.graphicsClipRect(graphics, m_frect2);
        }
        CGameScene.RenderTile(graphics, s, m_coords31[0], m_coords31[1]);
        if (bl) {
            g5.graphicsSetClip(graphics, m_frect1);
        }
    }

    public int Animateable_GetAnimationTime(int n) {
        if (null == this.m_stats.m_Animators) {
            return 0;
        }
        for (int i = 0; i < this.m_stats.m_Animators.length; ++i) {
            if (n != this.m_stats.m_Animators[i][0]) continue;
            return this.m_stats.m_Animators[i][2];
        }
        return 0;
    }

    public int Animateable_GetAnimationClipID(int n) {
        if (null == this.m_stats.m_Animators) {
            return -1;
        }
        for (int i = 0; i < this.m_stats.m_Animators.length; ++i) {
            if (n != this.m_stats.m_Animators[i][0]) continue;
            return this.m_stats.m_Animators[i][1];
        }
        return -1;
    }

    protected boolean Animateable_GetScreenRect(int[] nArray) {
        if (null == this.m_AnimClip || 0 == this.m_AnimClip.length) {
            return false;
        }
        short[] sArray = this.m_AnimClip[this.m_AnimClipChannel];
        short s = sArray[this.m_AnimClipTime * sArray.length / this.m_AnimClipTotalTime];
        this.Positionable_GetPosition(m_coords31, 1);
        g5.Tile_GetScreenRect(s, m_coords31[0], m_coords31[1], nArray, 0);
        return true;
    }

    public boolean CollisionControl_Update(int n) {
        int n2 = this.CollisionControl_GetCorrectedPosition(this.m_positionLast, this.m_position, m_coords32, -1);
        if (n2 <= 0) {
            return true;
        }
        g5.Math_SubVector3D(m_coords61, this.m_position, m_coords32);
        this.Positionable_SetPosition(m_coords32);
        boolean bl = true;
        if (this.m_stats.m_bSlidingEnabled) {
            int n3 = Integer.MAX_VALUE;
            for (int i = 0; i < COLLISION_SlidingVectors.length; ++i) {
                int n4 = g5.Math_GetDotProduct2D(COLLISION_SlidingVectors[i], m_coords61);
                if (n4 <= 0) continue;
                g5.Math_MulVector2D(m_coords51, COLLISION_SlidingVectors[i], n4);
                g5.Math_AddVector2D(m_coords52, m_coords32, m_coords51);
                int n5 = this.CollisionControl_GetCorrectedPosition(m_coords32, m_coords52, m_coords51, -1);
                if (n5 >= n4 || n5 >= n3) continue;
                this.Positionable_SetPosition(m_coords51);
                n3 = n5;
                if (0 != n5) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            this.CollisionControl_OnCollision();
        }
        return false;
    }

    public int CollisionControl_GetCorrectedPosition(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        if (nArray[0] == nArray2[0] && nArray[1] == nArray2[1]) {
            return 0;
        }
        int n2 = g5.Math_GetMagnitudeFast2DFlt(nArray[0] - nArray2[0], nArray[1] - nArray2[1]);
        int n3 = Math.min(CGameScene.g_scene.m_cellWidth, CGameScene.g_scene.m_cellHeight);
        int n4 = (n2 + n3 - 1) / n3;
        g5.Math_CopyVector3D(nArray3, nArray);
        for (int i = 1; i <= n4; ++i) {
            g5.Math_InterpolateVector3D(m_coords31, nArray, nArray2, 0, n4, i);
            CTerrainObject.setCollisionHint(this.m_stats.m_bSlidingEnabled ? 1 : 0);
            Object object = CGameScene.g_scene.isPositionBlocked(m_coords31[0], m_coords31[1], this.m_stats.m_size, true, true, this, n, this.m_stats.m_ExcludeObjectsMask);
            CTerrainObject.setCollisionHint(0);
            if (null != object && object instanceof CTerrainObject && 0 != (this.m_stats.m_PassableCellsMask & 1 << CTerrainObject.CheckedPassValue)) {
                object = null;
            }
            if (null != object) {
                return n2 - (i - 1) * n2 / n4;
            }
            g5.Math_CopyVector3D(nArray3, m_coords31);
        }
        return 0;
    }

    protected void CollisionControl_OnCollision() {
        if (0 != (this.m_ActiveComponents & 0x60)) {
            this.Behavior_OnCollision();
        } else {
            this.setState(1);
        }
    }

    protected void ContextInteractive_UpdateProgress(int n) {
        if (1 == this.m_ContextProgress) {
            int n2 = ++this.m_ObjectLinked.m_AuxData % this.m_ObjectLinked.m_stats.m_Interactive[0];
            CGameScene.g_scene.Events_PostEvent(0, -1, 17, this.m_ObjectLinked.m_iUID, n2);
            int n3 = this.m_ObjectLinked.m_stats.m_Interactive[1];
            if (n3 >= 0) {
                CGameObject cGameObject = CGameScene.g_scene.GameObject_CreateEffectObject(n3, false, 0, this.m_ObjectLinked.m_position);
                this.m_ObjectLinked.m_TimeOut = cGameObject.Animateable_GetAnimationTime(cGameObject.getState());
            }
            this.m_ContextProgress = 1000;
        }
    }

    protected void ContextInteractive_Render(Graphics graphics, int n, int n2) {
        this.ManualHumanControl_RenderBFight(graphics, 4, true);
    }

    protected void ContextCover_Begin() {
        this.Positionable_SetDirection(this.m_ObjectLinked.m_angle);
        this.Positionable_SetPosition(this.m_ObjectLinked.m_position);
        g5.Math_CopyVector3D(this.m_positionLast, this.m_position);
        CGameScene.g_scene.Events_PostEvent(0, -1, 17, this.m_ObjectLinked.m_iUID, 1);
    }

    protected void ContextCover_End() {
        CGameScene.g_scene.Events_PostEvent(0, -1, 17, this.m_ObjectLinked.m_iUID, 0);
    }

    protected void ContextCover_UpdateProgress(int n) {
        int n2;
        if (this.m_ContextProgress > 0 && Integer.MIN_VALUE != (n2 = CGameScene.g_scene.Math_GetAngleHeldFlt()) && n2 != this.m_ObjectLinked.m_angle) {
            this.m_ContextProgress = 1000;
        }
    }

    protected void ContextCover_Update(int n) {
        if (this.m_ContextProgress > 0) {
            this.Positionable_SetPosition(this.m_ObjectLinked.m_position);
            this.setState(11);
            this.ManualHumanControl_UpdateWeapon(n, true);
            this.m_flags = 11 == this.getState() ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
        }
    }

    protected void ContextCover_Render(Graphics graphics, int n, int n2) {
        if (this.m_ContextProgress == 0) {
            this.ManualHumanControl_RenderBFight(graphics, 4, true);
        }
    }

    public void ManualHumanControl_Update(int n) {
        if (((this.m_flags | this.m_stats.m_flags) & 8) != 0) {
            if (this.m_ObjectLinked != null && this.m_ContextProgress != 0) {
                this.Context_End();
            }
            return;
        }
        boolean bl = false;
        if (0 == this.m_ContextProgress) {
            bl = this.ManualHumanControl_UpdateMovement(n);
            this.m_ObjectLinked = null;
            Vector vector = CGameScene.g_scene.GameObject_GetActiveObjects();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                CGameObject cGameObject = (CGameObject)vector.elementAt(i);
                if (cGameObject == this || !this.Context_Check(cGameObject)) continue;
                this.m_ObjectLinked = cGameObject;
                break;
            }
        }
        if (null != this.m_ObjectLinked) {
            this.Context_Update(n);
        }
        if (this.m_ContextProgress == 0) {
            if (bl) {
                this.TargetControl_Update(true);
            } else {
                this.ManualHumanControl_UpdateWeapon(n, this.m_ObjectLinked == null);
            }
        }
    }

    protected void ManualHumanControl_UpdateWeapon(int n, boolean bl) {
        if (CGameScene.g_scene.CutScene_IsEnabled()) {
            return;
        }
        this.TargetControl_Update(true);
        if (g5.Input_IsKeyHit(42)) {
            this.TargetControl_SwitchTarget();
        }
        if (g5.Input_IsGameActionHeld(8) && bl) {
            if (null == this.m_ObjectTarget) {
                CGameObject.m_coords51[2] = 0;
                g5.Math_PolarToOrthogonal2D(m_coords51, this.m_angle, 65536);
                g5.Math_AddVector3D(m_coords51, m_coords51, this.m_position);
            } else {
                g5.Math_CopyVector3D(m_coords51, this.m_ObjectTarget.m_position);
                if (this.ManualHumanControl_IsHeadshotAvailable()) {
                    this.m_ObjectTarget.m_flags |= 0x20000;
                    Debug.Println("!!! HEADSHOT !!!");
                }
            }
            int n2 = this.ManualHumanControl_IsHeadshotAvailable() ? 0 : 6881;
            this.WeaponControl_Attack(m_coords51, n2);
        }
        if (g5.Input_IsKeyHit(35)) {
            this.WeaponControl_SwitchToNext();
            if (this.getState() != 11) {
                this.playState(9);
            }
        }
        this.ManualHumanControl_AimingUpdate(n);
    }

    protected boolean ManualHumanControl_UpdateMovement(int n) {
        if (0 == this.m_stats.m_MaxSpeed || ((this.m_flags | this.m_stats.m_flags) & 0x80) != 0 || CGameScene.g_scene.CutScene_IsEnabled()) {
            return false;
        }
        int n2 = CGameScene.g_scene.Math_GetAngleHeldFlt();
        if (Integer.MIN_VALUE != n2) {
            this.Positionable_SetDirection(n2);
            int n3 = this.m_stats.m_MaxSpeed * n / 1000;
            g5.Math_PolarToOrthogonalFlt(n2, n3);
            this.Positionable_SetPosition(this.m_position[0] + g5.ret_rPolarToOrthogonal_rX, this.m_position[1] + g5.ret_rPolarToOrthogonal_rY, this.m_position[2]);
            this.setState(2);
            return true;
        }
        this.setState(1);
        return false;
    }

    protected boolean Context_Check(CGameObject cGameObject) {
        if (((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 8) != 0) {
            return false;
        }
        if (((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x100) != 0 && ((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x400) == 0) {
            return false;
        }
        switch (cGameObject.m_stats.m_type) {
            case 12: {
                return this.Positionable_GetFastDistanceTo(cGameObject) < 98304;
            }
            case 52: {
                return this.Positionable_GetFastDistanceTo(cGameObject) < 2 * this.m_stats.m_size;
            }
        }
        if (0 != (cGameObject.m_ActiveComponents & 0x80)) {
            return 0 == cGameObject.m_TimeOut && this.Positionable_GetFastDistanceTo(cGameObject) < cGameObject.m_stats.m_size + 98304;
        }
        return false;
    }

    protected void Context_Begin() {
        switch (this.m_ObjectLinked.m_stats.m_type) {
            case 12: {
                this.ContextCover_Begin();
                break;
            }
            case 52: {
                g5.Sound_Play(10);
                this.m_ObjectLinked.playState(6);
                this.m_ObjectLinked.m_flags |= 0x100;
                this.m_ObjectLinked.m_camera = 1;
                int n = this.m_ObjectLinked.Animateable_GetAnimationTime(6);
                CGameScene.g_scene.Events_PostEvent(n, -1, 0, this.m_ObjectLinked.m_iUID, 0);
                CGameScene.g_scene.Events_PostEvent(n, this.m_iUID, 13, this.m_camera, 0);
                this.m_camera = 0;
                this.m_ContextProgress = 1000;
            }
        }
    }

    protected void Context_End() {
        switch (this.m_ObjectLinked.m_stats.m_type) {
            case 12: {
                this.ContextCover_End();
            }
        }
        this.m_ContextProgress = 0;
        this.m_AuxProgress = 0;
        this.m_ObjectLinked = null;
    }

    protected void Context_Update(int n) {
        int n2 = this.m_ContextProgress;
        if (1000 != this.m_ContextProgress) {
            this.Context_UpdateProgress(n);
            this.m_ContextProgress = Math.max(0, Math.min(1000, this.m_ContextProgress));
            if (this.m_ContextProgress > 0 && n2 == 0) {
                this.Context_Begin();
            }
        }
        if (null == this.m_ObjectLinked) {
            return;
        }
        switch (this.m_ObjectLinked.m_stats.m_type) {
            case 12: {
                this.ContextCover_Update(n);
            }
        }
        if (this.m_ContextProgress == 1000 || this.m_ContextProgress == 0 && n2 > 0) {
            this.Context_End();
        }
    }

    protected void Context_UpdateProgress(int n) {
        if (this.m_ContextProgress == 0 && (this.isGameActionHit(8) && !CGameScene.g_scene.CutScene_IsEnabled() || ((this.m_ObjectLinked.m_flags | this.m_ObjectLinked.m_stats.m_flags) & 0x10) != 0)) {
            g5.Input_ClearKeys();
            this.m_ContextProgress = 1;
            this.m_AuxProgress = 0;
        }
        switch (this.m_ObjectLinked.m_stats.m_type) {
            case 12: {
                this.ContextCover_UpdateProgress(n);
                break;
            }
            default: {
                if (0 == (this.m_ObjectLinked.m_ActiveComponents & 0x80)) break;
                this.ContextInteractive_UpdateProgress(n);
            }
        }
    }

    protected void ManualHumanControl_Render(Graphics graphics, byte by) {
        if (by != 4) {
            return;
        }
        this.ManualHumanControl_AimingRender(graphics);
        if (null == this.m_ObjectLinked) {
            return;
        }
        if (1000 == this.m_ContextProgress) {
            return;
        }
        this.Positionable_GetPosition(m_coords51, 1);
        int n = m_coords51[0];
        int n2 = m_coords51[1];
        switch (this.m_ObjectLinked.m_stats.m_type) {
            case 12: {
                this.ContextCover_Render(graphics, n, n2);
                break;
            }
            case 52: {
                if (this.m_ContextProgress != 0) break;
                this.ManualHumanControl_RenderBFight(graphics, 4, true);
                break;
            }
            default: {
                if (0 == (this.m_ObjectLinked.m_ActiveComponents & 0x80)) break;
                this.ContextInteractive_Render(graphics, n, n2);
            }
        }
    }

    protected void ManualHumanControl_RenderBFight(Graphics graphics, int n, boolean bl) {
        boolean bl2;
        this.Positionable_GetPosition(m_coords51, 1);
        int n2 = m_coords51[0] + 20;
        int n3 = m_coords51[1];
        boolean bl3 = bl2 = bl ? CGameScene.g_scene.ButtonFight_IsBlinking() : false;
        CGameScene.g_scene.ButtonFight_RenderButton(graphics, n2, n3, n, bl2 ? 1 : (bl ? 0 : 2));
    }

    public boolean ManualHumanControl_IsHasLinkedObject() {
        return null != this.m_ObjectLinked;
    }

    static void ManualHumanControl_AimingInit() {
        m_AimingTiles = g5.Clip_GetClip(37)[0];
        m_AimingHeadshotTime = 1000 - 1000 / m_AimingTiles.length;
    }

    void ManualHumanControl_AimingUpdate(int n) {
        m_AimingTime = this.ManualHumanControl_IsAimingAvailable() ? (m_AimingTime + n) % 1000 : 0;
    }

    void ManualHumanControl_AimingRender(Graphics graphics) {
        if (this.m_ObjectLinked != null && this.m_ObjectLinked.m_stats.m_type != 12) {
            return;
        }
        CGameObject cGameObject = this.m_ObjectTarget;
        if (cGameObject == null || ((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x40000) != 0) {
            return;
        }
        cGameObject.Positionable_GetPosition(m_coords51, 1);
        int n = m_coords51[0];
        int n2 = m_coords51[1] - 20;
        short s = m_AimingTiles[m_AimingTiles.length * m_AimingTime / 1000];
        g5.Tile_Render(graphics, s, n, n2);
    }

    boolean ManualHumanControl_IsAimingAvailable() {
        return !g5.Input_IsAnyActionHeld() && this.WeaponControl_GetType() == 1 && this.m_ObjectTarget != null && this.m_ObjectTarget.m_stats.getHeadlessType() != -1;
    }

    boolean ManualHumanControl_IsHeadshotAvailable() {
        return m_AimingTime > m_AimingHeadshotTime;
    }

    public boolean Events_OnEvent(int n, int n2, int n3) {
        switch (n) {
            case 2: {
                this.m_FlickerFrequency = n2;
                this.m_FlickerTime = 0;
                return true;
            }
            case 4: {
                this.ChangeHitPoints(n2 * this.m_stats.getLife() / 100, 0 != n3);
                return true;
            }
            case 5: {
                this.m_flags |= n2;
                return true;
            }
            case 6: {
                this.m_flags &= ~n2;
                return true;
            }
            case 7: {
                if (((this.m_flags | this.m_stats.m_flags) & 8) != 0) {
                    return true;
                }
                if (0 == n3) {
                    this.setState(n2);
                } else {
                    this.playState(n2);
                }
                this.Animateable_Update(0);
                return true;
            }
            case 8: {
                this.Behavior_Init(2, n2, n3);
                return true;
            }
            case 9: {
                this.Positionable_SetDirection(n2);
                return true;
            }
            case 12: {
                this.ChangeStats(n2);
                return true;
            }
            case 13: {
                this.m_camera = (byte)n2;
                if (n3 > 0) {
                    CGameScene.g_scene.setNewViewImmediately();
                }
                return true;
            }
            case 14: {
                this.m_position[0] = CGameScene.ScreenToWorldX(n2, n3);
                this.m_position[1] = CGameScene.ScreenToWorldY(n2, n3);
                this.m_position[2] = 0;
                CGameScene.g_scene.Triggers_CheckCondition((byte)5);
                CGameScene.g_scene.Triggers_CheckCondition((byte)4);
                g5.Math_CopyVector3D(this.m_positionLast, this.m_position);
                CGameScene.g_scene.setNewViewImmediately();
                return true;
            }
            case 15: {
                this.Respawn();
                return true;
            }
            case 16: {
                if (n2 != 0) {
                    this.m_flags |= 0x200;
                    this.m_FlickerFrequency = 100;
                } else {
                    this.m_flags &= 0xFFFFFDFF;
                    this.m_FlickerFrequency = 0;
                }
                this.m_FlickerTime = 0;
                return true;
            }
            case 17: {
                this.ChangeSpeed(n2);
                return true;
            }
            case 18: {
                if (n2 != 0) {
                    this.m_flags |= 0x80;
                    if (!this.CheckFlags(8)) {
                        this.setState(1);
                        this.Animateable_Update(0);
                    }
                } else {
                    this.m_flags &= 0xFFFFFF7F;
                }
                return true;
            }
        }
        if (0 != (this.m_ActiveComponents & 0x10) && this.WeaponControl_OnEvent(n, n2, n3)) {
            return true;
        }
        return true;
    }

    public void Route_Load(DataInputStream dataInputStream) throws IOException {
        int[][] nArray = new int[dataInputStream.readByte() + 1][5];
        int[] nArray2 = nArray[0];
        nArray2[3] = 1;
        nArray2[0] = this.m_position[0];
        nArray2[1] = this.m_position[1];
        nArray2[2] = this.m_position[2];
        for (int i = 1; i < nArray.length; ++i) {
            int[] nArray3 = nArray[i];
            nArray3[3] = dataInputStream.readByte();
            short s = dataInputStream.readShort();
            short s2 = dataInputStream.readShort();
            nArray3[0] = CGameScene.ScreenToWorldX(s, s2);
            nArray3[1] = CGameScene.ScreenToWorldY(s, s2);
            dataInputStream.readInt();
        }
        if (this.m_route == null) {
            this.m_route = nArray;
            this.Route_OnChanged();
        } else {
            this.m_RouteExtra = nArray;
        }
    }

    public boolean Route_IsPaused() {
        return 0 == this.m_Speed || this.m_route_paused;
    }

    public void Route_SetPause(boolean bl) {
        this.m_route_paused = bl;
    }

    public void Route_OnChanged() {
        this.m_route_length = 0;
        this.m_route_progress = 0;
        this.m_route_paused = false;
        for (int i = 1; i < this.m_route.length; ++i) {
            g5.Math_SubVector2D(m_coords52, this.m_route[i], this.m_route[i - 1]);
            int n = g5.Math_GetMagnitudeFast2D(m_coords52);
            this.m_route_length += n;
            this.m_route[i][4] = this.m_route_length;
        }
    }

    protected boolean Route_IsDone() {
        return this.m_Speed < 0 && this.m_route_progress == 0 || this.m_Speed > 0 && this.m_route_progress == this.m_route_length;
    }

    public int Route_GetType(int n) {
        for (int i = 1; i < this.m_route.length; ++i) {
            if (n > this.m_route[i][4]) continue;
            return this.m_route[i][3];
        }
        return 0;
    }

    public int[] Route_FindPointBetween(int n, int n2) {
        if (null == this.m_route) {
            return null;
        }
        n = Math.max(n, 0);
        n2 = Math.min(n2, this.m_route_length);
        for (int i = 1; i < this.m_route.length; ++i) {
            if (n < this.m_route[i][4] && n2 >= this.m_route[i][4]) {
                return this.m_route[i];
            }
            if (n2 >= this.m_route[i][4]) continue;
            return null;
        }
        return null;
    }

    public void Route_GetPosition(int n, int[] nArray) {
        this.Route_GetPosition(n, nArray, 0);
    }

    public void Route_GetPosition(int n, int[] nArray, int n2) {
        for (int i = 1; i < this.m_route.length; ++i) {
            if (n > this.m_route[i][4]) continue;
            int[] nArray2 = this.m_route[i - 1];
            int[] nArray3 = this.m_route[i];
            g5.Math_InterpolateVector3D(nArray, nArray2, nArray3, this.m_route[i - 1][4], this.m_route[i][4], n);
            if (n2 != 0) {
                g5.Math_SubVector2D(m_coords31, nArray2, nArray3);
                g5.Math_GetOrthoVector2D(m_coords32, m_coords31);
                g5.Math_MulVector2D(m_coords32, m_coords32, g5.Math_DivFlt(n2, g5.Math_SqrtFlt(g5.Math_GetSquareMagnitude2D(m_coords32))));
                g5.Math_AddVector2D(nArray, nArray, m_coords32);
            }
            return;
        }
    }

    public int Route_GetDirection() {
        g5.Math_SubVector2D(m_coords51, this.m_route[this.m_route.length - 1], this.m_route[0]);
        return g5.Math_GetVectorAngle2D(m_coords51);
    }

    public int Route_GetDirection(int n) {
        for (int i = 1; i < this.m_route.length; ++i) {
            if (n > this.m_route[i][4]) continue;
            g5.Math_SubVector2D(m_coords51, this.m_route[i], this.m_route[i - 1]);
            return g5.Math_GetVectorAngle2D(m_coords51);
        }
        return Integer.MIN_VALUE;
    }

    protected boolean Route_Update(int n) {
        if (this.Route_IsPaused()) {
            return false;
        }
        int n2 = this.m_route_progress + this.m_Speed * n / 1000;
        int[] nArray = this.Route_FindPointBetween(this.m_route_progress, n2);
        while (null != nArray && !this.m_route_paused) {
            switch (nArray[3]) {
                case 4: {
                    this.m_route_progress = nArray[4];
                    this.m_route_paused = true;
                    break;
                }
                case 2: {
                    n2 %= this.m_route_length;
                }
            }
            int n3 = nArray[4];
            nArray = this.Route_FindPointBetween(n3, n2);
        }
        this.m_route_progress = Math.max(0, Math.min(this.m_route_length, n2));
        this.Route_GetPosition(this.m_route_progress, this.m_position);
        this.Positionable_SetDirection(this.Route_GetDirection(this.m_route_progress));
        return this.Route_IsDone();
    }

    protected int Route_GetUnblockedDist() {
        if (0 == this.m_Speed) {
            return this.m_route_length;
        }
        if (this.Route_IsDone()) {
            return this.m_route_length;
        }
        int n = Math.min(CGameScene.g_scene.m_cellWidth, CGameScene.g_scene.m_cellHeight);
        int n2 = (this.m_route_length + n - 1) / n;
        for (int i = 1; i <= n2; ++i) {
            g5.Math_InterpolateVector3D(m_coords61, this.m_route[0], this.m_route[1], 0, n2, i);
            Object object = CGameScene.g_scene.isPositionBlocked(m_coords61[0], m_coords61[1], this.m_stats.m_size, true, true, this, -1, 2);
            if (null == object) continue;
            return g5.Math_InterpolateInt(0, this.m_route_length, 0, n2, i);
        }
        return this.m_route_length;
    }

    protected void Route_Invert() {
        if (null == this.m_route) {
            return;
        }
        if (1 == this.m_route.length) {
            return;
        }
        for (int i = 0; i < this.m_route.length / 2; ++i) {
            int n = this.m_route.length - 1 - i;
            for (int j = 0; j < 5; ++j) {
                int n2 = this.m_route[i][j];
                this.m_route[i][j] = this.m_route[n][j];
                this.m_route[n][j] = n2;
            }
        }
        this.m_route[0][4] = 0;
        this.Route_OnChanged();
    }

    public void Zone_Load(DataInputStream dataInputStream) throws IOException {
        this.m_zone = new int[4];
        this.m_zone[0] = dataInputStream.readInt();
        this.m_zone[1] = dataInputStream.readInt();
        this.m_zone[2] = dataInputStream.readInt();
        this.m_zone[3] = dataInputStream.readInt();
    }

    public boolean Zone_IsObjectInZone(CGameObject cGameObject) {
        if (null != this.m_zone) {
            int n = this.m_zone[2] - this.m_zone[0];
            int n2 = this.m_zone[3] - this.m_zone[1];
            return cGameObject.isPositionBlocked(this.m_position[0], this.m_position[1], n / 2, n2 / 2);
        }
        return this.isPositionBlocked(cGameObject);
    }

    void Behavior_Init(int n) {
        this.m_BehaviorType |= n;
        switch (n) {
            case 2: {
                this.BehaviorMover_Init();
                break;
            }
            case 4: {
                this.BehaviorWarrior_Init();
            }
        }
    }

    void Behavior_Init(int n, int n2, int n3) {
        this.m_BehaviorType |= n;
        switch (this.m_BehaviorType) {
            case 2: {
                this.BehaviorMover_Init(CGameScene.ScreenToWorldX(n2, n3), CGameScene.ScreenToWorldY(n2, n3));
                break;
            }
            default: {
                this.Behavior_Init(n);
            }
        }
    }

    void Behavior_Update(int n) {
        if (((this.m_flags | this.m_stats.m_flags) & 8) != 0) {
            return;
        }
        if (18 == (this.m_BehaviorType & 0x12)) {
            this.BehaviorMoverCam_Update(n);
        }
        if (2 == (this.m_BehaviorType & 2)) {
            this.BehaviorMover_Update(n);
        }
        if (4 == (this.m_BehaviorType & 4)) {
            this.BehaviorWarrior_Update(n);
        }
    }

    void Behavior_OnCollision() {
        if (0 != (this.m_BehaviorType & 2)) {
            this.setState(1);
        }
        if (0 != (this.m_BehaviorType & 4)) {
            this.BehaviorWarrior_OnCollision();
        }
    }

    void Behavior_OnAttacked(int n) {
        switch (this.m_BehaviorType) {
            case 4: {
                this.BehaviorWarrior_OnAttacked(n);
            }
        }
    }

    protected void BehaviorMover_Init() {
        this.m_Speed = this.m_ModifiedMaxSpeed;
        this.setState(2);
    }

    protected void BehaviorMover_Init(int n, int n2) {
        this.BehaviorMover_Init(n, n2, false);
    }

    protected void BehaviorMover_Init(int n, int n2, boolean bl) {
        this.m_route = new int[bl ? 3 : 2][5];
        this.m_route[0][0] = this.m_position[0];
        this.m_route[0][1] = this.m_position[1];
        this.m_route[0][2] = 0;
        this.m_route[0][3] = 1;
        this.m_route[1][0] = n;
        this.m_route[1][1] = n2;
        this.m_route[1][2] = 0;
        int n3 = this.m_route[1][3] = bl ? 4 : 1;
        if (bl) {
            System.arraycopy(this.m_route[0], 0, this.m_route[2], 0, this.m_route[0].length);
        }
        this.Route_OnChanged();
        this.Positionable_SetDirection(this.Route_GetDirection(0));
        this.BehaviorMover_Init();
    }

    protected void BehaviorMover_Update(int n) {
        if (((this.m_flags | this.m_stats.m_flags) & 0x80) != 0) {
            return;
        }
        if (null == this.m_route) {
            this.setState(1);
            this.m_BehaviorType = 0;
            if (0 != (this.m_ActiveComponents & 0x40)) {
                this.m_BehaviorType = 4;
            }
            return;
        }
        if (this.Route_Update(n)) {
            this.m_route = null;
        } else {
            this.setState(this.Route_IsPaused() ? 1 : 2);
        }
    }

    protected void BehaviorMoverCam_Init(CGameObject cGameObject, int n, int n2) {
        this.m_route = new int[2][5];
        this.m_BehaviorMoverCam_Object = cGameObject;
        this.m_route[0][3] = 1;
        this.m_route[1][3] = 1;
        this.m_route[0][2] = 0;
        this.m_route[1][2] = 0;
        this.BehaviorMover_Init();
        this.m_Speed = n;
        this.m_AuxData = n2;
    }

    protected void BehaviorMoverCam_Update(int n) {
        if (null == this.m_route) {
            this.setState(1);
            this.m_BehaviorType &= 0xFFFFFFED;
            this.m_position = this.m_BehaviorMoverCam_Object.m_position;
            CGameScene.g_scene.Events_PostEvent(0, -1, 32, this.m_AuxData, 0);
            return;
        }
        this.m_route[0][0] = this.m_position[0];
        this.m_route[0][1] = this.m_position[1];
        this.m_route[1][0] = this.m_BehaviorMoverCam_Object.m_position[0];
        this.m_route[1][1] = this.m_BehaviorMoverCam_Object.m_position[1];
        this.Route_OnChanged();
    }

    void BehaviorWarrior_GoToPlayer(int n) {
        boolean bl;
        CGameObject cGameObject = CGameScene.g_scene.m_player;
        this.BehaviorMover_Init(cGameObject.m_position[0], cGameObject.m_position[1]);
        int n2 = this.m_route_length - 78643;
        int n3 = this.Route_GetUnblockedDist();
        boolean bl2 = bl = n3 < n2;
        if (n2 > 6553 || bl) {
            if (!bl) {
                g5.Math_InterpolateVector3D(this.m_route[1], this.m_route[0], this.m_route[1], 0, this.m_route_length, n2);
                this.m_route[1][4] = this.m_route_length = n2;
            } else {
                this.m_route = new int[3][5];
                this.m_route[0][3] = 1;
                this.m_route[1][3] = 1;
                this.m_route[2][3] = 1;
                this.m_route[0][0] = this.m_position[0];
                this.m_route[0][1] = this.m_position[1];
                this.m_route[0][2] = this.m_position[2];
                this.m_route[2][0] = cGameObject.m_position[0];
                this.m_route[2][1] = cGameObject.m_position[1];
                this.m_route[2][2] = this.m_position[2];
                g5.Math_InterpolateVector3D(this.m_route[2], this.m_route[0], this.m_route[2], 0, this.m_route_length, n2);
                g5.Math_InterpolateVector3D(this.m_route[1], this.m_route[0], this.m_route[2], 0, n2, n3);
                int n4 = g5.Math_DivFlt(78643, n3);
                if (0 == this.m_iUID % 2) {
                    n4 = -n4;
                }
                int[] nArray = this.m_route[1];
                nArray[0] = nArray[0] + g5.Math_MulFlt(this.m_route[2][1] - this.m_route[0][1], n4);
                int[] nArray2 = this.m_route[1];
                nArray2[1] = nArray2[1] - g5.Math_MulFlt(this.m_route[2][0] - this.m_route[0][0], n4);
                this.Route_OnChanged();
                if (this.Route_GetUnblockedDist() < 6553) {
                    this.m_route = null;
                    this.setState(1);
                }
            }
        } else {
            this.m_route = null;
            this.setState(1);
        }
        if (null != this.m_route) {
            this.Route_Update(n);
            this.Positionable_SetDirection(this.Route_GetDirection(this.m_route_progress));
        }
    }

    void BehaviorWarrior_Init() {
        this.m_WarriorInactive = true;
    }

    void BehaviorWarrior_Update(int n) {
        if (this.m_WarriorInactive) {
            if (CGameScene.g_scene.isObjectVisible(this)) {
                this.m_WarriorInactive = false;
                this.m_WarriorAttackTimeout = this.m_stats.m_Warrior[1];
                this.m_TimeOut = this.m_stats.m_Warrior[3];
            }
            return;
        }
        if (0 != this.m_TimeOut) {
            return;
        }
        if (null == this.m_ObjectTarget) {
            this.TargetControl_Update(false);
        } else if (((this.m_ObjectTarget.m_flags | this.m_ObjectTarget.m_stats.m_flags) & 8) != 0) {
            this.m_ObjectTarget = null;
        } else if (!this.TargetControl_IsTargetVisible()) {
            this.m_ObjectTarget = null;
        }
        if (null == this.m_ObjectTarget) {
            return;
        }
        int[] nArray = this.m_stats.m_Warrior;
        if (this.m_WarriorAttackTimeout < 0) {
            int n2 = this.Animateable_GetAnimationTime(13);
            if (n2 > 0) {
                this.setState(13);
                CGameScene.g_scene.Events_PostEvent(n2, this.m_iUID, 7, 1, 0);
            }
            this.m_WarriorAttackTimeout = nArray[1];
            this.m_TimeOut = nArray[2];
            return;
        }
        this.m_WarriorAttackTimeout -= n;
        this.WeaponControl_Attack(this.m_ObjectTarget.m_position, nArray[0]);
    }

    void BehaviorWarrior_OnCollision() {
        this.setState(1);
    }

    void BehaviorWarrior_OnAttacked(int n) {
        this.TargetControl_SwithTo(CGameScene.g_scene.GameObject_FindObjectByUID(n));
    }

    public void WeaponControl_Init(int[] nArray) {
        this.m_WeaponAmmo = new int[this.m_stats.m_Weapons.length];
        this.m_WeaponAmmoInClip = new int[this.m_stats.m_Weapons.length];
        for (int i = 0; i < this.m_WeaponAmmo.length; ++i) {
            this.m_WeaponAmmo[i] = this.m_stats.m_Weapons[i][14];
            this.m_WeaponAmmoInClip[i] = this.m_stats.m_Weapons[i][13];
        }
        this.m_AvailableWeapons = nArray;
        this.WeaponControl_SetCurrent(null == this.m_AvailableWeapons ? 0 : this.m_AvailableWeapons[0]);
    }

    public void WeaponControl_SetCurrent(int n) {
        this.m_WeaponCurrent = n;
        this.ChangeStats(this.m_stats.m_Weapons[this.m_WeaponCurrent][1]);
    }

    public int WeaponControl_GetCurrent() {
        return this.m_WeaponCurrent;
    }

    public void WeaponControl_SwitchToNext() {
        if (null != this.m_AvailableWeapons) {
            for (int i = 0; i < this.m_AvailableWeapons.length; ++i) {
                if (this.m_WeaponCurrent != this.m_AvailableWeapons[i]) continue;
                this.WeaponControl_SetCurrent(this.m_AvailableWeapons[(i + 1) % this.m_AvailableWeapons.length]);
                break;
            }
        } else {
            this.WeaponControl_SetCurrent((this.m_WeaponCurrent + 1) % this.m_stats.m_Weapons.length);
        }
    }

    public int WeaponControl_GetAmmoInClip() {
        return this.m_WeaponAmmoInClip[this.m_WeaponCurrent];
    }

    public int WeaponControl_GetAmmo() {
        return this.m_WeaponAmmo[this.m_WeaponCurrent];
    }

    public int WeaponControl_GetType() {
        return this.m_stats.m_Weapons[this.m_WeaponCurrent][0];
    }

    public boolean WeaponControl_AddAmmo(int n, int n2) {
        int n3 = this.m_WeaponAmmo[n];
        this.m_WeaponAmmo[n] = Math.min(this.m_WeaponAmmo[n] + n2, this.m_stats.m_Weapons[n][14]);
        if (n3 == 0 && this.m_WeaponAmmoInClip[n] == 0) {
            this.WeaponControl_ReloadClip(n);
        }
        return n3 != this.m_WeaponAmmo[n];
    }

    public boolean WeaponControl_Attack(int[] nArray, int n) {
        return this.WeaponControl_Attack(nArray, n, this.m_iUID);
    }

    public boolean WeaponControl_Attack(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        if (0 != (this.m_flags & 0x1000) || 0 == this.m_WeaponAmmoInClip[this.m_WeaponCurrent]) {
            return false;
        }
        int[] nArray2 = this.m_stats.m_Weapons[this.m_WeaponCurrent];
        g5.Math_OrthogonalToPolarFlt(nArray[0] - this.m_position[0], nArray[1] - this.m_position[1]);
        this.Positionable_SetDirection(g5.Math_NormalizeAngle_0_2Pi_Flt(g5.ret_rOrthogonalToPolar_rAngle));
        this.playState(nArray2[11]);
        CGameObject.m_coords12[2] = nArray2[6];
        g5.Math_PolarToOrthogonal2D(m_coords12, this.m_angle + 102944, nArray2[5]);
        g5.Math_AddVector3D(m_coords11, m_coords12, this.m_position);
        int n5 = null == this.m_stats.m_Warrior ? 1 : this.m_stats.m_Warrior[4];
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = g5.Math_GetRandomInt(2 * n) - n;
            CGameScene.g_scene.Bullets_Create(nArray2[2], m_coords11, g5.Math_NormalizeAngle_0_2Pi_Flt(this.m_angle + n3 * nArray2[12] / 65536), n2, nArray2[4], n4 == 0 ? nArray2[3] : -1);
        }
        if (nArray2[7] != -1 && CGameScene.g_scene.isObjectVisible(this) && !g5.Sound_IsPlaying(nArray2[7])) {
            g5.Sound_Play(nArray2[7]);
        }
        int n6 = this.m_WeaponCurrent;
        this.m_WeaponAmmoInClip[n6] = this.m_WeaponAmmoInClip[n6] - 1;
        if (nArray2[8] > 0) {
            this.m_flags |= 0x1000;
            CGameScene.g_scene.Events_PostEvent(g5.Math_MulFlt(nArray2[8], CGameScene.g_scene.GamePlot_GetConst(6)), this.m_iUID, 6, 4096, 0);
        }
        if (0 == this.m_WeaponAmmoInClip[this.m_WeaponCurrent]) {
            if (this.m_WeaponAmmo[this.m_WeaponCurrent] == 0) {
                for (n4 = 0; n4 < this.m_AvailableWeapons.length; ++n4) {
                    n3 = this.m_AvailableWeapons[n4];
                    if (this.m_WeaponAmmo[n3] == 0) continue;
                    this.WeaponControl_SetCurrent(n3);
                    break;
                }
            } else {
                this.WeaponControl_ReloadClip(this.m_WeaponCurrent);
            }
        }
        return true;
    }

    protected void WeaponControl_ReloadClip(int n) {
        CGameScene.g_scene.Events_PostEvent(this.m_stats.m_Weapons[n][9], this.m_iUID, 19, n, 0);
    }

    protected boolean WeaponControl_OnEvent(int n, int n2, int n3) {
        if (3 == n) {
            CGameObject cGameObject = CGameScene.g_scene.GameObject_FindObjectByUID(n2);
            if (null != cGameObject) {
                int n4 = 0;
                if (1 == n3) {
                    cGameObject.playState(4);
                }
                this.WeaponControl_Attack(cGameObject.m_position, n4);
                return true;
            }
        } else if (19 == n) {
            int n5 = n2;
            this.m_WeaponAmmoInClip[n5] = this.m_WeaponAmmoInClip[n5] + Math.min(this.m_WeaponAmmo[n2], this.m_stats.m_Weapons[n2][13]);
            int n6 = n2;
            this.m_WeaponAmmo[n6] = this.m_WeaponAmmo[n6] - this.m_WeaponAmmoInClip[n2];
        }
        return false;
    }

    public void Physics_ApplyImpulse(int[] nArray) {
        g5.Math_AddVector3D(this.m_Momentum, this.m_Momentum, nArray);
    }

    public void Physics_Update(int n) {
        if (0 == n) {
            return;
        }
        int[] nArray = this.m_stats.m_Physics;
        g5.Math_MulVector3D(m_coords51, this.m_Momentum, -nArray[1]);
        g5.Math_AddVector3D(this.m_Momentum, this.m_Momentum, m_coords51);
        g5.Math_DivVector3D(m_coords51, this.m_Momentum, nArray[0] / n * 1000);
        g5.Math_AddVector3D(this.m_position, this.m_position, m_coords51);
    }

    public void Explosive_OnDestroy() {
        int[] nArray = this.m_stats.m_Explosive;
        if (-1 != nArray[3]) {
            CGameScene.Effects_Create(nArray[3], this.m_position, this);
        }
        g5.Sound_Play(nArray[4]);
        int n = nArray[0];
        if (0 == n) {
            return;
        }
        Vector vector = CGameScene.g_scene.GameObject_GetActiveObjects();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            CGameObject cGameObject = (CGameObject)vector.elementAt(i);
            if (cGameObject == this || (n3 = this.Positionable_GetDistanceTo(cGameObject)) > n) continue;
            CGameObject.m_coords51[2] = 0;
            g5.Math_SubVector2D(m_coords51, cGameObject.m_position, this.m_position);
            g5.Math_DivVector2D(m_coords51, m_coords51, 0 == n3 ? 1 : n3);
            n3 = n - n3;
            g5.Math_MulVector2D(m_coords51, m_coords51, g5.Math_MulFlt(nArray[1], g5.Math_DivFlt(n3, n)));
            cGameObject.ApplyImpulse(m_coords51);
            int n4 = nArray[2] * n3 / n;
            cGameObject.ChangeHitPoints(-cGameObject.GetRealBulletDamage(-1, n4), true);
        }
    }

    void TargetControl_Update(boolean bl) {
        int n;
        CGameObject cGameObject;
        int n2;
        if (null == this.m_stats.m_Targets) {
            return;
        }
        Vector<CGameObject> vector = null;
        if (bl) {
            vector = new Vector<CGameObject>();
        } else {
            this.m_ObjectTarget = null;
        }
        Vector vector2 = CGameScene.g_scene.GameObject_GetActiveObjects();
        int n3 = vector2.size();
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < n3; ++n2) {
            int n6;
            cGameObject = (CGameObject)vector2.elementAt(n2);
            if (cGameObject == this || ((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x208) != 0) continue;
            int n7 = n = this.WeaponControl_GetType() == 0 ? 1 : 0;
            if (n == 0 && ((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x40000) != 0 || (n6 = this.m_stats.getTargetPriority(cGameObject.m_stats)) >= n5) continue;
            int n8 = n != 0 ? 131072 : this.m_stats.m_TargetMaxDistance;
            int n9 = cGameObject.Positionable_GetFastDistanceTo(this.m_position);
            if (n9 > n8 || n9 >= n4) continue;
            g5.Math_SubVector3D(m_coords51, cGameObject.m_position, this.m_position);
            if (Math.abs(g5.Math_GetAngleDifferenceFlt(g5.Math_GetVectorAngle2D(m_coords51), this.m_angle)) > this.m_stats.m_TargetMaxAngle || !this.TargetControl_IsTargetVisible(cGameObject)) continue;
            if (bl) {
                vector.addElement(cGameObject);
                continue;
            }
            this.m_ObjectTarget = cGameObject;
            n4 = n9;
            n5 = n6;
        }
        if (!bl) {
            return;
        }
        if (this.TargetControl_IsTargetsDiffer(this.m_Targets, vector)) {
            this.m_Targets = vector;
            this.m_ObjectTarget = null;
            n4 = Integer.MAX_VALUE;
            for (n2 = 0; n2 < this.m_Targets.size(); ++n2) {
                cGameObject = (CGameObject)this.m_Targets.elementAt(n2);
                n = this.Positionable_GetFastDistanceTo(cGameObject.m_position);
                if (n >= n4) continue;
                this.m_SelectedTarget = n2;
                this.m_ObjectTarget = cGameObject;
                n4 = n;
            }
        }
    }

    void TargetControl_SwithTo(CGameObject cGameObject) {
        if (this.m_ObjectTarget != cGameObject && this.m_stats.getTargetPriority(cGameObject.m_stats) != Integer.MAX_VALUE && this.TargetControl_CanDisengage()) {
            this.m_ObjectTarget = cGameObject;
        }
    }

    boolean TargetControl_CanDisengage() {
        if (null == this.m_stats.m_Targets || null == this.m_ObjectTarget) {
            return true;
        }
        for (int i = 0; i < this.m_stats.m_Targets.length; ++i) {
            if (this.m_ObjectTarget.m_stats.m_type != this.m_stats.m_Targets[i][0]) continue;
            return this.m_stats.m_Targets[i][1] != 0;
        }
        return true;
    }

    boolean TargetControl_IsTargetVisible() {
        return this.TargetControl_IsTargetVisible(this.m_ObjectTarget);
    }

    boolean TargetControl_IsTargetVisible(CGameObject cGameObject) {
        if (cGameObject == null) {
            return false;
        }
        return !CGameScene.g_scene.m_terrain.isIsectsWithSegment(this.m_position, cGameObject.m_position, null, null);
    }

    protected void TargetControl_SwitchTarget() {
        if (this.m_Targets.size() == 0) {
            return;
        }
        ++this.m_SelectedTarget;
        if (this.m_SelectedTarget >= this.m_Targets.size()) {
            this.m_SelectedTarget = 0;
        }
        this.m_ObjectTarget = (CGameObject)this.m_Targets.elementAt(this.m_SelectedTarget);
    }

    private boolean TargetControl_IsTargetsDiffer(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == vector2.elementAt(i)) continue;
            return true;
        }
        return false;
    }

    CGameObject() {
    }

    CGameObject(CGameStats cGameStats, int n) {
        this.init(cGameStats, n);
    }

    static short getMaxArmor() {
        return (short)g5.Math_MulFlt(CGameScene.g_scene.GamePlot_GetConst(2), 1000);
    }

    void init(CGameStats cGameStats, int n) {
        this.m_stats = cGameStats;
        this.m_iUID = n;
        this.m_life = this.m_stats.getLife();
        this.m_flags = this.m_stats.m_flags;
        this.m_Layer = this.m_stats.m_Layer;
        this.m_ModifiedMaxSpeed = this.m_stats.m_MaxSpeed;
        this.m_ActiveComponents = this.m_stats.m_Components;
        if (this.checkComponent(0)) {
            this.Animateable_Init();
        }
        if (this.checkComponent(6)) {
            this.Behavior_Init(4);
        }
        if (this.checkComponent(5) && this.m_stats.m_bMoverBehavior) {
            this.Behavior_Init(2);
        }
        if (this.checkComponent(4)) {
            this.WeaponControl_Init(this.m_stats.isPlayer() ? CGameScene.m_gameplotWeapons[CGameScene.g_scene.m_currentChapter] : null);
        }
    }

    public String toString() {
        return "m_iUID: " + this.m_iUID + " m_stats: " + this.m_stats.toString();
    }

    protected final boolean isKeyHit(int n) {
        return g5.Input_IsKeyHit(n);
    }

    protected final boolean isKeyHeld(int n) {
        return g5.Input_IsKeyHeld(n);
    }

    protected final boolean isGameActionHeld(int n) {
        return g5.Input_IsGameActionHeld(n);
    }

    protected final boolean isGameActionHit(int n) {
        return g5.Input_IsGameActionHit(n);
    }

    protected boolean checkComponent(int n) {
        return 0 != (this.m_ActiveComponents & 1 << n);
    }

    public void enableComponent(int n, boolean bl) {
        if (bl) {
            this.m_ActiveComponents |= this.m_stats.m_Components & 1 << n;
            if (n == 2) {
                CGameScene.g_scene.Triggers_CheckCondition((byte)4);
                g5.Math_CopyVector3D(this.m_positionLast, this.m_position);
            }
        } else {
            this.m_ActiveComponents &= ~(1 << n);
        }
    }

    public static void enableComponents(int n, boolean bl) {
        Vector vector = CGameScene.g_scene.m_gameobjects;
        for (int i = 0; i < vector.size(); ++i) {
            ((CGameObject)vector.elementAt(i)).enableComponent(n, bl);
        }
    }

    boolean CheckFlags(int n) {
        if (-1 == n) {
            return true;
        }
        return 0 != (this.m_flags & n) || this.m_stats.checkFlags(n);
    }

    void ChangeStats(int n) {
        CGameStats cGameStats = CGameScene.g_scene.GameStats_FindStatsByType(n);
        if (null != cGameStats && cGameStats != this.m_stats) {
            this.m_stats = cGameStats;
            this.m_StateLast = 0;
            this.Animateable_Update(0);
            this.m_ModifiedMaxSpeed = this.m_stats.m_MaxSpeed;
            this.m_Speed = this.m_stats.m_MaxSpeed;
        }
    }

    boolean ChangeHitPoints(int n, boolean bl) {
        short s = this.m_life;
        int n2 = this.m_PlayedState;
        if ((this.m_stats.m_flags & 0x800) != 0) {
            n = this.DamageThroughArmour(n);
        }
        if (n >= 0) {
            this.m_life = (short)Math.min(this.m_life + n, this.m_stats.getLife());
        } else if (this.m_life > 0 && ((this.m_flags | this.m_stats.m_flags) & 1) == 0 && ((this.m_flags | this.m_stats.m_flags) & 0x200) == 0) {
            if (bl && 5 != this.getState()) {
                this.playState(5);
            }
            this.m_life = (short)(this.m_life + n);
            if (this.m_life <= 0) {
                this.Die();
            }
        }
        return s != this.m_life;
    }

    int DamageThroughArmour(int n) {
        int n2 = Math.min(0, Math.max(-m_Armour, n * 66 / 100));
        m_Armour = (short)(m_Armour + n2);
        return n - n2;
    }

    void ChangeSpeed(int n) {
        this.m_Speed = this.m_ModifiedMaxSpeed = n * this.m_stats.m_MaxSpeed / 100;
    }

    void SpawnInventoryObject() {
        if (-1 != this.m_InventoryObjectType) {
            CGameScene.g_scene.GameObject_CreateObject((int)this.m_InventoryObjectType, false, 0, this);
            this.m_InventoryObjectType = (byte)-1;
        }
    }

    void Respawn() {
        this.m_life = this.m_stats.getLife();
        this.setState(1);
        if (!this.m_stats.isPlayer()) {
            return;
        }
        CGameScene.g_scene.Events_PostEvent(0, this.m_iUID, 16, 1, 0);
        CGameScene.g_scene.Events_PostEvent(2500, this.m_iUID, 16, 0, 0);
    }

    void Stun(int n) {
        this.m_life = 0;
        this.setState(3);
        CGameScene.g_scene.Events_PostEvent(n, this.m_iUID, 15, 0, 0);
        CGameScene.g_scene.Triggers_OnObjectKilled(this);
    }

    void Die() {
        int n;
        int n2 = n = this.Animateable_GetAnimationTime(3);
        if (0 != (this.m_ActiveComponents & 0x40)) {
            n2 /= 2;
        }
        this.Die(n, n2);
    }

    void Die(int n, int n2) {
        Debug.Println("Die: " + this);
        this.m_life = 0;
        this.lockState(3);
        this.m_flags |= 8;
        this.m_flags |= 2;
        this.SpawnInventoryObject();
        CGameScene.g_scene.Events_PostEvent(n2, this.m_iUID, 2, 100, 0);
        CGameScene.g_scene.Events_PostEvent(n, -1, 0, this.m_iUID, 0);
        CGameScene.g_scene.Triggers_OnObjectKilled(this);
    }

    void OnDestroy() {
        if (0 != (this.m_ActiveComponents & 0x400)) {
            this.Explosive_OnDestroy();
        }
        if (((this.m_flags | this.m_stats.m_flags) & 0x80000) != 0) {
            return;
        }
        if ((this.m_stats.m_flags_ex & 0x100) != 0) {
            CGameScene.g_scene.m_Progress[3] = CGameScene.g_scene.m_Progress[3] + 1;
        }
        if ((this.m_stats.m_flags_ex & 0x80) != 0) {
            CGameScene.g_scene.m_Progress[2] = CGameScene.g_scene.m_Progress[2] + 1;
        }
    }

    void OnAttacked(int n) {
        if (((this.m_flags | this.m_stats.m_flags) & 0x20000) != 0) {
            this.ChangeStats(this.m_stats.getHeadlessType());
            this.ChangeHitPoints(-this.m_life, true);
            CGameScene.g_scene.m_Progress[4] = CGameScene.g_scene.m_Progress[4] + 1;
            return;
        }
        this.Behavior_OnAttacked(n);
    }

    public void ApplyImpulse(int[] nArray) {
        if (0 != (this.m_ActiveComponents & 0x200)) {
            this.Physics_ApplyImpulse(nArray);
        }
    }

    public void Update(int n) {
        g5.Math_CopyVector3D(this.m_positionLast, this.m_position);
        this.m_TimeOut = Math.max(0, this.m_TimeOut - n);
        if (this.m_PlayedStateTime > 0) {
            this.m_PlayedStateTime = Math.max(0, this.m_PlayedStateTime - n);
            if (0 == this.m_PlayedStateTime) {
                this.playState(0);
            }
        }
        if (0 != this.m_FlickerFrequency) {
            this.m_FlickerTime += n;
        }
        if (((this.m_flags | this.m_stats.m_flags) & 0x2000) != 0) {
            g5.Math_PolarToOrthogonalFlt(this.m_angle, this.m_stats.m_MaxSpeed * n / 1000);
            this.Positionable_SetPosition(this.m_position[0] + g5.ret_rPolarToOrthogonal_rX, this.m_position[1] + g5.ret_rPolarToOrthogonal_rY, this.m_position[2]);
            this.setState(2);
        }
        if (0 != (this.m_ActiveComponents & 8)) {
            this.ManualHumanControl_Update(n);
        }
        if (0 != (this.m_ActiveComponents & 0x60)) {
            this.Behavior_Update(n);
        }
        if (0 != (this.m_ActiveComponents & 0x200)) {
            this.Physics_Update(n);
        }
        if (0 != (this.m_ActiveComponents & 4)) {
            this.CollisionControl_Update(n);
        }
        if (0 != (this.m_ActiveComponents & 1)) {
            this.Animateable_Update(n);
        }
        this.m_StateLast = this.getState();
        this.m_angleLast = this.m_angle;
    }

    public void Render(Graphics graphics, byte by) {
        if (((this.m_flags | this.m_stats.m_flags) & 0x20) != 0) {
            return;
        }
        if (0 != this.m_FlickerFrequency && 0 == this.m_FlickerTime / this.m_FlickerFrequency % 2) {
            return;
        }
        if (0 != (this.m_ActiveComponents & 1)) {
            this.Animateable_Render(graphics, by);
        }
        if (0 != (this.m_ActiveComponents & 8)) {
            this.ManualHumanControl_Render(graphics, by);
        }
    }

    public int getState() {
        if (0 != this.m_PlayedState) {
            return this.m_PlayedState;
        }
        return this.m_State;
    }

    public void lockState(int n) {
        this.m_StateLocked = false;
        this.playState(0);
        this.setState(n);
        this.m_StateLocked = true;
    }

    public void setState(int n) {
        if (n == this.m_State || this.m_StateLocked) {
            return;
        }
        if (0 != this.m_State) {
            this.m_flags &= ~CGameStats.STATE_Flags[this.m_State];
        }
        this.m_State = n;
        if (0 != this.m_State) {
            this.m_flags |= CGameStats.STATE_Flags[this.m_State];
        }
    }

    public void playState(int n) {
        if (this.m_StateLocked) {
            return;
        }
        if (n != 0) {
            int n2 = this.Animateable_GetAnimationTime(n);
            if (n2 > 0) {
                this.m_PlayedStateTime = n2;
            } else {
                return;
            }
        }
        if (n != this.m_PlayedState) {
            if (0 != this.m_PlayedState) {
                this.m_flags &= ~CGameStats.STATE_Flags[this.m_PlayedState];
            }
            this.m_PlayedState = n;
            if (0 != this.m_PlayedState) {
                this.m_flags |= CGameStats.STATE_Flags[this.m_PlayedState];
            }
        }
    }

    public boolean isPositionBlocked(int n, int n2, int n3, int n4) {
        if (0 == (this.m_ActiveComponents & 2)) {
            return false;
        }
        CGameObject.m_frect2[0] = n - n3;
        CGameObject.m_frect2[2] = n + n3;
        CGameObject.m_frect2[1] = n2 - n4;
        CGameObject.m_frect2[3] = n2 + n4;
        switch (this.m_stats.m_geometry_type) {
            case 0: {
                CGameObject.m_coords11[0] = this.m_position[0];
                CGameObject.m_coords11[1] = this.m_position[1];
                CGameObject.m_coords11[2] = this.m_stats.m_size;
                return g5.Math_IsIntersectsRectCircle(m_frect2, m_coords11);
            }
            case 1: 
            case 2: {
                CGameObject.m_frect1[0] = this.m_position[0] - this.m_stats.m_size;
                CGameObject.m_frect1[2] = this.m_position[0] + this.m_stats.m_size;
                CGameObject.m_frect1[1] = this.m_position[1] - this.m_stats.m_size_y;
                CGameObject.m_frect1[3] = this.m_position[1] + this.m_stats.m_size_y;
                return g5.Math_IsIntersectsRect(m_frect1, m_frect2);
            }
        }
        return false;
    }

    public boolean isPositionBlocked(int n, int n2, int n3) {
        if (0 == (this.m_ActiveComponents & 2)) {
            return false;
        }
        CGameObject.m_coords12[0] = n;
        CGameObject.m_coords12[1] = n2;
        CGameObject.m_coords12[2] = n3;
        switch (this.m_stats.m_geometry_type) {
            case 0: {
                CGameObject.m_coords11[0] = this.m_position[0];
                CGameObject.m_coords11[1] = this.m_position[1];
                CGameObject.m_coords11[2] = this.m_stats.m_size;
                return g5.Math_IsIntersectsCircle(m_coords11, m_coords12);
            }
            case 1: 
            case 2: {
                CGameObject.m_frect1[0] = this.m_position[0] - this.m_stats.m_size;
                CGameObject.m_frect1[2] = this.m_position[0] + this.m_stats.m_size;
                CGameObject.m_frect1[1] = this.m_position[1] - this.m_stats.m_size_y;
                CGameObject.m_frect1[3] = this.m_position[1] + this.m_stats.m_size_y;
                return g5.Math_IsIntersectsRectCircle(m_frect1, m_coords12);
            }
        }
        return false;
    }

    public boolean isPositionBlocked(CGameObject cGameObject) {
        if (null == cGameObject) {
            return false;
        }
        if (0 == (this.m_ActiveComponents & 2) || 0 == (cGameObject.m_ActiveComponents & 2)) {
            return false;
        }
        int n = 0;
        block10: for (int i = 0; i < 2; ++i) {
            CGameObject cGameObject2 = 0 == i ? this : cGameObject;
            int[] nArray = 0 == i ? m_coords11 : m_coords12;
            int[] nArray2 = 0 == i ? m_frect1 : m_frect2;
            switch (cGameObject2.m_stats.m_geometry_type) {
                case 0: {
                    nArray[0] = cGameObject2.m_position[0];
                    nArray[1] = cGameObject2.m_position[1];
                    nArray[2] = cGameObject2.m_stats.m_size;
                    continue block10;
                }
                case 1: 
                case 2: {
                    nArray2[0] = cGameObject2.m_position[0] - cGameObject2.m_stats.m_size;
                    nArray2[2] = cGameObject2.m_position[0] + cGameObject2.m_stats.m_size;
                    nArray2[1] = cGameObject2.m_position[1] - cGameObject2.m_stats.m_size_y;
                    nArray2[3] = cGameObject2.m_position[1] + cGameObject2.m_stats.m_size_y;
                    n += 0 == i ? 2 : 1;
                }
            }
        }
        switch (n) {
            case 0: {
                return g5.Math_IsIntersectsCircle(m_coords11, m_coords12);
            }
            case 1: {
                return g5.Math_IsIntersectsRectCircle(m_frect2, m_coords11);
            }
            case 2: {
                return g5.Math_IsIntersectsRectCircle(m_frect1, m_coords12);
            }
            case 3: {
                return g5.Math_IsIntersectsRect(m_frect1, m_frect2);
            }
        }
        return false;
    }

    public boolean isIsectsWithSegment(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n;
        if (0 == this.m_stats.m_size) {
            return false;
        }
        g5.Math_SubVector2D(m_coords32, nArray2, nArray);
        g5.Math_SubVector2D(m_coords31, this.m_position, nArray);
        g5.Math_SubVector2D(m_coords33, this.m_position, nArray2);
        int n2 = g5.Math_GetMagnitudeFast2DFlt(m_coords31[0], m_coords31[1]);
        int n3 = g5.Math_GetMagnitudeFast2DFlt(m_coords33[0], m_coords33[1]);
        if (n2 >= 0xB50000 || n3 >= 0xB50000) {
            return false;
        }
        int n4 = g5.Math_GetDotProduct2D(m_coords31, m_coords31);
        int n5 = g5.Math_GetDotProduct2D(m_coords33, m_coords33);
        int n6 = g5.Math_GetDotProduct2D(m_coords32, m_coords32);
        int n7 = g5.Math_MulFlt(this.m_stats.m_size, this.m_stats.m_size);
        if (n4 + n5 - 2 * n7 > n6) {
            return false;
        }
        if (null == nArray4 && null == nArray3) {
            return true;
        }
        int n8 = n4;
        int n9 = n7;
        int n10 = n6;
        if (n10 == 0) {
            return false;
        }
        if (n8 < n9) {
            g5.Math_CopyVector3D(nArray3, nArray);
            return true;
        }
        int n11 = g5.Math_GetDotProduct2D(m_coords31, m_coords32);
        if (n11 < 0) {
            return false;
        }
        int n12 = n9 - n8 + g5.Math_MulFlt(n11, g5.Math_DivFlt(n11, n10));
        if (n12 > 0 && (n = n11 - g5.Math_SqrtFlt(n12)) >= 0 && n <= n10) {
            if (null != nArray3) {
                g5.Math_InterpolateVector3D(nArray3, nArray, nArray2, 0, n10, n);
                if (null != nArray4) {
                    g5.Math_SubVector2D(nArray4, nArray3, this.m_position);
                    g5.Math_DivVector2D(nArray4, nArray4, this.m_stats.m_size);
                }
            }
            return true;
        }
        return false;
    }

    public void moveTo(int[] nArray) {
        this.moveTo(nArray[0], nArray[1], nArray[2]);
    }

    public void moveTo(int n, int n2, int n3) {
    }

    public int GetRealBulletDamage(int n, int n2) {
        if (0 != (this.m_ActiveComponents & 0x2000)) {
            return n2 * this.m_stats.GetVulnerability(n) / 100;
        }
        return n2;
    }

    static {
        COLLISION_SlidingVectors = new int[][]{{46340, 46340, 0}, {46340, -46340, 0}, {-46340, 46340, 0}, {-46340, -46340, 0}};
    }
}

