/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public final class CGameScene
extends g5 {
    private static final byte GAMESTATE_VERSION = 15;
    protected static final int FLAG_USE_BACKBUFFER = 1;
    protected static final int FLAG_USE_STATICBACK = 2;
    protected static final int FLAG_MODE_BACKFILL = 256;
    protected static final int FLAG_MODE_CUTSCENE = 512;
    protected static final int FLAG_MODE_SMOOTHVIEW = 4096;
    protected static final int FLAG_LOOKFROZEN = 65536;
    protected static final int FLAG_OBJECTSFROZEN = 131072;
    protected static final int FLAG_CALCNEWVIEWFROZEN = 262144;
    protected static final int FLAG_SCENEFROZEN = 524288;
    protected static final int FLAG_RENDERFROZEN = 0x100000;
    public static final int SCENE_F_UI = 16;
    public static final int SCENE_F_DEBRIEF = 32;
    public static final int SCENE_NONE = 16;
    public static final int SCENE_MENU = 17;
    public static final int SCENE_MENUTEXT = 18;
    public static final int SCENE_MENUINPUT = 19;
    public static final int SCENE_MENUSCORES = 20;
    public static final int SCENE_MENUCHAPTER = 21;
    public static final int SCENE_SPLASHES = 22;
    public static final int SCENE_TITLE = 23;
    public static final int SCENE_ENDSCREEN = 24;
    public static final int FIRST_MISSION_SCENE = 41;
    public static final int SCENE_ACTION = 41;
    public static final byte TILEDESC_TILEINDEX = 0;
    public static final byte TILEDESC_X = 1;
    public static final byte TILEDESC_Y = 2;
    public static final byte TILEDESC_VIDEODEPTH = 3;
    public static final byte TILEDESC_PALETTE = 4;
    public static final byte TILEDESC_CLIPX = 5;
    public static final byte TILEDESC_CLIPY = 6;
    public static final byte TILEDESC_CLIPW = 7;
    public static final byte TILEDESC_CLIPH = 8;
    public static final byte TILEDESC_MAX = 9;
    public static CGameScene g_scene;
    protected static int[] m_coords1;
    protected static int[] m_coords2;
    protected static int[] m_coords3;
    protected static int[] m_scenerect1;
    protected static int[] m_scenerect2;
    protected int m_flags;
    protected int m_color;
    protected CTerrainObject m_terrain;
    protected int m_xlook;
    protected int m_ylook;
    protected int m_xviewLast;
    protected int m_yviewLast;
    protected int m_xlookShift;
    protected int m_ylookShift;
    protected int[][] m_lookSmooth = new int[10][3];
    protected int m_xview;
    protected int m_yview;
    protected int m_wview;
    protected int m_hview;
    protected int m_xscene;
    protected int m_yscene;
    protected int m_wscene;
    protected int m_hscene;
    static boolean m_RenderLayer;
    static boolean m_SortLayer;
    static VectorInt m_layertiles;
    public short m_gridWidth;
    public short m_gridHeight;
    public int m_cellWidth;
    public int m_cellHeight;
    protected static int m_scene;
    protected int m_scenenext = 16;
    protected int[] m_sceneparams = null;
    protected int[] m_sceneparamsnext = null;
    protected boolean m_preloaded = false;
    protected int m_SplashIndex = 0;
    protected CGameStats[] m_gamestats;
    public static final int INVALID_UID = -1;
    protected int m_iUID;
    protected Vector m_gameobjects = new Vector();
    public CGameObject m_player;
    protected Vector m_gameobjects_active = new Vector();
    public static final int CMD_ROUTE = 0;
    public static final int CMD_ZONE = 1;
    protected short[] m_mapobjects_offsets;
    DataInputStream m_mapobjects_data;
    String[] m_strings;
    String[][] m_languages;
    protected static int m_stringsLangIndex;
    protected boolean m_stringsLangSelected;
    private static final int COLOR_BASE = 0xFFFFFF;
    private static final int COLOR_BACKGROUND = 0;
    private static final int LANGUAGE_MENU_WIDTH = 80;
    public static final int DIALOG_INVALID = -1;
    public static final int DIALOG_BRIEFING = 0;
    public static final int DIALOG_DEBRIEF = 1;
    public static final int DIALOG_FAILSCREEN = 2;
    public static final int DIALOG_OBJECTIVES = 3;
    public static final int DIALOG_DEBRIEFASK = 4;
    private static final int DIALOG_DATA_FLAGS = 0;
    private static final int DIALOG_DATA_OPEN_EFFECT = 1;
    private static final int DIALOG_DATA_CLOSE_EFFECT = 2;
    private static final int DIALOG_DATA_MAX = 3;
    private static final int DIALOGFLAG_NONE = 0;
    private static final int DIALOGFLAG_FULLSCREEN = 1;
    private static final int DIALOGFLAG_NONMODAL = 2;
    private static final int DIALOGFLAG_EXCLUSIVE = 4;
    private static final int DIALOGFLAG_TOPMOST = 8;
    private static final int DIALOGFLAG_ALLOWPAUSE = 16;
    private static final int DIALOGFLAG_PAUSEDLG = 32;
    private static final int[][] DIALOGS_DATA;
    private static final int DIALOGPARAM_ID = 0;
    private static final int DIALOGPARAM_FLAGS = 1;
    private static final int DIALOGPARAM_PARAMS = 2;
    private static final int DIALOGPARAM_MAX = 3;
    private Stack m_DialogsStack = new Stack();
    private Stack m_PendingDialogsStack = new Stack();
    public static final int INVALID_BRIEFING_INDEX = -1;
    public static final int BRIEFING_PARAM_ID = 0;
    public static final int BRIEFING_PARAM_SILENT = 1;
    public static final int BRIEFING_PARAM_MAX = 2;
    private byte[] m_briefingsID;
    private byte[] m_briefingsOffset;
    private short[] m_briefingMembersTileID;
    private int[] m_briefingMembersName;
    private Vector m_briefingPhrasesMember;
    private Vector m_briefingPhrasesText;
    private byte m_briefing = (byte)-1;
    private byte m_briefingPhrase;
    private int m_briefingFlags;
    private Vector m_briefingContent;
    private byte m_briefingLine1;
    private byte m_briefingLine2;
    int m_CutsceneCropProgress = 0;
    boolean m_CutsceneCropInside = true;
    int m_CutScene_ID = -1;
    public static final byte ETC_INVALID = 0;
    public static final byte ETC_LEVELSTARTED = 1;
    public static final byte ETC_EVENT = 2;
    public static final byte ETC_OBJECTSKILLED = 3;
    public static final byte ETC_AREAENTERED = 4;
    public static final byte ETC_AREALEAVED = 5;
    public static final byte ETC_STATE = 6;
    public static final byte ETA_INVALID = 0;
    public static final byte ETA_FINISH_LEVEL = 1;
    public static final byte ETA_ACTIVATE_PASS_LAYER = 3;
    public static final byte ETA_DEACTIVATE_PASS_LAYER = 4;
    public static final byte ETA_SPAWN_OBJECTS = 5;
    public static final byte ETA_KILL_OBJECTS = 6;
    public static final byte ETA_SHOW_BRIEFING = 7;
    public static final byte ETA_SHOW_HINT = 8;
    public static final byte ETA_ACTIVATE_GRAPH_TILE = 9;
    public static final byte ETA_DEACTIVATE_GRAPH_TILE = 10;
    public static final byte ETA_SEND_EVENT = 11;
    public static final byte ETA_ACTIVATE_TRIGGER = 12;
    public static final byte ETA_DEACTIVATE_TRIGGER = 13;
    public static final byte ETA_ACTIVATE_GRAPH_LAYER = 14;
    public static final byte ETA_DEACTIVATE_GRAPH_LAYER = 15;
    public static final byte ETA_INVENTORY_ADD = 16;
    public static final byte ETA_INVENTORY_REMOVE = 17;
    public static final byte ETA_TELEPORT_OBJECT = 18;
    public static final byte ETA_BUTTON_FIGHT = 19;
    public static final byte ETA_INVENTORY_SELECT = 21;
    public static final byte ETA_PLAY_SOUND = 22;
    public static final byte ETA_BUTTON_FIGHT_STOP = 23;
    public static final byte ETA_SET_STATE = 24;
    public static final byte STATE_False = 0;
    public static final byte STATE_True = 1;
    public static final byte STATE_Toggle = 2;
    public static final byte CONDITIONINFO_TYPE = 0;
    public static final byte CONDITIONINFO_ACTIVITY = 1;
    public static final byte CONDITIONINFO_MINACTION = 2;
    public static final byte CONDITIONINFO_MAXACTION = 3;
    public static final byte CONDITIONINFO_MAX = 4;
    public static final byte CONDITIONINFO_ACTIVITY_ON = 0;
    public static final byte CONDITIONINFO_ACTIVITY_OFF = 1;
    public static final byte CONDITIONINFO_ACTIVITY_DIS = 2;
    public static final byte ACTIONINFO_TYPE = 0;
    public static final byte ACTIONINFO_MAX = 1;
    protected boolean m_triggersInited;
    private VectorInt m_triggersConditionOffsets;
    private VectorInt m_triggersConditionData;
    private VectorInt m_triggersActionOffsets;
    private VectorInt m_triggersActionData;
    protected VectorInt m_killedobjectUIDs;
    protected boolean m_isSomeoneKilled;
    protected byte[] m_TriggersSavedState;
    protected int m_StateFlags;
    protected int m_lastCutScene;
    protected Vector m_playerMessage;
    protected int m_playerMessageTime;
    protected int m_Param;
    public static final int EVENT_DestroyGameObject = 0;
    public static final int EVENT_CutsceneBeginEnd = 1;
    public static final int EVENT_BFightSucceeded = 2;
    public static final int EVENT_BFightFailed = 3;
    public static final int EVENT_BriefingFinished = 4;
    public static final int EVENT_Timeout = 5;
    public static final int EVENT_StartBriefing = 6;
    public static final int EVENT_CreateMapObject = 7;
    public static final int EVENT_SetTimer = 8;
    public static final int EVENT_CutsceneFinished = 9;
    public static final int EVENT_ShowMessage = 10;
    public static final int EVENT_OnInteractiveObjAct = 17;
    public static final int EVENT_CreateDialog = 21;
    public static final int EVENT_CloseDialog = 22;
    public static final int EVENT_SetLookPoint = 23;
    public static final int EVENT_ClearLookPoint = 24;
    public static final int EVENT_SetLookPointAction = 25;
    public static final int EVENT_ClearLookPointAction = 26;
    public static final int EVENT_ShowTransitionEffect = 27;
    public static final int EVENT_DrillingComplete = 28;
    public static final int EVENT_EndContext = 29;
    public static final int EVENT_MoveCamera = 31;
    public static final int EVENT_MoveCameraFinished = 32;
    public static final int EVENT_MoveCameraStop = 33;
    public static final int EVENT_CheckPoint = 34;
    public static final int EVENT_PrimaryCompleted = 35;
    public static final int EVENT_BonusCompleted = 36;
    public static final int EVENT_SecretPlaceFound = 37;
    public static final int EVENT_StartShake = 38;
    protected static final int EVENTINFO_TIME = 0;
    protected static final int EVENTINFO_OBJECT = 1;
    protected static final int EVENTINFO_EVENT = 2;
    protected static final int EVENTINFO_PARAM_1 = 3;
    protected static final int EVENTINFO_PARAM_2 = 4;
    protected static final int EVENTINFO_MAX = 5;
    VectorInt m_Events = new VectorInt();
    int[] m_LastEventInfo = new int[5];
    int[] m_Timers = new int[5];
    protected static final int MAX_EFFECT_OBJECTS = 16;
    static CEffectPattern[] m_EffectPatterns;
    static CEffectObject[] m_EffectObjects;
    protected static final int BULLETTYPE_Damage = 0;
    protected static final int BULLETTYPE_MaxSpeed = 1;
    protected static final int BULLETTYPE_Mass = 2;
    protected static final int BULLETTYPE_HitEffect = 3;
    protected static final int BULLETTYPE_TraceEffect = 4;
    protected static final int BULLETTYPE_ClipID = 5;
    protected static final int BULLETTYPE_LifeTime = 6;
    protected static final int BULLETTYPE_ExplosiveObj = 7;
    protected static final int BULLETTYPE_ExcludeObjectsMask = 8;
    protected static final int BULLETTYPE_Piercing = 9;
    protected static final int BULLETTYPE_Max = 10;
    protected static final int BULLET_X = 0;
    protected static final int BULLET_Y = 1;
    protected static final int BULLET_Z = 2;
    protected static final int BULLET_VX = 3;
    protected static final int BULLET_VY = 4;
    protected static final int BULLET_Owner = 5;
    protected static final int BULLET_Type = 6;
    protected static final int BULLET_Time = 7;
    protected static final int BULLET_Trace = 8;
    protected static final int BULLET_TileID = 9;
    protected static final int BULLET_Max = 10;
    protected static final int MAX_BULLET_OBJECTS = 8;
    protected int[][] m_bulletTypes;
    protected int[][] m_bullets;
    protected static final int SCORE_TOTAL = 0;
    protected static final int SCORE_KILLED = 1;
    protected static final int SCORE_DESTROYED = 2;
    protected static final int SCORE_HEADSHOTS = 3;
    protected static final int SCORE_SECRETS = 4;
    protected static final int SCORE_MAX = 5;
    protected String m_HeroName = "";
    int[][] m_scoreChapters;
    int[] m_scoreTableScores;
    String[] m_scoreTableNames;
    public static final int SCENE_P_OBJECTIVES = 0;
    public static final int SCENE_P_LEVELMAP = 1;
    public static final int SCENE_P_LEVELOBJ = 2;
    public static final int SCENE_P_TEXTBODY = 1;
    public static final int SCENE_P_TEXTCALLBACK = 2;
    public static final int SCENE_P_SCENE = 3;
    public static final int SCENE_P_AUTOSCROLL = 4;
    protected static int[][] m_gameplot;
    protected static int[][] m_gameplotImg;
    protected static int[][] m_gameplotWeapons;
    protected static String[] m_missionNames;
    protected static String[] m_missionDescs;
    protected int[][] m_difficultyConsts;
    protected int[] m_GamePlotSettingImg;
    byte m_gamePlotProgress;
    byte m_gamePlotDifficulty;
    byte m_currentChapter;
    byte m_currentDifficulty;
    public static final int MENU_POSITION_STACK_SIZE = 5;
    protected static int[] MENU_Main;
    protected static int[] MENU_Difficulty;
    protected static int[] MENU_PlayGame;
    protected static int[] MENU_GameOver;
    protected static int[] MENU_Pause;
    protected static int[] MENU_PauseExitToMenu;
    protected static int[] MENU_PauseRestartLevel;
    protected static int[] MENU_PauseExit;
    protected static int[] MENU_Settings;
    protected static final int[][] CUSTOMS_MENU;
    protected static final int CUSTOMS_MENU_DEFAULT_INDEX = 0;
    protected static final int CUSTOMS_MENU_LSK = 1;
    protected static final int CUSTOMS_MENU_RSK = 2;
    protected static final int[][] CUSTOMS_MENU_INFO;
    Stack m_currentMenu = new Stack();
    Stack m_currentMenuOriginal = new Stack();
    int m_currentMenuItem = 0;
    int m_currentMenuTopItem = 0;
    int m_currentMenuEvent = -1;
    static final int HUDMODE_None = 0;
    static final int HUDMODE_Foot = 1;
    int m_HudMode = 0;
    public static final int[] ACTION_Transform;
    protected int m_ActionShakeTime;
    protected int m_ActionShakeMax;
    protected int m_LoadedChapter;
    protected int[] m_ActionSavedPos = new int[3];
    protected short m_ActionSavedLife;
    protected short m_ActionSavedArmour;
    protected byte m_ActionSecretsTotal;
    private Vector RespawnableObjects = new Vector();
    public static final int PROGRESS_TIME = 0;
    public static final int PROGRESS_BONUS = 1;
    public static final int PROGRESS_KILLED = 2;
    public static final int PROGRESS_DESTROYED = 3;
    public static final int PROGRESS_HEADSHOTS = 4;
    public static final int PROGRESS_SECRETS = 5;
    public static final int PROGRESS_CHECKPOINT = 6;
    public static final int PROGRESS_MAX = 7;
    public int[] m_Progress = new int[7];
    public int[] m_ProgressLast = new int[7];
    public static final int BFIGHT_KeyUp = 0;
    public static final int BFIGHT_KeyDown = 1;
    public static final int BFIGHT_KeyLeft = 2;
    public static final int BFIGHT_KeyRight = 3;
    public static final int BFIGHT_KeyFire = 4;
    protected static short[][] BFIGHT_TilesKeys;
    public static final int BFB_Default = 0;
    public static final int BFB_Blinking = 1;
    public static final int BFB_Done = 2;
    int m_loadingIsActive;
    int m_loadingProgress;
    private boolean m_LoadingInitial;
    static final int LOADING_MAXIMUM = 1000;
    boolean m_pauseIsActive;
    protected int[] m_pauseMenu;
    boolean m_pauseShowHelp;
    private static final int[] DEBRIEF_ITEMS_ONFOOT;
    private int[] m_DebriefItems;
    Image Debrief_Render_Image = null;
    protected Vector m_menuText;
    protected int m_menuTextLineTop;
    protected int m_menuTextMaxLines;
    protected int m_menuTextCallback;
    protected int m_menuTextScene;
    protected int m_menuTextObjectives;
    protected boolean m_menuTextAutoscroll;
    protected int m_menuTextScrollSpeed;
    protected int m_menuTextScrollPos;
    protected int m_menuTextScrollMax;
    protected static final int MENUINPUT_KEY_DELAY = 1000;
    private static final int MENUINPUT_P_CALLBACK = 0;
    protected StringBuffer m_menuInputStringBuffer;
    protected String m_menuInputString;
    protected int m_menuInputLastKey;
    protected long m_menuInputLastKeyTime;
    protected int m_menuInputMaxChars;
    protected char m_menuInputLastChar;
    private static final int MENUSCORES_P_AFTERCOMPLETION = 0;
    private static final int[] ENDSCREEN_ITEMS;
    protected byte m_chapterChosen = (byte)-1;
    protected byte m_ChapterCount;
    protected byte history_ChapterMaxCount = 0;
    public static final int SPLASHES_KIND_INITIAL = 0;
    public static final int SPLASHES_KIND_FINAL = 1;
    private static final int SPLASHES_PARAM_KIND = 0;
    private static final int SPLASHES_TEXT_FONT = 0;
    private static final int SPLASHES_DATA_DURATION = 0;
    private static final int SPLASHES_DATA_BG_COLOR = 1;
    private static final int SPLASHES_DATA_TILE_ID = 2;
    private static final int SPLASHES_DATA_STRING_ID = 3;
    private static final int SPLASHES_DATA_TEXT_COLOR = 4;
    private static final int[][] SPLASHES_INITIAL;
    private static final int[][] SPLASHES_FINAL;
    private int m_SplashesKind;
    private int m_SplashesIndex;
    private int m_SplashesTime;
    private int[][] m_Splashes;
    int m_DebriefAskTextID;
    Vector m_DebriefAsk;
    static int RenderTileVideoDepth;
    public static final int[] DEFAULT_Transform;
    public static int[] m_SceneTransform;
    Image gamekey = null;
    int keyPosX = 10;
    int keyPosY = 60;
    int keyWid = 40;

    CGameScene(MIDlet mIDlet) {
        super(mIDlet);
        if (RedFaction.TelstraMode) {
            m_stringsLangIndex = 0;
            this.m_stringsLangSelected = true;
        }
    }

    void Init() throws IOException {
        super.Init();
        g_scene = this;
        this.Strings_Init();
        this.Loading_Begin("", "", true);
        g5.Sound_Init(true, 0, 100);
        this.Loading_UpdateProgress(100);
        g5.Tile_Init(this.getClass().getResourceAsStream("/idx.all"));
        this.Loading_UpdateProgress(200);
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/bin.all"));
        g5.Clip_Load(dataInputStream);
        this.Loading_UpdateProgress(350);
        this.GamePlot_Load(dataInputStream);
        this.Loading_UpdateProgress(400);
        this.Briefings_Load(dataInputStream);
        this.Loading_UpdateProgress(450);
        this.GameStats_Load(dataInputStream);
        this.Loading_UpdateProgress(500);
        CGameScene.Effects_Init(dataInputStream);
        this.Loading_UpdateProgress(550);
        this.Bullets_Init(dataInputStream);
        this.Loading_UpdateProgress(600);
        dataInputStream.close();
        CGameObject.ManualHumanControl_AimingInit();
        this.HeroParams_Init();
        this.GamePlot_Reset();
        this.loadGameState();
        this.Loading_UpdateProgress(800);
        this.Messages_Init();
        g5.Tile_LoadTileset(10);
        g5.Tile_LoadTileset(1);
        g5.Tile_UpdateTilesets(true, 800, 1000);
        g5.m_time = g5.getTime();
        this.Loading_End(false);
    }

    public void Shutdown() {
        if (this.Dialogs_GetDialogId() == 1) {
            this.GamePlot_Advance();
        }
        this.saveGameState();
        this.Messages_Shutdown();
        g5.Sound_Stop(true);
        super.Shutdown();
    }

    public synchronized void resume() {
        super.resume();
        if (g_scene != null && !this.m_pauseIsActive) {
            this.Pause_Toggle();
        }
    }

    public void loadGameState() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"redfaction", (boolean)true);
            byte[] byArray = null;
            try {
                byArray = recordStore.getRecord(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            recordStore.closeRecordStore();
            if (null != byArray) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                if (15 == dataInputStream.readByte()) {
                    g5.LoadSettings(dataInputStream);
                    this.m_gamePlotProgress = dataInputStream.readByte();
                    this.m_gamePlotDifficulty = dataInputStream.readByte();
                    this.HeroParams_Load(dataInputStream);
                    this.history_ChapterMaxCount = dataInputStream.readByte();
                }
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveGameState() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(15);
            g5.SaveSettings(dataOutputStream);
            dataOutputStream.writeByte(this.m_gamePlotProgress);
            dataOutputStream.writeByte(this.m_gamePlotDifficulty);
            this.HeroParams_Save(dataOutputStream);
            dataOutputStream.writeByte(this.history_ChapterMaxCount);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                RecordStore.deleteRecordStore((String)"redfaction");
            }
            catch (Exception exception) {
                // empty catch block
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"redfaction", (boolean)true);
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void CreateTerrain() {
        if (null == this.m_terrain) {
            this.m_terrain = new CTerrainObject();
        }
    }

    public void GameStats_Load(DataInputStream dataInputStream) throws IOException {
        this.m_gamestats = new CGameStats[67];
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            CGameStats cGameStats = new CGameStats();
            cGameStats.loadFromStream(dataInputStream);
            if (-1 == cGameStats.m_type || 67 == cGameStats.m_type) continue;
            this.m_gamestats[cGameStats.m_type] = cGameStats;
        }
        CGameStats.LoadStates(dataInputStream);
    }

    public CGameStats GameStats_FindStatsByType(int n) {
        if (n < 0 || n >= this.m_gamestats.length) {
            return null;
        }
        return this.m_gamestats[n];
    }

    public void GameStats_Reset() {
        for (int i = 0; i < this.m_gamestats.length; ++i) {
            if (null == this.m_gamestats[i]) continue;
            this.m_gamestats[i].reset();
        }
    }

    protected void GameObject_InitObjects() {
        this.m_gameobjects.removeAllElements();
        this.m_iUID = 1000;
        this.m_gameobjects_active.removeAllElements();
    }

    protected void GameObject_ShutdownObjects() {
        this.m_gameobjects.removeAllElements();
        this.m_gameobjects_active.removeAllElements();
        this.m_player = null;
    }

    public CGameObject GameObject_FindObjectByUID(int n) {
        for (int i = 0; i < this.m_gameobjects.size(); ++i) {
            CGameObject cGameObject = (CGameObject)this.m_gameobjects.elementAt(i);
            if (cGameObject.m_iUID != n) continue;
            return cGameObject;
        }
        return null;
    }

    public CGameObject GameObject_FindObjectByType(int n) {
        for (int i = 0; i < this.m_gameobjects.size(); ++i) {
            CGameObject cGameObject = (CGameObject)this.m_gameobjects.elementAt(i);
            if (cGameObject.m_stats.m_type != n) continue;
            return cGameObject;
        }
        return null;
    }

    public Vector GameObject_GetActiveObjects() {
        return this.m_gameobjects_active;
    }

    public CGameObject GameObject_CreateObject(int n, boolean bl, int n2) {
        CGameStats cGameStats = this.GameStats_FindStatsByType(n);
        if (cGameStats == null) {
            return null;
        }
        if (!bl) {
            n2 = this.m_iUID++;
        }
        CGameObject cGameObject = new CGameObject(cGameStats, n2);
        this.m_gameobjects.addElement(cGameObject);
        this.m_gameobjects_active.addElement(cGameObject);
        this.Triggers_OnObjectCreated(cGameObject);
        if (cGameObject.m_stats.isPlayer()) {
            this.m_player = cGameObject;
            CGameObject.m_Armour = 0;
        }
        return cGameObject;
    }

    public CGameObject GameObject_CreateObject(int n, boolean bl, int n2, int[] nArray) {
        if (null == nArray) {
            return null;
        }
        CGameObject cGameObject = this.GameObject_CreateObject(n, bl, n2);
        if (cGameObject != null) {
            cGameObject.Positionable_InitPosition(nArray);
        }
        return cGameObject;
    }

    public CGameObject GameObject_CreateObject(int n, boolean bl, int n2, CGameObject cGameObject) {
        cGameObject.Positionable_GetPosition(m_coords3, 0);
        return this.GameObject_CreateObject(n, bl, n2, m_coords3);
    }

    public CGameObject GameObject_CreateObject(int n, boolean bl, int n2, int n3, int n4, int n5) {
        CGameScene.m_coords1[0] = n3;
        CGameScene.m_coords1[1] = n4;
        CGameScene.m_coords1[2] = n5;
        return this.GameObject_CreateObject(n, bl, n2, m_coords1);
    }

    public CGameObject GameObject_CreateEffectObject(int n, boolean bl, int n2, int[] nArray) {
        CGameObject cGameObject = this.GameObject_CreateObject(n, bl, n2, nArray);
        if (null != cGameObject) {
            this.Events_PostEvent(cGameObject.Animateable_GetAnimationTime(cGameObject.getState()), -1, 0, cGameObject.m_iUID, 0);
        }
        return cGameObject;
    }

    public void GameObject_DestroyObject(CGameObject cGameObject) {
        if (null == cGameObject) {
            return;
        }
        if (cGameObject == this.m_player) {
            this.onSceneFinished(false);
        }
        cGameObject.OnDestroy();
        this.m_gameobjects.removeElement(cGameObject);
        this.m_gameobjects_active.removeElement(cGameObject);
        this.Triggers_OnObjectKilled(cGameObject);
    }

    public void MapObject_LoadObjects(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedByte();
        this.m_mapobjects_offsets = new short[n2];
        Object object = new byte[n2][];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = dataInputStream.readUnsignedByte();
            this.m_mapobjects_offsets[i] = n3;
            object[i] = new byte[n];
            dataInputStream.readFully(object[i]);
            n3 = (short)(n3 + n);
        }
        byte[] byArray = new byte[n3];
        for (n = 0; n < n2; ++n) {
            System.arraycopy(object[n], 0, byArray, this.m_mapobjects_offsets[n], object[n].length);
        }
        dataInputStream.readShort();
        object = null;
        System.gc();
        this.m_mapobjects_data = new DataInputStream(new ByteArrayInputStream(byArray));
        byArray = null;
        System.gc();
    }

    public void MapObject_UnloadObjects() {
        this.m_mapobjects_offsets = null;
        try {
            this.m_mapobjects_data.close();
        }
        catch (Exception exception) {
            Debug.PrintException(exception);
        }
    }

    public CGameObject MapObject_CreateObjectByUID(int n) {
        return this.MapObject_CreateObject(n, n);
    }

    private CGameObject MapObject_CreateObject(int n, int n2) {
        int n3 = n2;
        CGameObject cGameObject = null;
        try {
            DataInputStream dataInputStream = this.m_mapobjects_data;
            dataInputStream.reset();
            dataInputStream.skip(this.m_mapobjects_offsets[n3]);
            int n4 = dataInputStream.readUnsignedByte();
            CGameStats cGameStats = this.GameStats_FindStatsByType(n4);
            if (null != cGameStats) {
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                int n5 = CGameScene.ScreenToWorldX(s, s2);
                int n6 = CGameScene.ScreenToWorldY(s, s2);
                int n7 = 0;
                int n8 = dataInputStream.readUnsignedByte() * 51472;
                byte by = dataInputStream.readByte();
                int n9 = dataInputStream.readInt();
                int n10 = dataInputStream.readInt();
                cGameObject = this.GameObject_CreateObject(n4, true, n2, n5, n6, n7);
                if (cGameObject != null) {
                    cGameObject.Positionable_SetDirection(n8);
                    if (0 != (cGameObject.m_ActiveComponents & 1)) {
                        cGameObject.Animateable_Update(0);
                    }
                    cGameObject.m_camera = by;
                    cGameObject.m_flags |= n9;
                    cGameObject.m_Tag = n10;
                    if ((cGameStats.m_flags_ex & 2) != 0 && dataInputStream.readByte() != 0) {
                        cGameObject.m_InventoryAmount = (byte)dataInputStream.readInt();
                        cGameObject.m_InventoryObjectType = dataInputStream.readByte();
                    }
                    if ((cGameStats.m_flags_ex & 4) != 0) {
                        int n11 = dataInputStream.readByte();
                        for (int i = 0; i < n11; ++i) {
                            byte by2 = dataInputStream.readByte();
                            if (0 == by2) {
                                cGameObject.Route_Load(dataInputStream);
                                continue;
                            }
                            if (1 != by2) continue;
                            cGameObject.Zone_Load(dataInputStream);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            Debug.PrintException(exception);
        }
        return cGameObject;
    }

    public void MapObject_DestroyObjectByUID(int n) {
        int n2 = this.m_gameobjects.size();
        for (int i = n2 - 1; i >= 0; --i) {
            CGameObject cGameObject = (CGameObject)this.m_gameobjects.elementAt(i);
            if (cGameObject.m_iUID != n) continue;
            this.GameObject_DestroyObject(cGameObject);
        }
    }

    public void Strings_Init() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/Languages.bin"));
        this.m_languages = new String[dataInputStream.readShort()][];
        for (int i = 0; i < this.m_languages.length; ++i) {
            dataInputStream.readInt();
            this.m_languages[i] = g5.readStringA(dataInputStream);
        }
        dataInputStream.close();
        while (!this.m_stringsLangSelected) {
            this.RenderImmediate();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        RedFaction.languageSelectID = m_stringsLangIndex;
        if (!RedFaction.GameLinkEnabled) {
            MENU_Main = RedFaction.deleteItem(MENU_Main, 202);
        }
        if (!RedFaction.DemoMode) {
            MENU_Main = RedFaction.deleteItem(MENU_Main, 200);
            MENU_Main = RedFaction.deleteItem(MENU_Main, 201);
        } else {
            MENU_Main = RedFaction.deleteItem(MENU_Main, 29);
        }
        this.Strings_SetLanguage();
    }

    public void Strings_SetLanguage() throws IOException {
        this.m_languages = null;
        System.gc();
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream("/Languages.bin"));
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            dataInputStream.readInt();
            if (i == m_stringsLangIndex) {
                this.m_strings = g5.readStringA(dataInputStream);
                continue;
            }
            int n2 = dataInputStream.readShort();
            for (int j = 0; j < n2; ++j) {
                dataInputStream.readUTF();
            }
        }
        dataInputStream.close();
    }

    public void Strings_Init_keyPressed(int n) {
        if (null == this.m_languages) {
            return;
        }
        switch (this.getGameAction(n)) {
            case 8: {
                this.m_stringsLangSelected = true;
                break;
            }
            case 1: {
                m_stringsLangIndex = (m_stringsLangIndex - 1 + this.m_languages.length) % this.m_languages.length;
                break;
            }
            case 6: {
                m_stringsLangIndex = (m_stringsLangIndex + 1) % this.m_languages.length;
            }
        }
    }

    public void Strings_Init_Render(Graphics graphics) {
        if (null == this.m_languages) {
            return;
        }
        if (null == this.m_languages[0]) {
            return;
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setColor(0);
        graphics.fillRect(n, n2, n3, n4);
        int n5 = g5.Font_GetHeight(0) + 4;
        int n6 = n4 / 2 - this.m_languages.length * n5 / 2;
        for (int i = 0; i < this.m_languages.length; ++i) {
            if (i == m_stringsLangIndex) {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(n + (n3 - 80) / 2, n2 + n6 + i * n5, 80, n5);
            }
            g5.Font_RenderString(graphics, this.m_languages[i][1], 0, n + n3 / 2, n2 + n6 + i * n5 + n5 / 2, 3, i == m_stringsLangIndex ? 0 : 0xFFFFFF);
        }
    }

    public String getString(int n) {
        if (n == 200) {
            return RedFaction.TEXT_GetTheGame[RedFaction.languageSelectID];
        }
        if (n == 201) {
            return RedFaction.TEXT_StartTrial[RedFaction.languageSelectID];
        }
        if (n == 202) {
            return RedFaction.GameLink_Text[RedFaction.languageSelectID];
        }
        if (n == 203) {
            return RedFaction.CMD_GetIt[RedFaction.languageSelectID];
        }
        if (n == 204) {
            return RedFaction.TEXT_GetIt[RedFaction.languageSelectID];
        }
        if (n == 205) {
            return RedFaction.TITLE_FreeTrial[RedFaction.languageSelectID];
        }
        if (n == 206) {
            return RedFaction.TEXT_FreeTrial[RedFaction.languageSelectID];
        }
        if (n >= 0 && n < this.m_strings.length) {
            return this.m_strings[n];
        }
        Debug.Println("!!! Invalid string ID - " + n);
        return null;
    }

    protected void preload() {
        System.gc();
        this.m_preloaded = true;
    }

    protected boolean isScenePending() {
        return this.m_scenenext != m_scene || this.m_sceneparams != this.m_sceneparamsnext;
    }

    protected void setScene(int n, int[] nArray) {
        if (this.m_loadingIsActive > 0) {
            return;
        }
        this.ShutdownScene();
        m_scene = 16;
        if (0 == (n & 0x10)) {
            this.Loading_Begin(m_missionNames[nArray[0]], m_missionDescs[nArray[0]], false);
            if (!this.m_preloaded) {
                this.preload();
            }
        }
        this.reset();
        this.m_scenenext = n;
        this.m_sceneparams = nArray;
        this.m_sceneparamsnext = nArray;
        this.initScene(n);
        m_scene = n;
        if (0 == (n & 0x10)) {
            this.Loading_End(true);
        }
        Debug.PrintMemory();
    }

    public void requestScene(int n, int[] nArray) {
        this.m_scenenext = n;
        this.m_sceneparamsnext = nArray;
    }

    public void reset() {
        super.reset();
        this.CutScene_Shutdown();
        this.m_flags = 0;
        this.m_xscene = 0;
        this.m_yscene = 0;
        this.m_xlook = 0;
        this.m_ylook = 0;
        this.m_xviewLast = -1;
        this.m_yviewLast = -1;
        this.m_xlookShift = 0;
        this.m_ylookShift = 0;
        this.m_wview = this.m_wscene = g5.m_width;
        this.m_hview = this.m_hscene = g5.m_height;
        this.Dialogs_Reset();
        this.Messages_Reset();
        this.Events_Reset();
        CGameScene.Effects_Reset();
        this.Bullets_Reset();
        while (null != this.popSoftButtons()) {
        }
        g5.m_debugFPSTotalTime = 0L;
        g5.m_debugFPSTotalFrames = 0;
        this.m_pauseIsActive = false;
    }

    protected void initScene(int n) {
        this.GameObject_InitObjects();
        switch (n) {
            case 17: {
                this.Menu_Init();
                break;
            }
            case 41: {
                this.Action_Init();
                break;
            }
            case 18: {
                this.MenuText_Init();
                break;
            }
            case 19: {
                this.MenuInput_Init();
                break;
            }
            case 20: {
                this.MenuScores_Init();
                break;
            }
            case 24: {
                this.EndScreen_Init();
                break;
            }
            case 21: {
                this.MenuChapter_Init();
                break;
            }
            case 22: {
                this.Splashes_Init();
                break;
            }
            case 23: {
                this.Title_Init();
            }
        }
    }

    protected void ShutdownScene() {
        switch (m_scene) {
            case 17: {
                this.Menu_Shutdown();
                break;
            }
            case 41: {
                this.Action_Shutdown();
                break;
            }
            case 18: {
                this.MenuText_Shutdown();
                break;
            }
            case 19: {
                this.MenuInput_Shutdown();
                break;
            }
            case 20: {
                this.MenuScores_Shutdowm();
                break;
            }
            case 24: {
                this.EndScreen_Shutdown();
                break;
            }
            case 21: {
                this.MenuChapter_Shutdown();
                break;
            }
            case 22: {
                this.Splashes_Shutdown();
                break;
            }
            case 23: {
                this.Title_Shutdown();
            }
        }
        m_layertiles.remAllValues();
        this.GameObject_ShutdownObjects();
    }

    protected void UpdateScene(int n) {
        if (this.isScenePending()) {
            return;
        }
        if (this.m_loadingIsActive > 0) {
            this.Loading_Update();
            return;
        }
        if ((m_scene & 0x10) == 0) {
            this.m_Progress[0] = this.m_Progress[0] + n;
        }
        switch (m_scene) {
            case 17: {
                this.Menu_Update();
                break;
            }
            case 41: {
                this.Action_Update(n);
                break;
            }
            case 18: {
                this.MenuText_Update(n);
                break;
            }
            case 19: {
                this.MenuInput_Update();
                break;
            }
            case 20: {
                this.MenuScores_Update();
                break;
            }
            case 24: {
                this.EndScreen_Update();
                break;
            }
            case 21: {
                this.MenuChapter_Update();
                break;
            }
            case 22: {
                this.Splashes_Update(n);
                break;
            }
            case 23: {
                this.Title_Update(n);
            }
        }
        this.UpdateSounds();
    }

    protected void UpdateSounds() {
        if (!this.IsMenuSoundTime()) {
            return;
        }
        if (!g5.Sound_IsPlaying(0)) {
            g5.Sound_Play(0);
        }
    }

    protected boolean IsMenuSoundTime() {
        return (m_scene & 0x10) != 0 && m_scene != 22 && m_scene != 23 && this.m_loadingIsActive == 0;
    }

    protected boolean CanResumeSound() {
        return !this.m_pauseIsActive;
    }

    protected void RenderSceneBottom(Graphics graphics) {
        if (this.m_loadingIsActive > 0) {
            return;
        }
    }

    protected void RenderScene(Graphics graphics) {
        if (this.m_loadingIsActive > 0) {
            this.Loading_Render(graphics);
            return;
        }
        switch (m_scene) {
            case 17: {
                this.Menu_Render(graphics);
                break;
            }
            case 41: {
                this.Action_Render(graphics);
                this.Game_RenderKey(graphics);
                break;
            }
            case 18: {
                this.MenuText_Render(graphics);
                break;
            }
            case 19: {
                this.MenuInput_Render(graphics);
                break;
            }
            case 20: {
                this.MenuScores_Render(graphics);
                break;
            }
            case 24: {
                this.EndScreen_Render(graphics);
                break;
            }
            case 21: {
                this.MenuChapter_Render(graphics);
                break;
            }
            case 22: {
                this.Splashes_Render(graphics);
                break;
            }
            case 23: {
                this.Title_Render(graphics);
            }
        }
    }

    protected void RenderSceneCrop(Graphics graphics, int n) {
        graphics.setColor(0);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), n);
        if (0 != this.Dialogs_GetDialogId()) {
            graphics.fillRect(graphics.getClipX(), graphics.getClipY() + graphics.getClipHeight() - n, graphics.getClipWidth(), n);
        }
    }

    public void RenderScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2 && !bl3) {
            return;
        }
        int n6 = n - 2;
        graphics.setColor(0xFFCC66);
        graphics.drawRect(n6, n2, 3, n3 - n2 - 1);
        graphics.fillRect(n6, n4, 4, n5 - n4);
    }

    protected void onSceneStarted() {
        if (0 != (0x20 & m_scene)) {
            this.pushSoftButtons(12, -1);
        }
        System.gc();
        Debug.PrintMemory();
    }

    protected void onSceneFinished(boolean bl) {
        if (0 != (0x20 & m_scene)) {
            this.popSoftButtons();
        }
        if (this.CutScene_IsEnabled()) {
            this.CutScene_Shutdown();
        }
        if (bl) {
            this.Dialogs_Create(1, null);
        } else {
            this.Dialogs_Create(2, null);
        }
    }

    public boolean Dialogs_IsAnyDialogs() {
        return !this.m_DialogsStack.empty() || !this.m_PendingDialogsStack.empty();
    }

    public void Dialogs_CreatePending(int n, Object[] objectArray) {
        this.m_PendingDialogsStack.push(new Object[]{new Integer(n), objectArray});
    }

    public void Dialogs_Create(int n, Object[] objectArray) {
        if (!this.Dialogs_CanAdd(n)) {
            this.Dialogs_CreatePending(n, objectArray);
            return;
        }
        Object[] objectArray2 = new Object[3];
        Object var4_4 = null;
        int n2 = DIALOGS_DATA[n][0];
        switch (n) {
            case 0: {
                if (this.Briefings_CreateBriefing(objectArray)) break;
                return;
            }
            case 1: {
                this.Debrief_Create();
                break;
            }
            case 2: {
                this.FailScreen_Create();
                break;
            }
            case 3: {
                this.Objectives_Create();
                break;
            }
            case 4: {
                this.DebriefAsk_Create();
                break;
            }
            default: {
                Debug.Println("Dialogs_Create: Invalid Dialog ID " + n);
                return;
            }
        }
        objectArray2[0] = new Integer(n);
        objectArray2[1] = new Integer(n2);
        objectArray2[2] = var4_4;
        this.m_DialogsStack.push(objectArray2);
        if (0 != DIALOGS_DATA[n][1]) {
            this.m_RenderTransition = DIALOGS_DATA[n][1];
        }
        g5.Input_ClearKeys();
    }

    public int Dialogs_GetDialogId() {
        return this.m_DialogsStack.empty() ? -1 : (Integer)((Object[])this.m_DialogsStack.peek())[0];
    }

    public boolean Dialogs_IsFullscreen() {
        for (int i = 0; i < this.m_DialogsStack.size(); ++i) {
            if (0 == ((Integer)((Object[])this.m_DialogsStack.elementAt(i))[1] & 1)) continue;
            return true;
        }
        return false;
    }

    public boolean Dialogs_IsModal() {
        return !this.m_DialogsStack.empty() && ((Integer)((Object[])this.m_DialogsStack.peek())[1] & 2) == 0;
    }

    public boolean Dialogs_IsPauseDlg() {
        return this.Dialogs_IsModal() && ((Integer)((Object[])this.m_DialogsStack.peek())[1] & 0x20) != 0;
    }

    public boolean Dialogs_IsAllowPause() {
        return !this.Dialogs_IsModal() || ((Integer)((Object[])this.m_DialogsStack.peek())[1] & 0x10) != 0;
    }

    public boolean Dialogs_ContainsDialog(int n) {
        int n2;
        for (n2 = 0; n2 < this.m_DialogsStack.size(); ++n2) {
            if (n != (Integer)((Object[])this.m_DialogsStack.elementAt(n2))[0]) continue;
            return true;
        }
        for (n2 = 0; n2 < this.m_PendingDialogsStack.size(); ++n2) {
            if (n != (Integer)((Object[])this.m_PendingDialogsStack.elementAt(n2))[0]) continue;
            return true;
        }
        return false;
    }

    private boolean Dialogs_CanAdd(int n) {
        if (this.m_loadingIsActive > 0) {
            return false;
        }
        for (int i = 0; i < this.m_DialogsStack.size(); ++i) {
            int n2 = (Integer)((Object[])this.m_DialogsStack.elementAt(i))[1];
            if (n == (Integer)((Object[])this.m_DialogsStack.elementAt(i))[0]) {
                return false;
            }
            if (0 == (4 & DIALOGS_DATA[n][0]) || 0 != (n2 & 2) && 0 == DIALOGS_DATA[n][0]) continue;
            return false;
        }
        return true;
    }

    public void Dialogs_Update(int n) {
        if (this.m_pauseIsActive != this.Dialogs_IsPauseDlg()) {
            return;
        }
        switch (this.Dialogs_GetDialogId()) {
            case 0: {
                this.Briefings_Update(n);
                break;
            }
            case 1: {
                this.Debrief_Update();
                break;
            }
            case 2: {
                this.FailScreen_Update();
                break;
            }
            case 3: {
                this.Objectives_Update(n);
                break;
            }
            case 4: {
                this.DebriefAsk_Update();
            }
        }
        if (this.m_PendingDialogsStack.empty()) {
            return;
        }
        Object[] objectArray = (Object[])this.m_PendingDialogsStack.elementAt(0);
        int n2 = (Integer)objectArray[0];
        if (this.Dialogs_CanAdd(n2)) {
            this.Dialogs_Create(n2, (Object[])objectArray[1]);
            this.m_PendingDialogsStack.removeElementAt(0);
        }
    }

    private void Dialogs_RenderDialog(Graphics graphics, int n, Object object) {
        switch (n) {
            case 0: {
                this.Briefings_Render(graphics);
                break;
            }
            case 1: {
                this.Debrief_Render(graphics);
                break;
            }
            case 2: {
                this.FailScreen_Render(graphics);
                break;
            }
            case 3: {
                this.Objectives_Render(graphics);
                break;
            }
            case 4: {
                this.DebriefAsk_Render(graphics);
            }
        }
    }

    public boolean Dialogs_IsValidDialogLayer(int n, int n2) {
        switch (n2) {
            case 1: {
                return 0 == (n & 8);
            }
            case 4: {
                return 0 != (n & 8);
            }
        }
        return false;
    }

    public void Dialogs_Render(Graphics graphics, int n) {
        int n2 = this.m_DialogsStack.size();
        if (0 == n2) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (n3 = n2 - 1; !(n3 <= 0 || this.Dialogs_IsValidDialogLayer(n4 = ((Integer)((Object[])this.m_DialogsStack.elementAt(n3))[1]).intValue(), n) && 0 != (n4 & 1)); --n3) {
        }
        while (n3 < n2) {
            Object[] objectArray = (Object[])this.m_DialogsStack.elementAt(n3);
            if (this.Dialogs_IsValidDialogLayer((Integer)objectArray[1], n)) {
                this.Dialogs_RenderDialog(graphics, (Integer)objectArray[0], objectArray[2]);
            }
            ++n3;
        }
    }

    public void Dialogs_Close() {
        Object[] objectArray = this.m_DialogsStack.empty() ? null : (Object[])this.m_DialogsStack.pop();
        this.Dialogs_Close(objectArray);
    }

    public void Dialogs_Close(Object[] objectArray) {
        if (null == objectArray) {
            return;
        }
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        if (0 != DIALOGS_DATA[n][2]) {
            this.m_RenderTransition = DIALOGS_DATA[n][2];
        }
        switch (n) {
            case 0: {
                this.Briefings_CloseBriefing();
                break;
            }
            case 1: {
                this.Debrief_Close();
                break;
            }
            case 2: {
                this.FailScreen_Close();
                break;
            }
            case 4: {
                this.DebriefAsk_Close();
                break;
            }
            case 3: {
                this.Objectives_Close();
            }
        }
    }

    public void Dialogs_Close(int n) {
        for (int i = this.m_DialogsStack.size() - 1; i >= 0; --i) {
            Object[] objectArray = (Object[])this.m_DialogsStack.elementAt(i);
            if (n != (Integer)objectArray[0]) continue;
            this.Dialogs_Close(objectArray);
            this.m_DialogsStack.removeElementAt(i);
            break;
        }
    }

    protected void Dialogs_Load(DataInputStream dataInputStream) throws IOException {
    }

    protected void Dialogs_Save(DataOutputStream dataOutputStream) throws IOException {
    }

    protected void Dialogs_Reset() {
        this.m_PendingDialogsStack.removeAllElements();
        while (!this.m_DialogsStack.empty()) {
            this.Dialogs_Close();
        }
    }

    public void Briefings_Load(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readShort();
        this.m_briefingMembersTileID = new short[n2];
        this.m_briefingMembersName = new int[n2];
        int n3 = 0;
        for (n = 0; n < n2; n = (byte)(n + 1)) {
            n3 = dataInputStream.readInt();
            this.m_briefingMembersTileID[n3] = dataInputStream.readShort();
            this.m_briefingMembersName[n3] = dataInputStream.readInt();
        }
        n = (byte)dataInputStream.readShort();
        this.m_briefingsID = new byte[n];
        this.m_briefingsOffset = new byte[n + 1];
        this.m_briefingPhrasesMember = new Vector();
        this.m_briefingPhrasesText = new Vector();
        for (int i = 0; i < n; ++i) {
            this.m_briefingsID[i] = dataInputStream.readByte();
            byte by = (byte)dataInputStream.readShort();
            if (0 == i) {
                this.m_briefingsOffset[i] = 0;
            }
            this.m_briefingsOffset[i + 1] = (byte)(this.m_briefingsOffset[i] + by);
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                this.m_briefingPhrasesMember.addElement(new Integer(dataInputStream.readInt()));
                this.m_briefingPhrasesText.addElement(this.getString(dataInputStream.readInt()));
            }
        }
    }

    public boolean Briefings_CreateBriefing(Object[] objectArray) {
        if (this.m_briefing != -1) {
            return false;
        }
        this.m_briefingFlags = 0;
        byte by = (byte)((Integer)objectArray[0]).intValue();
        boolean bl = 0 != (Integer)objectArray[1];
        this.m_briefing = (byte)-1;
        for (int i = 0; i < this.m_briefingsID.length; ++i) {
            if (this.m_briefingsID[i] != by) continue;
            this.m_briefing = (byte)i;
            break;
        }
        if (-1 == this.m_briefing) {
            Debug.Println("Invalid briefing ID " + by);
            return false;
        }
        this.pushSoftButtons(-1, -1);
        this.m_briefingLine1 = 0;
        this.m_briefingLine2 = 0;
        if (this.Briefings_UpdatePhraseIndex(this.m_briefingsOffset[this.m_briefing])) {
            if (!bl) {
                g5.Sound_Play(3);
            }
        } else {
            this.m_briefing = (byte)-1;
            this.popSoftButtons();
            return false;
        }
        this.m_flags |= 0x10000;
        this.m_flags |= 0x20000;
        this.m_briefingFlags |= 0x30000;
        return true;
    }

    public void Briefings_Update(int n) {
        if (this.m_briefing == -1) {
            return;
        }
        if (g5.Input_IsKeyHit(-22) && this.m_briefingLine2 < this.m_briefingContent.size()) {
            this.Dialogs_Close();
        } else if (g5.Input_IsGameActionHit(8) || g5.Input_IsGameActionHit(6) || g5.Input_IsKeyHit(-21)) {
            this.Briefings_ScrollText(true, !g5.Input_IsGameActionHit(6));
            g5.Input_ClearKeys();
        } else if (g5.Input_IsGameActionHit(1)) {
            this.Briefings_ScrollText(false, false);
            g5.Input_ClearKeys();
        }
    }

    public void Briefings_Render(Graphics graphics) {
        int n;
        if (this.m_briefing == -1) {
            return;
        }
        int n2 = (Integer)this.m_briefingPhrasesMember.elementAt(this.m_briefingPhrase);
        this.Pause_FrameRender(graphics, this.m_briefingMembersName[n2]);
        int n3 = g5.Font_GetHeight(0);
        for (n = this.m_briefingLine1; n < this.m_briefingLine2; ++n) {
            g5.Font_RenderString(graphics, (String)this.m_briefingContent.elementAt(n), 0, 4, 225 + n3 * (n - this.m_briefingLine1), 20, 14380042);
        }
        n = 52 / n3;
        int n4 = ((this.m_briefingContent.size() - 1) / n + 1) * n;
        if (n < this.m_briefingContent.size()) {
            graphics.setColor(0);
            graphics.fillRect(232, 226, 5, 51);
            int n5 = this.m_briefingLine1 * 51 / n4;
            graphics.setColor(14380042);
            graphics.fillRect(232, 226 + n5, 5, (this.m_briefingLine1 + n) * 51 / n4 - n5);
        }
    }

    public void Briefings_CloseBriefing() {
        if (this.m_briefing == -1) {
            return;
        }
        this.popSoftButtons();
        this.Events_PostEvent(0, -1, 4, this.m_briefingsID[this.m_briefing], 0);
        this.m_briefing = (byte)-1;
        this.m_briefingContent = null;
        this.m_flags &= ~this.m_briefingFlags;
    }

    protected void Briefings_OnPhraseChanged() {
        if (this.m_briefing == -1) {
            return;
        }
        this.m_briefingLine1 = 0;
        this.m_briefingLine2 = 0;
        this.m_briefingContent = g5.Font_SplitString((String)this.m_briefingPhrasesText.elementAt(this.m_briefingPhrase), 0, 226);
        this.Briefings_ScrollText(true, true);
    }

    protected void Briefings_ScrollText(boolean bl, boolean bl2) {
        if (this.m_briefing == -1) {
            return;
        }
        if (this.m_briefingContent != null) {
            if (bl && (this.m_briefingLine2 != this.m_briefingContent.size() || bl2)) {
                this.m_briefingLine1 = this.m_briefingLine2;
                this.m_briefingLine2 = (byte)Math.min(this.m_briefingContent.size(), this.m_briefingLine1 + 52 / g5.Font_GetHeight(0));
            } else if (!bl && 0 != this.m_briefingLine1) {
                this.m_briefingLine2 = this.m_briefingLine1;
                this.m_briefingLine1 = (byte)Math.max(0, this.m_briefingLine2 - 52 / g5.Font_GetHeight(0));
            }
            if (this.m_briefingLine2 == this.m_briefingContent.size()) {
                this.setSoftButtons(3, -1);
            } else {
                this.setSoftButtons(6, 4);
            }
        }
        if (bl2 && this.m_briefingLine1 == this.m_briefingLine2 && !this.Briefings_UpdatePhraseIndex((byte)(this.m_briefingPhrase + 1))) {
            this.Dialogs_Close();
        }
    }

    protected boolean Briefings_UpdatePhraseIndex(byte by) {
        boolean bl = g5.GetHints();
        this.m_briefingPhrase = by;
        while (this.m_briefingPhrase < this.m_briefingsOffset[this.m_briefing + 1]) {
            if (bl || (Integer)this.m_briefingPhrasesMember.elementAt(this.m_briefingPhrase) != 1) {
                this.Briefings_OnPhraseChanged();
                return true;
            }
            this.m_briefingPhrase = (byte)(this.m_briefingPhrase + 1);
        }
        return false;
    }

    public void CutScene_Start(int n) {
        this.m_CutScene_ID = n;
        this.m_flags |= 0x200;
        this.m_CutsceneCropProgress = 0;
        this.m_CutsceneCropInside = true;
        this.pushSoftButtons(-1, -1);
    }

    public void CutScene_Shutdown() {
        this.m_flags &= 0xFFFFFDFF;
        this.Events_PostEvent(0, -1, 9, this.m_CutScene_ID, 0);
        this.m_CutScene_ID = -1;
        this.popSoftButtons();
    }

    public void CutScene_Stop() {
        this.m_CutsceneCropInside = false;
    }

    public boolean CutScene_IsEnabled() {
        return 512 == (0x200 & this.m_flags);
    }

    private boolean CutScene_Update(int n) {
        if (!this.CutScene_IsEnabled()) {
            return false;
        }
        if (this.m_CutsceneCropInside) {
            if (this.m_CutsceneCropProgress < 27) {
                this.m_CutsceneCropProgress += Math.max(25 * n / 1000, 1);
            }
            if (this.m_CutsceneCropProgress > 27) {
                this.m_CutsceneCropProgress = 27;
            }
        } else {
            if (this.m_CutsceneCropProgress > 0) {
                this.m_CutsceneCropProgress -= Math.max(25 * n / 1000, 1);
            }
            if (this.m_CutsceneCropProgress <= 0) {
                this.m_CutsceneCropProgress = 0;
                this.CutScene_Shutdown();
            }
        }
        return true;
    }

    protected void CutScene_Render(Graphics graphics) {
        if (!this.CutScene_IsEnabled()) {
            return;
        }
        this.CutScene_RenderCrop(graphics);
    }

    public void CutScene_RenderCrop(Graphics graphics) {
        this.RenderSceneCrop(graphics, this.m_CutsceneCropProgress);
    }

    public void Triggers_Init() {
        this.m_StateFlags = 0;
        this.m_triggersConditionOffsets = new VectorInt();
        this.m_triggersConditionData = new VectorInt();
        this.m_triggersActionOffsets = new VectorInt();
        this.m_triggersActionData = new VectorInt();
        this.m_killedobjectUIDs = new VectorInt();
        this.m_triggersInited = true;
    }

    public void Triggers_Shutdown() {
        this.m_triggersConditionOffsets = null;
        this.m_triggersConditionData = null;
        this.m_triggersActionOffsets = null;
        this.m_triggersActionData = null;
        this.m_killedobjectUIDs = null;
        this.m_triggersInited = false;
    }

    public void Triggers_Load(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = this.m_triggersConditionData.m_elements;
            this.m_triggersConditionData.addValuePlaceholders(4);
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    break;
                }
                case 2: {
                    this.m_triggersConditionData.addValue(dataInputStream.readUnsignedByte());
                    this.m_triggersConditionData.addValue(dataInputStream.readInt());
                    this.m_triggersConditionData.addValue(dataInputStream.readInt());
                    break;
                }
                case 4: 
                case 5: {
                    n3 = dataInputStream.readShort();
                    n2 = dataInputStream.readShort();
                    this.m_triggersConditionData.addValue(CGameScene.ScreenToWorldX(n3, n2));
                    this.m_triggersConditionData.addValue(CGameScene.ScreenToWorldY(n3, n2));
                    this.m_triggersConditionData.addValue(dataInputStream.readUnsignedByte() * 2 << 12);
                    this.m_triggersConditionData.addValue(dataInputStream.readUnsignedByte() * 2 << 12);
                    this.m_triggersConditionData.addValue(dataInputStream.readUnsignedByte());
                    this.m_triggersConditionData.addValue(dataInputStream.readUnsignedByte());
                    break;
                }
                case 3: {
                    n3 = dataInputStream.readUnsignedByte();
                    this.m_triggersConditionData.addValue(n3);
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.m_triggersConditionData.addValue(dataInputStream.readUnsignedByte());
                    }
                    break;
                }
                case 6: {
                    this.m_triggersConditionData.addValue(dataInputStream.readInt());
                }
            }
            n3 = dataInputStream.readShort();
            block24: for (n2 = 0; n2 < n3; ++n2) {
                this.m_triggersActionOffsets.addValue(this.m_triggersActionData.m_elements);
                byte by2 = dataInputStream.readByte();
                this.m_triggersActionData.addValue(by2);
                switch (by2) {
                    case 1: {
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                        continue block24;
                    }
                    case 3: 
                    case 4: 
                    case 14: 
                    case 15: {
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                        continue block24;
                    }
                    case 5: 
                    case 6: 
                    case 12: 
                    case 13: {
                        int n5;
                        int n6 = dataInputStream.readUnsignedByte();
                        this.m_triggersActionData.addValue(n6);
                        for (n5 = 0; n5 < n6; ++n5) {
                            this.m_triggersActionData.addValue(dataInputStream.readUnsignedByte());
                        }
                        continue block24;
                    }
                    case 9: 
                    case 10: {
                        int n5;
                        int n6 = dataInputStream.readUnsignedByte();
                        this.m_triggersActionData.addValue(n6);
                        for (n5 = 0; n5 < n6; ++n5) {
                            this.m_triggersActionData.addValue(dataInputStream.readShort());
                        }
                        continue block24;
                    }
                    case 7: {
                        this.m_triggersActionData.addValue(dataInputStream.readUnsignedByte());
                        continue block24;
                    }
                    case 8: {
                        this.m_triggersActionData.addValue(dataInputStream.readUnsignedByte());
                        continue block24;
                    }
                    case 11: {
                        this.m_triggersActionData.addValue(dataInputStream.readInt());
                        int n6 = dataInputStream.readUnsignedByte();
                        this.m_triggersActionData.addValue(255 == n6 ? -1 : n6);
                        this.m_triggersActionData.addValue(dataInputStream.readUnsignedByte());
                        this.m_triggersActionData.addValue(dataInputStream.readInt());
                        this.m_triggersActionData.addValue(dataInputStream.readInt());
                        continue block24;
                    }
                    case 16: 
                    case 17: 
                    case 21: {
                        this.m_triggersActionData.addValue(dataInputStream.readShort());
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                        continue block24;
                    }
                    case 18: {
                        int n5 = dataInputStream.readShort();
                        short s = dataInputStream.readShort();
                        this.m_triggersActionData.addValue(dataInputStream.readInt());
                        this.m_triggersActionData.addValue(CGameScene.ScreenToWorldX(n5, s));
                        this.m_triggersActionData.addValue(CGameScene.ScreenToWorldY(n5, s));
                        this.m_triggersActionData.addValue(dataInputStream.readShort() << 12);
                        continue block24;
                    }
                    case 22: {
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                        continue block24;
                    }
                    case 19: {
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                        this.m_triggersActionData.addValue(dataInputStream.readUnsignedByte());
                        this.m_triggersActionData.addValue(dataInputStream.readInt());
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                        int n7 = dataInputStream.readUnsignedByte();
                        this.m_triggersActionData.addValue(n7);
                        for (int j = 0; j < n7; ++j) {
                            this.m_triggersActionData.addValue(dataInputStream.readShort());
                        }
                        continue block24;
                    }
                    case 23: {
                        continue block24;
                    }
                    case 24: {
                        this.m_triggersActionData.addValue(dataInputStream.readInt());
                        this.m_triggersActionData.addValue(dataInputStream.readByte());
                    }
                }
            }
            this.m_triggersConditionOffsets.addValue(n4);
            this.m_triggersConditionData.m_data[n4 + 0] = by;
            this.m_triggersConditionData.m_data[n4 + 1] = 0;
            this.m_triggersConditionData.m_data[n4 + 2] = this.m_triggersActionOffsets.m_elements - n3;
            this.m_triggersConditionData.m_data[n4 + 3] = this.m_triggersActionOffsets.m_elements;
        }
    }

    public void Triggers_OnObjectCreated(CGameObject cGameObject) {
        if (!this.m_triggersInited) {
            return;
        }
        if (cGameObject.m_iUID != -1) {
            this.m_killedobjectUIDs.deleteSorted(cGameObject.m_iUID);
        }
    }

    public void Triggers_OnObjectKilled(CGameObject cGameObject) {
        if (!this.m_triggersInited) {
            return;
        }
        if (0 != (cGameObject.m_stats.m_flags_ex & 0x10) && cGameObject.m_iUID != -1) {
            this.m_isSomeoneKilled |= this.m_killedobjectUIDs.addSorted(cGameObject.m_iUID);
        }
    }

    public void Triggers_StoreState() {
        this.m_TriggersSavedState = new byte[this.m_triggersConditionOffsets.m_elements];
        for (int i = 0; i < this.m_triggersConditionOffsets.m_elements; ++i) {
            this.m_TriggersSavedState[i] = (byte)this.m_triggersConditionData.m_data[this.m_triggersConditionOffsets.m_data[i] + 1];
        }
    }

    public void Triggers_RestoreState() {
        if (this.m_TriggersSavedState == null) {
            return;
        }
        for (int i = 0; i < this.m_triggersConditionOffsets.m_elements; ++i) {
            this.m_triggersConditionData.m_data[this.m_triggersConditionOffsets.m_data[i] + 1] = this.m_TriggersSavedState[i];
        }
    }

    public void Triggers_Update() {
        if (!this.m_triggersInited) {
            return;
        }
        if (this.m_isSomeoneKilled) {
            this.m_isSomeoneKilled = false;
            this.Triggers_CheckCondition((byte)3);
        }
        this.Triggers_CheckCondition((byte)4);
        this.Triggers_CheckCondition((byte)5);
    }

    public void Triggers_CheckCondition(byte by) {
        if (!this.m_triggersInited) {
            return;
        }
        for (int i = 0; i < this.m_triggersConditionOffsets.m_elements; ++i) {
            int n = this.m_triggersConditionOffsets.m_data[i];
            if (this.m_triggersConditionData.m_data[n + 0] != by || this.m_triggersConditionData.m_data[n + 1] != 0 || !this.Triggers_CheckTriggerCondition(n)) continue;
            this.m_triggersConditionData.m_data[n + 1] = 1;
            int n2 = this.m_triggersConditionData.m_data[n + 2];
            int n3 = this.m_triggersConditionData.m_data[n + 3];
            for (int j = n2; j < n3; ++j) {
                this.Triggers_ExecuteAction(this.m_triggersActionOffsets.m_data[j]);
            }
        }
    }

    protected boolean Triggers_CheckTriggerCondition(int n) {
        int[] nArray = this.m_triggersConditionData.m_data;
        int n2 = nArray[n + 0];
        int n3 = n + 4;
        switch (n2) {
            case 4: 
            case 5: {
                int n4 = nArray[n3 + 0];
                int n5 = nArray[n3 + 1];
                int n6 = nArray[n3 + 2];
                int n7 = nArray[n3 + 3];
                int n8 = nArray[n3 + 4];
                int n9 = nArray[n3 + 5];
                Vector vector = this.GameObject_GetActiveObjects();
                int n10 = vector.size();
                for (int i = 0; i < n10; ++i) {
                    boolean bl;
                    CGameObject cGameObject = (CGameObject)vector.elementAt(i);
                    if (255 != n8 && cGameObject.m_iUID != n8 || cGameObject.m_iUID == n9) continue;
                    int[] nArray2 = cGameObject.m_positionLast;
                    int[] nArray3 = cGameObject.m_position;
                    boolean bl2 = nArray2[0] >= n4 && nArray2[1] >= n5 && nArray2[0] < n4 + n6 && nArray2[1] < n5 + n7;
                    boolean bl3 = bl = nArray3[0] >= n4 && nArray3[1] >= n5 && nArray3[0] < n4 + n6 && nArray3[1] < n5 + n7;
                    if (n2 == 4 ? bl && !bl2 : !bl && bl2) {
                        return true;
                    }
                    if (255 != n8) break;
                }
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return nArray[n3 + 0] == this.m_LastEventInfo[2] && nArray[n3 + 1] == this.m_LastEventInfo[3] && nArray[n3 + 2] == this.m_LastEventInfo[4];
            }
            case 3: {
                if (null == this.m_killedobjectUIDs) {
                    return false;
                }
                int n11 = nArray[n3];
                for (int i = 0; i < n11; ++i) {
                    int n12 = nArray[n3 + 1 + i];
                    if (-1 != this.m_killedobjectUIDs.findSorted(n12)) continue;
                    return false;
                }
                return true;
            }
            case 6: {
                return nArray[n3] == (this.m_StateFlags & nArray[n3]);
            }
        }
        return false;
    }

    protected void Triggers_ExecuteAction(int n) {
        try {
            int[] nArray = this.m_triggersActionData.m_data;
            int n2 = nArray[n + 0];
            int n3 = n + 1;
            switch (n2) {
                case 1: {
                    this.onSceneFinished(0 != nArray[n3 + 0]);
                    break;
                }
                case 3: 
                case 4: {
                    this.m_terrain.setPassLayerActivity(nArray[n3 + 0], 3 == n2 ? (byte)0 : 1);
                    break;
                }
                case 14: 
                case 15: {
                    this.m_terrain.setGraphLayerActivity(nArray[n3 + 0], 14 == n2 ? (byte)0 : 1);
                    break;
                }
                case 9: 
                case 10: {
                    int n4 = nArray[n3 + 0];
                    for (int i = 0; i < n4; ++i) {
                        int n5 = nArray[n3 + 1 + i];
                        this.m_terrain.setGraphTileActivity(n5, 9 == n2 ? (byte)0 : 1);
                    }
                    break;
                }
                case 12: 
                case 13: {
                    int n6 = nArray[n3 + 0];
                    for (int i = 0; i < n6; ++i) {
                        int n7 = nArray[n3 + 1 + i];
                        if (12 == n2) {
                            int n8 = this.m_triggersConditionOffsets.m_data[n7] + 1;
                            this.m_triggersConditionData.m_data[n8] = this.m_triggersConditionData.m_data[n8] & 0xFFFFFFFE;
                            continue;
                        }
                        int n9 = this.m_triggersConditionOffsets.m_data[n7] + 1;
                        this.m_triggersConditionData.m_data[n9] = this.m_triggersConditionData.m_data[n9] | 1;
                    }
                    break;
                }
                case 5: {
                    int n10 = nArray[n3 + 0];
                    for (int i = 0; i < n10; ++i) {
                        int n11 = nArray[n3 + 1 + i];
                        if (null != this.MapObject_CreateObjectByUID(n11) || !this.m_killedobjectUIDs.addSorted(n11)) continue;
                        this.Triggers_CheckCondition((byte)3);
                    }
                    break;
                }
                case 6: {
                    int n12 = nArray[n3 + 0];
                    for (int i = 0; i < n12; ++i) {
                        this.MapObject_DestroyObjectByUID(nArray[n3 + 1 + i]);
                    }
                    break;
                }
                case 7: 
                case 8: {
                    this.Dialogs_Create(0, new Object[]{new Integer(nArray[n3 + 0]), new Integer(0)});
                    break;
                }
                case 11: {
                    if (nArray[n3 + 0] < 0) {
                        this.Events_SendEvent(nArray[n3 + 1], nArray[n3 + 2], nArray[n3 + 3], nArray[n3 + 4]);
                        break;
                    }
                    this.Events_PostEvent(nArray[n3 + 0], nArray[n3 + 1], nArray[n3 + 2], nArray[n3 + 3], nArray[n3 + 4]);
                    break;
                }
                case 16: 
                case 17: 
                case 21: {
                    CGameStats cGameStats = this.GameStats_FindStatsByType(nArray[n3 + 0]);
                    if (null == cGameStats) break;
                    int n13 = nArray[n3 + 1];
                    break;
                }
                case 18: {
                    int n14 = nArray[n3 + 0];
                    int n15 = nArray[n3 + 1];
                    int n16 = nArray[n3 + 2];
                    int n17 = nArray[n3 + 3];
                    break;
                }
                case 24: {
                    int n18 = nArray[n3 + 0];
                    Debug.Println("ETA_SET_STATE: " + n18 + " (" + this.m_StateFlags + ")");
                    switch (nArray[n3 + 1]) {
                        case 0: {
                            this.m_StateFlags &= ~n18;
                            break;
                        }
                        case 1: {
                            this.m_StateFlags |= n18;
                            break;
                        }
                        case 2: {
                            this.m_StateFlags ^= n18;
                        }
                    }
                    Debug.Println("ETA_SET_STATE: m_StateFlags = " + this.m_StateFlags);
                    this.Triggers_CheckCondition((byte)6);
                    break;
                }
                case 22: {
                    Debug.Println("PlaySound: " + nArray[n3 + 0]);
                    g5.Sound_Play(nArray[n3 + 0]);
                }
            }
        }
        catch (Exception exception) {
            Debug.PrintException(exception);
        }
    }

    public void Triggers_Optimize(int n, int n2) {
        if (!this.m_triggersInited) {
            return;
        }
        CGameScene.m_scenerect1[0] = CGameScene.ScreenToWorldX(n, n2) - CGameScene.ScreenToWorldX(g5.m_width + 80, 0);
        CGameScene.m_scenerect1[1] = CGameScene.ScreenToWorldY(n, n2) - CGameScene.ScreenToWorldY(0, g5.m_height + 80);
        CGameScene.m_scenerect1[2] = CGameScene.ScreenToWorldX(n, n2) + CGameScene.ScreenToWorldX(g5.m_width + 80, 0);
        CGameScene.m_scenerect1[3] = CGameScene.ScreenToWorldY(n, n2) + CGameScene.ScreenToWorldY(0, g5.m_height + 80);
        int n3 = 0;
        int n4 = 0;
        block3: for (int i = 0; i < this.m_triggersConditionOffsets.m_elements; ++i) {
            int n5 = this.m_triggersConditionOffsets.m_data[i];
            int[] nArray = this.m_triggersConditionData.m_data;
            switch (nArray[n5 + 0]) {
                case 4: 
                case 5: {
                    CGameScene.m_scenerect2[0] = nArray[n5 + 4 + 0];
                    CGameScene.m_scenerect2[1] = nArray[n5 + 4 + 1];
                    CGameScene.m_scenerect2[2] = m_scenerect2[0] + nArray[n5 + 4 + 2];
                    CGameScene.m_scenerect2[3] = m_scenerect2[1] + nArray[n5 + 4 + 3];
                    ++n3;
                    if (g5.Math_IsIntersectsRect(m_scenerect1, m_scenerect2)) {
                        int n6 = n5 + 1;
                        nArray[n6] = nArray[n6] & 0xFFFFFFFD;
                        continue block3;
                    }
                    int n7 = n5 + 1;
                    nArray[n7] = nArray[n7] | 2;
                    ++n4;
                }
            }
        }
    }

    public void Messages_Init() {
        this.m_playerMessage = new Vector();
    }

    public void Messages_Shutdown() {
        this.m_playerMessage = null;
    }

    public void Messages_Reset() {
        if (this.m_playerMessage != null) {
            this.m_playerMessage.removeAllElements();
        }
        this.m_playerMessageTime = 0;
    }

    public void Messages_ShowMessage(String string) {
        this.Messages_ShowMessage(string, 0);
    }

    public void Messages_ShowMessage(String string, int n) {
        if (null == this.m_playerMessage) {
            return;
        }
        this.m_Param = n;
        this.m_playerMessage.addElement(string);
        this.m_playerMessageTime = 1000;
    }

    public void Messages_Update(int n) {
        if (this.m_playerMessageTime <= 0) {
            return;
        }
        this.m_playerMessageTime -= n;
        if (this.m_playerMessageTime > 0) {
            return;
        }
        if (!this.m_playerMessage.isEmpty()) {
            this.m_playerMessage.removeElementAt(0);
        }
        if (!this.m_playerMessage.isEmpty()) {
            this.m_playerMessageTime = 1000;
        }
    }

    public void Messages_RenderMessage(Graphics graphics) {
        if (this.m_playerMessage == null || this.m_playerMessage.isEmpty()) {
            return;
        }
        if (!this.Dialogs_IsModal()) {
            this.Messages_RenderMessageString(graphics, (String)this.m_playerMessage.elementAt(0), this.m_Param);
        }
    }

    public void Messages_RenderMessageString(Graphics graphics, String string, int n) {
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(string, 2, 200), 2, 120, 145, 3, 16618252, 0);
    }

    void Events_PostEvent(int n, int n2, int n3, int n4, int n5) {
        this.m_Events.addValue(n);
        this.m_Events.addValue(n2);
        this.m_Events.addValue(n3);
        this.m_Events.addValue(n4);
        this.m_Events.addValue(n5);
    }

    boolean Events_SendEvent(int n, int n2, int n3, int n4) {
        Debug.Println("***** Events_SendEvent: Event = " + n2 + " Object = " + n + " P1 = " + n3 + " P2 = " + n4);
        if (n == -1) {
            return this.Events_OnEvent(n2, n3, n4);
        }
        CGameObject cGameObject = this.GameObject_FindObjectByUID(n);
        if (cGameObject != null) {
            return cGameObject.Events_OnEvent(n2, n3, n4);
        }
        Debug.Println("  wasted");
        return true;
    }

    void Events_Update(int n) {
        int n2 = 0;
        while (n2 < this.m_Events.m_elements) {
            int[] nArray = this.m_Events.m_data;
            int n3 = nArray[n2 + 0];
            if (n3 > 0) {
                nArray[n2 + 0] = n3 - n;
            } else if (this.Events_SendEvent(nArray[n2 + 1], nArray[n2 + 2], nArray[n2 + 3], nArray[n2 + 4])) {
                this.m_Events.remValuesAt(5, n2);
                continue;
            }
            n2 += 5;
        }
        for (n2 = 0; n2 < this.m_Timers.length; ++n2) {
            if (this.m_Timers[n2] <= 0) continue;
            int n4 = n2;
            this.m_Timers[n4] = this.m_Timers[n4] - n;
            if (this.m_Timers[n2] > 0) continue;
            this.Events_SendEvent(-1, 5, n2, 0);
        }
    }

    void Events_Reset() {
        this.m_Events.remAllValues();
        for (int i = 0; i < this.m_Timers.length; ++i) {
            this.m_Timers[i] = 0;
        }
    }

    boolean Events_OnEvent(int n, int n2, int n3) {
        switch (n) {
            case 7: {
                this.MapObject_CreateObjectByUID(n2);
                return true;
            }
            case 0: {
                this.GameObject_DestroyObject(this.GameObject_FindObjectByUID(n2));
                return true;
            }
            case 6: {
                this.Dialogs_Create(0, new Object[]{new Integer(n2), new Integer(0)});
                return true;
            }
            case 1: {
                if (0 == n3) {
                    this.CutScene_Start(n2);
                } else {
                    this.CutScene_Stop();
                }
                return true;
            }
            case 8: {
                this.m_Timers[n2] = n3;
                return true;
            }
            case 10: {
                this.Messages_ShowMessage(this.getString(n2));
                return true;
            }
            case 21: {
                this.Dialogs_Create(n2, new Object[]{new Integer(n3)});
                return true;
            }
            case 22: {
                this.Dialogs_Close(n2);
                return true;
            }
            case 23: 
            case 25: {
                this.m_xlook = CGameScene.ScreenToWorldX(n2, n3);
                this.m_ylook = CGameScene.ScreenToWorldY(n2, n3);
                this.m_flags |= 0x10000;
                if (23 == n) {
                    this.m_flags |= 0x20000;
                }
                return true;
            }
            case 24: 
            case 26: {
                this.m_flags &= 0xFFFEFFFF;
                if (24 == n) {
                    this.m_flags &= 0xFFFDFFFF;
                }
                return true;
            }
            case 38: {
                this.Action_StartShake(n2, 19660);
                return true;
            }
            case 2: 
            case 3: {
                break;
            }
            case 27: {
                this.m_RenderTransition = n2;
                break;
            }
            case 29: {
                if (this.m_player == null || this.m_player.m_ObjectLinked == null) break;
                if (this.m_player.m_ContextProgress == 0) break;
                this.m_player.Context_End();
                break;
            }
            case 31: {
                this.GameObject_DestroyObject(this.GameObject_FindObjectByType(42));
                CGameObject cGameObject = this.GameObject_CreateObject(42, false, 0, this.m_xlook - this.m_xlookShift, this.m_ylook - this.m_ylookShift, 0);
                cGameObject.m_camera = 1;
                cGameObject.m_BehaviorType |= 0x12;
                cGameObject.BehaviorMoverCam_Init(g_scene.GameObject_FindObjectByUID(n2), n3, -1);
                return true;
            }
            case 33: {
                this.GameObject_DestroyObject(this.GameObject_FindObjectByType(42));
                return true;
            }
            case 34: {
                if (this.m_Progress[6] >= n2) break;
                this.Messages_ShowMessage(this.getString(88), 0);
                this.Action_Store();
                this.Progress_OnCheckpointPass(n2);
                break;
            }
            case 35: {
                this.Messages_ShowMessage(this.getString(89), 0);
                return true;
            }
            case 36: {
                this.m_Progress[1] = 1;
                this.Messages_ShowMessage(this.getString(90), 0);
                g5.Sound_Play(5);
                return true;
            }
            case 37: {
                this.m_Progress[5] = this.m_Progress[5] + 1;
                this.Dialogs_Create(0, new Object[]{new Integer(17), new Integer(1)});
                g5.Sound_Play(4);
                return true;
            }
        }
        this.m_LastEventInfo[2] = n;
        this.m_LastEventInfo[3] = n2;
        this.m_LastEventInfo[4] = n3;
        this.Triggers_CheckCondition((byte)2);
        return true;
    }

    static void Effects_Init(DataInputStream dataInputStream) throws IOException {
        int n;
        m_EffectObjects = new CEffectObject[16];
        for (n = 0; n < 16; ++n) {
            CGameScene.m_EffectObjects[n] = new CEffectObject();
        }
        m_EffectPatterns = new CEffectPattern[dataInputStream.readShort()];
        for (n = 0; n < m_EffectPatterns.length; ++n) {
            CGameScene.m_EffectPatterns[n] = new CEffectPattern();
            m_EffectPatterns[n].Init(dataInputStream);
        }
    }

    static void Effects_Reset() {
        for (int i = 0; i < 16; ++i) {
            m_EffectObjects[i].Reset();
        }
    }

    static void Effects_Update(int n) {
        for (int i = 0; i < 16; ++i) {
            CEffectObject cEffectObject = m_EffectObjects[i];
            if (null == cEffectObject.Pattern || cEffectObject.Pattern.Update(cEffectObject, n)) continue;
            CGameScene.Effects_Destroy(i);
        }
    }

    static void Effects_Render(Graphics graphics, byte by) {
        for (int i = 0; i < 16; ++i) {
            CEffectObject cEffectObject = m_EffectObjects[i];
            if (null == cEffectObject.Pattern) continue;
            cEffectObject.Pattern.Render(cEffectObject, graphics, by);
        }
    }

    static int Effects_Create(int n, int[] nArray, Object object) {
        for (int i = 0; i < 16; ++i) {
            CEffectObject cEffectObject = m_EffectObjects[i];
            if (null != cEffectObject.Pattern) continue;
            cEffectObject.Pattern = m_EffectPatterns[n];
            cEffectObject.Pattern.Create(cEffectObject, nArray, object);
            return i;
        }
        Debug.Println("Effects_Create: max number of effects reached");
        return -1;
    }

    static void Effects_Destroy(int n) {
        if (n == -1) {
            return;
        }
        m_EffectObjects[n].Reset();
    }

    static CEffectObject Effects_Get(int n) {
        if (n == -1) {
            return null;
        }
        if (null == CGameScene.m_EffectObjects[n].Pattern) {
            return null;
        }
        return m_EffectObjects[n];
    }

    protected void Bullets_Init(DataInputStream dataInputStream) throws IOException {
        int n;
        this.m_bullets = new int[8][];
        for (n = 0; n < 8; ++n) {
            this.m_bullets[n] = new int[10];
        }
        this.m_bulletTypes = new int[dataInputStream.readShort()][10];
        for (n = 0; n < this.m_bulletTypes.length; ++n) {
            for (int i = 0; i < 10; ++i) {
                this.m_bulletTypes[n][i] = dataInputStream.readInt();
            }
        }
    }

    protected void Bullets_Reset() {
        for (int i = 0; i < 8; ++i) {
            this.m_bullets[i][6] = -1;
        }
    }

    protected boolean Bullets_AreEnemyBulletsOnScreen() {
        for (int i = 0; i < 8; ++i) {
            int[] nArray = this.m_bullets[i];
            if (-1 == nArray[6] || this.m_player.m_iUID == nArray[5]) continue;
            int n = CGameScene.WorldToScreenX(nArray);
            int n2 = CGameScene.WorldToScreenY(nArray);
            if (n < this.m_xview || n >= this.m_xview + this.m_wview || n2 < this.m_yview || n2 >= this.m_yview + this.m_hview) continue;
            return true;
        }
        return false;
    }

    public void Bullets_Create(int n, int[] nArray, int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray2 = null;
        for (n6 = 0; n6 < 8 && -1 != (nArray2 = this.m_bullets[n6])[6]; ++n6) {
        }
        if (n6 == 8) {
            Debug.Println("Bullets_Create: max number of bullets reached");
            return;
        }
        g5.Math_CopyVector3D(nArray2, nArray);
        int n7 = this.m_bulletTypes[n][1];
        g5.Math_PolarToOrthogonalFlt(n2, n7);
        nArray2[3] = g5.ret_rPolarToOrthogonal_rX;
        nArray2[4] = g5.ret_rPolarToOrthogonal_rY;
        nArray2[5] = n3;
        nArray2[6] = n;
        nArray2[8] = -1;
        nArray2[7] = 0;
        if (this.Bullets_UpdateBullet(nArray2, 1000 * n4 / n7)) {
            nArray2[6] = -1;
        } else {
            int n8 = this.m_bulletTypes[n][4];
            if (n8 >= 0) {
                nArray2[8] = CGameScene.Effects_Create(n8, nArray2, nArray2);
            }
        }
        if (n5 >= 0) {
            CGameScene.Effects_Create(n5, nArray2, nArray2);
        }
        if (this.m_bulletTypes[n][5] < 0) {
            nArray2[9] = -1;
        } else {
            short[][] sArray = g5.Clip_GetClip(this.m_bulletTypes[n][5]);
            int n9 = g5.Math_AngleToDirectionFlt(n2, sArray.length, false);
            nArray2[9] = sArray[n9][0];
        }
    }

    protected void Bullets_Update(int n) {
        for (int i = 0; i < 8; ++i) {
            CEffectObject cEffectObject;
            int[] nArray = this.m_bullets[i];
            if (-1 == nArray[6] || !this.Bullets_UpdateBullet(nArray, n)) continue;
            if (nArray[8] >= 0 && null != (cEffectObject = CGameScene.Effects_Get(nArray[8]))) {
                cEffectObject.DisconnectHost();
            }
            nArray[6] = -1;
        }
    }

    protected boolean Bullets_UpdateBullet(int[] nArray, int n) {
        Object object;
        int[] nArray2 = this.m_bulletTypes[nArray[6]];
        n = Math.min(n, nArray2[6] - nArray[7]);
        CGameScene.m_coords1[0] = nArray[0] + n * nArray[3] / 1000;
        CGameScene.m_coords1[1] = nArray[1] + n * nArray[4] / 1000;
        CGameScene.m_coords1[2] = nArray[2];
        if (nArray[8] >= 0 && null != (object = CGameScene.Effects_Get(nArray[8])) && ((CEffectObject)object).LifeTime + n >= ((CEffectObject)object).Pattern.m_Duration) {
            ((CEffectObject)object).LifeTime -= (1 + n / ((CEffectObject)object).Pattern.m_Duration) * ((CEffectObject)object).Pattern.m_Duration;
        }
        if (null != (object = this.getIsectionWithSegment(nArray, m_coords1, m_coords2, null, nArray[5], -1, nArray2[8]))) {
            CGameObject cGameObject;
            g5.Math_CopyVector3D(nArray, m_coords2);
            int n2 = nArray2[3];
            if (object instanceof CGameObject) {
                cGameObject = (CGameObject)object;
                CGameScene.m_coords2[0] = g5.Math_MulFlt(nArray[3], nArray2[2]);
                CGameScene.m_coords2[1] = g5.Math_MulFlt(nArray[4], nArray2[2]);
                CGameScene.m_coords2[2] = 0;
                cGameObject.ApplyImpulse(m_coords2);
                cGameObject.ChangeHitPoints(-cGameObject.GetRealBulletDamage(nArray[6], nArray2[0]), true);
                cGameObject.OnAttacked(nArray[5]);
                int n3 = cGameObject.m_stats.getHitEffect();
                if (n3 != -1) {
                    n2 = n3;
                }
                if (!g5.GetBlood() && n2 == 24) {
                    n2 = -1;
                }
            }
            if (n2 >= 0) {
                CGameScene.Effects_Create(n2, nArray, null);
            }
            if (nArray2[7] != -1) {
                cGameObject = this.GameObject_CreateObject(nArray2[7], false, -1, nArray);
                this.GameObject_DestroyObject(cGameObject);
            }
            if (nArray2[9] == 0) {
                return true;
            }
        }
        g5.Math_CopyVector3D(nArray, m_coords1);
        nArray[7] = nArray[7] + n;
        return nArray[7] >= nArray2[6];
    }

    protected void Bullets_Render(Graphics graphics, byte by) {
        if (this.m_bullets == null) {
            return;
        }
        if (by != 3) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            int[] nArray = this.m_bullets[i];
            if (nArray[6] == -1 || nArray[9] == -1) continue;
            CGameScene.RenderTile(graphics, nArray[9], CGameScene.WorldToScreenX(nArray), CGameScene.WorldToScreenY(nArray));
        }
    }

    protected void HeroParams_Init() {
        this.m_scoreChapters = new int[m_gameplot.length][5];
        this.m_scoreTableScores = new int[]{65, 60, 45};
        this.m_scoreTableNames = new String[]{this.getString(70), this.getString(71), this.getString(72)};
    }

    protected void HeroParams_ConfirmMissionScore(int[] nArray) {
        System.arraycopy(nArray, 0, this.m_scoreChapters[this.m_currentChapter], 0, 5);
        this.saveGameState();
    }

    protected int HeroParams_UpdateScoreTable(String string, int n) {
        int n2 = 0;
        int n3 = Math.min(5, this.m_scoreTableScores.length + 1);
        int[] nArray = new int[n3];
        String[] stringArray = new String[n3];
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n4 < this.m_scoreTableScores.length && (n <= this.m_scoreTableScores[n4] || n4 < i)) {
                nArray[i] = this.m_scoreTableScores[n4];
                stringArray[i] = this.m_scoreTableNames[n4];
                ++n4;
                continue;
            }
            nArray[i] = n;
            stringArray[i] = string;
            n2 = i;
        }
        this.m_scoreTableScores = nArray;
        this.m_scoreTableNames = stringArray;
        return n2;
    }

    public int HeroParams_GetScoreSum(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_scoreChapters.length; ++i) {
            n2 += this.m_scoreChapters[i][n];
        }
        return n2;
    }

    public void HeroParams_Load(DataInputStream dataInputStream) throws IOException {
        this.m_HeroName = dataInputStream.readUTF();
        this.m_scoreTableScores = g5.readIntA(dataInputStream);
        this.m_scoreTableNames = g5.readStringA(dataInputStream);
        this.m_scoreChapters = g5.readIntAA(dataInputStream);
    }

    public void HeroParams_Save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.m_HeroName);
        g5.writeIntA(dataOutputStream, this.m_scoreTableScores);
        g5.writeStringA(dataOutputStream, this.m_scoreTableNames);
        g5.writeIntAA(dataOutputStream, this.m_scoreChapters);
    }

    public void HeroParams_Reset() {
        this.m_scoreChapters = new int[m_gameplot.length][5];
    }

    public void GamePlot_Load(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        int n3 = dataInputStream.readShort();
        m_gameplot = new int[n3][];
        m_gameplotImg = new int[n3][];
        m_gameplotWeapons = new int[n3][];
        m_missionNames = new String[n3];
        m_missionDescs = new String[n3];
        this.m_GamePlotSettingImg = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            n = dataInputStream.readInt();
            CGameScene.m_missionNames[n2] = this.getString(dataInputStream.readInt());
            CGameScene.m_missionDescs[n2] = this.getString(dataInputStream.readInt());
            CGameScene.m_gameplot[n2] = new int[4];
            CGameScene.m_gameplot[n2][0] = 41 + n;
            CGameScene.m_gameplot[n2][1] = n2;
            CGameScene.m_gameplot[n2][2] = dataInputStream.readInt();
            CGameScene.m_gameplot[n2][3] = dataInputStream.readInt();
            this.m_GamePlotSettingImg[n2] = dataInputStream.readInt();
            CGameScene.m_gameplotImg[n2] = new int[dataInputStream.readShort()];
            for (n4 = 0; n4 < m_gameplotImg[n2].length; ++n4) {
                CGameScene.m_gameplotImg[n2][n4] = dataInputStream.readInt();
            }
            CGameScene.m_gameplotWeapons[n2] = new int[dataInputStream.readShort()];
            for (n4 = 0; n4 < m_gameplotWeapons[n2].length; ++n4) {
                CGameScene.m_gameplotWeapons[n2][n4] = dataInputStream.readInt();
            }
        }
        this.m_difficultyConsts = new int[dataInputStream.readShort()][9];
        for (n2 = 0; n2 < this.m_difficultyConsts.length; ++n2) {
            for (n = 0; n < 9; ++n) {
                this.m_difficultyConsts[n2][n] = dataInputStream.readInt();
            }
        }
    }

    public void GamePlot_Reset() {
        this.m_gamePlotProgress = 0;
        this.m_currentChapter = 0;
        this.m_chapterChosen = (byte)-1;
        this.history_ChapterMaxCount = 0;
    }

    public void GamePlot_Advance() {
        if (-1 != this.m_chapterChosen) {
            this.requestScene(21, null);
        } else {
            this.m_gamePlotProgress = (byte)(this.m_currentChapter + 1);
            this.GamePlot_Process(false);
        }
    }

    public void GamePlot_Process(boolean bl) {
        this.m_currentChapter = this.m_gamePlotProgress;
        if (-1 != this.m_chapterChosen) {
            this.m_currentChapter = this.m_chapterChosen;
        }
        Debug.Println("m_currentChapters=" + this.m_currentChapter);
        Debug.Println("m_gamePlotProgress=" + this.m_gamePlotProgress);
        if (this.m_currentChapter > this.history_ChapterMaxCount) {
            this.history_ChapterMaxCount = this.m_currentChapter;
        }
        if (this.m_currentChapter >= m_gameplot.length) {
            this.requestScene(24, null);
            return;
        }
        int[] nArray = m_gameplot[this.m_currentChapter];
        int n = nArray[0];
        int[] nArray2 = new int[nArray.length - 1];
        System.arraycopy(nArray, 1, nArray2, 0, nArray2.length);
        this.requestScene(n, nArray2);
        this.Progress_OnMissionStart(bl);
    }

    public int GamePlot_GetConst(int n) {
        return this.m_difficultyConsts[this.m_currentDifficulty][n];
    }

    protected void Menu_Init() {
        if (null != this.m_sceneparams) {
            this.Menu_Reset(this.m_sceneparams);
        } else {
            this.Menu_Reset(MENU_Main);
        }
    }

    protected void Menu_Shutdown() {
        this.Menu_Pop();
    }

    boolean isSettingMenu(int[] nArray) {
        if (nArray.length >= 2 && nArray.length <= MENU_Settings.length) {
            for (int i = 0; i < 2; ++i) {
                if (nArray[i] == MENU_Settings[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void Menu_RenderContent(Graphics graphics) {
        int[] nArray = (int[])this.m_currentMenu.peek();
        if (this.isSettingMenu(nArray)) {
            g5.Font_RenderString(graphics, this.getString(18), 2, 120, 45, 3, 16685063);
        }
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl;
            String string = this.getString(nArray[i]);
            boolean bl2 = bl = i == this.m_currentMenuItem;
            g5.Font_RenderString(graphics, string, 2, 18, 120 + 22 * i, 6, bl ? 16685063 : (nArray[i] == 202 && RedFaction.TelstraMode ? 0xFFFFFF : 14380042));
            if (!bl) continue;
            int n = g5.Font_GetStringWidth(2, string) + 4;
            int n2 = 109 + 22 * i;
            int n3 = 16 + n - 1;
            int n4 = n2 + 23 - 1;
            graphics.setColor(16685063);
            graphics.drawLine(16, n2, n3, n2);
            graphics.drawLine(16, n2, 16, n4);
            graphics.drawLine(16, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
        }
    }

    public void Menu_Render(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        this.Menu_RenderContent(graphics);
    }

    protected void Menu_Update() {
    }

    public void Menu_OnKeyPressed(int n) {
        if (this.m_currentMenu.empty()) {
            return;
        }
        int[] nArray = (int[])this.m_currentMenu.peek();
        if (null == nArray) {
            return;
        }
        int n2 = this.m_currentMenuItem;
        try {
            int n3 = this.getGameAction(n);
            if (n == 53) {
                n3 = 8;
            } else if (n == 50) {
                n3 = 1;
            } else if (n == 52) {
                n3 = 2;
            } else if (n == 54) {
                n3 = 5;
            } else if (n == 56) {
                n3 = 6;
            } else if (n == -21) {
                n3 = 0;
            } else if (n == -22) {
                n3 = 0;
            } else if (n == 48) {
                n3 = 0;
            }
            if (!this.m_pauseShowHelp) {
                switch (n3) {
                    case 1: {
                        --this.m_currentMenuItem;
                        break;
                    }
                    case 6: {
                        ++this.m_currentMenuItem;
                        break;
                    }
                    case 8: {
                        this.m_currentMenuEvent = nArray[this.m_currentMenuItem];
                        if (!this.Menu_IsItemExists(17)) break;
                        this.m_currentMenuItem = 0;
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (n == -8) {
            if (this.Menu_IsItemExists(17)) {
                this.m_currentMenuEvent = 17;
            } else if (this.Menu_IsItemExists(16)) {
                this.m_currentMenuEvent = 16;
            } else if (this.Menu_IsItemExists(20)) {
                this.m_currentMenuEvent = 20;
            }
        } else if (n == -22 && this.m_idCommands[1] == 10) {
            this.m_currentMenuEvent = this.Menu_IsItemExists(17) ? 17 : 20;
        } else if (n == -21 && this.m_idCommands[0] != -1) {
            this.m_currentMenuEvent = nArray[this.m_currentMenuItem];
        }
        nArray = (int[])this.m_currentMenu.peek();
        this.m_currentMenuItem = Math.max(0, this.m_currentMenuItem);
        this.m_currentMenuItem = Math.min(this.m_currentMenuItem, nArray.length - 1);
        if (n2 != this.m_currentMenuItem) {
            this.Menu_OnScrolling(nArray[this.m_currentMenuItem]);
        }
    }

    protected void Menu_OnScrolling(int n) {
        if (MENU_Settings == this.m_currentMenuOriginal.peek()) {
            block0 : switch (n) {
                case 40: {
                    this.setSoftButtons(3, 10);
                    break;
                }
                default: {
                    for (int i = 0; i < CUSTOMS_MENU.length; ++i) {
                        if (MENU_Settings != CUSTOMS_MENU[i]) continue;
                        this.setSoftButtons(CUSTOMS_MENU_INFO[i][1], CUSTOMS_MENU_INFO[i][2]);
                        break block0;
                    }
                }
            }
        }
    }

    protected void Menu_UpdateItems() {
        int n = 0;
        int n2 = 0;
        if (!g5.getSound()) {
            n = 21;
            n2 = 22;
        }
        if (g5.getSound()) {
            n = 22;
            n2 = 21;
        }
        this.Menu_ReplaceString(n, n2);
        this.Menu_ReplaceString(n, n2, MENU_Settings);
        int n3 = 0;
        int n4 = 0;
        if (!g5.GetHints()) {
            n3 = 23;
            n4 = 24;
        }
        if (g5.GetHints()) {
            n3 = 24;
            n4 = 23;
        }
        this.Menu_ReplaceString(n3, n4);
        this.Menu_ReplaceString(n3, n4, MENU_Settings);
        int n5 = 0;
        int n6 = 0;
        if (!g5.GetBlood()) {
            n5 = 25;
            n6 = 26;
        }
        if (g5.GetBlood()) {
            n5 = 26;
            n6 = 25;
        }
        this.Menu_ReplaceString(n5, n6);
        this.Menu_ReplaceString(n5, n6, MENU_Settings);
    }

    protected boolean Menu_IsItemEnabled(int n) {
        switch (n) {
            case 30: {
                return this.m_gamePlotProgress > 0 && this.m_gamePlotProgress < m_gameplot.length;
            }
            case 35: {
                return this.history_ChapterMaxCount > 0;
            }
            case 33: {
                return this.m_Progress[6] > 0;
            }
            case 40: {
                return this.m_gamePlotProgress > 0 && this.m_gamePlotProgress < m_gameplot.length && !this.m_pauseIsActive;
            }
            case 25: 
            case 26: {
                return g5.IsBloodSelectEnabled();
            }
        }
        return true;
    }

    protected boolean Menu_IsItemExists(int n) {
        int[] nArray = (int[])this.m_currentMenu.peek();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    protected void Menu_OnItemActivated(int n) {
        switch (n) {
            case 29: {
                this.Menu_Push(MENU_PlayGame);
                break;
            }
            case 30: {
                this.m_chapterChosen = (byte)-1;
                this.GamePlot_Process(false);
                break;
            }
            case 33: {
                this.m_currentDifficulty = this.m_gamePlotDifficulty;
                this.Dialogs_Close();
                this.GamePlot_Process(true);
                break;
            }
            case 31: {
                this.m_chapterChosen = (byte)-1;
                this.Menu_Push(MENU_Difficulty);
                break;
            }
            case 35: {
                this.requestScene(21, null);
                break;
            }
            case 43: 
            case 44: {
                this.m_currentDifficulty = (byte)this.m_currentMenuItem;
                if (this.m_chapterChosen != -1) {
                    this.GamePlot_Process(false);
                    break;
                }
                if (this.m_gamePlotProgress > 0 && this.m_gamePlotProgress < m_gameplot.length) {
                    this.requestScene(18, new int[]{48, 50, 31});
                    break;
                }
                this.requestScene(19, new int[]{31});
                break;
            }
            case 16: {
                if (this.m_pauseIsActive) {
                    this.Menu_Push(MENU_PauseExit);
                    break;
                }
                this.requestScene(18, new int[]{48, 49, n});
                break;
            }
            case 38: {
                this.requestScene(22, new int[]{1});
                break;
            }
            case 19: {
                this.Menu_Push(MENU_PauseExitToMenu);
                break;
            }
            case 37: {
                if (this.m_pauseIsActive) {
                    this.Pause_Toggle();
                } else {
                    this.Dialogs_Close();
                }
                this.requestScene(17, null);
                break;
            }
            case 17: {
                g5.Input_ClearKeys();
                this.Pause_Toggle();
                break;
            }
            case 32: {
                this.Menu_Push(MENU_PauseRestartLevel);
                break;
            }
            case 39: {
                if (this.m_pauseIsActive) {
                    this.Pause_Toggle();
                    this.popSoftButtons();
                } else {
                    this.Dialogs_Close();
                }
                this.GamePlot_Process(false);
                break;
            }
            case 18: {
                this.Menu_Push(MENU_Settings);
                this.Menu_UpdateItems();
                break;
            }
            case 21: 
            case 22: {
                g5.switchSound();
                this.Menu_UpdateItems();
                if (!g5.getSound()) break;
                if (!this.m_pauseIsActive) {
                    g5.Sound_Play(0);
                    break;
                }
                g5.Sound_Play(1);
                break;
            }
            case 23: 
            case 24: {
                g5.SwitchHints();
                this.Menu_UpdateItems();
                break;
            }
            case 25: 
            case 26: {
                g5.SwitchBlood();
                this.Menu_UpdateItems();
                break;
            }
            case 20: {
                if (this.m_currentMenuOriginal.peek() == MENU_Difficulty && this.m_chapterChosen != -1) {
                    this.requestScene(21, null);
                    break;
                }
                if (this.m_currentMenu.size() == 1) {
                    this.requestScene(17, null);
                    break;
                }
                this.Menu_Pop();
                break;
            }
            case 27: {
                if (this.m_pauseIsActive) {
                    this.m_pauseShowHelp = true;
                    this.MenuText_InitCustom(27, 45);
                    break;
                }
                this.requestScene(18, new int[]{27, 45});
                break;
            }
            case 28: {
                this.requestScene(18, new int[]{28, 46, -1, 17, 0});
                break;
            }
            case 34: {
                this.requestScene(20, new int[]{0});
                break;
            }
            case 40: {
                this.requestScene(19, new int[]{40});
                break;
            }
            case 41: {
                this.Dialogs_Create(3, null);
                break;
            }
            case 200: {
                this.requestScene(18, new int[]{200, 204, 203});
                break;
            }
            case 201: {
                this.requestScene(18, new int[]{205, 206, 15});
                break;
            }
            case 202: {
                if (RedFaction.TelstraMode) {
                    this.Show_TelstraGMG();
                } else {
                    this.connectWap(RedFaction.GameLinkURL[RedFaction.languageSelectID]);
                }
                this.m_currentMenuItem = 0;
            }
        }
    }

    protected void Menu_OnGameStart(byte by) {
        g5.Sound_Stop(true);
        this.GamePlot_Reset();
        this.HeroParams_Reset();
        this.m_gamePlotDifficulty = this.m_currentDifficulty;
        this.GamePlot_Process(false);
    }

    protected void Menu_ReplaceString(int n, int n2) {
        for (int i = 0; i < this.m_currentMenu.size(); ++i) {
            this.Menu_ReplaceString(n, n2, (int[])this.m_currentMenu.elementAt(i));
        }
    }

    protected void Menu_ReplaceString(int n, int n2, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            nArray[i] = n2;
        }
    }

    protected int Menu_CreateEnabled(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.Menu_IsItemEnabled(nArray[i])) continue;
            if (nArray2 != null) {
                nArray2[n] = nArray[i];
            }
            ++n;
        }
        return n;
    }

    protected void Menu_Reset(int[] nArray) {
        this.m_currentMenu.removeAllElements();
        this.m_currentMenuOriginal.removeAllElements();
        this.m_currentMenuItem = 0;
        this.m_currentMenuTopItem = 0;
        this.Menu_Push(nArray);
        this.m_menuText = null;
    }

    protected void Menu_Push(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.Menu_CreateEnabled(nArray, null)];
        this.Menu_CreateEnabled(nArray, nArray2);
        this.m_currentMenu.push(nArray2);
        this.m_currentMenuOriginal.push(nArray);
        this.m_currentMenuTopItem = 0;
        this.m_currentMenuItem = 0;
        for (n = 0; n < CUSTOMS_MENU.length; ++n) {
            if (nArray != CUSTOMS_MENU[n]) continue;
            this.m_currentMenuItem = CUSTOMS_MENU_INFO[n][0];
            if (CUSTOMS_MENU_INFO[n][1] == -1 && CUSTOMS_MENU_INFO[n][2] == -1) break;
            this.pushSoftButtons(CUSTOMS_MENU_INFO[n][1], CUSTOMS_MENU_INFO[n][2]);
            break;
        }
        n = -1;
        if (MENU_PauseRestartLevel == nArray) {
            n = 51;
        } else if (MENU_PauseExitToMenu == nArray) {
            n = 52;
        } else if (MENU_PauseExit == nArray) {
            n = 49;
        }
        if (n != -1) {
            this.m_menuText = g5.Font_SplitString(this.getString(n), 2, 210);
        }
    }

    protected void Menu_Pop() {
        int[] nArray = (int[])this.m_currentMenuOriginal.peek();
        this.m_currentMenu.pop();
        this.m_currentMenuOriginal.pop();
        this.m_currentMenuTopItem = 0;
        for (int i = 0; i < CUSTOMS_MENU.length; ++i) {
            if (nArray != CUSTOMS_MENU[i]) continue;
            if (CUSTOMS_MENU_INFO[i][1] == -1 && CUSTOMS_MENU_INFO[i][2] == -1) break;
            this.popSoftButtons();
            break;
        }
        this.m_currentMenuItem = 0;
        this.m_menuText = null;
    }

    protected void Menu_GoToMenu(int[] nArray) {
        this.setScene(17, null);
        this.Menu_Push(nArray);
    }

    public void HUD_Render(Graphics graphics) {
        if (this.CutScene_IsEnabled()) {
            return;
        }
        switch (this.m_HudMode) {
            case 1: {
                g5.Tile_Render(graphics, 221, 0, 0);
                g5.Tile_Render(graphics, 222, 240, 0);
                if (null == this.m_player) break;
                int n = 28 * this.m_player.m_life / this.m_player.m_stats.getLife();
                graphics.setColor(1325063);
                graphics.fillRect(30 + n, 5, 28 - n, 7);
                int n2 = 24 * CGameObject.m_Armour / CGameObject.getMaxArmor();
                graphics.setColor(1325063);
                graphics.fillRect(34 + n2, 15, 24 - n2, 7);
                g5.Tile_Render(graphics, 233 + this.m_player.WeaponControl_GetCurrent(), 240, 0);
                if (this.m_player.m_stats.m_Weapons[this.m_player.WeaponControl_GetCurrent()][13] <= 0) break;
                g5.Font_RenderString(graphics, Integer.toString(this.m_player.WeaponControl_GetAmmo()), 0, 198, 12, 3, 1993984);
                g5.Font_RenderString(graphics, Integer.toString(this.m_player.WeaponControl_GetAmmoInClip()), 0, 225, 12, 3, 16510218);
            }
        }
    }

    protected void HUD_RenderProgressBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n3 > n4) {
            graphics.setColor(n6);
            graphics.fillRect(n, n2, n5, n4);
            graphics.setColor(n7);
            graphics.fillRect(n + n5, n2, n3 - n5, n4);
        } else {
            graphics.setColor(n6);
            graphics.fillRect(n, n2, n3, n5);
            graphics.setColor(n7);
            graphics.fillRect(n, n2 + n5, n3, n4 - n5);
        }
    }

    public void HUD_RenderFillBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        int n11 = graphics.getClipWidth();
        int n12 = graphics.getClipHeight();
        if (n7 >= 0) {
            g5.Tile_Render(graphics, n7, n, n2);
        }
        graphics.clipRect(n3, n4, n5, n6);
        g5.Tile_Render(graphics, n8, n, n2);
        graphics.setClip(n9, n10, n11, n12);
    }

    protected void Action_Init() {
        m_SceneTransform = ACTION_Transform;
        this.m_HudMode = 1;
        this.m_xscene = 0;
        this.m_yscene = 0;
        this.m_wscene = g5.m_width;
        this.m_hscene = g5.m_height;
        this.m_wview = this.m_wscene;
        this.m_hview = this.m_hscene;
        this.m_flags |= 0x1001;
        this.m_LoadedChapter = this.m_currentChapter;
        this.m_ActionShakeTime = 0;
        g5.Tile_LoadTileset(this.m_GamePlotSettingImg[this.m_LoadedChapter]);
        g5.Tile_UpdateTilesets(false, 0, 0);
        this.CreateTerrain();
        this.m_terrain.Init(this.m_sceneparams[1]);
        g5.Tile_UnloadTileset(this.m_GamePlotSettingImg[this.m_LoadedChapter]);
        this.Loading_UpdateProgress(100);
        for (int i = 0; i < m_gameplotImg[this.m_LoadedChapter].length; ++i) {
            g5.Tile_LoadTileset(m_gameplotImg[this.m_LoadedChapter][i]);
        }
        g5.Tile_UpdateTilesets(true, 100, 800);
        this.Triggers_Init();
        try {
            DataInputStream dataInputStream = g5.getResourcePart("/Levels.bin", this.m_sceneparams[2]);
            this.MapObject_LoadObjects(dataInputStream);
            while (g5.m_paused) {
                Thread.sleep(200L);
            }
            this.Loading_UpdateProgress(850);
            this.Triggers_Load(dataInputStream);
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (g5.m_paused) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        this.Loading_UpdateProgress(900);
        this.Triggers_CheckCondition((byte)1);
        while (g5.m_paused) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        this.Loading_UpdateProgress(950);
        this.Events_SendEvent(-1, 34, this.m_Progress[6], 0);
        if (this.m_Progress[6] > 0) {
            this.Action_Restore();
        }
        this.updateLook(true);
        this.updateView(0, false);
        while (g5.m_paused) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
        }
        this.Loading_UpdateProgress(1000);
        this.Action_CountSecrets();
    }

    private void Action_CountSecrets() {
        this.m_ActionSecretsTotal = 0;
        for (int i = 0; i < this.m_triggersActionOffsets.m_elements; ++i) {
            int n = this.m_triggersActionOffsets.m_data[i];
            int n2 = this.m_triggersActionData.m_data[n + 0];
            if (n2 != 11 || this.m_triggersActionData.m_data[n + 1 + 2] != 37) continue;
            this.m_ActionSecretsTotal = (byte)(this.m_ActionSecretsTotal + 1);
        }
    }

    protected void Action_Store() {
        this.Triggers_StoreState();
        g5.Math_CopyVector3D(this.m_ActionSavedPos, this.m_player.m_position);
        this.m_ActionSavedLife = this.m_player.m_life;
        this.m_ActionSavedArmour = CGameObject.m_Armour;
    }

    protected void Action_Restore() {
        this.Triggers_RestoreState();
        g5.Math_CopyVector3D(this.m_player.m_position, this.m_ActionSavedPos);
        this.m_player.m_life = this.m_ActionSavedLife;
        CGameObject.m_Armour = this.m_ActionSavedArmour;
    }

    protected void Action_Shutdown() {
        for (int i = 0; i < m_gameplotImg[this.m_LoadedChapter].length; ++i) {
            g5.Tile_UnloadTileset(m_gameplotImg[this.m_LoadedChapter][i]);
        }
        this.GameStats_Reset();
        this.MapObject_UnloadObjects();
        this.Triggers_Shutdown();
        this.m_terrain.Shutdown();
        this.m_terrain = null;
    }

    protected void Action_Update(int n) {
        Vector vector = this.GameObject_GetActiveObjects();
        int n2 = vector.size();
        block7: for (int i = 0; i < n2; ++i) {
            CGameObject cGameObject = (CGameObject)vector.elementAt(i);
            if (((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x4000) != 0 || cGameObject.Positionable_GetFastDistanceTo(this.m_player) > 2 * this.m_player.m_stats.m_size) continue;
            switch (cGameObject.m_stats.m_type) {
                case 15: {
                    if (this.m_player.ChangeHitPoints(cGameObject.m_life, false)) break;
                    continue block7;
                }
                case 16: {
                    if (this.m_player.WeaponControl_AddAmmo(1, cGameObject.m_life)) break;
                    continue block7;
                }
                case 57: {
                    if (this.m_player.WeaponControl_AddAmmo(2, cGameObject.m_life)) break;
                    continue block7;
                }
                case 58: {
                    if (this.m_player.WeaponControl_AddAmmo(3, cGameObject.m_life)) break;
                    continue block7;
                }
                case 46: {
                    if (CGameObject.getMaxArmor() == CGameObject.m_Armour) continue block7;
                    CGameScene cGameScene = this;
                    CGameObject.m_Armour = cGameScene.m_player.getMaxArmor();
                    break;
                }
                default: {
                    if (0 == (cGameObject.m_ActiveComponents & 0x100) || 1 != cGameObject.getState()) continue block7;
                    this.Triggers_OnObjectKilled(cGameObject);
                }
            }
            if (((cGameObject.m_flags | cGameObject.m_stats.m_flags) & 0x8000) != 0) {
                this.Action_PickupRespawnable(cGameObject);
                continue;
            }
            this.Events_PostEvent(0, -1, 0, cGameObject.m_iUID, 0);
        }
        if (this.m_ActionShakeTime > 0) {
            this.m_xlookShift = g5.Math_GetRandomInt(this.m_ActionShakeMax * 2) - this.m_ActionShakeMax;
            this.m_ylookShift = g5.Math_GetRandomInt(this.m_ActionShakeMax * 2) - this.m_ActionShakeMax;
            this.m_ActionShakeTime -= n;
        } else {
            this.m_xlookShift = 0;
            this.m_ylookShift = 0;
        }
        this.Triggers_Update();
    }

    protected void Action_PickupRespawnable(CGameObject cGameObject) {
        cGameObject.m_flags |= 0x4020;
        this.RespawnableObjects.removeAllElements();
        for (int i = 0; i < this.m_gameobjects.size(); ++i) {
            CGameObject cGameObject2 = (CGameObject)this.m_gameobjects.elementAt(i);
            if (cGameObject2.m_stats.m_type != cGameObject.m_stats.m_type || !cGameObject2.CheckFlags(32768)) continue;
            if (cGameObject2.CheckFlags(16384)) {
                this.RespawnableObjects.addElement(cGameObject2);
                continue;
            }
            return;
        }
        CGameObject cGameObject3 = (CGameObject)this.RespawnableObjects.elementAt(g5.Math_GetRandomInt(this.RespawnableObjects.size()));
        this.Events_PostEvent(15000, cGameObject3.m_iUID, 6, 16416, 0);
    }

    protected void Action_Render(Graphics graphics) {
        if (!g5.m_paused) {
            this.HUD_Render(graphics);
        }
    }

    protected void Action_StartShake(int n, int n2) {
        this.m_ActionShakeTime = n;
        this.m_ActionShakeMax = n2;
    }

    public void Progress_OnMissionStart(boolean bl) {
        if (bl) {
            System.arraycopy(this.m_ProgressLast, 0, this.m_Progress, 0, 7);
        } else {
            this.Progress_Reset();
        }
    }

    public void Progress_Reset() {
        for (int i = 0; i < 7; ++i) {
            this.m_Progress[i] = 0;
            this.m_ProgressLast[i] = 0;
        }
    }

    public void Progress_OnCheckpointPass(int n) {
        this.m_Progress[6] = n;
        System.arraycopy(this.m_Progress, 0, this.m_ProgressLast, 0, 7);
    }

    public int Progress_GetScore() {
        int n = 0;
        if (this.m_Progress[1] > 0) {
            n += 100;
        }
        n += this.m_Progress[2] * 1;
        n += this.m_Progress[3] * 1;
        n += this.m_Progress[4] * 1;
        return n += this.m_Progress[5] * 10;
    }

    protected void ButtonFight_RenderButton(Graphics graphics, int n, int n2, int n3, int n4) {
        g5.Tile_Render(graphics, 228, n, n2);
    }

    protected boolean ButtonFight_IsBlinking() {
        return g5.m_time / 200L % 2L != 0L;
    }

    public void Loading_Begin(String string, String string2, boolean bl) {
        this.m_LoadingInitial = bl;
        if (this.m_loadingIsActive++ == 0) {
            if (!this.m_LoadingInitial) {
                g5.Sound_Stop(false);
            }
            this.m_menuTextLineTop = 0;
            this.m_menuTextMaxLines = 217 / g5.Font_GetHeight(0);
            this.m_menuText = string2 != null ? g5.Font_SplitString(string2, 0, 210) : null;
            this.m_loadingProgress = 0;
        }
        this.m_RenderTransition = this.m_LoadingInitial ? 0 : 1;
        this.Loading_UpdateProgress(0);
    }

    public void Loading_End(boolean bl) {
        this.Loading_UpdateProgress(1000);
        if (bl) {
            g5.Input_ClearKeys();
        } else {
            this.Loading_Shutdown();
        }
    }

    public void Loading_UpdateProgress(int n) {
        if (this.m_loadingIsActive <= 0 || n < this.m_loadingProgress) {
            return;
        }
        this.m_loadingProgress = n;
        Debug.PrintMemory();
        Debug.Println("Loading_UpdateProgress: " + this.m_loadingProgress);
        this.RenderImmediate();
    }

    public void Loading_Update() {
        this.timeLast = 0L;
        boolean bl = true;
        if (null != this.m_menuText) {
            if (this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size()) {
                bl = false;
            }
            if (g5.Input_IsGameActionHit(1)) {
                this.m_menuTextLineTop = this.m_menuTextLineTop - this.m_menuTextMaxLines >= 0 ? this.m_menuTextLineTop - this.m_menuTextMaxLines : 0;
            } else if (g5.Input_IsGameActionHit(6) || g5.Input_IsGameActionHit(8) || g5.Input_IsKeyHit(-21)) {
                int n = this.m_menuTextLineTop = bl ? this.m_menuTextLineTop : this.m_menuTextLineTop + this.m_menuTextMaxLines;
            }
        }
        if (this.m_loadingProgress >= 1000) {
            this.setSoftButtons(bl ? 3 : 6, this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size() ? 4 : -1);
            if (bl && (g5.Input_IsGameActionHit(8) || g5.Input_IsKeyHit(-21)) || this.m_idCommands[1] == 4 && g5.Input_IsKeyHit(-22)) {
                super.reset();
                this.Loading_Shutdown();
                this.onSceneStarted();
            }
        }
    }

    protected void Loading_Shutdown() {
        if (--this.m_loadingIsActive == 0) {
            this.m_menuText = null;
            this.m_RenderTransition = this.m_LoadingInitial ? 0 : 1;
            this.setSoftButtons(-1, -1);
        }
    }

    protected void Loading_Render(Graphics graphics) {
        if (this.m_LoadingInitial) {
            this.Loading_RenderInitial(graphics);
            return;
        }
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(m_missionNames[this.m_currentChapter], 2, 240), 2, 120, 52, 3, 16685063);
        if (null != this.m_menuText && !this.m_menuText.isEmpty()) {
            int n = g5.Font_GetHeight(0);
            for (int i = this.m_menuTextLineTop; i < Math.min(this.m_menuText.size(), this.m_menuTextLineTop + this.m_menuTextMaxLines); ++i) {
                g5.Font_RenderString(graphics, (String)this.m_menuText.elementAt(i), 0, 15, 75 + (i - this.m_menuTextLineTop) * n, 20, 16685063);
            }
        }
        if (1000 == this.m_loadingProgress) {
            if (this.m_menuTextLineTop > 0) {
                g5.Tile_Render(graphics, 155, 120, 283);
            }
            if (this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size()) {
                g5.Tile_Render(graphics, 154, 120, 289);
            }
        } else {
            this.HUD_RenderFillBar(graphics, 119, 289, 41, 288, 156 * this.m_loadingProgress / 1000, 3, 161, 162);
        }
    }

    private void Loading_RenderInitial(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Font_RenderString(graphics, this.getString(2), 0, 120, 149, 3, 0xFFFFFF);
        int n = 149 + g5.Font_GetHeight(0);
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(60, n, 119, 6);
        graphics.fillRect(62, n + 2, 116 * this.m_loadingProgress / 1000, 3);
    }

    public void Pause_Toggle() {
        this.Pause_Toggle(MENU_Pause);
    }

    public boolean Pause_IsAvailable() {
        return 0 == (m_scene & 0x10) && this.m_loadingIsActive <= 0 && this.Dialogs_IsAllowPause();
    }

    public void Pause_Toggle(int[] nArray) {
        if (!this.Pause_IsAvailable()) {
            return;
        }
        this.m_menuText = null;
        this.m_pauseMenu = nArray;
        boolean bl = this.m_pauseIsActive = !this.m_pauseIsActive;
        if (this.m_pauseIsActive) {
            g5.Sound_Stop(false);
            this.pushSoftButtons(-1, -1);
            this.Menu_Reset(this.m_pauseMenu);
        } else {
            this.Menu_Pop();
            this.popSoftButtons();
        }
    }

    public void Pause_Update() {
        if (this.m_pauseShowHelp) {
            if (this.MenuText_IsFinished()) {
                this.MenuText_Shutdown();
                this.m_pauseShowHelp = false;
            }
            this.MenuText_UpdateScroll(0);
        } else {
            this.Menu_Update();
        }
    }

    public void Pause_Render(Graphics graphics) {
        if (!this.m_pauseIsActive) {
            return;
        }
        if (this.m_pauseShowHelp) {
            this.MenuText_Render(graphics);
            return;
        }
        this.Pause_FrameRender(graphics, 55);
        this.Pause_RenderContent(graphics);
        if (null != this.m_menuText) {
            graphics.setColor(0);
            graphics.fillRect(0, 4, 240, 135);
            g5.Font_RenderStringsVector(graphics, this.m_menuText, 2, 120, 71, 3, 16357900);
        }
    }

    public void Pause_FrameRender(Graphics graphics, int n) {
        g5.Tile_Render(graphics, 224, 120, 149);
        if (n != -1) {
            g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(this.getString(n), 2, 220), 2, 10, 212, 6, 0, 16750094);
        }
    }

    public void Pause_RenderContent(Graphics graphics) {
        int[] nArray = (int[])this.m_currentMenu.peek();
        int n = Math.min(2, nArray.length);
        this.m_currentMenuTopItem = Math.max(this.m_currentMenuTopItem, this.m_currentMenuItem - n + 1);
        this.m_currentMenuTopItem = Math.min(this.m_currentMenuTopItem, this.m_currentMenuItem);
        for (int i = 0; i < n; ++i) {
            int n2 = this.m_currentMenuTopItem + i;
            boolean bl = n2 == this.m_currentMenuItem;
            String string = this.getString(nArray[n2]);
            g5.Font_RenderString(graphics, string, 2, 12, 243 + 19 * i, 6, bl ? 16685063 : 14380042);
            if (!bl) continue;
            int n3 = g5.Font_GetStringWidth(2, string) + 4;
            int n4 = 234 + 19 * i;
            int n5 = 10 + n3 - 1;
            int n6 = n4 + 20 - 1;
            graphics.setColor(16685063);
            graphics.drawLine(10, n4, n5, n4);
            graphics.drawLine(10, n4, 10, n6);
            graphics.drawLine(10, n6, n5, n6);
            graphics.drawLine(n5, n4, n5, n6);
        }
        if (this.m_currentMenuTopItem > 0) {
            g5.Tile_Render(graphics, 155, 120, 231);
        }
        if (this.m_currentMenuTopItem + n < nArray.length) {
            g5.Tile_Render(graphics, 154, 120, 288);
        }
    }

    protected void Debrief_Create() {
        this.m_DebriefItems = DEBRIEF_ITEMS_ONFOOT;
        this.pushSoftButtons(15, 5);
        g5.Sound_Play(6);
        int n = this.Progress_GetScore();
        if (n > this.m_scoreChapters[this.m_currentChapter][0]) {
            int[] nArray = new int[]{n, this.m_Progress[2], this.m_Progress[3], this.m_Progress[4], this.m_Progress[5]};
            this.HeroParams_ConfirmMissionScore(nArray);
        }
    }

    protected void Debrief_Close() {
        this.popSoftButtons();
    }

    protected void Debrief_Update() {
        if (g5.Input_IsKeyHit(-21) || g5.Input_IsGameActionHit(8)) {
            if (RedFaction.DemoMode) {
                this.Dialogs_Close();
                this.requestScene(17, null);
                this.requestScene(18, new int[]{200, 204, 203});
            } else {
                this.GamePlot_Advance();
                this.Dialogs_Close();
            }
            g5.Input_ClearKeys();
        } else if (g5.Input_IsKeyHit(-22)) {
            this.m_DebriefAskTextID = 51;
            this.Dialogs_Create(4, null);
        }
    }

    protected void Debrief_RenderBackground(Graphics graphics) {
        g5.Tile_Render(graphics, 226, 120, 149);
        g5.Font_RenderString(graphics, this.getString(73), 2, 7, 109, 6, 0, 16750094);
    }

    protected void Debrief_Render(Graphics graphics) {
        this.Debrief_RenderBackground(graphics);
        graphics.setColor(11632385);
        graphics.fillRect(0, 255, 240, 1);
        graphics.setColor(0);
        graphics.fillRect(0, 297, 240, 5);
        for (int i = 0; i < this.m_DebriefItems.length; ++i) {
            int n = 20 * i;
            g5.Font_RenderString(graphics, this.getString(this.m_DebriefItems[i]), 1, 0, 137 + n, 6, 15701760);
            g5.Font_RenderString(graphics, this.Debrief_GetValueString(this.m_DebriefItems[i]), 1, 240, 137 + n, 10, 11632385);
        }
        g5.Font_RenderString(graphics, this.getString(87), 1, 1, 267, 6, 11632385);
        g5.Font_RenderString(graphics, this.Debrief_GetValueString(87), 1, 239, 267, 10, 11632385);
    }

    private String Debrief_GetValueString(int n) {
        switch (n) {
            case 79: {
                return this.TimeToString(this.m_Progress[0], false, true, true, false);
            }
            case 80: {
                return Integer.toString(this.m_Progress[2]);
            }
            case 81: 
            case 82: {
                return Integer.toString(this.m_Progress[3]);
            }
            case 83: {
                return Integer.toString(this.m_Progress[4]);
            }
            case 84: {
                return Integer.toString(this.m_Progress[5]) + "/" + Integer.toString(this.m_ActionSecretsTotal);
            }
            case 85: {
                return Integer.toString(this.m_player.m_stats.getLife() - this.m_player.m_life);
            }
            case 86: {
                return Integer.toString(this.Progress_GetScore());
            }
            case 87: {
                return Integer.toString(this.HeroParams_GetScoreSum(0));
            }
        }
        return "";
    }

    protected void FailScreen_Create() {
        this.Menu_Reset(MENU_GameOver);
        this.pushSoftButtons(3, -1);
    }

    protected void FailScreen_Close() {
        this.Menu_Pop();
        this.popSoftButtons();
    }

    protected void FailScreen_Update() {
        this.Menu_Update();
    }

    protected void FailScreen_Render(Graphics graphics) {
        g5.Font_RenderString(graphics, this.getString(74), 2, 7, 54, 6, 1259271, 0xFFFF00);
        graphics.setColor(0xFFFF00);
        graphics.fillRect(0, 65, 240, 72);
        graphics.setColor(1259271);
        graphics.fillRect(0, 66, 240, 70);
        graphics.setColor(0xFFFF00);
        graphics.fillRect(0, 274, 240, 25);
        graphics.setColor(1259271);
        graphics.fillRect(0, 275, 240, 24);
        int[] nArray = (int[])this.m_currentMenu.peek();
        for (int i = 0; i < nArray.length; ++i) {
            g5.Font_RenderString(graphics, this.getString(nArray[i]), 2, 0, 81 + 19 * i, 6, i == this.m_currentMenuItem ? 0xFFFF00 : 11312384);
        }
    }

    protected void MenuText_Init() {
        this.m_menuTextObjectives = this.m_sceneparams[0];
        this.m_menuTextCallback = this.m_sceneparams.length > 2 ? this.m_sceneparams[2] : -1;
        this.m_menuTextScene = this.m_sceneparams.length > 3 ? this.m_sceneparams[3] : 17;
        if (46 != this.m_sceneparams[1]) {
            this.MenuText_Init(this.getString(this.m_sceneparams[1]));
        } else {
            String string = g5.g_midlet.getAppProperty("MIDlet-Version");
            if (null == string) {
                string = "1.0";
            }
            this.MenuText_Init(g5.Font_Sprintf(this.getString(this.m_sceneparams[1]), new Object[]{string}));
        }
        if (this.m_sceneparams.length > 4 && this.m_sceneparams[4] != 0) {
            this.m_menuTextAutoscroll = true;
            this.m_menuTextScrollSpeed = 0x140000;
            this.m_menuTextScrollPos = 0;
            this.m_menuTextScrollMax = g5.Math_IntToFlt(g5.Font_GetHeight(0) * this.m_menuText.size() + 217);
        }
        this.MenuText_InitSoftKeys();
    }

    protected void MenuText_InitCustom(int n, int n2) {
        this.m_menuTextObjectives = n;
        this.m_menuTextCallback = -1;
        this.m_menuTextScene = 17;
        this.MenuText_Init(this.getString(n2));
        this.MenuText_InitSoftKeys();
        g5.Input_ClearKeys();
    }

    protected void MenuText_InitSoftKeys() {
        if (this.m_menuTextCallback == 15) {
            this.pushSoftButtons(15, 10);
        } else if (this.m_menuTextCallback == 203) {
            this.pushSoftButtons(203, 10);
        } else if (-1 != this.m_menuTextCallback) {
            this.pushSoftButtons(8, 9);
        } else {
            this.pushSoftButtons(this.m_menuText.size() > this.m_menuTextMaxLines && !this.m_menuTextAutoscroll ? 6 : -1, 10);
        }
    }

    protected void MenuText_Init(String string) {
        if (null == string) {
            this.m_menuText = null;
            return;
        }
        this.Text_Init(string, 210, 217, -1 == this.m_menuTextCallback ? 0 : 2);
        this.m_menuTextAutoscroll = false;
    }

    protected void MenuText_Shutdown() {
        this.m_menuText = null;
        this.popSoftButtons();
    }

    protected void MenuText_OnCallback(int n) {
        switch (n) {
            case 31: {
                this.requestScene(19, new int[]{31});
                break;
            }
            case 16: {
                this.requestScene(22, new int[]{1});
                break;
            }
            case 56: {
                g5.switchSound();
                this.requestScene(this.m_menuTextScene, null);
                break;
            }
            case 34: {
                this.m_scoreTableScores = new int[0];
                this.m_scoreTableNames = new String[0];
                this.requestScene(20, null);
                break;
            }
            case 15: {
                this.m_chapterChosen = (byte)-1;
                this.requestScene(this.m_menuTextScene, MENU_Difficulty);
                break;
            }
            case 203: {
                this.connectWap(RedFaction.GameLinkURL[RedFaction.languageSelectID]);
                break;
            }
            default: {
                Debug.Println("Unknown callback");
            }
        }
    }

    protected void MenuText_Update(int n) {
        if (this.MenuText_IsFinished()) {
            this.requestScene(this.m_menuTextScene, (int[])(this.m_menuTextCallback == 31 ? MENU_PlayGame : null));
            return;
        }
        if (-1 != this.m_menuTextCallback) {
            if (g5.Input_IsGameActionHit(8) || g5.Input_IsKeyHit(-21)) {
                this.MenuText_OnCallback(this.m_menuTextCallback);
            }
            return;
        }
        this.MenuText_UpdateScroll(n);
    }

    protected boolean MenuText_IsFinished() {
        return g5.Input_IsKeyHit(-22) || g5.Input_IsKeyHit(-8);
    }

    protected void MenuText_UpdateScroll(int n) {
        if (this.m_menuTextAutoscroll) {
            if (g5.Input_IsGameActionHit(1)) {
                this.m_menuTextScrollSpeed -= 655360;
            } else if (g5.Input_IsGameActionHit(6)) {
                this.m_menuTextScrollSpeed += 655360;
            }
            this.m_menuTextScrollSpeed = Math.max(0, Math.min(this.m_menuTextScrollSpeed, 0x280000));
            this.m_menuTextScrollPos += this.m_menuTextScrollSpeed * n / 1000;
            this.m_menuTextScrollPos %= this.m_menuTextScrollMax;
        } else if (g5.Input_IsGameActionHit(1)) {
            this.m_menuTextLineTop = Math.max(0, this.m_menuTextMaxLines * (this.m_menuTextLineTop / this.m_menuTextMaxLines - 1));
            if (this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size()) {
                this.setSoftButton(0, 6);
            }
        } else if (g5.Input_IsGameActionHit(6) || g5.Input_IsGameActionHit(8) || g5.Input_IsKeyHit(-21)) {
            int n2;
            int n3 = n2 = this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size() ? this.m_menuTextLineTop + this.m_menuTextMaxLines : this.m_menuTextLineTop;
            if (n2 + this.m_menuTextMaxLines >= this.m_menuText.size()) {
                this.setSoftButton(0, -1);
            }
            if (n2 != this.m_menuTextLineTop) {
                this.m_menuTextLineTop = n2;
            }
        }
    }

    protected void MenuText_Render(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(this.getString(this.m_menuTextObjectives), 2, 240), 2, 120, 45, 3, 16685063);
        if (null == this.m_menuText) {
            return;
        }
        if (this.m_menuTextAutoscroll) {
            this.MenuText_RenderAutoscrolledText(graphics);
            return;
        }
        int n = g5.Font_GetHeight(0);
        int n2 = Math.min(this.m_menuText.size(), this.m_menuTextLineTop + this.m_menuTextMaxLines);
        int n3 = 167 - n2 * n / 2;
        for (int i = this.m_menuTextLineTop; i < n2; ++i) {
            if (-1 != this.m_menuTextCallback) {
                g5.Font_RenderString(graphics, (String)this.m_menuText.elementAt(i), 2, 120, n3 + (i - this.m_menuTextLineTop) * n, 17, 16685063);
                continue;
            }
            g5.Font_RenderString(graphics, (String)this.m_menuText.elementAt(i), 0, 15, 59 + (i - this.m_menuTextLineTop) * n, 20, 16685063);
        }
        if (this.m_menuTextLineTop > 0) {
            g5.Tile_Render(graphics, 155, 120, 283);
        }
        if (this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size()) {
            g5.Tile_Render(graphics, 154, 120, 289);
        }
    }

    protected void MenuText_RenderAutoscrolledText(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.clipRect(15, 59, 210, 217);
        int n5 = g5.Font_GetHeight(0);
        int n6 = g5.Math_FltToInt(this.m_menuTextScrollPos);
        for (int i = 0; i < this.m_menuText.size(); ++i) {
            g5.Font_RenderString(graphics, (String)this.m_menuText.elementAt(i), 0, 15, 276 - n6 + n5 * i, 20, 16685063);
        }
        graphics.setClip(n, n2, n3, n4);
    }

    void Text_Init(String string, int n, int n2, int n3) {
        this.m_menuTextLineTop = 0;
        this.m_menuTextMaxLines = n2 / g5.Font_GetHeight(n3);
        this.m_menuText = g5.Font_SplitString(string, n3, n);
    }

    protected void MenuInput_Init() {
        this.m_menuInputLastChar = '\u0000';
        this.m_menuInputStringBuffer = new StringBuffer(this.m_HeroName.equals("") ? this.getString(58) : this.m_HeroName);
        this.m_menuInputString = this.m_menuInputStringBuffer.toString();
        this.m_menuInputMaxChars = 8;
        this.pushSoftButtons(this.m_HeroName == "" ? -1 : 3, this.m_HeroName == "" ? 10 : 7);
    }

    protected void MenuInput_Shutdown() {
        this.m_menuInputStringBuffer = null;
        this.popSoftButtons();
    }

    protected void MenuInput_Update() {
        if (g5.Input_IsKeyHit(-21) || g5.Input_IsGameActionHit(8) && !g5.Input_IsKeyHit(53)) {
            this.MenuInput_ConfirmLastChar();
            if (this.m_menuInputString.length() > 0) {
                this.MenuInput_ActionOK();
            }
        } else if (g5.Input_IsKeyHit(-22) || g5.Input_IsKeyHit(-8)) {
            if ('\u0000' != this.m_menuInputLastChar) {
                this.m_menuInputLastChar = '\u0000';
            } else if (this.m_menuInputStringBuffer.length() > 0) {
                this.m_menuInputStringBuffer.deleteCharAt(this.m_menuInputStringBuffer.length() - 1);
                this.m_menuInputString = this.m_menuInputStringBuffer.toString();
            } else {
                this.MenuInput_ActionBack();
            }
        }
        if ((int)(g5.getTime() - this.m_menuInputLastKeyTime) >= 1000) {
            this.MenuInput_ConfirmLastChar();
        }
        boolean bl = this.m_menuInputStringBuffer.length() == 0 && this.m_menuInputLastChar == '\u0000';
        this.setSoftButtons(bl ? -1 : 3, bl ? 10 : 7);
    }

    protected boolean MenuInput_ConfirmLastChar() {
        if (this.m_menuInputStringBuffer.length() < this.m_menuInputMaxChars && '\u0000' != this.m_menuInputLastChar) {
            this.m_menuInputStringBuffer.append(this.m_menuInputLastChar);
            this.m_menuInputString = this.m_menuInputStringBuffer.toString();
            this.m_menuInputLastChar = '\u0000';
            return true;
        }
        return false;
    }

    protected void MenuInput_OnKeyPressed(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                int n2 = n - 48;
                String string = this.getString(59 + n2);
                if (n == this.m_menuInputLastKey && '\u0000' != this.m_menuInputLastChar && 1 < string.length()) {
                    int n3 = string.indexOf(this.m_menuInputLastChar);
                    int n4 = -1 == n3 ? 0 : (n3 + 1) % string.length();
                    this.m_menuInputLastChar = string.charAt(n4);
                } else {
                    this.MenuInput_ConfirmLastChar();
                    if (this.m_menuInputStringBuffer.length() < this.m_menuInputMaxChars) {
                        this.m_menuInputLastChar = string.charAt(0);
                    }
                }
                this.m_menuInputLastKey = n;
                this.m_menuInputLastKeyTime = g5.getTime();
                break;
            }
        }
    }

    protected void MenuInput_Render(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(this.getString(57), 2, 226), 2, 120, 88, 33, 16685063);
        graphics.setColor(0);
        graphics.fillRect(16, 95, 206, 21);
        graphics.setColor(16685063);
        graphics.drawRect(16, 95, 205, 20);
        g5.Font_RenderString(graphics, this.m_menuInputString, 2, 31, 105, 6, 14380042);
        if ('\u0000' != this.m_menuInputLastChar) {
            g5.Font_RenderString(graphics, String.valueOf(this.m_menuInputLastChar), 2, 31 + g5.Font_GetStringWidth(2, this.m_menuInputString), 105, 6, 16685063);
        } else if (this.m_menuInputStringBuffer.length() < this.m_menuInputMaxChars && this.ButtonFight_IsBlinking()) {
            g5.Font_RenderString(graphics, "_", 2, 31 + g5.Font_GetStringWidth(2, this.m_menuInputString), 105, 6, 16685063);
        }
    }

    private void MenuInput_ActionOK() {
        this.m_HeroName = this.m_menuInputString;
        switch (this.m_sceneparams[0]) {
            case 31: {
                this.Menu_OnGameStart((byte)0);
                break;
            }
            case 40: {
                this.requestScene(17, MENU_Settings);
            }
        }
    }

    private void MenuInput_ActionBack() {
        switch (this.m_sceneparams[0]) {
            case 31: {
                this.requestScene(17, MENU_PlayGame);
                break;
            }
            case 40: {
                this.requestScene(17, MENU_Settings);
            }
        }
    }

    protected void MenuScores_Init() {
        this.m_currentMenuItem = 0;
        boolean bl = false;
        if (null != this.m_sceneparams) {
            boolean bl2 = bl = this.m_sceneparams[0] != 0;
        }
        if (bl) {
            this.HeroParams_UpdateScoreTable(this.m_HeroName, this.HeroParams_GetScoreSum(0));
        }
        this.pushSoftButtons(this.m_scoreTableNames.length > 0 ? 13 : -1, bl ? 11 : 10);
    }

    protected void MenuScores_Shutdowm() {
        this.m_currentMenuItem = 0;
        this.m_currentMenuTopItem = 0;
        this.popSoftButtons();
    }

    protected void MenuScores_Update() {
        if (g5.Input_IsKeyHit(-22) || g5.Input_IsKeyHit(-8)) {
            this.requestScene(17, null);
        } else if (g5.Input_IsKeyHit(-21) && this.m_scoreTableNames.length > 0) {
            this.requestScene(18, new int[]{48, 53, 34, 20});
        }
    }

    protected void MenuScores_Render(Graphics graphics) {
        int n;
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(this.getString(69), 2, 240), 2, 120, 48, 17, 16685063);
        for (n = 0; n < this.m_scoreTableNames.length; ++n) {
            g5.Font_RenderString(graphics, "" + (n + 1) + ". " + this.m_scoreTableNames[n], 2, 10, 78 + 19 * n, 20, 16685063);
        }
        for (n = 0; n < this.m_scoreTableScores.length; ++n) {
            g5.Font_RenderString(graphics, "" + this.m_scoreTableScores[n], 2, 194, 78 + 19 * n, 20, 16685063);
        }
    }

    protected void EndScreen_Init() {
        this.pushSoftButtons(3, -1);
    }

    protected void EndScreen_Shutdown() {
        this.popSoftButtons();
        g5.Input_ClearKeys();
    }

    protected void EndScreen_Update() {
        if (g5.Input_IsKeyHit(-21) || g5.Input_IsGameActionHit(8)) {
            this.requestScene(20, new int[]{1});
        }
    }

    protected void EndScreen_Render(Graphics graphics) {
        g5.Tile_Render(graphics, 240, 120, 149);
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(this.getString(135), 2, 240), 2, 120, 53, 3, 16685063);
        graphics.setColor(16356615);
        graphics.fillRect(0, 77, 240, 1);
        graphics.setColor(16356615);
        graphics.fillRect(0, 250, 240, 1);
        for (int i = 0; i < ENDSCREEN_ITEMS.length; ++i) {
            int n = 27 * i;
            g5.Font_RenderString(graphics, this.getString(ENDSCREEN_ITEMS[i]), 1, 0, 90 + n, 6, 16685063);
            g5.Font_RenderString(graphics, this.EndScreen_GetValueString(ENDSCREEN_ITEMS[i]), 1, 240, 90 + n, 10, 16685063);
        }
        g5.Font_RenderString(graphics, this.getString(87), 2, 1, 261, 6, 16685063);
        g5.Font_RenderString(graphics, this.EndScreen_GetValueString(87), 2, 239, 261, 10, 16685063);
    }

    private String EndScreen_GetValueString(int n) {
        int n2 = -1;
        switch (n) {
            case 80: {
                n2 = 1;
                break;
            }
            case 81: {
                n2 = 2;
                break;
            }
            case 83: {
                n2 = 3;
                break;
            }
            case 84: {
                n2 = 4;
                break;
            }
            case 87: {
                n2 = 0;
            }
        }
        return Integer.toString(this.HeroParams_GetScoreSum(n2));
    }

    protected void MenuChapter_Init() {
        this.m_chapterChosen = (byte)-1;
        this.pushSoftButtons(5, 10);
        this.m_currentMenuItem = 0;
        this.m_currentMenuTopItem = 0;
        this.m_ChapterCount = this.history_ChapterMaxCount;
    }

    protected void MenuChapter_Shutdown() {
        this.m_currentMenuItem = 0;
        this.m_currentMenuTopItem = 0;
        this.popSoftButtons();
    }

    protected void MenuChapter_Update() {
        if (g5.Input_IsKeyHit(-22) || g5.Input_IsKeyHit(-8)) {
            this.requestScene(17, MENU_PlayGame);
        }
        if (g5.Input_IsGameActionHit(1)) {
            --this.m_currentMenuItem;
        } else if (g5.Input_IsGameActionHit(6)) {
            ++this.m_currentMenuItem;
        } else if ((g5.Input_IsGameActionHit(8) || g5.Input_IsKeyHit(-21)) && this.m_currentMenuItem >= 0 && this.m_currentMenuItem < this.m_ChapterCount) {
            this.popSoftButtons();
            this.m_chapterChosen = (byte)this.m_currentMenuItem;
            this.Menu_GoToMenu(MENU_Difficulty);
        }
        if (this.m_currentMenuItem < 0) {
            this.m_currentMenuItem = 0;
        } else if (this.m_currentMenuItem > this.m_ChapterCount - 1) {
            this.m_currentMenuItem = this.m_ChapterCount - 1;
        }
    }

    public void MenuChapter_Render(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        g5.Font_RenderString(graphics, this.getString(35), 2, 120, 45, 17, 16685063);
        this.m_currentMenuTopItem = Math.max(Math.min(this.m_currentMenuItem, this.m_currentMenuTopItem), this.m_currentMenuItem - 3 + 1);
        for (int i = 0; i < Math.min(3, this.m_ChapterCount); ++i) {
            int n = this.m_currentMenuTopItem + i;
            if (n == this.m_currentMenuItem) {
                g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(m_missionNames[n], 2, 240), 2, 120, 97 + 50 * i, 3, 16685063);
                continue;
            }
            g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(m_missionNames[n], 2, 240), 2, 120, 97 + 50 * i, 3, 14380042);
        }
        if (this.m_currentMenuTopItem > 0) {
            g5.Tile_Render(graphics, 155, 120, 283);
        }
        if (this.m_currentMenuTopItem + 3 < this.m_ChapterCount) {
            g5.Tile_Render(graphics, 154, 120, 289);
        }
    }

    protected void Splashes_Init() {
        g5.Sound_Stop(false);
        this.m_SplashesKind = this.m_sceneparams[0];
        this.m_SplashesIndex = 0;
        this.m_SplashesTime = 0;
        switch (this.m_SplashesKind) {
            case 0: {
                g5.Tile_LoadTileset(0);
                g5.Tile_LoadTileset(7);
                g5.Tile_UpdateTilesets(false, 0, 0);
                this.m_Splashes = SPLASHES_INITIAL;
                break;
            }
            case 1: {
                g5.Tile_LoadTileset(0);
                g5.Tile_UpdateTilesets(false, 0, 0);
                this.m_Splashes = SPLASHES_FINAL;
            }
        }
    }

    protected void Splashes_Shutdown() {
        switch (this.m_SplashesKind) {
            case 0: {
                g5.Tile_UnloadTileset(0);
                g5.Tile_UnloadTileset(7);
                break;
            }
            case 1: {
                g5.Tile_UnloadTileset(0);
            }
        }
    }

    protected void Splashes_Update(int n) {
        this.m_SplashesTime += n;
        if (g5.Input_IsGameActionHit(8)) {
            this.m_SplashesTime = this.m_Splashes[this.m_SplashesIndex][0];
        }
        if (this.m_SplashesTime >= this.m_Splashes[this.m_SplashesIndex][0]) {
            ++this.m_SplashesIndex;
            this.m_SplashesTime = 0;
            if (this.m_SplashesIndex == this.m_Splashes.length) {
                switch (this.m_SplashesKind) {
                    case 0: {
                        this.requestScene(17, null);
                        break;
                    }
                    case 1: {
                        g5.terminate();
                    }
                }
            }
        }
    }

    protected void Splashes_Render(Graphics graphics) {
        if (this.m_SplashesIndex >= this.m_Splashes.length) {
            return;
        }
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        int n5 = n + n3 / 2;
        int n6 = n2 + n4 / 2;
        graphics.setColor(this.m_Splashes[this.m_SplashesIndex][1]);
        graphics.fillRect(n, n2, n3, n4);
        g5.Tile_Render(graphics, this.m_Splashes[this.m_SplashesIndex][2], n5, n6);
        g5.Font_RenderStringsVector(graphics, g5.Font_SplitString(this.getString(this.m_Splashes[this.m_SplashesIndex][3]), 0, n3), 0, n5, n2 + n4, 33, this.m_Splashes[this.m_SplashesIndex][4]);
    }

    protected void Title_Init() {
        this.pushSoftButtons(8, 9);
    }

    protected void Title_Shutdown() {
        this.popSoftButtons();
    }

    protected void Title_Update(int n) {
        if (g5.Input_IsKeyHit(-21) || g5.Input_IsKeyHit(-22)) {
            g5.setSound(g5.Input_IsKeyHit(-21));
            this.requestScene(22, new int[]{0});
        }
    }

    protected void Title_Render(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 240, 299);
        g5.Tile_Render(graphics, 240, 120, 149);
        Vector vector = g5.Font_SplitString(this.getString(56), 2, 220);
        g5.Font_RenderStringsVector(graphics, vector, 2, 120, 157, 3, 16685063);
    }

    void Objectives_Create() {
        this.m_menuTextCallback = -1;
        this.Text_Init(m_missionDescs[this.m_LoadedChapter], 220, 101, 1);
        this.MenuText_InitSoftKeys();
    }

    void Objectives_Close() {
        this.m_menuText = null;
        this.popSoftButtons();
    }

    void Objectives_Update(int n) {
        this.MenuText_UpdateScroll(n);
        if (g5.Input_IsKeyHit(-22)) {
            this.Dialogs_Close();
            g5.Input_ClearKeys();
        }
    }

    void Objectives_Render(Graphics graphics) {
        g5.Tile_Render(graphics, 227, 120, 187);
        g5.Font_RenderString(graphics, this.getString(41), 2, 0, 160, 6, 0, 16750094);
        int n = g5.Font_GetHeight(1);
        int n2 = Math.min(this.m_menuText.size(), this.m_menuTextLineTop + this.m_menuTextMaxLines);
        int n3 = 228 - n2 * n / 2;
        for (int i = this.m_menuTextLineTop; i < n2; ++i) {
            g5.Font_RenderString(graphics, (String)this.m_menuText.elementAt(i), 1, 10, 178 + (i - this.m_menuTextLineTop) * n, 20, 16750094);
        }
        if (this.m_menuTextLineTop > 0) {
            g5.Tile_Render(graphics, 155, 120, 283);
        }
        if (this.m_menuTextLineTop + this.m_menuTextMaxLines < this.m_menuText.size()) {
            g5.Tile_Render(graphics, 154, 120, 289);
        }
    }

    void DebriefAsk_Create() {
        this.m_DebriefAsk = g5.Font_SplitString(this.getString(this.m_DebriefAskTextID), 2, 207);
        this.pushSoftButtons(8, 9);
    }

    void DebriefAsk_Close() {
        this.m_DebriefAsk = null;
        this.popSoftButtons();
    }

    void DebriefAsk_Update() {
        if (g5.Input_IsKeyHit(-21)) {
            g5.Input_ClearKeys();
            this.GamePlot_Process(false);
            this.Dialogs_Close();
            this.Dialogs_Close();
        } else if (g5.Input_IsKeyHit(-22)) {
            g5.Input_ClearKeys();
            this.Dialogs_Close();
        }
    }

    void DebriefAsk_Render(Graphics graphics) {
        this.Debrief_RenderBackground(graphics);
        g5.Font_RenderStringsVector(graphics, this.m_DebriefAsk, 2, 119, 199, 3, 16291075);
    }

    public void preRenderTick(int n) {
        g5.Sound_Update(n);
        if (0 == this.m_loadingIsActive) {
            this.Dialogs_Update(n);
        }
        if (!this.m_pauseIsActive && 0 == this.m_loadingIsActive && !this.Dialogs_IsModal() && 0 == (0x10 & m_scene)) {
            this.CutScene_Update(n);
            this.updateObjects(n);
        }
        if (!this.m_pauseIsActive && this.m_loadingIsActive == 0 && (0x20 & m_scene) != 0 && g5.Input_IsKeyHit(-21) && this.m_idCommands[0] == 12) {
            g5.Input_ClearKeys();
            this.Pause_Toggle();
        }
        if (this.m_pauseIsActive) {
            this.Pause_Update();
        } else if (!this.Dialogs_IsModal() && (this.m_flags & 0x80000) == 0) {
            if (0 == this.m_loadingIsActive) {
                this.Bullets_Update(n);
                CGameScene.Effects_Update(n);
                this.Events_Update(n);
            }
            this.UpdateScene(n);
        }
        this.Messages_Update(n);
        if (!this.m_pauseIsActive) {
            this.updateLook(false);
            this.updateView(n, true);
            if (Math.abs(this.m_xview - this.m_xviewLast) > 60 || Math.abs(this.m_yview - this.m_yviewLast) > 60) {
                this.m_gameobjects_active.removeAllElements();
                int n2 = this.m_xview + g5.m_width / 2;
                int n3 = this.m_yview + g5.m_height / 2;
                int n4 = 0;
                int n5 = this.m_gameobjects.size();
                for (int i = 0; i < n5; ++i) {
                    CGameObject cGameObject = (CGameObject)this.m_gameobjects.elementAt(i);
                    if (0 != (cGameObject.m_stats.m_flags_ex & 0x40)) {
                        this.m_gameobjects_active.addElement(cGameObject);
                        continue;
                    }
                    cGameObject.Positionable_GetPosition(m_coords1, 1);
                    int n6 = Math.abs(m_coords1[0] - n2) - g5.m_width / 2;
                    int n7 = Math.abs(m_coords1[1] - n3) - g5.m_height / 2;
                    if (n6 > 80 || n7 > 80) {
                        cGameObject.m_flags |= 0x40;
                    } else {
                        cGameObject.m_flags &= 0xFFFFFFBF;
                        this.m_gameobjects_active.addElement(cGameObject);
                    }
                    if (!cGameObject.CheckFlags(64)) continue;
                    ++n4;
                }
                this.Triggers_Optimize(n2, n3);
                this.m_xviewLast = this.m_xview;
                this.m_yviewLast = this.m_yview;
            }
        }
    }

    protected void postRenderTick(int n) {
        if (-1 != this.m_currentMenuEvent) {
            this.Menu_OnItemActivated(this.m_currentMenuEvent);
            this.m_currentMenuEvent = -1;
        }
        if (this.Dialogs_IsAllowPause() && this.isScenePending()) {
            this.setScene(this.m_scenenext, this.m_sceneparamsnext);
        }
    }

    protected void updateObjects(int n) {
        if ((this.m_flags & 0x20000) != 0) {
            return;
        }
        Vector vector = this.GameObject_GetActiveObjects();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            ((CGameObject)vector.elementAt(i)).Update(n);
        }
    }

    protected void updateLook(boolean bl) {
        if (!bl && (this.m_flags & 0x10000) != 0) {
            return;
        }
        int n = this.m_xlook - this.m_xlookShift;
        int n2 = this.m_ylook - this.m_ylookShift;
        int n3 = 0;
        CGameScene.m_coords1[0] = 0;
        CGameScene.m_coords1[1] = 0;
        Vector vector = this.m_gameobjects_active;
        int n4 = vector.size();
        for (int i = 0; i < n4; ++i) {
            CGameObject cGameObject = (CGameObject)vector.elementAt(i);
            byte by = cGameObject.m_camera;
            if (by == 0) continue;
            cGameObject.Positionable_GetPosition(m_coords2, 2);
            m_coords1[0] = m_coords1[0] + by * m_coords2[0];
            m_coords1[1] = m_coords1[1] + by * m_coords2[1];
            n3 += by;
        }
        if (n3 != 0) {
            n = m_coords1[0] / n3;
            n2 = m_coords1[1] / n3;
        }
        if ((this.m_flags & 0x1000) != 0) {
            CGameScene.m_coords1[0] = n;
            CGameScene.m_coords1[1] = n2;
            g5.Math_GetFloatingIntegral(this.m_lookSmooth, m_coords1, m_coords2, bl);
            n = m_coords2[0];
            n2 = m_coords2[1];
        }
        this.m_xlook = n += this.m_xlookShift;
        this.m_ylook = n2 += this.m_ylookShift;
    }

    public void setNewViewImmediately() {
        this.updateLook(true);
        this.updateView(0, true);
    }

    protected void updateView(int n, boolean bl) {
        int n2 = CGameScene.WorldToScreenX(this.m_xlook, this.m_ylook, 65536) - this.m_wview / 2;
        int n3 = CGameScene.WorldToScreenY(this.m_xlook, this.m_ylook, 65536) - this.m_hview / 2;
        if (n2 != this.m_xview || n3 != this.m_yview || !bl) {
            this.m_xview = n2;
            this.m_yview = n3;
        }
    }

    protected void setCameraShift(int n, int n2) {
        this.m_xlookShift = n;
        this.m_ylookShift = n2;
    }

    public boolean RenderGame(Graphics graphics) {
        if (!this.m_stringsLangSelected) {
            this.Strings_Init_Render(graphics);
            return false;
        }
        if (this.m_loadingIsActive == 0 && 0 == (this.m_flags & 0x100000)) {
            if (!this.Dialogs_IsModal() && this.isScenePending()) {
                return false;
            }
            if (!this.Dialogs_IsFullscreen()) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, 240, 299);
                this.RenderSceneBottom(graphics);
                this.TranslateToWorldSpace(graphics);
                this.RenderLayer(graphics, 0, true, false);
                this.RenderLayer(graphics, 3, true, true);
                this.RenderLayer(graphics, 4, true, false);
                this.TranslateToUISpace(graphics);
            }
            this.Dialogs_Render(graphics, 1);
        }
        if (!this.Dialogs_IsFullscreen()) {
            this.RenderScene(graphics);
        }
        this.Dialogs_Render(graphics, 4);
        this.Messages_RenderMessage(graphics);
        this.CutScene_Render(graphics);
        if (this.m_pauseIsActive && !this.Dialogs_IsPauseDlg()) {
            this.Pause_Render(graphics);
        }
        Debug.RenderStats(this, graphics, g5.m_time);
        return true;
    }

    public VectorInt RenderLayer(Graphics graphics, int n, boolean bl, boolean bl2) {
        int n2;
        VectorInt vectorInt = null;
        m_RenderLayer = bl;
        m_SortLayer = bl2;
        m_layertiles.remAllValues();
        if (n == 0 && (this.m_flags & 0x100) != 0) {
            graphics.setColor(this.m_color);
            graphics.fillRect(this.m_xview, this.m_yview, this.m_wscene, this.m_hscene);
        }
        if (this.m_terrain != null) {
            this.m_terrain.Render(graphics, (byte)n);
        }
        Vector vector = this.GameObject_GetActiveObjects();
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            ((CGameObject)vector.elementAt(n2)).Render(graphics, (byte)n);
        }
        this.Bullets_Render(graphics, (byte)n);
        CGameScene.Effects_Render(graphics, (byte)n);
        if (bl && bl2) {
            for (n2 = 0; n2 < CGameScene.m_layertiles.m_elements; n2 += 9) {
                this.RenderTileByDescription(graphics, m_layertiles, n2);
            }
        }
        return vectorInt;
    }

    static void RenderTile(Graphics graphics, int n, int n2, int n3) {
        if (m_RenderLayer && !m_SortLayer) {
            g5.Tile_Render(graphics, n, n2, n3);
        } else {
            if (-1 == RenderTileVideoDepth) {
                RenderTileVideoDepth = n3;
            }
            int n4 = CGameScene.m_layertiles.m_elements;
            if (m_SortLayer) {
                for (n4 = 0; n4 < CGameScene.m_layertiles.m_elements && CGameScene.m_layertiles.m_data[n4 + 3] <= RenderTileVideoDepth; n4 += 9) {
                }
            }
            m_layertiles.addValuePlaceholdersAt(9, n4);
            CGameScene.m_layertiles.m_data[n4++] = n;
            CGameScene.m_layertiles.m_data[n4++] = n2;
            CGameScene.m_layertiles.m_data[n4++] = n3;
            CGameScene.m_layertiles.m_data[n4++] = RenderTileVideoDepth;
            int n5 = ++n4;
            CGameScene.m_layertiles.m_data[n5] = graphics.getClipX();
            int n6 = ++n4;
            CGameScene.m_layertiles.m_data[n6] = graphics.getClipY();
            int n7 = ++n4;
            CGameScene.m_layertiles.m_data[n7] = graphics.getClipWidth();
            int n8 = ++n4;
            ++n4;
            CGameScene.m_layertiles.m_data[n8] = graphics.getClipHeight();
            RenderTileVideoDepth = -1;
        }
    }

    protected void RenderTileByDescription(Graphics graphics, VectorInt vectorInt, int n) {
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        graphics.clipRect(vectorInt.m_data[n + 5], vectorInt.m_data[n + 6], vectorInt.m_data[n + 7], vectorInt.m_data[n + 8]);
        g5.Tile_Render(graphics, vectorInt.m_data[n + 0], vectorInt.m_data[n + 1], vectorInt.m_data[n + 2]);
        graphics.setClip(n2, n3, n4, n5);
    }

    public void RenderSoftButtons(Graphics graphics, int n, int n2, int n3, int n4, String string, String string2) {
        if (null != string2) {
            g5.Font_RenderString(graphics, string2, 2, 2, 299, 36, 16291075);
        }
        if (null != string) {
            g5.Font_RenderString(graphics, string, 2, 238, 299, 40, 16291075);
        }
    }

    String TimeToString(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        String string = "";
        if (bl) {
            n2 = n / 3600000;
            if (n2 < 10) {
                string = string + "0";
            }
            string = string + n2;
            if (bl2) {
                string = string + ":";
            }
            n %= 3600000;
        }
        if (bl2) {
            n2 = n / 60000;
            if (n2 < 10) {
                string = string + "0";
            }
            string = string + n2;
            if (bl3) {
                string = string + ":";
            }
            n %= 60000;
        }
        if (bl3) {
            n2 = n / 1000;
            if (n2 < 10) {
                string = string + "0";
            }
            string = string + n2;
            if (bl4) {
                string = string + ":";
            }
            n %= 1000;
        }
        if (bl4) {
            n2 = n;
            if (n2 < 10) {
                string = string + "0";
            }
            if (n2 < 100) {
                string = string + "0";
            }
            string = string + n2;
        }
        return string;
    }

    public Object isPositionBlocked(int n, int n2, int n3, boolean bl, boolean bl2, CGameObject cGameObject, int n4, int n5) {
        if (bl2) {
            Vector vector = this.GameObject_GetActiveObjects();
            int n6 = vector.size();
            for (int i = 0; i < n6; ++i) {
                CGameObject cGameObject2 = (CGameObject)vector.elementAt(i);
                if (cGameObject2 == cGameObject || n4 != -1 && ((cGameObject2.m_flags | cGameObject2.m_stats.m_flags) & n4) == 0 || ((cGameObject2.m_flags | cGameObject2.m_stats.m_flags) & n5) != 0 || !cGameObject2.isPositionBlocked(n, n2, n3)) continue;
                return cGameObject2;
            }
        }
        if (bl && this.m_terrain != null && this.m_terrain.isPositionBlocked(n, n2, n3)) {
            return this.m_terrain;
        }
        return null;
    }

    public Object isPositionBlocked(CGameObject cGameObject, int n, int n2) {
        Vector vector = this.GameObject_GetActiveObjects();
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            CGameObject cGameObject2 = (CGameObject)vector.elementAt(i);
            if (cGameObject2 == cGameObject || n != -1 && ((cGameObject2.m_flags | cGameObject2.m_stats.m_flags) & n) == 0 || ((cGameObject2.m_flags | cGameObject2.m_stats.m_flags) & n2) != 0 || !cGameObject2.isPositionBlocked(cGameObject)) continue;
            return cGameObject2;
        }
        return null;
    }

    public Object getIsectionWithSegment(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n, int n2, int n3) {
        Vector vector = this.GameObject_GetActiveObjects();
        int n4 = vector.size();
        for (int i = 0; i < n4; ++i) {
            CGameObject cGameObject = (CGameObject)vector.elementAt(i);
            if (cGameObject.m_iUID == n || n2 != -1 && ((cGameObject.m_flags | cGameObject.m_stats.m_flags) & n2) == 0 || ((cGameObject.m_flags | cGameObject.m_stats.m_flags) & n3) != 0 || !cGameObject.isIsectsWithSegment(nArray, nArray2, nArray3, nArray4)) continue;
            return cGameObject;
        }
        if (this.m_terrain != null && this.m_terrain.isIsectsWithSegment(nArray, nArray2, nArray3, nArray4)) {
            return this.m_terrain;
        }
        return null;
    }

    public Object getIsectionWithSegment(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int n) {
        return this.getIsectionWithSegment(nArray, nArray2, nArray3, nArray4, n, -1, 2);
    }

    public boolean isPointVisible(int n, int n2) {
        return n >= this.m_xview && n < this.m_xview + this.m_wview && n2 >= this.m_yview && n2 < this.m_yview + this.m_hview;
    }

    public boolean isWorldPointVisible(int n, int n2, int n3) {
        return this.isPointVisible(CGameScene.WorldToScreenX(n, n2, n3), CGameScene.WorldToScreenY(n, n2, n3));
    }

    public boolean isWorldPointVisible(int[] nArray) {
        return this.isPointVisible(CGameScene.WorldToScreenX(nArray), CGameScene.WorldToScreenY(nArray));
    }

    public boolean isObjectVisible(CGameObject cGameObject) {
        cGameObject.Positionable_GetPosition(m_coords1, 1);
        return this.isPointVisible(m_coords1[0], m_coords1[1]);
    }

    public static int WorldToScreenX(int n, int n2, int n3) {
        return g5.Math_FltToInt(g5.Math_MulFlt(n, m_SceneTransform[0]) + g5.Math_MulFlt(n2, m_SceneTransform[2]));
    }

    public static int WorldToScreenY(int n, int n2, int n3) {
        return g5.Math_FltToInt(g5.Math_MulFlt(n, m_SceneTransform[1]) + g5.Math_MulFlt(n2, m_SceneTransform[3])) - (n3 >> 12);
    }

    public static int WorldToScreenX(int[] nArray) {
        return CGameScene.WorldToScreenX(nArray[0], nArray[1], nArray[2]);
    }

    public static int WorldToScreenY(int[] nArray) {
        return CGameScene.WorldToScreenY(nArray[0], nArray[1], nArray[2]);
    }

    public static int ScreenToWorldX(int n, int n2) {
        return g5.Math_MulFlt(g5.Math_IntToFlt(n), m_SceneTransform[4]) + g5.Math_MulFlt(g5.Math_IntToFlt(n2), m_SceneTransform[6]);
    }

    public static int ScreenToWorldY(int n, int n2) {
        return g5.Math_MulFlt(g5.Math_IntToFlt(n), m_SceneTransform[5]) + g5.Math_MulFlt(g5.Math_IntToFlt(n2), m_SceneTransform[7]);
    }

    public static void ScreenToWorld(int n, int n2, int[] nArray) {
        nArray[0] = CGameScene.ScreenToWorldX(n, n2);
        nArray[1] = CGameScene.ScreenToWorldY(n, n2);
        nArray[2] = 0;
    }

    public void TranslateToUISpace(Graphics graphics) {
        graphics.translate(this.m_xview - this.m_xscene, this.m_yview - this.m_yscene);
        graphics.setClip(0, 0, g5.m_width, g5.m_height);
    }

    public void TranslateToWorldSpace(Graphics graphics) {
        graphics.setClip(this.m_xscene, this.m_yscene, this.m_wscene, this.m_hscene);
        graphics.translate(this.m_xscene - this.m_xview, this.m_yscene - this.m_yview);
    }

    public void onKeyPressed(int n) {
        if (this.Dialogs_IsPauseDlg() || this.m_pauseShowHelp) {
            return;
        }
        if (!this.m_stringsLangSelected) {
            this.Strings_Init_keyPressed(n);
            return;
        }
        if (m_scene == 17 || this.m_pauseIsActive || this.Dialogs_GetDialogId() == 2) {
            this.Menu_OnKeyPressed(n);
        }
        if (m_scene == 19) {
            this.MenuInput_OnKeyPressed(n);
        }
        if (RedFaction.EnableCheats) {
            switch (n) {
                case 48: {
                    if ((m_scene & 0x10) != 0 || 0 != this.m_loadingIsActive) break;
                    this.onSceneFinished(true);
                    break;
                }
                case 49: {
                    if ((m_scene & 0x10) != 0 || 0 != this.m_loadingIsActive || null == this.m_player) break;
                    this.m_player.m_life = (short)10000;
                }
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        if (n2 > 270) {
            if (n < 60) {
                this.keyReleased(-6);
                return;
            }
            if (n > 180) {
                this.keyReleased(-7);
                return;
            }
        }
        if (m_scene == 41) {
            if (n2 >= this.keyPosY && n2 <= this.keyPosY + this.keyWid) {
                if (n >= this.keyPosX && n <= this.keyPosX + this.keyWid) {
                    this.keyReleased(42);
                    return;
                }
                if (n >= 240 - this.keyPosX - this.keyWid && n <= 240 - this.keyPosX) {
                    this.keyReleased(35);
                    return;
                }
            } else if (n < 60 && n2 < 60) {
                this.keyReleased(48);
                return;
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (n2 > 270) {
            if (n < 60) {
                this.keyPressed(-6);
                return;
            }
            if (n > 180) {
                this.keyPressed(-7);
                return;
            }
        }
        if (m_scene == 41) {
            if (n2 >= this.keyPosY && n2 <= this.keyPosY + this.keyWid) {
                if (n >= this.keyPosX && n <= this.keyPosX + this.keyWid) {
                    this.keyPressed(42);
                    return;
                }
                if (n >= 240 - this.keyPosX - this.keyWid && n <= 240 - this.keyPosX) {
                    this.keyPressed(35);
                    return;
                }
            } else if (n < 60 && n2 < 60) {
                this.keyPressed(48);
                return;
            }
        }
    }

    public void Game_RenderKey(Graphics graphics) {
        if (!RedFaction.isMotoA1000) {
            return;
        }
        try {
            if (this.gamekey == null) {
                this.gamekey = Image.createImage((String)"/gamekey.png");
            }
            graphics.setClip(this.keyPosX, this.keyPosY, this.keyWid, this.keyWid);
            graphics.drawImage(this.gamekey, this.keyPosX, this.keyPosY, 0);
            graphics.setClip(240 - this.keyPosX - this.keyWid, this.keyPosY, this.keyWid, this.keyWid);
            graphics.drawImage(this.gamekey, 240 - this.keyPosX - this.keyWid - this.keyWid, this.keyPosY, 0);
            graphics.setClip(0, 0, 240, 299);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        m_coords1 = new int[3];
        m_coords2 = new int[3];
        m_coords3 = new int[3];
        m_scenerect1 = new int[4];
        m_scenerect2 = new int[4];
        m_layertiles = new VectorInt();
        m_scene = 16;
        DIALOGS_DATA = new int[][]{{8, 0, 0}, {8, 0, 0}, {8, 0, 0}, {40, 0, 0}, {8, 1, 1}};
        MENU_Main = new int[]{201, 200, 29, 34, 18, 27, 28, 202, 16};
        MENU_Difficulty = new int[]{43, 44};
        MENU_PlayGame = new int[]{30, 31, 35};
        MENU_GameOver = new int[]{33, 32, 19};
        MENU_Pause = new int[]{17, 41, 32, 18, 27, 19, 16};
        MENU_PauseExitToMenu = new int[]{20, 37};
        MENU_PauseRestartLevel = new int[]{20, 39};
        MENU_PauseExit = new int[]{20, 38};
        MENU_Settings = new int[]{21, 23, 25, 40};
        CUSTOMS_MENU = new int[][]{MENU_Settings, MENU_PlayGame, MENU_PauseExit, MENU_PauseExitToMenu, MENU_Difficulty};
        CUSTOMS_MENU_INFO = new int[][]{{0, 14, 10}, {0, -1, 10}, {0, -1, -1}, {0, -1, -1}, {0, -1, 10}};
        ACTION_Transform = new int[]{0x100000, 0, 0, 0x100000, 4096, 0, 0, 4096};
        BFIGHT_TilesKeys = new short[0][];
        DEBRIEF_ITEMS_ONFOOT = new int[]{79, 80, 81, 83, 84, 86};
        ENDSCREEN_ITEMS = new int[]{80, 81, 83, 84};
        SPLASHES_INITIAL = new int[][]{{2000, 0, 338, 136, 0xFFFFFF}, {2000, 0, 334, 136, 0xFFFFFF}, {2000, 0, 341, 136, 0xFFFFFF}};
        SPLASHES_FINAL = new int[][]{{2000, 0, 337, 136, 0xFFFFFF}};
        RenderTileVideoDepth = -1;
        DEFAULT_Transform = new int[]{0x100000, 0, 0, 0x100000, 4096, 0, 0, 4096};
        m_SceneTransform = DEFAULT_Transform;
    }
}

