/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.Archer;
import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.CannonBall;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Resource;
import com.eternity.castlelords.Warlord;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Image;

public class Cannon
extends Person {
    private int CANNON_TURN_DELAY = 350;
    public static final int WIDTH = 90;
    public static final int HEIGHT = 100;
    public int number;
    public static final byte STATE_MOVING = 0;
    public static final byte STATE_AT_POSITION = 1;
    public byte state = 1;
    int targetX;
    boolean canMove = true;

    public Cannon(int x, int y, int hp, int pp, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, hp, pp, ownedByBlue, gameObjects, tracker);
        this.setTurnDelay(this.actualTurnDelay);
        this.frames = CLImageTracker.catapult;
        this.width = this.frames.getWidth();
        this.height = this.frames.getHeight();
        this.number = 1;
        this.type = 4;
        this.actualTurnDelay = this.CANNON_TURN_DELAY / this.number;
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 2, 2, 2, 2, 3, 3, 3, 3, 3};
        this.sequence = nArrayArray;
        this.setFrameSequence(this.sequence[Person.NORMAL]);
        this.defineReferencePixel(this.getWidth() / 2, 0);
        if (ownedByBlue) {
            this.level = gameObjects.blueWarlord.unitsLevel[4];
            CLGameCanvas.playerGameEvent = 19;
            this.targetX = 12 + this.frames.getWidth() / 2;
        } else {
            this.level = gameObjects.redWarlord.unitsLevel[4];
            this.targetX = 708 - this.frames.getWidth() / 2;
        }
        this.state = 0;
        this.setTurnDelay(10);
    }

    public Image getImage() {
        return null;
    }

    public void increaseNumber() {
        ++this.number;
    }

    public void doStep() {
        super.doStep();
        this.canMove = true;
        int i = 0;
        while (i < this.gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
            if (temp instanceof Resource) {
                Resource res = (Resource)temp;
                if (res.hitPoints > 0) {
                    if (this.ownedByBlue) {
                        if (this.collideWith(temp)) {
                            res.setHitPoints(0);
                            switch (res.type) {
                                case 0: {
                                    this.gameObjects.blueWarlord.addGold(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                                case 1: {
                                    this.gameObjects.blueWarlord.addStone(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("STONES")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                                case 2: {
                                    this.gameObjects.blueWarlord.addMana(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("MANA")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                                default: {
                                    this.gameObjects.blueWarlord.addGold(res.powerPoints);
                                    this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 3);
                                    break;
                                }
                            }
                        }
                    } else if (this.collideWith(temp)) {
                        res.setHitPoints(0);
                        switch (res.type) {
                            case 0: {
                                this.gameObjects.redWarlord.addGold(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 4);
                                break;
                            }
                            case 1: {
                                this.gameObjects.redWarlord.addStone(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("STONES")) + "+" + res.powerPoints, 10, 4);
                                break;
                            }
                            case 2: {
                                this.gameObjects.redWarlord.addMana(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("MANA")) + "+" + res.powerPoints, 10, 4);
                                break;
                            }
                            default: {
                                this.gameObjects.redWarlord.addGold(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, 4);
                            }
                        }
                    }
                }
            }
            if (temp instanceof Person && !(temp instanceof Archer) && this.canMove) {
                this.canMove = !this.collideWith2((Person)temp);
            }
            ++i;
        }
        switch (this.state) {
            case 0: {
                boolean reachedTraget = false;
                this.moved = this.canMove;
                if (this.canMove) {
                    if (this.isOwnedByBlue()) {
                        this.positionX += GameObjects.CATAPULT_PX_DIFF;
                        if (this.positionX >= this.targetX) {
                            this.positionX = this.targetX;
                            reachedTraget = true;
                        }
                    } else {
                        this.positionX -= GameObjects.CATAPULT_PX_DIFF;
                        if (this.positionX <= this.targetX) {
                            this.positionX = this.targetX;
                            reachedTraget = true;
                        }
                    }
                }
                if (!reachedTraget) break;
                this.state = 1;
                this.setTurnDelay(10);
                break;
            }
            case 1: {
                this.canMove = false;
                boolean canShoot = true;
                if (this.getTurnDelay() < 10) {
                    if (this.actualSequence != Person.BATTLE) {
                        this.actualSequence = Person.BATTLE;
                        this.setFrameSequence(this.sequence[Person.BATTLE]);
                    }
                    this.moved = true;
                } else {
                    this.actualSequence = Person.NORMAL;
                    this.setFrameSequence(this.sequence[Person.NORMAL]);
                    this.moved = false;
                }
                if (this.getTurnDelay() == 1) {
                    if (canShoot) {
                        if (this.isOwnedByBlue()) {
                            this.gameObjects.addLiveObject(new CannonBall(this.getPositionX() - 45 + 65, this.positionY + 5, this.powerPoints, this.isOwnedByBlue(), this.gameObjects, this.tracker, this.level));
                        } else {
                            this.gameObjects.addLiveObject(new CannonBall(this.getPositionX() + 45 - 65, this.positionY + 5, this.powerPoints, this.isOwnedByBlue(), this.gameObjects, this.tracker, this.level));
                        }
                    }
                    this.setTurnDelay(this.getTurnDelay() - 1);
                    break;
                }
                if (this.getTurnDelay() < 1) {
                    Warlord w = this.isOwnedByBlue() ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
                    this.setTurnDelay(w.shotTurnDelay[1] / XCanvas.DT);
                    System.out.println("Cannon set turndelay to: " + w.shotTurnDelay[1] + ", " + w.shotTurnDelay[1] / XCanvas.DT);
                    break;
                }
                this.setTurnDelay(this.getTurnDelay() - 1);
            }
        }
        this.setRefPixelPosition(this.positionX, this.positionY);
    }
}

