/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.IMenu;

class MenuItem {
    static final byte TYP_OPEN_MENU = 0;
    static final byte TYP_DO_ACTION = 1;
    static final byte TYP_SETTING = 2;
    static final byte TYP_STATIC_TEXT = 3;
    static final byte TYP_GO_BACK = 4;
    byte[] text;
    byte[] settings_text;
    byte type;
    static IMenu menuListener;
    int data;
    private static final byte MAX_ITEMS = 15;
    private static final byte MAX_STACK = 10;
    static MenuItem[] items;
    static int menuCode;
    static int index;
    static int count;
    private static int[] stack;
    private static int stack_index;
    static MenuItem selectedItem;
    static byte[] settings;
    static byte[][][] settingTexts;

    static {
        items = new MenuItem[15];
        index = 0;
        count = 0;
        stack = new int[10];
        stack_index = 0;
    }

    public MenuItem(byte[] text, byte type, int data) {
        this.text = text;
        this.type = type;
        this.data = data;
        if (type == 2) {
            this.settings_text = MenuItem.joinByteTexts(text, settingTexts[data][settings[data]]);
        }
    }

    public byte[] getText() {
        switch (this.type) {
            case 2: {
                return this.settings_text;
            }
        }
        return this.text;
    }

    static final byte[] joinByteTexts(byte[] text1, byte[] text2) {
        byte[] newText = new byte[text1.length + text2.length + 1];
        System.arraycopy(text1, 0, newText, 0, text1.length);
        newText[text1.length] = -1;
        System.arraycopy(text2, 0, newText, text1.length + 1, text2.length);
        return newText;
    }

    void changeSetting(boolean next) {
        byte max = (byte)(settingTexts[this.data].length - 1);
        byte pos = settings[this.data];
        pos = next ? (byte)(pos + 1) : (byte)(pos - 1);
        if (pos < 0) {
            pos = max;
        }
        if (pos > max) {
            pos = 0;
        }
        MenuItem.settings[this.data] = pos;
        this.settings_text = MenuItem.joinByteTexts(this.text, settingTexts[this.data][pos]);
        menuListener.settingChanged(this.data, pos);
    }

    public static void keyPressed(int keyCode, int ga) {
        block0 : switch (ga) {
            case 6: {
                MenuItem.next();
                break;
            }
            case 1: {
                MenuItem.prev();
                break;
            }
            case 2: {
                if (MenuItem.selectedItem.type != 2) break;
                selectedItem.changeSetting(false);
                break;
            }
            case 5: {
                if (MenuItem.selectedItem.type != 2) break;
                selectedItem.changeSetting(true);
                break;
            }
            case 8: {
                switch (MenuItem.selectedItem.type) {
                    case 0: {
                        MenuItem.openMenu(MenuItem.selectedItem.data);
                        break block0;
                    }
                    case 4: {
                        MenuItem.goBack();
                        break block0;
                    }
                    case 1: {
                        menuListener.doAction(MenuItem.selectedItem.data);
                        break block0;
                    }
                    case 2: {
                        selectedItem.changeSetting(true);
                    }
                }
            }
        }
    }

    public static void startAddingItems() {
        count = 0;
        index = 0;
        selectedItem = null;
    }

    public static void addItem(MenuItem item) {
        MenuItem.items[MenuItem.count++] = item;
        if (selectedItem == null && item.type != 3) {
            index = count - 1;
            selectedItem = items[index];
        }
    }

    public static void openMenu(int code) {
        MenuItem.push();
        menuCode = code;
        menuListener.openMenu(menuCode);
    }

    public static void push() {
        MenuItem.stack[MenuItem.stack_index++] = (menuCode << 16) + index;
    }

    public static void goBack() {
        if (stack_index > 0) {
            menuCode = stack[--stack_index];
            int old_index = menuCode & 0xFFFF;
            menuListener.openMenu(menuCode >>= 16);
            index = old_index;
            selectedItem = items[index];
        }
    }

    public static void reset() {
        stack_index = 0;
    }

    public static void next() {
        int startIndex = index;
        do {
            if (++index < count) continue;
            index = 0;
        } while (MenuItem.items[MenuItem.index].type == 3 && startIndex != index);
        selectedItem = items[index];
    }

    public static void prev() {
        int startIndex = index;
        do {
            if (--index >= 0) continue;
            index = count - 1;
        } while (MenuItem.items[MenuItem.index].type == 3 && startIndex != index);
        selectedItem = items[index];
    }
}

