/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Walker;
import javax.microedition.lcdui.Image;

public class Rider
extends Walker {
    public static final int[] RIDER_TURN_DELAY = new int[]{2, 2, 2, 2};
    public static final int[] RIDER_BATTLE_DELAY = new int[]{12, 12, 12, 12};
    public static final byte RIDER_START_HIT = 8;
    private int DIRECTION_ATTACK = 1;
    private int DIRECTION_RETURN = -1;
    public static final int[] WIDTH = new int[]{90, 118, 95, 95};
    public static final int[] HEIGHT = new int[]{95, 95, 90, 90};
    public int direction = this.DIRECTION_ATTACK;

    public Rider(int x, int y, int hp, int pp, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, hp, pp, ownedByBlue, gameObjects, tracker);
        this.setAttackOver(false);
        this.actualTurnDelay = RIDER_TURN_DELAY[this.race];
        this.actualBattleDelay = RIDER_BATTLE_DELAY[this.race];
        this.start_hit_anim_idx = (byte)8;
        this.setTurnDelay(this.actualTurnDelay);
        this.type = 3;
        if (ownedByBlue) {
            this.sequence = GameObjects.RIDER_ANIM_SEQ[gameObjects.blueWarlord.race];
            this.pixelDiff = GameObjects.RIDER_PX_DIFF[gameObjects.blueWarlord.race];
            this.frames = CLImageTracker.pkr_blue[2];
            this.width = WIDTH[gameObjects.blueWarlord.race];
            this.height = HEIGHT[gameObjects.blueWarlord.race];
            CLGameCanvas.playerGameEvent = 20;
            System.out.println("Built rider!");
        } else {
            this.sequence = GameObjects.RIDER_ANIM_SEQ[gameObjects.redWarlord.race];
            this.pixelDiff = GameObjects.RIDER_PX_DIFF[gameObjects.redWarlord.race];
            this.frames = CLImageTracker.pkr_red[2];
            this.width = WIDTH[gameObjects.redWarlord.race];
            this.height = HEIGHT[gameObjects.redWarlord.race];
        }
        this.actualSequence = Person.NORMAL;
        this.setFrameSequence(this.sequence[Person.NORMAL]);
        this.setRelatedAbilities();
        this.setRelatedBonuses();
        this.defineReferencePixel(this.getWidth() / 2, 0);
        this.level = ownedByBlue ? gameObjects.blueWarlord.unitsLevel[3] : gameObjects.redWarlord.unitsLevel[3];
    }

    public Image getImage() {
        return null;
    }

    public void setRelatedAbilities() {
        switch (this.race) {
            case 0: {
                break;
            }
            case 3: {
                this.addAbility(32768);
                this.addAbility(1024);
                break;
            }
            case 1: {
                this.addAbility(131072);
                break;
            }
        }
    }

    public void setRelatedBonuses() {
        switch (this.race) {
            case 0: {
                this.addStackBonus(32);
                break;
            }
            case 3: {
                this.addStackBonus(64);
                break;
            }
            case 1: {
                this.addStackBonus(16);
                break;
            }
            case 2: {
                this.addStackBonus(128);
            }
        }
    }
}

