/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Graphics;

class Rain {
    int[] x;
    int[] y;
    byte[] drop_size;
    short[] drop_speeds;
    int dx;
    int dy;
    int rain_width;
    int rain_x;
    byte rain_type;
    int transform = 0;
    int time;

    public Rain(byte rtype, int rx, int width, boolean playerSide, int time) {
        this.rain_type = rtype;
        CLGameCanvas.DROP_MAX_SPEED = (WarlordsCastles.imageTracker.getImageForStronghold(2).getHeight() * XCanvas.DT << 8) / 800;
        CLGameCanvas.DROP_MIN_SPEED = (WarlordsCastles.imageTracker.getImageForStronghold(2).getHeight() * XCanvas.DT << 8) / 1100;
        this.time = time;
        this.rain_width = width;
        int w = CLImageTracker.drops.getWidth(this.rain_type, 2);
        int drops_per_line = (this.rain_width << 8) / w;
        switch (this.rain_type) {
            case 0: {
                this.dx = 23;
                this.dy = 64;
                drops_per_line = (this.rain_width << 8) / ((w << 8) + (w << 9));
                break;
            }
            case 1: {
                this.dx = 41;
                this.dy = 59;
                drops_per_line = (this.rain_width << 8) / ((w << 8) + (w << 9));
                break;
            }
            case 2: {
                this.dx = 31;
                this.dy = 59;
                drops_per_line = (this.rain_width << 8) / (w << 8);
            }
        }
        int x_offset = (213 - CLGameCanvas.getMenuY()) * this.dx / this.dy;
        if (playerSide) {
            this.transform = 2;
            this.rain_x = WarlordsCastles.imageTracker.getImageForStronghold(2).getWidth() - x_offset;
        } else {
            this.transform = 0;
            this.rain_x = 528 - this.rain_width + x_offset - WarlordsCastles.imageTracker.getImageForStronghold(2).getWidth();
            this.dx = -this.dx;
        }
        int advance = this.rain_width << 8 / drops_per_line;
        int yy = CLGameCanvas.getMenuY() << 8;
        int rain_height = 54528 - yy;
        int h = CLImageTracker.drops.getHeight(this.rain_type, 2) << 9;
        int drop_lines = rain_height / h;
        this.x = new int[drop_lines * drops_per_line];
        this.y = new int[drop_lines * drops_per_line];
        this.drop_size = new byte[drop_lines * drops_per_line];
        this.drop_speeds = new short[drop_lines * drops_per_line];
        int start_x = this.rain_x << 8;
        int start_offset = this.dx * h / this.dy;
        int i = 0;
        int k = 0;
        while (i < drop_lines) {
            int j = 0;
            int xx = start_x;
            while (j < drops_per_line) {
                this.addDrop(k, xx, yy, -1);
                ++j;
                ++k;
                xx += (this.rain_width << 8) / drops_per_line;
            }
            ++i;
            yy += h;
            start_x += start_offset;
        }
    }

    void addDrop(int idx, int x, int y, int size) {
        if (size == -1) {
            size = XCanvas.next_random(3);
        }
        int w = CLImageTracker.drops.getWidth(this.rain_type, 2) << 7;
        int h = CLImageTracker.drops.getHeight(this.rain_type, 2) << 7;
        this.x[idx] = x + XCanvas.next_random(w);
        this.y[idx] = y + XCanvas.next_random(h);
        this.drop_size[idx] = (byte)size;
        switch (size) {
            case 0: {
                this.drop_speeds[idx] = (short)CLGameCanvas.DROP_MIN_SPEED;
                break;
            }
            case 1: {
                this.drop_speeds[idx] = (short)(CLGameCanvas.DROP_MIN_SPEED + (CLGameCanvas.DROP_MAX_SPEED - CLGameCanvas.DROP_MIN_SPEED >> 1));
                break;
            }
            case 2: {
                this.drop_speeds[idx] = (short)CLGameCanvas.DROP_MAX_SPEED;
            }
        }
        int n = idx;
        this.drop_speeds[n] = (short)(this.drop_speeds[n] + XCanvas.next_random(CLGameCanvas.DROP_MIN_SPEED / 5));
    }

    public void runRain() {
        this.time -= XCanvas.DT;
        if (this.time > 0) {
            int i = 0;
            while (i < this.x.length) {
                long speed = this.drop_speeds[i];
                long speed_y = XCanvas.sqrt(speed * speed * (long)this.dy * (long)this.dy / (long)(this.dy * this.dy + this.dx * this.dx));
                long speed_x = speed_y * (long)this.dx / (long)this.dy;
                int n = i;
                this.x[n] = (int)((long)this.x[n] + speed_x);
                int n2 = i;
                this.y[n2] = (int)((long)this.y[n2] + speed_y);
                if ((this.y[i] >> 8) + CLImageTracker.drops.getHeight(this.rain_type, this.drop_size[i]) >= 213) {
                    this.addDrop(i, this.rain_x + XCanvas.next_random(this.rain_width) << 8, CLGameCanvas.getMenuY() << 8, -1);
                }
                ++i;
            }
        }
    }

    public void drawRain(Graphics g) {
        CLImageTracker.drops.transform = this.transform;
        byte k = 0;
        while (k < 3) {
            int i = 0;
            while (i < this.x.length) {
                if (this.drop_size[i] == k) {
                    CLImageTracker.drops.drawSubImage(g, (this.x[i] >> 8) - CLGameCanvas.viewport, this.y[i] >> 8, this.rain_type, k);
                }
                ++i;
            }
            ++k;
        }
    }

    public boolean isOver() {
        if (this.time <= 0) {
            System.out.println("Rain is over");
        }
        return this.time <= 0;
    }
}

