/*
 * Decompiled with CFR 0.152.
 */
package com.impossible.bluetooth;

import com.impossible.bluetooth.L2CAP_GET_DATA;
import com.impossible.bluetooth.L2CAP_util;
import com.impossible.common.Communicator;
import com.impossible.common.MPGame;
import com.impossible.common.Packet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public class BTCommunicator
extends Communicator
implements Runnable,
DiscoveryListener,
L2CAP_GET_DATA {
    Thread thread;
    boolean over = false;
    boolean server;
    static final byte GST_SETUP = 0;
    static final byte GST_STARTED = 1;
    static final byte GST_OVER = 2;
    byte gameState;
    static final String UUID = "";
    private LocalDevice localDevice;
    private DiscoveryAgent discoveryAgent;
    private static final String myServiceName = "IMP_BT_MP";
    private UUID MYSERVICEUUID_UUID;
    protected Hashtable remoteDevices;
    protected Vector discoveredServices;
    ServerHandler[] clientHandlers;
    int max_connectable_devices = 1;
    Packet[] packets;
    byte runAction;
    static final byte RA_SERVER_ACCEPT_AND_WAIT = 0;
    static final byte RA_INQUIRY_DEVICES_AND_GAMES = 1;
    static final byte RA_SEND_PACKETS = 2;
    L2CAPConnectionNotifier l2n;
    String[] gameListCP;
    byte[] gameList_pJoinedCP;
    byte[] gameList_pnumCP;
    L2CAP_util util;
    Vector messageTypes = new Vector();
    private int game_idx;
    public Packet[] setups;
    private boolean sendCommunicationEnded = false;
    static final byte BCT_SEND_STATE = 0;
    static final byte BCT_SEND_PACKET = 1;
    static final byte BCT_SEND_PACKETS = 2;
    static final byte BCT_SEND_MESSAGE = 4;
    byte broadCastType;
    Packet bctPacket;
    Packet[] bctPackets;
    byte bctMessage;

    public void btInit() throws BluetoothStateException {
        this.localDevice = null;
        this.discoveryAgent = null;
        this.localDevice = LocalDevice.getLocalDevice();
        this.localDevice.setDiscoverable(0);
        String max_devices = LocalDevice.getProperty((String)"bluetooth.connected.devices.max");
        if (max_devices != null) {
            this.max_connectable_devices = Integer.parseInt(max_devices);
        }
        System.out.println("Maximum connectable devices: " + this.max_connectable_devices);
    }

    public BTCommunicator() {
        super(null);
    }

    public void init(Vector args) {
        this.game = (MPGame)args.elementAt(0);
        String uuid = (String)args.elementAt(1);
        this.MYSERVICEUUID_UUID = new UUID(uuid, false);
    }

    public BTCommunicator(MPGame game, String uuid) {
        super(game);
        this.game = game;
        this.MYSERVICEUUID_UUID = new UUID(uuid, false);
    }

    public void connect(String pname) {
        this.pname = pname;
        try {
            this.btInit();
            this.game.communicationEnded((byte)0, (byte)50);
        }
        catch (Exception e) {
            System.out.println("BT init excp. ");
            e.printStackTrace();
            this.game.communicationEnded((byte)0, (byte)102);
        }
    }

    public void createGame(int numPlayers, Packet setup) {
        try {
            this.localDevice.setDiscoverable(10390323);
        }
        catch (Exception e) {
            System.out.println("SetDiscoverable error");
            e.printStackTrace();
            this.game.communicationEnded((byte)1, (byte)102);
        }
        if (this.max_connectable_devices < numPlayers - 1) {
            this.game.communicationEnded((byte)1, (byte)13);
            return;
        }
        System.out.println("Listening as server...");
        this.gs_numPlayers = (byte)numPlayers;
        this.setup_data = setup;
        this.gs_numJoined = 1;
        this.gs_started = false;
        this.gs_Players = new String[this.gs_numPlayers];
        this.gs_Players[0] = this.pname;
        this.gs_Packets = new Packet[this.gs_numPlayers];
        this.gs_Packets[0] = setup;
        this.clientHandlers = new ServerHandler[numPlayers];
        this.server = true;
        this.gameState = 0;
        this.runAction = 0;
        Thread thread = new Thread(this);
        thread.start();
        this.game.communicationEnded((byte)1, (byte)50);
        this.game.communicationEnded((byte)8, (byte)50);
    }

    public void listGames() {
        this.discoveryAgent = this.localDevice.getDiscoveryAgent();
        this.server = false;
        this.runAction = 1;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void sendPacket(Packet p) {
        System.out.println("Sendpacket " + this.server);
        if (this.server) {
            this.bctPacket = p;
            this.broadCastType = 1;
            this.broadCastMessage(-1);
        } else {
            try {
                this.sendMessage((byte)18);
                this.util.dout.writeByte(p.getId());
                p.writeOut(this.util.dout);
                this.util.senddData();
                this.game.communicationEnded((byte)6, (byte)50);
            }
            catch (Exception e) {
                System.out.println("Exception at packet send");
                e.printStackTrace();
                this.game.communicationEnded((byte)6, (byte)102);
            }
        }
    }

    public void sendPackets(Packet[] p) {
        System.out.println("Sendpackets " + this.server);
        this.packets = p;
        Thread thread = new Thread(this);
        this.runAction = (byte)2;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        switch (this.runAction) {
            case 0: {
                String connURL = "btl2cap://localhost:" + this.MYSERVICEUUID_UUID.toString() + ";ReceiveMTU=48;TransmitMTU=48" + ";authenticate=false;encrypt=false;" + "name=" + myServiceName;
                try {
                    this.l2n = (L2CAPConnectionNotifier)Connector.open((String)connURL);
                    while (true) {
                        L2CAPConnection conn = this.l2n.acceptAndOpen();
                        ServerHandler handler = new ServerHandler(conn);
                    }
                }
                catch (Exception e) {
                    break;
                }
            }
            case 1: {
                System.out.println("Starting device search");
                try {
                    RemoteDevice[] preknownDevices;
                    int i;
                    int ln;
                    this.remoteDevices = new Hashtable(8);
                    this.remoteDevices.clear();
                    RemoteDevice[] cachedDevices = this.discoveryAgent.retrieveDevices(0);
                    if (cachedDevices != null) {
                        ln = cachedDevices.length;
                        for (i = 0; i < ln; ++i) {
                            this.remoteDevices.put(cachedDevices[i].getBluetoothAddress(), cachedDevices[i]);
                        }
                    }
                    if ((preknownDevices = this.discoveryAgent.retrieveDevices(1)) != null) {
                        ln = preknownDevices.length;
                        for (i = 0; i < ln; ++i) {
                            this.remoteDevices.put(preknownDevices[i].getBluetoothAddress(), preknownDevices[i]);
                        }
                    }
                    boolean inquiryStarted = false;
                    try {
                        inquiryStarted = this.discoveryAgent.startInquiry(10390323, (DiscoveryListener)this);
                    }
                    catch (BluetoothStateException bse) {
                        System.out.println("Inquiry Failed");
                        this.game.communicationEnded((byte)3, (byte)102);
                        return;
                    }
                    if (inquiryStarted) {
                        System.out.println("Inquiry in Progress...");
                        BTCommunicator bse = this;
                        synchronized (bse) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                    }
                    System.out.println("Inquiry Failed");
                    System.out.println("InitiateServiceSearch");
                    this.discoveredServices = new Vector();
                    ln = this.remoteDevices.size();
                    if (ln == 0) {
                        System.out.println("No devices to search...");
                    } else {
                        Enumeration devices = this.remoteDevices.elements();
                        UUID[] uuids = new UUID[]{this.MYSERVICEUUID_UUID};
                        while (devices.hasMoreElements()) {
                            RemoteDevice rd = (RemoteDevice)devices.nextElement();
                            try {
                                System.out.println("Friendly name: " + rd.getFriendlyName(true));
                                int transID = this.discoveryAgent.searchServices(null, uuids, rd, (DiscoveryListener)this);
                                System.out.println("Service Search in Progress (" + transID + ")");
                                BTCommunicator bTCommunicator = this;
                                synchronized (bTCommunicator) {
                                    this.wait();
                                }
                            }
                            catch (InterruptedException ie) {
                            }
                            catch (Exception e) {
                                System.out.println("Service Search Failed");
                                e.printStackTrace();
                                this.game.communicationEnded((byte)3, (byte)102);
                                return;
                            }
                        }
                    }
                    System.out.println("---------------------------------");
                    System.out.println("Starting connection to server devices...");
                    int num_games = this.discoveredServices.size();
                    this.gameListCP = new String[num_games];
                    this.gameList_pnumCP = new byte[num_games];
                    this.gameList_pJoinedCP = new byte[num_games];
                    this.setups = new Packet[num_games];
                    this.game_idx = 0;
                    this.sendCommunicationEnded = false;
                    for (i = 0; i < this.discoveredServices.size(); ++i) {
                        this.getGameInfo((ServiceRecord)this.discoveredServices.elementAt(i));
                        BTCommunicator bTCommunicator = this;
                        synchronized (bTCommunicator) {
                            this.wait();
                            continue;
                        }
                    }
                    this.gameList = this.gameListCP;
                    this.gameList_pJoined = this.gameList_pJoinedCP;
                    this.gameList_pnum = this.gameList_pnumCP;
                    this.sendCommunicationEnded = true;
                    this.game.communicationEnded((byte)3, (byte)50);
                }
                catch (Exception e) {
                    System.out.println("Client exception");
                    e.printStackTrace();
                    this.game.communicationEnded((byte)3, (byte)102);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.packets.length; ++i) {
                    this.sendPacket(this.packets[i]);
                }
                break;
            }
        }
    }

    protected void getGameInfo(ServiceRecord sr) {
        RemoteDevice rd = sr.getHostDevice();
        String connectionURL = sr.getConnectionURL(0, false);
        if (connectionURL.indexOf("ReciveMTU") == -1) {
            connectionURL = connectionURL + ";ReceiveMTU=48";
        }
        if (connectionURL.indexOf("TransmitMTU") == -1) {
            connectionURL = connectionURL + ";TransmitMTU=48";
        }
        try {
            System.out.println("Connecting to " + rd.getFriendlyName(true) + ", " + connectionURL);
            L2CAPConnection conn = (L2CAPConnection)Connector.open((String)connectionURL);
            this.util = new L2CAP_util(this, conn);
            this.sendMessage((byte)17);
            System.out.println("Asking for game setup...");
            this.util.senddData();
        }
        catch (Exception ioe) {
            System.out.println("Connect exception in getGamesetup");
            ioe.printStackTrace();
        }
    }

    public void getGameSetup(int game_idx) {
        this.setup_data = this.setups[game_idx];
        this.game.communicationEnded((byte)9, (byte)50);
    }

    public void joinGame(int game_idx, Packet p) {
        ServiceRecord sr = (ServiceRecord)this.discoveredServices.elementAt(game_idx);
        try {
            String connectionURL = sr.getConnectionURL(0, false);
            if (connectionURL.indexOf("ReciveMTU") == -1) {
                connectionURL = connectionURL + ";ReceiveMTU=48";
            }
            if (connectionURL.indexOf("TransmitMTU") == -1) {
                connectionURL = connectionURL + ";TransmitMTU=48";
            }
            L2CAPConnection conn = (L2CAPConnection)Connector.open((String)connectionURL);
            this.util = new L2CAP_util(this, conn);
            this.sendMessage((byte)5);
            this.util.dout.writeUTF(this.pname);
            if (p != null) {
                this.util.dout.writeByte(p.getId());
                p.writeOut(this.util.dout);
            } else {
                this.util.dout.writeByte(-1);
            }
            this.util.senddData();
        }
        catch (Exception e) {
            this.game.communicationEnded((byte)5, (byte)102);
        }
    }

    public void dispose() {
    }

    public void disConnect() {
        if (this.server) {
            if (this.clientHandlers != null) {
                for (int i = 0; i < this.clientHandlers.length; ++i) {
                    if (this.clientHandlers[i] == null) continue;
                    this.clientHandlers[i].dispose();
                    this.clientHandlers[i] = null;
                }
                this.clientHandlers = null;
            }
        } else if (this.util != null) {
            this.util.close();
            this.util = null;
        }
        this.game.communicationEnded((byte)7, (byte)50);
    }

    public void startGame() {
        if (this.server) {
            this.gs_started = true;
            this.gameState = 1;
            try {
                this.l2n.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.localDevice.setDiscoverable(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.broadCastType = 0;
            this.broadCastMessage(-1);
            this.game.communicationEnded((byte)12, (byte)50);
        }
    }

    public void leaveGame() {
        if (this.gameState == 2) {
            this.leaveGameOverGame();
            return;
        }
        if (!this.server) {
            this.sendMessage((byte)10);
            this.util.senddData();
            this.util.scheduleClosing(1000);
        } else {
            this.deleteGame();
        }
    }

    public void leaveGameOverGame() {
        if (!this.server) {
            this.sendMessage((byte)15);
            this.util.senddData();
        } else {
            this.game.communicationEnded((byte)15, (byte)50);
            try {
                this.localDevice.setDiscoverable(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteGame() {
        if (this.server) {
            try {
                if (this.gameState != 2) {
                    this.broadCastType = (byte)4;
                    this.bctMessage = (byte)70;
                    this.broadCastMessage(-1);
                }
                if (this.gameState == 0) {
                    try {
                        this.l2n.close();
                        this.localDevice.setDiscoverable(0);
                    }
                    catch (Exception e) {
                        System.out.println("L2n exception in deletGame");
                    }
                }
                if (this.gameState != 2) {
                    for (int i = 0; i < this.gs_numJoined - 1; ++i) {
                        this.clientHandlers[i].dispose();
                    }
                }
                this.clientHandlers = null;
                this.game.communicationEnded((byte)11, (byte)50);
            }
            catch (Exception e) {
                System.out.println("Delete game exception");
                e.printStackTrace();
                this.game.communicationEnded((byte)11, (byte)102);
            }
        }
    }

    public void getGameStatus() {
    }

    public void sendGameOver() {
        if (this.server) {
            this.gameState = (byte)2;
            this.game.communicationEnded((byte)14, (byte)50);
        } else {
            this.sendMessage((byte)14);
            this.util.senddData();
        }
    }

    void sendMessage(byte type) {
        this.messageTypes.addElement(new Byte(type));
        try {
            this.util.dout.writeByte(type);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getData(DataInputStream din) {
        byte last_type = -1;
        try {
            byte code = din.readByte();
            if (code < 50) {
                switch (code) {
                    case 8: {
                        System.out.println("New game state received...");
                        this.gs_numPlayers = din.readByte();
                        this.gs_numJoined = din.readByte();
                        this.gs_Players = new String[this.gs_numPlayers];
                        for (int i = 0; i < this.gs_numJoined; ++i) {
                            this.gs_Players[i] = din.readUTF();
                        }
                        this.gs_started = din.readBoolean();
                        this.game.communicationEnded((byte)8, (byte)50);
                        break;
                    }
                    case 12: {
                        this.game.communicationEnded((byte)12, (byte)50);
                        break;
                    }
                    case 18: {
                        System.out.println("Packet received");
                        short type = din.readByte();
                        Packet p = this.game.makePacket(type);
                        p.readIn(din);
                        this.getPacket(p);
                        this.game.communicationEnded((byte)6, (byte)50);
                        break;
                    }
                    case 6: {
                        int num = din.readShort();
                        System.out.println(num + " PACKETS received");
                        for (int i = 0; i < num; ++i) {
                            short type = din.readByte();
                            Packet p = this.game.makePacket(type);
                            p.readIn(din);
                            this.getPacket(p);
                        }
                        this.game.communicationEnded((byte)6, (byte)50);
                    }
                }
            } else {
                switch (code) {
                    case 50: {
                        if (this.messageTypes.size() > 0) {
                            last_type = (Byte)this.messageTypes.elementAt(0);
                            this.messageTypes.removeElementAt(0);
                        } else {
                            System.out.println("--- ERROR: problem with message types");
                        }
                        switch (last_type) {
                            case 17: {
                                this.gameList_pnumCP[this.game_idx] = din.readByte();
                                this.gameList_pJoinedCP[this.game_idx] = din.readByte();
                                this.gameListCP[this.game_idx] = din.readUTF();
                                System.out.println(this.gameListCP[this.game_idx] + "(" + this.gameList_pJoinedCP[this.game_idx] + "/" + this.gameList_pnumCP[this.game_idx] + ")");
                                byte type = din.readByte();
                                if (type != -1) {
                                    Packet p = this.game.makePacket(type);
                                    p.readIn(din);
                                    this.setups[this.game_idx] = p;
                                } else {
                                    this.setups[this.game_idx] = null;
                                }
                                this.sendMessage((byte)7);
                                System.out.println("Disconnecting...");
                                this.util.senddData();
                                break;
                            }
                            case 7: {
                                System.out.println("Disconnected succesfully !!!");
                                this.util.close();
                                this.wakeUP();
                                break;
                            }
                            case 5: {
                                this.join_order = din.readByte();
                                break;
                            }
                            case 10: 
                            case 15: {
                                System.out.println("Leave Game or leave game over game succes");
                                this.util.close();
                            }
                        }
                        break;
                    }
                    case 70: 
                    case 75: {
                        this.util.close();
                    }
                }
                if (this.sendCommunicationEnded) {
                    this.game.communicationEnded(last_type, code);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Client getData exception...");
            e.printStackTrace();
        }
    }

    protected synchronized void wakeUP() {
        this.notify();
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        this.remoteDevices.put(remoteDevice.getBluetoothAddress(), remoteDevice);
    }

    public void inquiryCompleted(int transId) {
        this.wakeUP();
    }

    public void servicesDiscovered(int transId, ServiceRecord[] serviceRecord) {
        System.out.println("Adding serviceRecord: " + serviceRecord[0].getConnectionURL(0, false));
        this.discoveredServices.addElement(serviceRecord[0]);
    }

    public void serviceSearchCompleted(int transId, int responseCode) {
        this.wakeUP();
    }

    void bctSendData(DataOutputStream dout) throws IOException {
        switch (this.broadCastType) {
            case 0: {
                dout.writeByte(8);
                dout.writeByte(this.gs_numPlayers);
                dout.writeByte(this.gs_numJoined);
                for (int i = 0; i < this.gs_numJoined; ++i) {
                    dout.writeUTF(this.gs_Players[i]);
                }
                dout.writeBoolean(this.gs_started);
                break;
            }
            case 1: {
                dout.writeByte(18);
                dout.writeByte(this.bctPacket.getId());
                this.bctPacket.writeOut(dout);
                break;
            }
            case 2: {
                dout.writeByte(6);
                int num_p = this.bctPackets.length;
                dout.writeShort(num_p);
                for (int i = 0; i < num_p; ++i) {
                    dout.writeByte(this.bctPackets[i].getId());
                    this.bctPackets[i].writeOut(dout);
                }
                break;
            }
            case 4: {
                dout.writeByte(this.bctMessage);
            }
        }
    }

    private final void broadCastMessage(int idxExclude) {
        for (int i = 0; i < this.gs_numJoined - 1; ++i) {
            if (i == idxExclude) continue;
            try {
                this.bctSendData(this.clientHandlers[i].util.dout);
                this.clientHandlers[i].util.senddData();
                continue;
            }
            catch (Exception e) {
                System.out.println("BroadCastmessage exception");
                e.printStackTrace();
            }
        }
    }

    private final synchronized void addClient(String name, ServerHandler handler, Packet sp) {
        int idx = -1;
        if (this.gs_numJoined < this.gs_numPlayers) {
            idx = this.gs_numJoined - 1;
            this.gs_Players[this.gs_numJoined] = name;
            this.gs_Packets[this.gs_numJoined] = sp;
            this.gs_numJoined = (byte)(this.gs_numJoined + 1);
            try {
                handler.util.dout.writeByte(50);
                handler.util.dout.writeByte(idx + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            handler.util.senddData();
            handler.client_idx = idx;
            this.clientHandlers[idx] = handler;
            this.game.communicationEnded((byte)8, (byte)50);
            this.broadCastType = 0;
            this.broadCastMessage(-1);
        } else {
            try {
                handler.util.dout.writeByte(73);
            }
            catch (Exception e) {
                // empty catch block
            }
            handler.util.senddData();
        }
    }

    private final synchronized void removeClient(int idx) {
        int i;
        for (i = idx + 1; i < this.gs_numJoined - 1; ++i) {
            this.gs_Players[i] = this.gs_Players[i + 1];
        }
        this.clientHandlers[idx] = null;
        for (i = idx; i < this.gs_numJoined - 1; ++i) {
            this.clientHandlers[i] = this.clientHandlers[i + 1];
            if (this.clientHandlers[i] == null) continue;
            --this.clientHandlers[i].client_idx;
        }
        this.gs_numJoined = (byte)(this.gs_numJoined - 1);
    }

    class ServerHandler
    implements L2CAP_GET_DATA {
        L2CAPConnection conn;
        L2CAP_util util;
        int transf;
        int recive;
        int client_idx;

        public ServerHandler(L2CAPConnection l2c) {
            System.out.println("New connection");
            this.conn = l2c;
            this.util = new L2CAP_util(this, this.conn);
        }

        public void getData(DataInputStream din) {
            try {
                byte type = din.readByte();
                switch (type) {
                    case 17: {
                        System.out.println("Client asks for Game setup");
                        this.util.dout.writeByte(50);
                        this.util.dout.writeByte(BTCommunicator.this.gs_numPlayers);
                        this.util.dout.writeByte(BTCommunicator.this.gs_numJoined);
                        this.util.dout.writeUTF(BTCommunicator.this.pname);
                        if (BTCommunicator.this.setup_data != null) {
                            this.util.dout.writeByte(BTCommunicator.this.setup_data.getId());
                            BTCommunicator.this.setup_data.writeOut(this.util.dout);
                        } else {
                            this.util.dout.writeByte(-1);
                        }
                        this.util.senddData();
                        break;
                    }
                    case 5: {
                        Packet sp;
                        String clientName = din.readUTF();
                        type = din.readByte();
                        if (type != -1) {
                            sp = BTCommunicator.this.game.makePacket(type);
                            sp.readIn(din);
                        } else {
                            sp = null;
                        }
                        System.out.println(clientName + " wants to join the game");
                        BTCommunicator.this.addClient(clientName, this, sp);
                        break;
                    }
                    case 7: {
                        System.out.println("Client disconnected");
                        this.util.dout.writeByte(50);
                        this.util.senddData();
                        this.util.close();
                        break;
                    }
                    case 18: {
                        short p_type = din.readByte();
                        System.out.println("Packet received " + p_type);
                        Packet p = BTCommunicator.this.game.makePacket(p_type);
                        p.readIn(din);
                        BTCommunicator.this.getPacket(p);
                        BTCommunicator.this.game.communicationEnded((byte)6, (byte)50);
                        BTCommunicator.this.broadCastType = 1;
                        BTCommunicator.this.bctPacket = p;
                        BTCommunicator.this.broadCastMessage(this.client_idx);
                        break;
                    }
                    case 6: {
                        int np = din.readShort();
                        System.out.println(np + "PACKETS received");
                        Packet[] packets = new Packet[np];
                        for (int i = 0; i < np; ++i) {
                            short p_type = din.readByte();
                            packets[i] = BTCommunicator.this.game.makePacket(p_type);
                            packets[i].readIn(din);
                            BTCommunicator.this.getPacket(packets[i]);
                        }
                        BTCommunicator.this.game.communicationEnded((byte)6, (byte)50);
                        BTCommunicator.this.broadCastType = (byte)2;
                        BTCommunicator.this.bctPackets = packets;
                        BTCommunicator.this.broadCastMessage(this.client_idx);
                        break;
                    }
                    case 10: {
                        this.util.dout.writeByte(50);
                        this.util.senddData();
                        BTCommunicator.this.removeClient(this.client_idx);
                        switch (BTCommunicator.this.gameState) {
                            case 1: {
                                BTCommunicator.this.broadCastType = (byte)4;
                                BTCommunicator.this.bctMessage = (byte)75;
                                BTCommunicator.this.broadCastMessage(-1);
                                BTCommunicator.this.game.communicationEnded((byte)4, (byte)75);
                                for (int i = 0; i < BTCommunicator.this.gs_numJoined - 1; ++i) {
                                    BTCommunicator.this.clientHandlers[i].dispose();
                                }
                                BTCommunicator.this.clientHandlers = null;
                                break;
                            }
                            case 0: {
                                BTCommunicator.this.game.communicationEnded((byte)8, (byte)50);
                                BTCommunicator.this.broadCastType = 0;
                                BTCommunicator.this.broadCastMessage(-1);
                            }
                        }
                        this.dispose();
                        break;
                    }
                    case 15: {
                        System.out.println("Client wants to leave game over mode...");
                        this.util.dout.writeByte(50);
                        this.util.senddData();
                        System.out.println("Response sent");
                        this.dispose();
                        break;
                    }
                    case 14: {
                        BTCommunicator.this.gameState = (byte)2;
                        this.util.dout.writeByte(50);
                        this.util.senddData();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Server getData excpetion");
                e.printStackTrace();
            }
        }

        public void dispose() {
            this.util.close();
        }
    }
}

