/*
 * Decompiled with CFR 0.152.
 */
package com.impossible.util;

import com.impossible.util.ImLoader;
import javax.microedition.lcdui.Graphics;

public class PalettedSprite
extends ImLoader {
    private int[] palette;
    private int[] workingPalette;
    short[] widths;
    byte[][][] frameData;
    int[] rgb_data;

    public PalettedSprite(boolean initializeRgbData) {
        if (ImLoader.LOAD_MODE != 0) {
            try {
                ImLoader.jpack_is.readInt();
                int n = ImLoader.jpack_is.readShort();
                this.palette = new int[n];
                int i = 0;
                while (i < n) {
                    this.palette[i] = ImLoader.jpack_is.readInt();
                    ++i;
                }
                this.workingPalette = this.palette;
                n = ImLoader.jpack_is.readShort();
                System.out.println("Subimage count: " + n);
                this.kh = ImLoader.jpack_is.readShort();
                this.widths = new short[n];
                this.frameData = new byte[n][][];
                short maxWidth = 0;
                i = 0;
                while (i < n) {
                    this.widths[i] = ImLoader.jpack_is.readShort();
                    if (this.widths[i] > maxWidth) {
                        maxWidth = this.widths[i];
                    }
                    System.out.println(String.valueOf(i) + ". frame width = " + this.widths[i] + " " + maxWidth);
                    this.frameData[i] = new byte[this.kh][this.widths[i]];
                    int y = 0;
                    while (y < this.kh) {
                        int x = 0;
                        while (x < this.widths[i]) {
                            this.frameData[i][y][x] = ImLoader.jpack_is.readByte();
                            ++x;
                        }
                        ++y;
                    }
                    ++i;
                }
                if (initializeRgbData) {
                    this.rgb_data = new int[maxWidth * this.kh];
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ImLoader.LOAD_MODE == 1 && ImLoader.load_listener != null) {
                ImLoader.LOAD_POS = (short)(ImLoader.LOAD_POS + 1);
                ImLoader.load_listener.loadProgress(ImLoader.LOAD_NUM, ImLoader.LOAD_POS);
            }
        } else {
            ImLoader.LOAD_NUM = (short)(ImLoader.LOAD_NUM + 1);
        }
    }

    public void drawSubImage(Graphics g, int x, int y, int s, int o) {
        int rgbIdx = 0;
        byte[][] frame = this.frameData[o];
        switch (this.transform) {
            case 0: {
                int i = 0;
                while (i < this.kh) {
                    int j = 0;
                    while (j < this.widths[o]) {
                        this.rgb_data[rgbIdx++] = this.workingPalette[frame[i][j] & 0xFF];
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.kh) {
                    int j = this.widths[o] - 1;
                    while (j >= 0) {
                        this.rgb_data[rgbIdx++] = this.workingPalette[frame[i][j] & 0xFF];
                        --j;
                    }
                    ++i;
                }
                break;
            }
        }
        g.drawRGB(this.rgb_data, 0, (int)this.widths[o], x, y, (int)this.widths[o], this.kh, true);
    }

    public int getWidth() {
        return this.getWidth(0, 0);
    }

    public int getWidth(int s, int o) {
        return this.widths[o];
    }

    public int getHeight(int s, int o) {
        return this.kh;
    }

    public int getOriginalPaletteColor(int index) {
        return this.palette[index];
    }

    public int[] getWorkingPalette() {
        if (this.workingPalette == this.palette) {
            this.workingPalette = new int[this.palette.length];
            System.arraycopy(this.palette, 0, this.workingPalette, 0, this.palette.length);
        }
        return this.workingPalette;
    }

    public void resetWorkingPalette() {
        if (this.workingPalette == this.palette) {
            this.workingPalette = new int[this.palette.length];
        }
        System.arraycopy(this.palette, 0, this.workingPalette, 0, this.palette.length);
    }
}

