/*
 * Decompiled with CFR 0.152.
 */
package joybits.disciples;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import joybits.disciples.DisCanvas;
import joybits.disciples.FontParam;
import joybits.disciples.GlobalConstants;
import joybits.disciples.StringParamInterface;

public class Globals
implements StringParamInterface,
FontParam,
GlobalConstants {
    public static Vector mStringArr;
    public static Vector fontVect;
    public static DataInputStream imagesDis;
    public static InputStream imagesIs;
    public static byte[] fontArr;
    public static Image font1;
    public static final int[] mCharWidth;
    public static int[] imagesData0;
    public static int[] imagesData1;
    private static Random rnd;

    public static int abs(int a) {
        if (a < 0) {
            return -a;
        }
        return a;
    }

    public static int clip(int a, int b, int c) {
        if (a > c) {
            return c;
        }
        if (a < b) {
            return b;
        }
        return a;
    }

    public static byte round(int a) {
        if (a % 10000 < 5000) {
            return (byte)(a / 10000);
        }
        return (byte)(a / 10000 + 1);
    }

    public static int ceilDiv(int a, int b) {
        if (a % b == 0) {
            return a / b;
        }
        return a / b + 1;
    }

    public static void readStrings(String fileName) {
        mStringArr = null;
        InputStream stringIS = null;
        InputStream fontIS = null;
        try {
            stringIS = fileName.getClass().getResourceAsStream(fileName);
            DataInputStream stringDIS = new DataInputStream(stringIS);
            fontIS = fileName.getClass().getResourceAsStream("/font");
            DataInputStream fontDIS = new DataInputStream(fontIS);
            int n = 0;
            while ((n = fontDIS.read()) != -1) {
                fontVect.addElement(new Integer(n));
            }
            fontArr = new byte[256];
            for (int i = 0; i < 256; ++i) {
                Globals.fontArr[i] = (byte)fontVect.indexOf(new Integer(i));
            }
            mStringArr = new Vector();
            int strCount = 0;
            String str = "";
            while ((n = stringDIS.read()) != -1) {
                if (n == 10) {
                    mStringArr.addElement(str);
                    str = "";
                    ++strCount;
                    continue;
                }
                if (n == 13) continue;
                str = str + (char)n;
            }
            stringDIS.close();
            stringDIS = null;
            stringIS = null;
            fontDIS.close();
            fontDIS = null;
            fontIS = null;
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void drawClippedString(Graphics g, int x, int y, String str, int initClipY, int initClipH) {
        int space = 1;
        int startX = x;
        int clipY = y;
        int clipH = 10;
        if (clipY < initClipY) {
            clipY = initClipY;
            clipH -= initClipY - y;
        }
        if (clipY + 10 > initClipY + initClipH) {
            clipH = -clipY + initClipY + initClipH;
        }
        for (int i = 0; i < str.length(); ++i) {
            byte ch = fontArr[str.charAt(i)];
            if (i == -1) {
                return;
            }
            if (ch == 88) {
                y += 10 + space;
                x = startX;
                continue;
            }
            if (ch == 87) {
                x += mCharWidth[ch] + space;
                continue;
            }
            if (ch == 89) {
                return;
            }
            int charOffsX = ch & 7;
            int charOffsY = (ch & 0xF8) >> 3;
            g.setClip(x, clipY, 10, clipH);
            g.drawImage(font1, x - charOffsX * 10, y - charOffsY * 10, 0);
            x += mCharWidth[ch] + space;
        }
    }

    public static void drawString(Graphics g, int x, int y, String str) {
        int space = 1;
        int startX = x;
        for (int i = 0; i < str.length(); ++i) {
            byte ch = fontArr[str.charAt(i)];
            if (i == -1) {
                return;
            }
            if (ch == 88) {
                y += 10 + space;
                x = startX;
                continue;
            }
            if (ch == 87) {
                x += mCharWidth[ch] + space;
                continue;
            }
            if (ch == 89) {
                return;
            }
            int charOffsX = ch & 7;
            int charOffsY = (ch & 0xF8) >> 3;
            g.setClip(x, y, 10, 10);
            g.drawImage(font1, x - charOffsX * 10, y - charOffsY * 10, 0);
            x += mCharWidth[ch] + space;
        }
    }

    public static void drawString(Graphics g, int x, int y, int stringId) {
        int startX = x;
        int space = 1;
        String str = (String)mStringArr.elementAt(stringId);
        for (int i = 0; i < str.length(); ++i) {
            byte ch = fontArr[str.charAt(i)];
            if (ch == 88) {
                y += 10 + space;
                x = startX;
                continue;
            }
            if (ch == 87) {
                x += mCharWidth[ch] + space;
                continue;
            }
            if (ch == 89) {
                return;
            }
            int charOffsX = ch & 7;
            int charOffsY = (ch & 0xF8) >> 3;
            g.setClip(x, y, 10, 10);
            g.drawImage(font1, x - charOffsX * 10, y - charOffsY * 10, 0);
            x += mCharWidth[ch] + space;
        }
    }

    public static int drawInteger(Graphics g, int x, int y, int value) {
        int i;
        int space = 1;
        int mask = 1;
        if (value < 0) {
            value = 0;
        }
        int temp = value;
        int length = String.valueOf(value).length();
        int stringWidth = 0;
        for (i = 0; i < length - 1; ++i) {
            mask *= 10;
        }
        for (i = 0; i < length; ++i) {
            int ch = temp / mask + 0;
            temp %= mask;
            mask /= 10;
            Globals.drawChar(g, x + stringWidth, y, ch);
            stringWidth += mCharWidth[ch] + space;
        }
        return stringWidth;
    }

    public static int getIntegerStringWidth(int value) {
        int i;
        int space = 1;
        int mask = 1;
        if (value < 0) {
            value = 0;
        }
        int temp = value;
        int length = String.valueOf(value).length();
        int stringWidth = 0;
        for (i = 0; i < length - 1; ++i) {
            mask *= 10;
        }
        for (i = 0; i < length; ++i) {
            int ch = temp / mask + 0;
            temp %= mask;
            mask /= 10;
            stringWidth += mCharWidth[ch] + space;
        }
        return stringWidth;
    }

    private static void drawChar(Graphics g, int x, int y, int ch) {
        int charOffsX = ch & 7;
        int charOffsY = (ch & 0xF8) >> 3;
        g.setClip(x, y, 10, 10);
        g.drawImage(font1, x - charOffsX * 10, y - charOffsY * 10, 0);
    }

    public static int getStringWidth(int stringId) {
        int space = 1;
        int res = 0;
        String str = (String)mStringArr.elementAt(stringId);
        for (int i = 0; i < str.length(); ++i) {
            int ch = fontArr[str.charAt(i)];
            if (ch == 255 || ch == -1) {
                ch = 87;
            }
            if (mCharWidth.length <= ch) continue;
            res += mCharWidth[ch] + space;
        }
        return res;
    }

    public static int getStringWidth(String str) {
        int space = 1;
        int res = 0;
        for (int i = 0; i < str.length(); ++i) {
            int ch = fontArr[str.charAt(i)];
            if (ch == 255 || ch == -1) {
                ch = 87;
            }
            if (mCharWidth.length <= ch) continue;
            res += mCharWidth[ch] + space;
        }
        return res;
    }

    public static void loadIntArray() {
        try {
            for (int n = 0; n < 2; ++n) {
                int i;
                InputStream is = DisCanvas.instance.getClass().getResourceAsStream("/imagesData" + n);
                DataInputStream dis = new DataInputStream(is);
                int size = dis.read();
                if (n == 0) {
                    imagesData0 = new int[size];
                    for (i = 0; i < size; ++i) {
                        Globals.imagesData0[i] = dis.readInt();
                    }
                } else {
                    imagesData1 = new int[size];
                    for (i = 0; i < size; ++i) {
                        Globals.imagesData1[i] = dis.readInt();
                    }
                }
                dis.close();
                dis = null;
                Object var1_2 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Image loadImage(int imageIndex) {
        if (imageIndex == -1) {
            return null;
        }
        try {
            int section = 0;
            if (imageIndex >= 1000) {
                section = 1;
            }
            int offset = 0;
            int length = 0;
            if (section == 0) {
                offset = imagesData0[imageIndex * 2 + 0];
                length = imagesData0[imageIndex * 2 + 1];
            } else {
                offset = imagesData1[(imageIndex - 1000) * 2 + 0];
                length = imagesData1[(imageIndex - 1000) * 2 + 1];
            }
            byte[] data = new byte[length];
            imagesIs = DisCanvas.instance.getClass().getResourceAsStream("/images.pak" + section);
            imagesDis = new DataInputStream(imagesIs);
            imagesDis.skip(offset);
            imagesDis.read(data);
            Image result = Image.createImage((byte[])data, (int)0, (int)length);
            data = null;
            imagesDis.close();
            imagesDis = null;
            imagesIs = null;
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int rand(int max) {
        if (rnd == null) {
            rnd = new Random();
        }
        return Math.abs(rnd.nextInt() % max);
    }

    static {
        fontVect = new Vector();
        mCharWidth = new int[]{6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 2, 2, 2, 2, 5, 5, 5, 4, 3, 3, 10, 5, 9, 4, 6, 7, 7, 7, 8, 7, 8, 6, 8, 8, 7, 7, 9, 8, 6, 8, 7, 6, 8, 6, 8, 7, 9, 7, 8, 10, 9, 7, 10, 6, 10, 7, 6, 7, 6, 7, 7, 7, 6, 8, 4, 7, 7, 7, 9, 8, 6, 7, 7, 7, 6, 8, 8, 9, 10, 7, 8, 8, 2, 2, 6, 2, 9, 3, 0, 0};
        imagesData0 = null;
        imagesData1 = null;
    }
}

