/*
 * Decompiled with CFR 0.152.
 */
package joybits.disciples;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import joybits.disciples.ArmyCharacter;
import joybits.disciples.ArmyController;
import joybits.disciples.DisCanvas;
import joybits.disciples.GlobalConstants;
import joybits.disciples.Globals;

public class Map
implements GlobalConstants {
    public DisCanvas game;
    public static Map instance;
    public boolean[] nearTile = new boolean[8];
    public int currentObjectId = 0;
    public int currentObjectScreenX = 0;
    public int currentObjectScreenY = 0;
    public int currentObjectX = 0;
    public int currentObjectY = 0;
    public int currentObjectW = 0;
    public int currentObjectH = 0;
    public int shakeX;
    public int shakeY;
    public boolean shaking = false;
    public boolean armyStep = false;
    public Image tilesImg;
    public Image waterImg;
    public Image[] natureImg;
    public Image pathFlags;
    public int cameraSpeed = 15;
    public byte width;
    public byte height;
    public int pixelWidth;
    public int pixelHeight;
    public int screenWidth;
    public int screenHeight;
    public int cameraX;
    public int cameraY;
    public int cameraFloatX;
    public int cameraFloatY;
    private int \u043f\u0438\u0441\u044c\u043a\u0430N1;
    private int \u043f\u0438\u0441\u044c\u043a\u0430N2;
    public int oldCameraRoundX;
    public int oldCameraRoundY;
    public int bufferOffsetX = 0;
    public int bufferOffsetY = 0;
    public byte[][] tiles;
    public short natureCount = 0;
    public byte[][] nature;
    public byte layer3Count = 0;
    public byte[][] layer3;
    public byte mapItemsCount = 0;
    public byte[][] mapItems;
    public byte triggersCount = 0;
    public byte[] triggers;
    public Image minimapBufferImg = null;
    public Graphics minimapBufferGraphics = null;
    public static final byte[][][] imgMap;
    public static final int[] MINIMAP_COLORS;

    public Map(DisCanvas theGame) {
        this.game = theGame;
        instance = this;
        this.screenWidth = 240;
        this.screenHeight = 306 - DisCanvas.instance.userBarHeight - 17;
    }

    public void init() {
        this.cameraSpeed = 15;
    }

    public void destroy() {
        this.tilesImg = null;
        this.tiles = null;
    }

    public void read(String filename) {
        InputStream is = null;
        try {
            int i;
            int i2;
            is = filename.getClass().getResourceAsStream(filename);
            DataInputStream dis = new DataInputStream(is);
            dis.read();
            this.width = (byte)(0xFF & dis.read());
            this.height = (byte)(0xFF & dis.read());
            this.pixelWidth = this.width * 16;
            this.pixelHeight = this.height * 16;
            this.tiles = new byte[this.width][this.height];
            for (int j = 0; j < this.height; ++j) {
                for (int i3 = 0; i3 < this.width; ++i3) {
                    this.tiles[i3][j] = (byte)(0xBF & dis.read());
                }
            }
            int byte1 = dis.read();
            int byte2 = dis.read() << 8;
            this.natureCount = (short)(byte1 + byte2 & 0xFFFF);
            this.nature = new byte[this.natureCount][3];
            for (i2 = 0; i2 < this.natureCount; ++i2) {
                this.nature[i2][0] = (byte)(0xFF & dis.read());
                this.nature[i2][1] = (byte)(0xFF & dis.read());
                this.nature[i2][2] = (byte)(0xFF & dis.read());
            }
            System.out.println("filename = " + filename);
            this.layer3Count = (byte)(0xFF & dis.read());
            this.layer3 = new byte[this.layer3Count][6];
            for (i2 = 0; i2 < this.layer3Count; ++i2) {
                this.layer3[i2][0] = (byte)(0xFF & dis.read());
                this.layer3[i2][1] = (byte)(0xFF & dis.read());
                this.layer3[i2][2] = (byte)(0xFF & dis.read());
                this.layer3[i2][3] = (byte)(0xFF & dis.read());
                this.layer3[i2][4] = (byte)(0xFF & dis.read());
                this.layer3[i2][5] = -1;
            }
            this.mapItemsCount = (byte)(0xFF & dis.read());
            this.mapItems = new byte[this.mapItemsCount][5];
            for (i2 = 0; i2 < this.mapItemsCount; ++i2) {
                this.mapItems[i2][0] = (byte)(0xFF & dis.read());
                this.mapItems[i2][1] = (byte)(0xFF & dis.read());
                this.mapItems[i2][2] = (byte)(0xFF & dis.read());
                this.mapItems[i2][3] = (byte)(0xFF & dis.read());
                this.mapItems[i2][4] = (byte)(0xFF & dis.read());
            }
            int armiesCount = 0xFF & dis.read();
            DisCanvas.instance.army = new ArmyController();
            for (i = 0; i < armiesCount; ++i) {
                byte x = (byte)(0xFF & dis.read());
                byte y = (byte)(0xFF & dis.read());
                byte p = (byte)(0xFF & dis.read());
                byte leader = (byte)(0xFF & dis.read());
                byte id = (byte)(0xFF & dis.read());
                boolean visible = (byte)(0xFF & dis.read()) != 0;
                byte u0 = (byte)(0xFF & dis.read() - 150);
                byte u1 = (byte)(0xFF & dis.read() - 150);
                byte u2 = (byte)(0xFF & dis.read() - 150);
                byte u3 = (byte)(0xFF & dis.read() - 150);
                byte u4 = (byte)(0xFF & dis.read() - 150);
                byte u5 = (byte)(0xFF & dis.read() - 150);
                DisCanvas.instance.army.addArmy(x, y, leader, p, u0, u1, u2, u3, u4, u5, id, visible);
            }
            this.\u043f\u0438\u0441\u044c\u043a\u0430N1 = 20;
            this.\u043f\u0438\u0441\u044c\u043a\u0430N2 = 19;
            this.triggersCount = (byte)(0xFF & dis.read());
            this.triggers = new byte[this.triggersCount * 7];
            for (i = 0; i < this.triggersCount; ++i) {
                for (int j = 0; j < 7; ++j) {
                    this.triggers[i * 7 + j] = (byte)(0xFF & dis.read());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void findTownArmies() {
        DisCanvas.instance.townsCount = 0;
        for (int playerId = 0; playerId < 2; ++playerId) {
            for (int i = 0; i < ArmyController.instance.armyVector.size(); ++i) {
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i);
                if (ac.owner < 3) continue;
                for (int j = 0; j < this.layer3Count; ++j) {
                    if (this.layer3[j][2] != 50 + playerId || ac.x != this.layer3[j][0] + 1 || ac.y != this.layer3[j][1] + 3) continue;
                    DisCanvas.instance.capitals[DisCanvas.instance.townsCount][0] = (byte)i;
                    DisCanvas.instance.capitals[DisCanvas.instance.townsCount][2] = (byte)j;
                    this.layer3[j][5] = DisCanvas.instance.townsCount;
                    DisCanvas.instance.findLeaderInCapital((byte)j);
                    DisCanvas.instance.townsCount = (byte)(DisCanvas.instance.townsCount + 1);
                }
            }
        }
        if (DisCanvas.instance.townsCount < 2) {
            DisCanvas.instance.townsCount = (byte)2;
        }
        for (int i = 0; i < ArmyController.instance.armyVector.size(); ++i) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i);
            if (ac.owner < 3) continue;
            for (int j = 0; j < this.layer3Count; ++j) {
                if (this.layer3[j][2] != 52 || ac.x != this.layer3[j][0] + 1 || ac.y != this.layer3[j][1] + 2) continue;
                DisCanvas.instance.capitals[DisCanvas.instance.townsCount][0] = (byte)i;
                DisCanvas.instance.capitals[DisCanvas.instance.townsCount][2] = (byte)j;
                this.layer3[j][5] = DisCanvas.instance.townsCount;
                DisCanvas.instance.findLeaderInCapital((byte)j);
                DisCanvas.instance.townsCount = (byte)(DisCanvas.instance.townsCount + 1);
            }
        }
    }

    public void checkNearTiles(int i, int j) {
        for (int n = 0; n < 8; ++n) {
            this.nearTile[n] = false;
        }
        if (i != 0 && j != 0) {
            boolean bl = this.nearTile[0] = (0xFF & this.tiles[i - 1][j - 1] & 0x40) != 0;
        }
        if (j != 0) {
            boolean bl = this.nearTile[1] = (0xFF & this.tiles[i][j - 1] & 0x40) != 0;
        }
        if (i != this.width - 1 && j != 0) {
            boolean bl = this.nearTile[2] = (0xFF & this.tiles[i + 1][j - 1] & 0x40) != 0;
        }
        if (i != this.width - 1) {
            boolean bl = this.nearTile[3] = (0xFF & this.tiles[i + 1][j] & 0x40) != 0;
        }
        if (i != this.width - 1 && j != this.height - 1) {
            boolean bl = this.nearTile[4] = (0xFF & this.tiles[i + 1][j + 1] & 0x40) != 0;
        }
        if (j != this.height - 1) {
            boolean bl = this.nearTile[5] = (0xFF & this.tiles[i][j + 1] & 0x40) != 0;
        }
        if (i != 0 && j != this.height - 1) {
            boolean bl = this.nearTile[6] = (0xFF & this.tiles[i - 1][j + 1] & 0x40) != 0;
        }
        if (i != 0) {
            this.nearTile[7] = (0xFF & this.tiles[i - 1][j] & 0x40) != 0;
        }
    }

    public void draw(Graphics g) {
        boolean needRepaintMap = false;
        if (this.cameraX / 16 < this.oldCameraRoundX) {
            needRepaintMap = true;
        }
        if (this.cameraX / 16 > this.oldCameraRoundX) {
            needRepaintMap = true;
        }
        if (this.cameraY / 16 < this.oldCameraRoundY) {
            needRepaintMap = true;
        }
        if (this.cameraY / 16 > this.oldCameraRoundY) {
            needRepaintMap = true;
        }
        this.oldCameraRoundX = this.cameraX / 16;
        this.oldCameraRoundY = this.cameraY / 16;
        if (needRepaintMap) {
            this.draw();
        }
        int x = -this.cameraX % 16;
        int y = -this.cameraY % 16 - 16;
        if (this.shaking) {
            this.shakeX = Globals.rand(5) - 2;
            this.shakeY = Globals.rand(5) - 2;
            x += this.shakeX;
            y += this.shakeY;
        }
        if (this.game.gameStill == 0) {
            g.setClip(0, 17, 240, this.screenHeight);
            g.drawImage(this.game.bufferImg, x, y + 17, 0);
        }
        byte tempGameStill = this.game.gameStill;
        if (needRepaintMap) {
            tempGameStill = 1;
        }
        Graphics gr = this.game.bufferGraphics;
        if (tempGameStill == 1) {
            int objType;
            this.bufferOffsetX = this.cameraX % 16;
            this.bufferOffsetY = this.cameraY % 16;
            if (DisCanvas.instance.onTourney) {
                this.draw();
            }
            this.drawTiles(gr, true);
            for (objType = 0; objType < 2; ++objType) {
                this.drawOther(gr, (byte)0, objType);
            }
            this.drawOther(gr, (byte)2, 2);
            for (objType = 0; objType < 2; ++objType) {
                this.drawOther(gr, (byte)1, objType);
            }
            this.drawRods(gr);
            this.drawFoW(gr);
        }
        if (tempGameStill != 0) {
            g.setClip(0, 17, 240, this.screenHeight);
            g.drawImage(this.game.bufferImg, x, y + 17, 0);
        }
        if (ArmyController.instance.targetID != -1) {
            this.drawFlags(g);
        }
        ArmyController.instance.drawArmies(g);
        this.drawTopArmies(g);
        this.game.oldGameStill = this.game.gameStill;
        if (DisCanvas.instance.onTourney) {
            this.game.gameStill = 0;
        }
        this.armyStep = false;
    }

    public void drawRods(Graphics g) {
        block4: for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            this.currentObjectX = this.getObjectX(1, i);
            this.currentObjectY = this.getObjectY(1, i);
            if (g == this.game.bufferGraphics) {
                this.currentObjectX += this.bufferOffsetX;
                this.currentObjectY += this.bufferOffsetY;
            }
            if (this.shaking) {
                this.currentObjectX += this.shakeX;
                this.currentObjectY += this.shakeY;
            }
            if (this.layer3[i][2] < 53 || this.layer3[i][2] > 55) continue;
            switch (this.layer3[i][4]) {
                case 0: {
                    g.setClip(this.currentObjectX, this.currentObjectY - 12, 15, 19);
                    g.drawImage(DisCanvas.instance.mineRods, this.currentObjectX, this.currentObjectY - 12, 0);
                    continue block4;
                }
                case 1: {
                    g.setClip(this.currentObjectX, this.currentObjectY - 12, 15, 19);
                    g.drawImage(DisCanvas.instance.mineRods, this.currentObjectX - 15, this.currentObjectY - 12, 0);
                }
            }
        }
    }

    public void draw() {
        this.bufferOffsetX = this.cameraX % 16;
        this.bufferOffsetY = this.cameraY % 16;
        this.drawTiles(this.game.bufferGraphics, false);
    }

    public void drawStars(Graphics g, int color, int offsetX, int offsetY, int rand) {
        boolean inBuffer = g == this.game.bufferGraphics;
        for (int i = 0; i < 12; ++i) {
            int ty;
            int tx;
            int randshift = 1;
            randshift = 473;
            int x = (987 - offsetX + i * rand * randshift) % 240;
            int y = 17 + (1234 - offsetY + i * rand * randshift) % this.screenHeight;
            if (inBuffer) {
                x += this.bufferOffsetX;
                y += this.bufferOffsetY;
            }
            if ((0xFF & this.tiles[tx = (x + this.cameraX) / 16 % this.width][ty = (y + this.cameraY - 17) / 16 % this.height] & 0x40) != 0) continue;
            g.setColor(color);
            g.drawLine(x, y, x, y);
        }
    }

    public void drawFoW(Graphics g) {
        boolean curTile;
        int i;
        int j;
        g.setColor(0);
        boolean inBuffer = g == this.game.bufferGraphics;
        int startX = this.cameraX / 16;
        int startY = this.cameraY / 16;
        int screenTileWidth = this.screenWidth / 16 + 2;
        int screenTileHeight = this.screenHeight / 16 + 2;
        for (j = startY; j < startY + screenTileHeight + 1; ++j) {
            for (i = startX; i < startX + screenTileWidth + 1; ++i) {
                if (i < 0 || j < 0 || i >= this.width || j >= this.height) continue;
                boolean bl = curTile = (0xFF & this.tiles[i][j] & 0x40) != 0;
                if (curTile) continue;
                this.checkNearTiles(i, j);
                if ((curTile || !this.nearTile[7] || !this.nearTile[3]) && (curTile || !this.nearTile[1] || !this.nearTile[5])) continue;
                byte[] byArray = this.tiles[i];
                int n = j;
                byArray[n] = (byte)(byArray[n] | 0x40);
            }
        }
        for (j = startY; j < startY + screenTileHeight + 1; ++j) {
            for (i = startX; i < startX + screenTileWidth + 1; ++i) {
                if (i < 0 || j < 0 || i >= this.width || j >= this.height) continue;
                boolean bl = curTile = (0xFF & this.tiles[i][j] & 0x40) != 0;
                if (curTile) continue;
                this.checkNearTiles(i, j);
                int curTileType = -1;
                if (!curTile && !this.nearTile[7] && !this.nearTile[1] && this.nearTile[4]) {
                    curTileType = 52;
                }
                if (!curTile && !this.nearTile[1] && !this.nearTile[3] && this.nearTile[6]) {
                    curTileType = 53;
                }
                if (!curTile && !this.nearTile[7] && !this.nearTile[5] && this.nearTile[2]) {
                    curTileType = 54;
                }
                if (!curTile && !this.nearTile[3] && !this.nearTile[5] && this.nearTile[0]) {
                    curTileType = 55;
                }
                if (!curTile && this.nearTile[7] && this.nearTile[1] && !this.nearTile[4]) {
                    curTileType = 56;
                }
                if (!curTile && this.nearTile[1] && this.nearTile[3] && !this.nearTile[6]) {
                    curTileType = 57;
                }
                if (!curTile && this.nearTile[7] && this.nearTile[5] && !this.nearTile[2]) {
                    curTileType = 58;
                }
                if (!curTile && this.nearTile[3] && this.nearTile[5] && !this.nearTile[0]) {
                    curTileType = 59;
                }
                if (!curTile && !this.nearTile[7] && !this.nearTile[3] && this.nearTile[5]) {
                    curTileType = 48;
                }
                if (!curTile && !this.nearTile[7] && !this.nearTile[3] && this.nearTile[1]) {
                    curTileType = 49;
                }
                if (!curTile && !this.nearTile[1] && !this.nearTile[5] && this.nearTile[3]) {
                    curTileType = 50;
                }
                if (!curTile && !this.nearTile[1] && !this.nearTile[5] && this.nearTile[7]) {
                    curTileType = 51;
                }
                int x = i * 16 - this.cameraX;
                int y = j * 16 - this.cameraY + 17;
                if (inBuffer) {
                    x += this.bufferOffsetX;
                    y += this.bufferOffsetY;
                }
                if (curTileType != -1) {
                    int tileOffsetX = curTileType % 8 * 16;
                    int tileOffsetY = curTileType / 8 * 16;
                    g.setClip(x, y, 16, 16);
                    g.drawImage(this.tilesImg, x - tileOffsetX, y - tileOffsetY, 0);
                    continue;
                }
                if (curTile) continue;
                g.setClip(x, y, 16, 16);
                g.fillRect(x, y, 16, 16);
            }
        }
        g.setClip(0, 0, 240, 320);
        this.drawStars(g, 3490661, this.cameraX, this.cameraY, 108);
        this.drawStars(g, 2309239, this.cameraX * 3 / 4, this.cameraY * 3 / 4, 95);
        this.drawStars(g, 1324156, this.cameraX / 2, this.cameraY / 2, 98);
        this.drawStars(g, 2627596, this.cameraX / 3, this.cameraY / 3, 77);
        this.drawStars(g, 2895928, this.cameraX / 5, this.cameraY / 5, 130);
        this.drawStars(g, 0x242428, 0, 0, 150);
    }

    public void drawTiles(Graphics g, boolean drawOnlyWater) {
        boolean inBuffer = g == this.game.bufferGraphics;
        int startX = this.cameraX / 16;
        int startY = this.cameraY / 16;
        int screenTileWidth = this.screenWidth / 16 + 2;
        int screenTileHeight = this.screenHeight / 16 + 2;
        for (int j = startY; j < startY + screenTileHeight + 1; ++j) {
            for (int i = startX; i < startX + screenTileWidth + 1; ++i) {
                if (i < 0 || j < 0 || i >= this.width || j >= this.height) continue;
                int curTileType = 0xFF & this.tiles[i][j];
                int x = i * 16 - this.cameraX;
                int y = j * 16 - this.cameraY + 17;
                if (inBuffer) {
                    x += this.bufferOffsetX;
                    y += this.bufferOffsetY;
                }
                int tileOffsetX = (curTileType &= 0x3F) % 8 * 16;
                int tileOffsetY = curTileType / 8 * 16;
                g.setClip(x, y, 16, 16);
                if (curTileType == 63 || curTileType >= 2 && curTileType <= 15) {
                    int waterFrame = this.game.gameStateTicks / 5 % 8;
                    g.drawImage(this.waterImg, x - waterFrame * 16, y, 0);
                    if (curTileType == 63) continue;
                    if (drawOnlyWater) {
                        g.drawImage(this.tilesImg, x - tileOffsetX, y - tileOffsetY, 0);
                    }
                }
                if (drawOnlyWater) continue;
                g.drawImage(this.tilesImg, x - tileOffsetX, y - tileOffsetY, 0);
            }
        }
    }

    public void deleteItem(int num) {
        if (num > this.mapItemsCount - 1 || num < 0) {
            return;
        }
        for (int i = num; i < this.mapItemsCount - 1; ++i) {
            this.mapItems[i] = this.mapItems[i + 1];
        }
        this.mapItemsCount = (byte)(this.mapItemsCount - 1);
        this.draw();
    }

    public boolean objectIsInFrontOfUnit(boolean inBuffer, int i, int objType, ArmyCharacter ac) {
        this.currentObjectId = this.getObjectId(objType, i);
        this.currentObjectH = this.getObjectH();
        if (this.currentObjectH <= 16) {
            return false;
        }
        this.currentObjectW = this.getObjectW();
        byte objX = 0;
        byte objY = 0;
        if (objType == 0) {
            objX = this.nature[i][0];
            objY = this.nature[i][1];
        } else if (objType == 1) {
            objX = this.layer3[i][0];
            objY = this.layer3[i][1];
        }
        this.currentObjectX = objX * 16 - this.cameraX;
        this.currentObjectY = objY * 16 - this.cameraY + 17;
        int offset = 8;
        int x = ac.globalX - this.cameraX;
        int y = ac.globalY - this.cameraY + 17;
        return this.currentObjectX + this.currentObjectW > x - offset && this.currentObjectX < x + offset && this.currentObjectY < y && this.currentObjectY > y - 32 && this.objectIsVisible(inBuffer);
    }

    public void drawTopArmies(Graphics g) {
        boolean inBuffer = g == this.game.bufferGraphics;
        byte objX = 0;
        byte objY = 0;
        for (int j = 0; j < ArmyController.instance.armyVector.size(); ++j) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(j);
            for (int i = 0; i < ac.inFrontObjectsCount; ++i) {
                int objType = ac.inFrontObjects[i] / 1000;
                int objI = ac.inFrontObjects[i] % 1000;
                if (objType == 0) {
                    objX = this.nature[objI][0];
                    objY = this.nature[objI][1];
                }
                if (objType == 1) {
                    objX = this.layer3[objI][0];
                    objY = this.layer3[objI][1];
                }
                this.currentObjectX = objX * 16 - this.cameraX;
                this.currentObjectY = objY * 16 - this.cameraY + 17;
                this.currentObjectId = this.getObjectId(objType, objI);
                this.currentObjectW = this.getObjectW();
                this.currentObjectH = this.getObjectH();
                this.drawObject(g, (byte)1, objType, objI, this.currentObjectX, this.currentObjectY);
            }
        }
    }

    public void drawOther(Graphics g, byte high, int objType) {
        boolean inBuffer = g == this.game.bufferGraphics;
        byte objX = 0;
        byte objY = 0;
        int count = 0;
        if (objType == 0) {
            count = this.natureCount;
        }
        if (objType == 1) {
            count = this.layer3Count;
        }
        if (objType == 2) {
            count = this.mapItemsCount;
        }
        if (high != 3) {
            for (int i = 0; i < count; ++i) {
                this.currentObjectId = this.getObjectId(objType, i);
                this.currentObjectH = this.getObjectH();
                if ((high == 1 || high == 3) && this.currentObjectH <= 16) continue;
                this.currentObjectW = this.getObjectW();
                if (objType == 0) {
                    objX = this.nature[i][0];
                    objY = this.nature[i][1];
                } else if (objType == 1) {
                    objX = this.layer3[i][0];
                    objY = this.layer3[i][1];
                } else if (objType == 2) {
                    objX = this.mapItems[i][0];
                    objY = this.mapItems[i][1];
                }
                this.currentObjectX = objX * 16 - this.cameraX;
                this.currentObjectY = objY * 16 - this.cameraY + 17;
                if (!this.objectIsVisible(inBuffer)) continue;
                this.drawObject(g, high, objType, i, this.currentObjectX, this.currentObjectY);
            }
        }
    }

    public void drawFlags(Graphics g) {
        int begPtr;
        if (ArmyController.instance.aiTurn) {
            return;
        }
        boolean inBuffer = g == this.game.bufferGraphics;
        boolean enemyOnPath = false;
        if (ArmyController.instance.targetID == -1) {
            return;
        }
        if (ArmyController.instance.currId == -1) {
            return;
        }
        ArmyCharacter tempArmy = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(ArmyController.instance.currId);
        int movePoints = tempArmy.movePoints;
        if (DisCanvas.instance.onTourney) {
            begPtr = ArmyController.instance.pathPtr + 1;
            --movePoints;
        } else {
            begPtr = ArmyController.instance.pathPtr;
        }
        for (int n = begPtr; n < ArmyController.instance.pathLength; ++n) {
            byte i = ArmyController.instance.path[n * 2];
            byte j = ArmyController.instance.path[n * 2 + 1];
            int x = this.getScreenX(i);
            int y = this.getScreenY(j);
            if (inBuffer) {
                x += this.bufferOffsetX;
                y += this.bufferOffsetY;
            }
            if (movePoints > 0) {
                if (!enemyOnPath) {
                    enemyOnPath = ArmyController.instance.seeAround(i, j) != -1;
                    byte id = ArmyController.instance.getId(i, j, true);
                    if (id != -1) {
                        ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(id);
                        if (ac.owner % 3 != 0) {
                            enemyOnPath = true;
                        }
                    }
                }
                g.setClip(x + 5, y - 3, this.pathFlags.getHeight() - 1, this.pathFlags.getHeight());
                g.drawImage(this.pathFlags, x - (enemyOnPath ? this.pathFlags.getHeight() : 0) + 5, y - 3, 0);
                --movePoints;
                continue;
            }
            g.setClip(x + 5, y - 3, this.pathFlags.getHeight() - 1, this.pathFlags.getHeight());
            g.drawImage(this.pathFlags, x - this.pathFlags.getHeight() * 2 + 5, y - 3, 0);
        }
    }

    public void drawObject(Graphics g, byte high, int objType, int objId, int x, int y) {
        boolean inBuffer;
        boolean bl = inBuffer = g == this.game.bufferGraphics;
        if (inBuffer) {
            x += this.bufferOffsetX;
            y += this.bufferOffsetY;
        }
        int id = this.currentObjectId;
        int collectionId = id / 50;
        byte imageIndex = imgMap[collectionId][id %= 50][0];
        int offsetX = imgMap[collectionId][id][1] * 16;
        int offsetY = imgMap[collectionId][id][2] * 16;
        int w = this.currentObjectW;
        int h = this.currentObjectH;
        if (high == 0) {
            g.setClip(x, y + h - 16, w, 16);
        } else if (high == 1 && h > 16) {
            g.setClip(x, y, w, h - 16);
        } else if (high == 2) {
            g.setClip(x, y, w, h);
        } else {
            return;
        }
        if (this.natureImg[imageIndex] == null) {
            this.natureImg[imageIndex] = Globals.loadImage(DisCanvas.imgNames[imageIndex]);
        }
        g.drawImage(this.natureImg[imageIndex], x - offsetX, y - offsetY, 0);
    }

    public int getObjectX(int objType, int objId) {
        if (objType == 0) {
            return this.getScreenX(this.nature[objId][0]);
        }
        if (objType == 1) {
            return this.getScreenX(this.layer3[objId][0]);
        }
        if (objType == 2) {
            return this.getScreenX(this.mapItems[objId][0]);
        }
        if (objType == 3) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(objId);
            return this.getScreenX(ac.x);
        }
        return -1;
    }

    public int getObjectY(int objType, int objId) {
        if (objType == 0) {
            return this.getScreenY(this.nature[objId][1]);
        }
        if (objType == 1) {
            return this.getScreenY(this.layer3[objId][1]);
        }
        if (objType == 2) {
            return this.getScreenY(this.mapItems[objId][1]);
        }
        if (objType == 3) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(objId);
            return this.getScreenY(ac.y);
        }
        return -1;
    }

    public int getObjectId(int objType, int objId) {
        if (objType == 0) {
            return this.nature[objId][2];
        }
        if (objType == 1) {
            return this.layer3[objId][2];
        }
        if (objType == 2) {
            return this.mapItems[objId][2];
        }
        return -1;
    }

    public int getObjectW() {
        int id = this.currentObjectId;
        int collectionId = id / 50;
        return imgMap[collectionId][id %= 50][3] * 16;
    }

    public int getObjectH() {
        int id = this.currentObjectId;
        int collectionId = id / 50;
        return imgMap[collectionId][id %= 50][4] * 16;
    }

    public boolean objectIsVisible(boolean inBuffer) {
        int x = this.currentObjectX;
        int y = this.currentObjectY;
        if (inBuffer) {
            x += this.bufferOffsetX;
            y += this.bufferOffsetY;
        }
        int w = this.currentObjectW;
        int h = this.currentObjectH;
        if (x + w <= 0) {
            return false;
        }
        if (x >= this.screenWidth + 16) {
            return false;
        }
        if (y + h < 17) {
            return false;
        }
        return y <= this.screenHeight + 17 + 16;
    }

    public boolean objectNotFoW(boolean inBuffer, int objType, int objId) {
        int x = this.getObjectX(objType, objId);
        int y = this.getObjectY(objType, objId);
        if (inBuffer) {
            x += this.bufferOffsetX;
            y += this.bufferOffsetY;
        }
        int w = this.getObjectW();
        int h = this.getObjectH();
        return this.objectNotFoW(x, y, w, h);
    }

    public byte isItemOnCell(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return -1;
        }
        if ((this.tiles[x][y] & 0x40) == 0 && !ArmyController.instance.aiTurn) {
            return -1;
        }
        for (byte i = 0; i < this.mapItemsCount; i = (byte)(i + 1)) {
            if (this.mapItems[i][0] != x || this.mapItems[i][1] != y) continue;
            return i;
        }
        return -1;
    }

    public byte isMineOnCell(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return -1;
        }
        if ((this.tiles[x][y] & 0x40) == 0 && !ArmyController.instance.aiTurn) {
            return -1;
        }
        for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            if (this.layer3[i][0] != x || this.layer3[i][1] != y || this.layer3[i][2] < 53 || this.layer3[i][2] > 55) continue;
            return i;
        }
        return -1;
    }

    public boolean findMine(byte owner) {
        for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            if (this.layer3[i][2] != 53 || this.layer3[i][4] != owner) continue;
            return true;
        }
        return false;
    }

    public void restoreRes(byte owner) {
        block5: for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            if (this.layer3[i][2] < 53 || this.layer3[i][2] > 55 || this.layer3[i][4] != owner) continue;
            switch (this.layer3[i][2] - 53) {
                case 0: {
                    int n = owner * 3;
                    DisCanvas.instance.res[n] = DisCanvas.instance.res[n] + 50;
                    continue block5;
                }
                case 1: {
                    int n = owner * 3 + 2;
                    DisCanvas.instance.res[n] = DisCanvas.instance.res[n] + 50;
                    continue block5;
                }
                case 2: {
                    int n = owner * 3 + 1;
                    DisCanvas.instance.res[n] = DisCanvas.instance.res[n] + 50;
                }
            }
        }
    }

    public byte isTownOnCellAi(int x, int y) {
        for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            byte entranceX = 1;
            int entranceY = 3;
            if (this.layer3[i][2] < 50 || this.layer3[i][2] > 52) continue;
            if (this.layer3[i][2] == 52) {
                entranceY = 2;
            }
            if (this.layer3[i][0] + entranceX != x || this.layer3[i][1] + entranceY != y) continue;
            DisCanvas.instance.currentTownId = i;
            return i;
        }
        return -1;
    }

    public byte isTownOnCell(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return -1;
        }
        if ((this.tiles[x][y] & 0x40) == 0 && !ArmyController.instance.aiTurn) {
            return -1;
        }
        for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            byte entranceX = 1;
            int entranceY = 3;
            if (this.layer3[i][2] != 50 && this.layer3[i][2] != 51 && this.layer3[i][2] != 52) continue;
            if (this.layer3[i][2] == 52) {
                entranceY = 2;
            }
            if (this.layer3[i][0] + entranceX != x || this.layer3[i][1] + entranceY != y) continue;
            if (this.layer3[i][5] != -1 && !ArmyController.instance.aiTurn) {
                DisCanvas.instance.findLeaderInCapital(i);
                if (DisCanvas.instance.capitals[this.layer3[i][5]][1] != -1) {
                    return -1;
                }
            }
            DisCanvas.instance.currentTownId = i;
            return i;
        }
        return -1;
    }

    public byte isTownBodyOnCell(int x, int y, boolean inf) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return -1;
        }
        if ((this.tiles[x][y] & 0x40) == 0 && !ArmyController.instance.aiTurn) {
            return -1;
        }
        for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            byte entranceX = 1;
            int entranceY = 3;
            if (this.layer3[i][2] != 50 && this.layer3[i][2] != 51 && this.layer3[i][2] != 52) continue;
            if (this.layer3[i][2] == 52) {
                entranceY = 2;
            }
            if (this.layer3[i][0] + entranceX == x && this.layer3[i][1] + entranceY == y) {
                if (ArmyController.instance.getId() != -1 && inf) {
                    return -1;
                }
                DisCanvas.instance.findLeaderInCapital(i);
                if (this.layer3[i][5] != -1 && DisCanvas.instance.capitals[this.layer3[i][5]][1] != -1 && inf) {
                    return -1;
                }
            }
            if (x < this.layer3[i][0] || x >= this.layer3[i][0] + 3 || y < this.layer3[i][1] || y > this.layer3[i][1] + entranceY) continue;
            return i;
        }
        return -1;
    }

    public byte isBuildingOnCell(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return -1;
        }
        if ((this.tiles[x][y] & 0x40) == 0 && !ArmyController.instance.aiTurn) {
            return -1;
        }
        for (byte i = 0; i < this.layer3Count; i = (byte)(i + 1)) {
            if (this.layer3[i][0] + 1 != x || this.layer3[i][1] + 1 != y || this.layer3[i][2] < 56 || this.layer3[i][2] > 58) continue;
            return i;
        }
        return -1;
    }

    public byte isUnitOnCell(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return -1;
        }
        if ((this.tiles[x][y] & 0x40) == 0) {
            return -1;
        }
        for (byte i = 0; i < ArmyController.instance.armyVector.size(); i = (byte)((byte)(i + 1))) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i);
            if (ac.owner >= 3 || !ac.visible || ac.x != x || ac.y != y) continue;
            return i;
        }
        return -1;
    }

    public boolean objectNotFoW(int x, int y, int w, int h) {
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                if ((this.tiles[i][j] & 0x40) == 0) continue;
                if (this.getScreenX(i) <= x + w && this.getScreenY(j) <= y + h && this.getScreenX(i) >= x && this.getScreenY(j) >= y) {
                    return true;
                }
                if (x > this.getScreenX(i) + 16 || y > this.getScreenY(j) + 16 || x < this.getScreenX(i) || y < this.getScreenY(j)) continue;
                return true;
            }
        }
        return false;
    }

    public int getScreenX(int x) {
        return x * 16 - this.cameraX;
    }

    public int getScreenY(int y) {
        return y * 16 - this.cameraY + 17;
    }

    public int getScreenXFloat(int x) {
        return x * 16 / 10000 - this.cameraX;
    }

    public int getScreenYFloat(int y) {
        return y * 16 / 10000 - this.cameraY + 17;
    }

    public void moveCamera() {
        int x = this.game.cursorX * 16 - this.cameraX;
        int y = this.game.cursorY * 16 - this.cameraY + 17;
        this.moveCamera(x, y, false);
    }

    public void moveCamera(int x, int y, boolean centered) {
        this.screenHeight = 306 - DisCanvas.instance.userBarHeight - 17;
        int xoffset = 32;
        int yoffset = 32;
        if (!centered) {
            if (x < xoffset - 16) {
                this.cameraFloatX += (x - (xoffset - 16)) * 10000 / this.cameraSpeed;
            }
            if (y < 17 + yoffset - 16) {
                this.cameraFloatY += (y - (17 + yoffset - 16)) * 10000 / this.cameraSpeed;
            }
            if (x > this.screenWidth - xoffset) {
                this.cameraFloatX += (x - (this.screenWidth - xoffset)) * 10000 / this.cameraSpeed;
            }
            if (y > this.screenHeight + 17 - yoffset) {
                this.cameraFloatY += (y - (this.screenHeight + 17 - yoffset)) * 10000 / this.cameraSpeed;
            }
        } else {
            this.cameraFloatX += (x - this.screenWidth / 2) * 10000 / this.cameraSpeed;
            this.cameraFloatY += (y - (this.screenHeight / 2 + 17)) * 10000 / this.cameraSpeed;
        }
        this.cameraFloatX = Globals.clip(this.cameraFloatX, 0, (this.pixelWidth - this.screenWidth) * 10000);
        this.cameraFloatY = Globals.clip(this.cameraFloatY, 0, (this.pixelHeight - this.screenHeight) * 10000);
        this.cameraX = this.cameraFloatX / 10000;
        this.cameraY = this.cameraFloatY / 10000;
    }

    void drawMinimap(Graphics g, int x, int y) {
        int i;
        int SCALE = 180 / this.width;
        g.setClip(x - 1, y - 1, this.width * SCALE + 2, this.height * SCALE + 2);
        for (int j = 0; j < this.height; ++j) {
            for (int i2 = 0; i2 < this.width; ++i2) {
                int curTileType = 0xFF & this.tiles[i2][j];
                if ((curTileType & 0x40) == 0) continue;
                curTileType &= 0x3F;
                if ((curTileType &= 0xBF) == 63) {
                    g.setColor(0x277F7F);
                } else {
                    g.setColor(MINIMAP_COLORS[curTileType]);
                }
                g.fillRect(x + i2 * SCALE, y + j * SCALE, SCALE, SCALE);
            }
        }
        int MINIMAP_NATURE_COLOR = 5976832;
        int MINIMAP_ENEMY_COLOR = 0xFF0000;
        int MINIMAP_NEUTRAL_COLOR = 16756224;
        int MINIMAP_OBJECTS_COLOR = 3716425;
        int MINIMAP_PLAYER_COLOR = 2131959;
        int MINIMAP_GOLD_MINE_COLOR = 0xFFF200;
        int MINIMAP_LIFE_MANA_MINE_COLOR = 7667709;
        int MINIMAP_DEATH_HMANA_MINE_COLOR = 0xFF8B8B;
        g.setColor(5976832);
        for (i = 0; i < this.natureCount; ++i) {
            if (!this.objectNotFoW(false, 0, i)) continue;
            this.currentObjectId = this.nature[i][2];
            if (this.currentObjectId >= 2) continue;
            g.fillRect(x + this.nature[i][0] * SCALE, y + this.nature[i][1] * SCALE, SCALE * this.getObjectW() / 16, SCALE * this.getObjectH() / 16);
        }
        for (i = 0; i < this.layer3Count; ++i) {
            g.setColor(3716425);
            if (!this.objectNotFoW(false, 1, i)) continue;
            this.currentObjectId = this.layer3[i][2];
            if (this.currentObjectId == 53) {
                g.setColor(0xFFF200);
            }
            if (this.currentObjectId == 55) {
                g.setColor(7667709);
            }
            if (this.currentObjectId == 54) {
                g.setColor(0xFF8B8B);
            }
            if (this.currentObjectId == 50) {
                g.setColor(2131959);
            }
            if (this.currentObjectId == 51) {
                g.setColor(0xFF0000);
            }
            if (this.currentObjectId == 52) {
                byte currentTown = this.layer3[i][5];
                byte armyIndex = DisCanvas.instance.capitals[currentTown][0];
                ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(armyIndex);
                if (ac.owner % 3 == 0) {
                    g.setColor(2131959);
                }
                if (ac.owner % 3 == 1) {
                    g.setColor(0xFF0000);
                }
                if (ac.owner % 3 == 2) {
                    g.setColor(16756224);
                }
            }
            g.fillRect(x + this.layer3[i][0] * SCALE, y + this.layer3[i][1] * SCALE, SCALE * this.getObjectW() / 16, SCALE * this.getObjectH() / 16);
            if (this.currentObjectId == 50 || this.currentObjectId == 51) {
                if (this.currentObjectId == 50) {
                    g.setColor(7667709);
                }
                if (this.currentObjectId == 51) {
                    g.setColor(0xFF8B8B);
                }
                g.drawRect(x + this.layer3[i][0] * SCALE, y + this.layer3[i][1] * SCALE, SCALE * this.getObjectW() / 16 - 1, SCALE * this.getObjectH() / 16 - 1);
            }
            if (this.currentObjectId != 53 && this.currentObjectId != 55 && this.currentObjectId != 54) continue;
            if (this.layer3[i][4] == 0) {
                g.setColor(2131959);
            } else if (this.layer3[i][4] == 1) {
                g.setColor(0xFF0000);
            } else {
                g.setColor(16756224);
            }
            g.drawRect(x + this.layer3[i][0] * SCALE, y + this.layer3[i][1] * SCALE, SCALE * this.getObjectW() / 16 - 1, SCALE * this.getObjectH() / 16 - 1);
        }
        for (i = 0; i < ArmyController.instance.armyVector.size(); ++i) {
            ArmyCharacter ac = (ArmyCharacter)ArmyController.instance.armyVector.elementAt(i);
            if (ac.owner > 2) continue;
            if (ac.owner == 0) {
                g.setColor(2131959);
            }
            if (ac.owner == 1) {
                g.setColor(0xFF0000);
            }
            if (ac.owner == 2) {
                g.setColor(16756224);
            }
            g.fillArc(x + ac.x * SCALE, y + ac.y * SCALE, SCALE, SCALE, 0, 360);
        }
        for (int j = 0; j < this.height; ++j) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                int curTileType = 0xFF & this.tiles[i3][j];
                if ((curTileType & 0x40) != 0) continue;
                g.setColor(0);
                g.fillRect(x + i3 * SCALE, y + j * SCALE, SCALE, SCALE);
            }
        }
        g.setClip(x - 1, y - 1, this.width * SCALE + 2, this.height * SCALE + 2);
        g.setColor(0xFFFFFF);
        g.drawRect(x - 1, y - 1, this.width * SCALE + 1, this.height * SCALE + 1);
    }

    void drawMinimap(Graphics g) {
        int SCALE = 180 / this.width;
        int x = (240 - this.width * SCALE) / 2;
        int y = 17 + (this.screenHeight - this.height * SCALE) / 2;
        g.setClip(0, 0, 240, 320);
        g.drawImage(this.minimapBufferImg, x - 1, y - 1, 0);
        g.setColor(0xFFFFFF);
        int minimapCameraX = this.cameraX * SCALE / 16;
        int minimapCameraY = this.cameraY * SCALE / 16;
        int minimapCameraW = this.screenWidth * SCALE / 16 - 1;
        int minimapCameraH = this.screenHeight * SCALE / 16;
        g.drawRect(x + minimapCameraX, y + minimapCameraY, minimapCameraW, minimapCameraH);
    }

    void destroyMinimap() {
        this.minimapBufferGraphics = null;
        this.minimapBufferImg = null;
    }

    void initMinimap() {
        int SCALE = 180 / this.width;
        this.minimapBufferImg = Image.createImage((int)(this.width * SCALE + 2), (int)(this.height * SCALE + 2));
        this.minimapBufferGraphics = this.minimapBufferImg.getGraphics();
        this.drawMinimap(this.minimapBufferGraphics, 1, 1);
    }

    static {
        imgMap = new byte[][][]{new byte[][]{{0, 0, 2, 2, 2}, {0, 0, 4, 1, 2}, {0, 0, 0, 1, 1}, {0, 1, 0, 1, 1}, {0, 2, 0, 1, 1}, {0, 3, 0, 1, 1}, {0, 4, 0, 1, 1}, {0, 5, 0, 1, 1}, {0, 6, 0, 1, 1}, {0, 7, 0, 1, 1}, {0, 0, 1, 1, 1}, {0, 1, 1, 1, 1}, {0, 2, 1, 1, 1}, {0, 0, 10, 1, 1}, {0, 2, 2, 1, 2}, {0, 3, 2, 2, 2}, {0, 1, 10, 1, 1}, {0, 5, 2, 2, 2}, {0, 7, 2, 2, 2}, {0, 2, 10, 1, 1}, {1, 0, 0, 2, 2}}, new byte[][]{{0, 0, 6, 3, 4}, {0, 3, 7, 3, 4}, {0, 3, 4, 3, 3}, {0, 3, 1, 1, 1}, {0, 4, 1, 1, 1}, {0, 5, 1, 1, 1}, {0, 6, 8, 2, 2}, {0, 6, 4, 2, 2}, {0, 6, 6, 2, 2}, {0, 1, 4, 1, 2}, {0, 2, 4, 1, 2}}, new byte[][]{{0, 6, 10, 1, 1}, {0, 7, 10, 1, 1}}, new byte[][]{{3, 0, 0, 1, 2}, {2, 1, 0, 1, 2}, {2, 2, 0, 1, 2}, {2, 3, 0, 1, 2}, {4, 4, 0, 1, 2}, {2, 5, 0, 1, 2}, {2, 6, 0, 1, 2}, {2, 7, 0, 1, 2}, {2, 8, 0, 1, 2}, {2, 9, 0, 1, 2}, {2, 10, 0, 1, 2}, {2, 11, 0, 1, 2}, {2, 12, 0, 1, 2}, {2, 13, 0, 1, 2}, {2, 14, 0, 1, 2}}};
        MINIMAP_COLORS = new int[]{6444598, 6052406, 5923661, 5660493, 5924693, 6121299, 5794392, 0x556D5D, 6906695, 6445886, 6381122, 6644296, 4158573, 3963251, 4026216, 3830636, 4530453, 5972498, 5126693, 4993825, 5324070, 4797729, 5192998, 5126949, 4731423, 4467996, 4600095, 4468253, 5851694, 5654573, 5654060, 5654060, 2839572, 3694111, 4411171, 4149281, 4346147, 3690781, 4214305, 4476964, 4017951, 3230745, 3428378, 3558684, 5330733, 5001256, 4935208, 4672549};
    }
}

