/*
 * Decompiled with CFR 0.152.
 */
package joybits.disciples;

import javax.microedition.lcdui.Graphics;
import joybits.disciples.ArmyController;
import joybits.disciples.Battle;
import joybits.disciples.DisCanvas;
import joybits.disciples.GlobalConstants;
import joybits.disciples.Map;
import joybits.disciples.StringParamInterface;

public class ArmyCharacter
implements GlobalConstants,
StringParamInterface {
    public byte movePoints;
    public byte vision;
    public byte x;
    public byte y;
    public int globalX;
    public int globalY;
    public byte ay = 0;
    public byte nx = (byte)-1;
    public byte ny = (byte)-1;
    public byte owner;
    public byte leader;
    public byte leadership;
    public byte direction;
    public byte frame = 0;
    public byte tick = 0;
    public byte animShiftX = 0;
    public byte animShiftY = 0;
    public boolean visible;
    public byte id;
    public boolean noTarget;
    public byte currentWindow;
    public short[] inFrontObjects;
    public byte inFrontObjectsCount;
    public short[] units = new short[]{0, 0, 0, 0, 0, 0};
    public byte heroName;
    public boolean isInTownAdditionalCheck = true;
    public boolean[] abilities;
    public byte[] slot;
    public byte[] inhand = new byte[]{-1, -1};
    public byte handcount;
    public byte[] counts;
    public byte[] equip = new byte[]{-1, -1, -1, -1, -1, -1};
    public byte slotcount;
    public static byte[] gmHeroesParam = new byte[]{10, 15, 10, 10, 10, 15, 10, 10};

    public byte artefactType(byte artefact) {
        switch (artefact) {
            case 2: 
            case 3: {
                return 0;
            }
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: 
            case 8: 
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 13: 
            case 14: {
                return 5;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return 6;
            }
            case 0: 
            case 1: {
                return 7;
            }
        }
        return -1;
    }

    public void artefactEquip(byte id) {
        byte i = this.artefactType(this.slot[id]);
        if (i == 1 && !this.abilities[3]) {
            return;
        }
        if (i == 0 && !this.abilities[0]) {
            return;
        }
        if (i > 5) {
            return;
        }
        if (i != -1) {
            this.equip[i] = id;
        }
        this.postCalculate(i);
    }

    public boolean isHandEquip(byte id) {
        if (this.handcount == 0) {
            return false;
        }
        if (this.handcount == 1 && this.inhand[0] == id) {
            return true;
        }
        return this.handcount == 2 && (this.inhand[1] == id || this.inhand[0] == id);
    }

    public void handEquip(byte id) {
        byte i = this.artefactType(this.slot[id]);
        if (this.handcount < 0) {
            this.handcount = 0;
        }
        if (i == 6 || i == 7 || i == 5) {
            switch (this.handcount) {
                case 0: {
                    this.inhand[0] = id;
                    this.handcount = 1;
                    break;
                }
                case 1: {
                    if (this.inhand[0] == id) break;
                    this.inhand[1] = this.inhand[0];
                    this.inhand[0] = id;
                    this.handcount = (byte)2;
                    break;
                }
                case 2: {
                    if (this.inhand[0] == id || this.inhand[1] == id) break;
                    this.inhand[1] = this.inhand[0];
                    this.inhand[0] = id;
                }
            }
        }
    }

    public void handUnEquip(byte id) {
        switch (this.handcount) {
            case 1: {
                if (this.inhand[0] != id) break;
                this.inhand[0] = -1;
                this.handcount = 0;
                break;
            }
            case 2: {
                if (this.inhand[0] == id) {
                    this.inhand[0] = this.inhand[1];
                    this.handcount = 1;
                    break;
                }
                if (this.inhand[1] != id) break;
                this.inhand[1] = -1;
                this.handcount = 1;
            }
        }
    }

    public void artefactUnEquip(byte id) {
        byte i = this.artefactType(this.slot[id]);
        for (int a = 0; a < 6; a = (int)((byte)(a + 1))) {
            if (this.equip[a] != id) continue;
            this.equip[a] = -1;
        }
        this.postCalculate(i);
    }

    public void postCalculate(byte artId) {
        switch (artId) {
            case 0: {
                if (this.maxMP(this.owner, false) >= this.movePoints) break;
                this.movePoints = this.maxMP(this.owner, false);
            }
        }
    }

    public boolean isEquipped(byte id) {
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (this.equip[i] != id) continue;
            return true;
        }
        return false;
    }

    public void initGlobalParams() {
        this.leadership = (byte)2;
        this.vision = (byte)3;
        if (this.leader == -1) {
            return;
        }
        if (this.units[this.leader] == -1) {
            return;
        }
        short id = ArmyController.instance.battleUnits[this.units[this.leader] * 5 + 0];
        if (this.owner >= 3 && id > 7 && id < 42) {
            this.leader = (byte)-1;
        }
        switch (id) {
            case 0: 
            case 4: {
                this.vision = (byte)3;
                this.leadership = (byte)4;
                break;
            }
            case 1: 
            case 5: {
                this.abilities[0] = true;
                this.vision = (byte)4;
                this.leadership = (byte)4;
                break;
            }
            case 2: 
            case 6: {
                this.abilities[2] = true;
                this.vision = (byte)3;
                this.leadership = (byte)2;
                break;
            }
            case 3: 
            case 7: {
                this.abilities[1] = true;
                this.vision = (byte)3;
                this.leadership = (byte)4;
                break;
            }
            case 42: 
            case 43: {
                this.leadership = (byte)6;
            }
        }
        this.movePoints = id <= 7 ? gmHeroesParam[id] : (byte)0;
        this.heroName = (byte)(id + 85);
        if (this.abilities[4]) {
            this.movePoints = (byte)(this.movePoints + this.movePoints / 5);
        }
        if (this.abilities[8]) {
            this.movePoints = (byte)(this.movePoints + this.movePoints / 4);
        }
    }

    public ArmyCharacter() {
        this.init();
    }

    public ArmyCharacter(byte ix, byte iy, byte leader, byte owner) {
        this.currentWindow = (byte)4;
        this.noTarget = false;
        this.x = ix;
        this.y = iy;
        this.leader = leader;
        this.owner = owner;
        this.init();
        if (owner == 0) {
            for (byte i = 0; i < 2; i = (byte)(i + 1)) {
                this.addArtefact(i);
            }
        }
    }

    public void init() {
        int i;
        this.slot = new byte[64];
        this.counts = new byte[64];
        this.direction = (byte)2;
        this.slotcount = 0;
        this.handcount = 0;
        this.abilities = new boolean[14];
        for (i = 0; i < 14; ++i) {
            this.abilities[i] = false;
        }
        this.inFrontObjectsCount = 0;
        this.inFrontObjects = new short[5];
        for (i = 0; i < 3; ++i) {
            this.inFrontObjects[i] = -1;
        }
    }

    public void setUnit(byte id, byte type) {
        this.units[id] = type;
    }

    public boolean addArtefact(byte id) {
        if (id < 0) {
            return false;
        }
        for (int i = 0; i < this.slotcount; ++i) {
            if (this.slot[i] != id) continue;
            int n = i;
            this.counts[n] = (byte)(this.counts[n] + 1);
            return true;
        }
        if (this.slotcount >= 30) {
            return false;
        }
        this.slot[this.slotcount] = id;
        this.counts[this.slotcount] = 1;
        this.slotcount = (byte)(this.slotcount + 1);
        return true;
    }

    public void findInFrontObjects() {
        this.inFrontObjectsCount = 0;
        boolean inBuffer = true;
        int count = 0;
        for (int objType = 0; objType < 2; ++objType) {
            if (objType == 0) {
                count = Map.instance.natureCount;
            }
            if (objType == 1) {
                count = Map.instance.layer3Count;
            }
            for (int i = 0; i < count; ++i) {
                if (!Map.instance.objectIsInFrontOfUnit(inBuffer, i, objType, this)) continue;
                System.out.println("inFrontObjectsCount = " + this.inFrontObjectsCount);
                this.inFrontObjects[this.inFrontObjectsCount] = (short)(i + objType * 1000);
                this.inFrontObjectsCount = (byte)(this.inFrontObjectsCount + 1);
            }
        }
    }

    public void delArtefact(byte index) {
        if (index == -1) {
            return;
        }
        int n = index;
        this.counts[n] = (byte)(this.counts[n] - 1);
        if (this.counts[index] > 0) {
            return;
        }
        for (int j = 0; j < 6; j = (int)((byte)(j + 1))) {
            if (this.equip[j] == index) {
                this.equip[j] = -1;
            }
            if (this.equip[j] <= index) continue;
            int n2 = j;
            this.equip[n2] = (byte)(this.equip[n2] - 1);
        }
        switch (this.handcount) {
            case 1: {
                if (this.inhand[0] == index) {
                    this.inhand[0] = -1;
                    this.handcount = 0;
                    break;
                }
                if (index >= this.inhand[0]) break;
                this.inhand[0] = (byte)(this.inhand[0] - 1);
                break;
            }
            case 2: {
                if (this.inhand[0] == index) {
                    this.inhand[0] = index < this.inhand[1] ? (byte)(this.inhand[1] - 1) : this.inhand[1];
                    this.handcount = 1;
                } else if (index < this.inhand[0]) {
                    this.inhand[0] = (byte)(this.inhand[0] - 1);
                }
                if (this.inhand[1] == index) {
                    this.inhand[1] = -1;
                    this.handcount = 1;
                    break;
                }
                if (index >= this.inhand[1]) break;
                this.inhand[1] = (byte)(this.inhand[1] - 1);
            }
        }
        for (int i = index; i < this.slotcount - 1; ++i) {
            if (i + 1 >= this.slotcount) continue;
            this.slot[i] = this.slot[i + 1];
            this.counts[i] = this.counts[i + 1];
        }
        this.slotcount = (byte)(this.slotcount - 1);
    }

    public void postAbilitySelect(byte abGet) {
        switch (abGet) {
            case 11: {
                this.vision = (byte)(this.vision + 1);
                break;
            }
            case 5: 
            case 9: {
                this.leadership = (byte)(this.leadership + 1);
            }
        }
    }

    public boolean findArtefact(byte artefact) {
        for (byte i = 0; i < this.slotcount; i = (byte)(i + 1)) {
            if (this.slot[i] != artefact) continue;
            return true;
        }
        return false;
    }

    public byte getArtefactSlot(byte artefact) {
        for (byte i = 0; i < this.slotcount; i = (byte)(i + 1)) {
            if (this.slot[i] != artefact) continue;
            return i;
        }
        return -1;
    }

    public int calculateInitiative(int baseI) {
        if (this.isEquippedArt((byte)5)) {
            return baseI / 10;
        }
        return 0;
    }

    public int calculateDamage(int baseD) {
        int add = 0;
        if (this.isEquippedArt((byte)6)) {
            add += baseD / 10;
        }
        if (this.isEquippedArt((byte)7)) {
            add += baseD / 10;
        }
        if (this.isEquippedArt((byte)8)) {
            add += baseD / 6;
        }
        if (this.isEquippedArt((byte)9)) {
            add += baseD / 4;
        }
        return add;
    }

    public int calculateDefence(short baseDef, short unitType) {
        int add = 0;
        if (this.isEquippedArt((byte)4)) {
            add += 10;
        }
        if (unitType <= 8) {
            if (this.isEquippedArt((byte)10)) {
                add += 10;
            }
            if (this.isEquippedArt((byte)11)) {
                add += 15;
            }
        }
        return add;
    }

    public boolean isEquippedArt(byte artId) {
        for (byte i = 0; i < this.slotcount; i = (byte)(i + 1)) {
            if (this.slot[i] != artId) continue;
            for (int j = 0; j < 6; j = (int)((byte)(j + 1))) {
                if (this.equip[j] != i) continue;
                return true;
            }
        }
        return false;
    }

    public byte maxMP(byte owner, boolean init) {
        byte movePoints;
        if (this.leader == -1) {
            return 0;
        }
        if (this.units[this.leader] == -1) {
            return 0;
        }
        short id = ArmyController.instance.battleUnits[this.units[this.leader] * 5 + 0];
        if (id > 7) {
            return -1;
        }
        byte newMovePoints = movePoints = gmHeroesParam[id];
        if (this.owner != owner) {
            return -1;
        }
        if (this.abilities[8]) {
            newMovePoints = (byte)(newMovePoints + movePoints / 4);
        } else if (this.abilities[4]) {
            newMovePoints = (byte)(newMovePoints + movePoints / 5);
        }
        if (this.isEquippedArt((byte)3)) {
            newMovePoints = (byte)(newMovePoints + movePoints / 2);
        }
        if (this.isEquippedArt((byte)2)) {
            newMovePoints = (byte)(newMovePoints + movePoints / 4);
        }
        movePoints = newMovePoints;
        if (init) {
            this.movePoints = movePoints;
        }
        return movePoints;
    }

    public void draw(Graphics g, boolean selected) {
        int innOffsetY;
        int innOffsetX;
        boolean inBuffer;
        boolean bl = inBuffer = g == DisCanvas.instance.bufferGraphics;
        if (this.owner >= 3) {
            return;
        }
        int objX = this.globalX - Map.instance.cameraX;
        int objY = this.globalY - Map.instance.cameraY + 17;
        if (inBuffer) {
            objX += Map.instance.bufferOffsetX;
            objY += Map.instance.bufferOffsetY;
        }
        if (Map.instance.shaking) {
            objX += Map.instance.shakeX;
            objY += Map.instance.shakeY;
        }
        boolean openedIsNear = false;
        byte width = Map.instance.width;
        byte height = Map.instance.height;
        if (this.y != 0 && (Map.instance.tiles[this.x][this.y - 1] & 0x40) != 0) {
            openedIsNear = true;
        }
        if (this.x != width - 1 && this.y != 0 && (Map.instance.tiles[this.x + 1][this.y - 1] & 0x40) != 0) {
            openedIsNear = true;
        }
        if (this.x != 0 && this.y != 0 && (Map.instance.tiles[this.x - 1][this.y - 1] & 0x40) != 0) {
            openedIsNear = true;
        }
        if (!openedIsNear && (Map.instance.tiles[this.x][this.y] & 0x40) == 0) {
            return;
        }
        if (selected) {
            innOffsetX = -8;
            innOffsetY = -8;
            g.setClip(objX + innOffsetX, objY + innOffsetY, 16, 16);
            g.drawImage(DisCanvas.instance.gameCursorSelection, objX + innOffsetX, objY + innOffsetY, 0);
        }
        if (!selected && DisCanvas.instance.cursorX == this.x && DisCanvas.instance.cursorY == this.y) {
            innOffsetX = -8;
            innOffsetY = -8;
            g.setClip(objX + innOffsetX, objY + innOffsetY, 16, 16);
            g.drawImage(DisCanvas.instance.gameCursorOver, objX + innOffsetX, objY + innOffsetY, 0);
        }
        if (this.isInTown() && this.isInTownAdditionalCheck) {
            g.setClip(objX - 7, objY - 17, 14, 17);
            g.drawImage(DisCanvas.instance.cityPartyImg, objX - 7 - this.owner * 14, objY - 17, 0);
            return;
        }
        short unitType = ArmyController.instance.battleUnits[this.units[this.leader] * 5 + 0];
        int animIndex = -1;
        if (unitType <= 7) {
            animIndex = Battle.HEROES_ANIMATIONS + unitType * 8;
            animIndex += this.direction;
            if (DisCanvas.instance.onTourney && selected) {
                animIndex += 4;
            }
        } else {
            animIndex = Battle.NEUTRAL_ANIMATIONS + (unitType - 7) - 1;
        }
        Battle.instance.drawFrame(g, objX, objY, animIndex, unitType + 3, this.frame, false);
    }

    public byte unitsCount() {
        byte count = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.units[i] == -1) continue;
            count = (byte)(count + 1);
        }
        return count;
    }

    public boolean isInTown() {
        byte t = Map.instance.isTownOnCellAi(this.x, this.y);
        if (t != -1) {
            DisCanvas.instance.capitals[Map.instance.layer3[t][5]][2] = t;
            return true;
        }
        return false;
    }
}

