/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Anim {
    public static final int NOFLIP = 0;
    public static final int HFLIP = 1;
    public static final int VFLIP = 2;
    public static final int ANIM_TYPE_NORMAL = 0;
    public static final int ANIM_TYPE_HFLIP = 1;
    public static final int ANIM_TYPE_VFLIP = 2;
    public static final int ANIM_TYPE_HVFLIP = 3;
    public static final int ANIM_MASK_NONE = 0;
    public static final int ANIM_MASK_SINGLE = 1;
    public static final int ANIM_MASK_ALL = 2;
    private CCanvas canvas;
    private int px;
    private int py;
    public Image frames;
    public int lx;
    public int ly;
    public int n_frames_ex;
    public int n_rows;
    public int type;
    public int res_index;
    public int pindex;

    public Anim(CCanvas canvas, int total_lx, int total_ly, int _n_frames_ex, int _n_rows, int _type, int _mask_type, Image _frames, int _px, int _py, boolean optimize, int res_index, int pindex, boolean transp_on) {
        this.canvas = canvas;
        this.res_index = res_index;
        this.pindex = pindex;
        this.px = _px;
        this.py = _py;
        this.n_frames_ex = _n_frames_ex;
        this.n_rows = _n_rows;
        this.type = _type;
        int n_frames_total = this.n_frames_ex;
        this.ly = total_ly;
        _type &= 0xF;
        this.frames = _frames;
        this.lx = total_lx / n_frames_total;
        this.ly /= _n_rows;
        boolean is_native = false;
        if (!is_native) {
            if (this.type == 1 || this.type == 2) {
                this.ly >>= 1;
            } else if (this.type == 3) {
                this.ly >>= 2;
            }
        }
        if (optimize) {
            // empty if block
        }
    }

    public final void disp(int x, int y, int frame_x, int frame_y) {
        CCanvas canvas = this.canvas;
        Graphics g = canvas.graphics;
        int cx0 = x;
        int cy0 = y;
        int cx1 = x + this.lx;
        int cy1 = y + this.ly;
        if (canvas.clip_x0 > cx0) {
            cx0 = canvas.clip_x0;
        }
        if (canvas.clip_y0 > cy0) {
            cy0 = canvas.clip_y0;
        }
        if (canvas.clip_x1 < cx1) {
            cx1 = canvas.clip_x1;
        }
        if (canvas.clip_y1 < cy1) {
            cy1 = canvas.clip_y1;
        }
        g.setClip(cx0, cy0, cx1 - cx0, cy1 - cy0);
        if (this.type == 2) {
            frame_y = (frame_y & 2) != 0 ? 1 : 0;
        }
        g.drawImage(this.frames, x - frame_x * this.lx - this.px, y - this.ly * frame_y - this.py, 0);
    }

    public final void disp_part(int x, int y, int frame_x, int frame_y, int x_offset, int y_offset, int width, int height) {
        int cx0 = this.canvas.clip_x0;
        int cy0 = this.canvas.clip_y0;
        int clx = this.canvas.clip_lx;
        int cly = this.canvas.clip_ly;
        this.canvas.set_clip(x + x_offset, y + y_offset, width, height);
        this.disp(x, y, frame_x, frame_y);
        this.canvas.set_clip(cx0, cy0, clx, cly);
    }
}

