/*
 * Decompiled with CFR 0.152.
 */
public final class IngameMenu {
    public static final int MAX_ROWS_WEAPONS = 6;
    public static final int MAX_ROWS_BUILDINGS = 5;
    public static final int INFINITE = -1;
    public static final int NOT_AVAILABLE = -2;
    private static final int Y_PADDING = 8;
    private Ingame ingame;
    private int slx;
    private int sly;
    private Anim menu_topleft;
    private Anim menu_top;
    private Anim menu_topright;
    private Anim menu_left;
    private Anim menu_middle;
    private Anim menu_right;
    private Anim menu_bottomleft;
    private Anim menu_bottom;
    private Anim menu_bottomright;
    private Anim menu_selection;
    private Anim menu_mask;
    private Anim menu_icons;
    private Anim special_flags;
    private char tiles_x;
    private char tiles_y;
    private char offset_x;
    private char offset_y;
    public char menu_choice_row;
    public char menu_choice_column;
    public char menu_disp_x0;
    public char menu_disp_y0;
    private char[][] menu_items;
    private boolean[][] menu_items_active;
    private int[][] num_menu_items;
    private boolean open;
    private boolean weapon_menu;

    public IngameMenu(Ingame _ingame, boolean _weapon_menu) {
        int y;
        int x;
        this.ingame = _ingame;
        this.slx = this.ingame.game.slx;
        this.sly = this.ingame.game.slyc;
        this.weapon_menu = _weapon_menu;
        this.menu_choice_row = '\u0000';
        this.menu_choice_column = '\u0000';
        this.menu_disp_x0 = '\u0000';
        this.menu_disp_y0 = '\u0000';
        this.open = true;
        this.menu_topleft = this.ingame.game.res_get_anim(25);
        this.menu_top = this.ingame.game.res_get_anim(26);
        this.menu_topright = this.ingame.game.res_get_anim(27);
        this.menu_left = this.ingame.game.res_get_anim(28);
        this.menu_middle = this.ingame.game.res_get_anim(29);
        this.menu_right = this.ingame.game.res_get_anim(30);
        this.menu_bottomleft = this.ingame.game.res_get_anim(31);
        this.menu_bottom = this.ingame.game.res_get_anim(32);
        this.menu_bottomright = this.ingame.game.res_get_anim(33);
        this.menu_selection = this.ingame.game.res_get_anim(34);
        this.menu_mask = this.ingame.game.res_get_anim(35);
        this.special_flags = this.ingame.building_special_flags;
        if (this.weapon_menu) {
            this.menu_icons = this.ingame.game.res_get_anim(36);
            this.menu_items = new char[5][];
            this.menu_items[0] = new char[3];
            this.menu_items[1] = new char[4];
            this.menu_items[2] = new char[2];
            this.menu_items[3] = new char[3];
            this.menu_items[4] = new char[4];
            this.menu_items[0][0] = '\u0000';
            this.menu_items[0][1] = '\u0001';
            this.menu_items[0][2] = 2;
            this.menu_items[1][0] = 3;
            this.menu_items[1][1] = 4;
            this.menu_items[1][2] = 5;
            this.menu_items[1][3] = 7;
            this.menu_items[2][0] = 8;
            this.menu_items[2][1] = 9;
            this.menu_items[3][0] = 15;
            this.menu_items[3][1] = 16;
            this.menu_items[3][2] = 18;
            this.menu_items[4][0] = 20;
            this.menu_items[4][1] = 21;
            this.menu_items[4][2] = 22;
            this.menu_items[4][3] = 23;
            this.num_menu_items = new int[5][];
            this.num_menu_items[0] = new int[3];
            this.num_menu_items[1] = new int[4];
            this.num_menu_items[2] = new int[2];
            this.num_menu_items[3] = new int[3];
            this.num_menu_items[4] = new int[4];
            this.menu_items_active = new boolean[5][];
            this.menu_items_active[0] = new boolean[3];
            this.menu_items_active[1] = new boolean[4];
            this.menu_items_active[2] = new boolean[2];
            this.menu_items_active[3] = new boolean[3];
            this.menu_items_active[4] = new boolean[4];
            for (x = 0; x < this.num_menu_items.length; ++x) {
                for (y = 0; y < this.num_menu_items[x].length; ++y) {
                    this.num_menu_items[x][y] = -2;
                    this.menu_items_active[x][y] = true;
                }
            }
        } else {
            this.menu_icons = this.ingame.game.res_get_anim(37 + Ingame.scheme);
            this.menu_items = new char[5][];
            this.menu_items[0] = new char[2];
            this.menu_items[1] = new char[2];
            this.menu_items[2] = new char[2];
            this.menu_items[3] = new char[2];
            this.menu_items[4] = new char[2];
            this.menu_items[0][0] = 4;
            this.menu_items[0][1] = 9;
            this.menu_items[1][0] = '\u0000';
            this.menu_items[1][1] = 6;
            this.menu_items[2][0] = '\u0001';
            this.menu_items[2][1] = 5;
            this.menu_items[3][0] = 2;
            this.menu_items[3][1] = 7;
            this.menu_items[4][0] = 3;
            this.menu_items[4][1] = 8;
            this.num_menu_items = new int[5][];
            this.num_menu_items[0] = new int[2];
            this.num_menu_items[1] = new int[2];
            this.num_menu_items[2] = new int[2];
            this.num_menu_items[3] = new int[2];
            this.num_menu_items[4] = new int[2];
            this.menu_items_active = new boolean[5][];
            this.menu_items_active[0] = new boolean[2];
            this.menu_items_active[1] = new boolean[2];
            this.menu_items_active[2] = new boolean[2];
            this.menu_items_active[3] = new boolean[2];
            this.menu_items_active[4] = new boolean[2];
            for (x = 0; x < this.num_menu_items.length; ++x) {
                for (y = 0; y < this.num_menu_items[x].length; ++y) {
                    this.num_menu_items[x][y] = -2;
                    this.menu_items_active[x][y] = true;
                }
            }
        }
        this.tiles_y = (char)this.menu_items.length;
        int y2 = (this.tiles_y - 2) * this.menu_left.ly + this.menu_topleft.ly + this.menu_bottomleft.ly;
        if (y2 >= this.sly) {
            y2 = this.sly - this.menu_topleft.ly - this.menu_bottomleft.ly;
            this.tiles_y = (char)(y2 / this.menu_left.ly + 2);
        }
        this.tiles_x = (char)this.menu_items[0].length;
        for (int t = 1; t < this.menu_items.length; ++t) {
            if (this.menu_items[t].length <= this.tiles_x) continue;
            this.tiles_x = (char)this.menu_items[t].length;
        }
        int x2 = (this.tiles_x - 2) * this.menu_left.lx + this.menu_topleft.lx + this.menu_bottomleft.lx;
        if (x2 >= this.slx) {
            x2 = this.slx - this.menu_topleft.lx - this.menu_bottomleft.lx;
            this.tiles_x = (char)(y2 / this.menu_left.lx + 2);
        }
        x2 = (this.tiles_x - 2) * this.menu_top.lx + this.menu_topleft.lx + this.menu_topright.lx;
        this.offset_x = (char)((this.slx - x2) / 2);
        y2 = (this.tiles_y - 2) * this.menu_left.ly + this.menu_topleft.ly + this.menu_bottomleft.ly;
        this.offset_y = (char)((this.sly - y2) / 2 - 8);
    }

    public void add_item(int item, int quantity) {
        for (int r = 0; r < this.menu_items.length; ++r) {
            for (int c = 0; c < this.menu_items[r].length; ++c) {
                if (this.menu_items[r][c] != item) continue;
                if (this.ingame.game.everything_unlocked) {
                    this.num_menu_items[r][c] = -1;
                } else if (quantity != 0 && this.num_menu_items[r][c] == -2) {
                    this.num_menu_items[r][c] = quantity;
                } else if (this.num_menu_items[r][c] > -1) {
                    int[] nArray = this.num_menu_items[r];
                    int n = c;
                    nArray[n] = nArray[n] + quantity;
                }
                return;
            }
        }
    }

    public void set_item_state(int item, boolean state) {
        for (int r = 0; r < this.menu_items.length; ++r) {
            for (int c = 0; c < this.menu_items[r].length; ++c) {
                if (this.menu_items[r][c] != item) continue;
                this.menu_items_active[r][c] = state;
            }
        }
    }

    public void close() {
        this.open = false;
        this.menu_choice_row = '\u0000';
        this.menu_choice_column = '\u0000';
        this.menu_disp_x0 = '\u0000';
        this.menu_disp_y0 = '\u0000';
    }

    public void open(int current_building_type) {
        this.close();
        this.open = true;
        for (int x = 0; x < this.menu_items.length; ++x) {
            for (int y = 0; y < this.menu_items[x].length; ++y) {
                if (this.ingame.game.everything_unlocked) {
                    this.set_item_state(this.menu_items[x][y], true);
                    continue;
                }
                this.set_item_state(this.menu_items[x][y], false);
            }
        }
        if (this.weapon_menu) {
            switch (current_building_type) {
                case 0: {
                    this.set_item_state(0, true);
                    this.set_item_state(3, true);
                    this.set_item_state(7, true);
                    this.set_item_state(15, true);
                    break;
                }
                case 1: {
                    this.set_item_state(4, true);
                    this.set_item_state(22, true);
                    this.set_item_state(9, true);
                    this.set_item_state(16, true);
                    this.set_item_state(20, true);
                    break;
                }
                case 2: {
                    this.set_item_state(1, true);
                    this.set_item_state(2, true);
                    this.set_item_state(21, true);
                    break;
                }
                case 3: {
                    this.set_item_state(5, true);
                    this.set_item_state(8, true);
                    this.set_item_state(18, true);
                    this.set_item_state(23, true);
                }
            }
        } else {
            int b;
            boolean building_ok = false;
            int num_buildings = 0;
            if (this.ingame.players_turn) {
                for (b = 0; b < this.ingame.player_building_list.length; ++b) {
                    if (this.ingame.player_building_list[b].building_type < 0) continue;
                    ++num_buildings;
                }
                if (num_buildings < this.ingame.player_building_list.length) {
                    building_ok = true;
                }
            } else if (!this.ingame.players_turn) {
                for (b = 0; b < this.ingame.ai_building_list.length; ++b) {
                    if (this.ingame.ai_building_list[b].building_type < 0) continue;
                    ++num_buildings;
                }
                if (num_buildings < this.ingame.ai_building_list.length) {
                    building_ok = true;
                }
            }
            if (building_ok) {
                building_ok = false;
                if (this.ingame.players_turn && this.ingame.player_stronghold_placed || !this.ingame.players_turn && this.ingame.ai_stronghold_placed) {
                    for (b = 0; b < this.ingame.player_building_list.length; ++b) {
                        if (this.ingame.players_turn) {
                            if (this.ingame.player_building_list[b].building_type == 4) {
                                building_ok = true;
                            }
                        } else if (this.ingame.ai_building_list[b].building_type == 4) {
                            building_ok = true;
                        }
                        if (!building_ok) {
                            continue;
                        }
                        break;
                    }
                } else {
                    building_ok = true;
                }
            }
            this.set_item_state(9, true);
            if (building_ok) {
                this.set_item_state(4, true);
                if (this.ingame.players_turn && this.ingame.player_stronghold_placed || !this.ingame.players_turn && this.ingame.ai_stronghold_placed) {
                    this.set_item_state(0, true);
                    this.set_item_state(1, true);
                    this.set_item_state(2, true);
                    this.set_item_state(3, true);
                    this.set_item_state(5, true);
                    this.set_item_state(6, true);
                    this.set_item_state(7, true);
                    this.set_item_state(8, true);
                }
            }
        }
        while (!this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
            this.menu_choice_column = (char)(this.menu_choice_column + '\u0001');
            if (this.menu_choice_column >= this.menu_items[this.menu_choice_row].length) {
                this.menu_choice_column = '\u0000';
                this.menu_choice_row = (char)(this.menu_choice_row + '\u0001');
            }
            if (this.menu_choice_row < this.menu_items.length) continue;
            this.menu_choice_column = '\u0000';
            this.menu_choice_row = '\u0000';
            break;
        }
    }

    public int get_menu_choice() {
        if (this.num_menu_items[this.menu_choice_row][this.menu_choice_column] != 0 && this.menu_items_active[this.menu_choice_row][this.menu_choice_column]) {
            return this.menu_items[this.menu_choice_row][this.menu_choice_column];
        }
        return -1;
    }

    public void move(int x, int y) {
        char old_col = this.menu_choice_column;
        char old_row = this.menu_choice_row;
        if (x > 0) {
            if (this.menu_choice_column < this.menu_items[this.menu_choice_row].length - 1) {
                this.menu_choice_column = (char)(this.menu_choice_column + '\u0001');
                while (!this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
                    this.menu_choice_column = (char)(this.menu_choice_column + '\u0001');
                    if (this.menu_choice_column < this.menu_items[this.menu_choice_row].length) continue;
                    this.menu_choice_column = old_col;
                    break;
                }
            }
        } else if (x < 0 && this.menu_choice_column > '\u0000') {
            this.menu_choice_column = (char)(this.menu_choice_column - '\u0001');
            while (!this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
                if (this.menu_choice_column > '\u0000') {
                    this.menu_choice_column = (char)(this.menu_choice_column - '\u0001');
                    continue;
                }
                this.menu_choice_column = old_col;
                break;
            }
        }
        if (y > 0) {
            if (this.menu_choice_row < this.menu_items.length - 1) {
                this.menu_choice_row = (char)(this.menu_choice_row + '\u0001');
                if (this.menu_choice_column >= this.menu_items[this.menu_choice_row].length) {
                    this.menu_choice_column = (char)(this.menu_items[this.menu_choice_row].length - 1);
                }
                if (this.num_menu_items[this.menu_choice_row][this.menu_choice_column] == -2 || this.num_menu_items[this.menu_choice_row][this.menu_choice_column] == 0 || !this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
                    this.menu_choice_column = '\u0000';
                }
                while (!this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
                    this.menu_choice_column = (char)(this.menu_choice_column + '\u0001');
                    if (this.menu_choice_column < this.menu_items[this.menu_choice_row].length) continue;
                    this.menu_choice_column = '\u0000';
                    this.menu_choice_row = (char)(this.menu_choice_row + '\u0001');
                    if (this.menu_choice_row < this.menu_items.length) continue;
                    this.menu_choice_row = old_row;
                    this.menu_choice_column = old_col;
                    break;
                }
            }
        } else if (y < 0 && this.menu_choice_row > '\u0000') {
            this.menu_choice_row = (char)(this.menu_choice_row - '\u0001');
            if (this.menu_choice_column >= this.menu_items[this.menu_choice_row].length) {
                this.menu_choice_column = (char)(this.menu_items[this.menu_choice_row].length - 1);
            }
            if (this.num_menu_items[this.menu_choice_row][this.menu_choice_column] == -2 || this.num_menu_items[this.menu_choice_row][this.menu_choice_column] == 0 || !this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
                this.menu_choice_column = '\u0000';
            }
            while (!this.item_selectable(this.menu_items[this.menu_choice_row][this.menu_choice_column], false)) {
                this.menu_choice_column = (char)(this.menu_choice_column + '\u0001');
                if (this.menu_choice_column < this.menu_items[this.menu_choice_row].length) continue;
                if (this.menu_choice_row > '\u0000') {
                    this.menu_choice_column = '\u0000';
                    this.menu_choice_row = (char)(this.menu_choice_row - '\u0001');
                    continue;
                }
                this.menu_choice_row = old_row;
                this.menu_choice_column = old_col;
                break;
            }
        }
        if (this.menu_choice_column >= this.menu_items[this.menu_choice_row].length) {
            this.menu_choice_column = (char)(this.menu_items[this.menu_choice_row].length - 1);
        }
        if (this.menu_choice_row > this.menu_disp_y0 + this.tiles_y - 1) {
            this.menu_disp_y0 = (char)(this.menu_choice_row - this.tiles_y + 1);
        } else if (this.menu_choice_row < this.menu_disp_y0) {
            this.menu_disp_y0 = this.menu_choice_row;
        }
        if (this.menu_choice_column > this.menu_disp_x0 + this.tiles_x - 1) {
            this.menu_disp_x0 = (char)(this.menu_choice_column - this.tiles_x + 1);
        } else if (this.menu_choice_column < this.menu_disp_x0) {
            this.menu_disp_x0 = this.menu_choice_column;
        }
    }

    public void disp() {
        if (this.open) {
            int y;
            this.ingame.game.update_clip();
            for (int y2 = 0; y2 <= this.tiles_y; ++y2) {
                if (y2 < 0 || y2 >= this.tiles_y) continue;
                for (int x = 0; x <= this.tiles_x; ++x) {
                    if (y2 == 0 && x == 0) {
                        this.ingame.game.graphics.drawImage(this.menu_topleft.frames, (int)this.offset_x, (int)this.offset_y, 0);
                        continue;
                    }
                    if (y2 == 0 && x == this.tiles_x - '\u0001') {
                        this.ingame.game.graphics.drawImage(this.menu_topright.frames, this.offset_x + this.menu_topleft.lx + (this.tiles_x - 2) * this.menu_top.lx, (int)this.offset_y, 0);
                        continue;
                    }
                    if (y2 == this.tiles_y - '\u0001' && x == 0) {
                        this.ingame.game.graphics.drawImage(this.menu_bottomleft.frames, (int)this.offset_x, this.offset_y + this.menu_topleft.ly + (this.tiles_y - 2) * this.menu_left.ly, 0);
                        continue;
                    }
                    if (y2 == this.tiles_y - '\u0001' && x == this.tiles_x - '\u0001') {
                        this.ingame.game.graphics.drawImage(this.menu_bottomright.frames, this.offset_x + this.menu_bottomleft.lx + (this.tiles_x - 2) * this.menu_bottom.lx, this.offset_y + this.menu_topright.ly + (this.tiles_y - 2) * this.menu_right.ly, 0);
                        continue;
                    }
                    if (y2 == 0 && x >= 0 && x < this.tiles_x) {
                        this.ingame.game.graphics.drawImage(this.menu_top.frames, this.offset_x + this.menu_topleft.lx + (x - 1) * this.menu_top.lx, (int)this.offset_y, 0);
                        continue;
                    }
                    if (y2 == this.tiles_y - '\u0001' && x >= 0 && x < this.tiles_x) {
                        this.ingame.game.graphics.drawImage(this.menu_bottom.frames, this.offset_x + this.menu_bottomleft.lx + (x - 1) * this.menu_bottom.lx, this.offset_y + this.menu_topright.ly + (y2 - 1) * this.menu_right.ly, 0);
                        continue;
                    }
                    if (x == 0) {
                        this.ingame.game.graphics.drawImage(this.menu_left.frames, (int)this.offset_x, this.offset_y + this.menu_topleft.ly + (y2 - 1) * this.menu_left.ly, 0);
                        continue;
                    }
                    if (x == this.tiles_x - '\u0001') {
                        this.ingame.game.graphics.drawImage(this.menu_right.frames, this.offset_x + this.menu_topleft.lx + (x - 1) * this.menu_top.lx, this.offset_y + this.menu_topright.ly + (y2 - 1) * this.menu_right.ly, 0);
                        continue;
                    }
                    if (x < 0 || x >= this.tiles_x) continue;
                    this.ingame.game.graphics.drawImage(this.menu_middle.frames, this.offset_x + this.menu_topleft.lx + (x - 1) * this.menu_middle.lx, this.offset_y + this.menu_topleft.ly + (y2 - 1) * this.menu_middle.ly, 0);
                }
            }
            int max_len = 0;
            int target = 0;
            for (y = 0; y < this.menu_items.length; ++y) {
                if (this.menu_items[y].length <= max_len) continue;
                max_len = this.menu_items[y].length;
                target = y;
            }
            for (y = (int)this.menu_disp_y0; y < this.menu_items.length && y < this.menu_disp_y0 + this.tiles_y; ++y) {
                for (int x = this.menu_disp_x0; x < this.menu_items[y].length && x < this.tiles_x + this.menu_disp_x0; ++x) {
                    if (this.menu_items[y] == null) continue;
                    if (!this.weapon_menu) {
                        if (this.menu_items[y][x] <= '\u0004') {
                            this.menu_icons.disp(this.offset_x + 5 + (x - this.menu_disp_x0) * this.menu_middle.lx, this.offset_y + 5 + (y - this.menu_disp_y0) * this.menu_middle.ly, this.menu_items[y][x], 0);
                        } else if (this.menu_items[y][x] == '\t') {
                            this.ingame.game.disp_tile(this.offset_x + 5 + (x - this.menu_disp_x0) * this.menu_middle.lx, this.offset_y + 5 + (y - this.menu_disp_y0) * this.menu_middle.ly, 10);
                        } else {
                            this.special_flags.disp(this.offset_x + 5 + (x - this.menu_disp_x0) * this.menu_middle.lx, this.offset_y + 5 + (y - this.menu_disp_y0) * this.menu_middle.ly, this.menu_items[y][x] - 4, 0);
                        }
                    } else {
                        this.menu_icons.disp(this.offset_x + 5 + (x - this.menu_disp_x0) * this.menu_middle.lx, this.offset_y + 5 + (y - this.menu_disp_y0) * this.menu_middle.ly, this.ingame.game.convertWeaponItem(this.menu_items[y][x]), 0);
                    }
                    if (this.num_menu_items[y][x] > 0 && this.menu_items_active[y][x]) {
                        this.ingame.game.draw_string("" + this.num_menu_items[y][x], this.offset_x + 5 + (x - this.menu_disp_x0) * this.menu_middle.lx + this.menu_icons.lx - this.ingame.game.font_get_width(this.ingame.ingame_font, "" + this.num_menu_items[y][x]), this.offset_y + 7 + (y - this.menu_disp_y0) * this.menu_middle.ly + this.menu_icons.ly - this.ingame.game.font_get_height(this.ingame.ingame_font), 0, this.ingame.ingame_font);
                        continue;
                    }
                    if (this.num_menu_items[y][x] != 0 && this.num_menu_items[y][x] != -2 && this.menu_items_active[y][x]) continue;
                    this.menu_mask.disp(this.offset_x + 5 + (x - this.menu_disp_x0) * this.menu_middle.lx, this.offset_y + 5 + (y - this.menu_disp_y0) * this.menu_middle.ly, 0, 0);
                }
            }
            this.menu_selection.disp(this.offset_x + 5 + (this.menu_choice_column - this.menu_disp_x0) * this.menu_middle.lx, this.offset_y + 5 + (this.menu_choice_row - this.menu_disp_y0) * this.menu_middle.ly, 0, 0);
            if (!this.weapon_menu) {
                String item = this.ingame.game.res_get_string(this.ingame.building_names[this.menu_items[this.menu_choice_row][this.menu_choice_column]]);
                this.ingame.game.draw_bordered_text(item, this.slx >> 1, this.sly - this.ingame.game.font_get_height(this.ingame.ingame_font), this.ingame.ingame_font, 0, 0xDD0000, true);
            } else {
                String item = this.ingame.game.res_get_string(this.ingame.weapon_names[this.ingame.game.convertWeaponItem(this.menu_items[this.menu_choice_row][this.menu_choice_column])]);
                this.ingame.game.draw_bordered_text(item, this.slx >> 1, this.sly - this.ingame.game.font_get_height(this.ingame.ingame_font), this.ingame.ingame_font, 0, 0xDD0000, true);
            }
        }
    }

    public void remove_item(int item) {
        for (int r = 0; r < this.menu_items.length; ++r) {
            for (int c = 0; c < this.menu_items[r].length; ++c) {
                if (this.menu_items[r][c] != item || this.num_menu_items[r][c] <= 0) continue;
                int[] nArray = this.num_menu_items[r];
                int n = c;
                nArray[n] = nArray[n] - 1;
                return;
            }
        }
    }

    public boolean item_selectable(char item, boolean ignore_active) {
        for (int r = 0; r < this.menu_items.length; ++r) {
            for (int c = 0; c < this.menu_items[r].length; ++c) {
                if (this.menu_items[r][c] != item || this.num_menu_items[r][c] == 0 || this.num_menu_items[r][c] == -2 || !ignore_active && !this.menu_items_active[r][c]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean item_available(char item) {
        for (int r = 0; r < this.menu_items.length; ++r) {
            for (int c = 0; c < this.menu_items[r].length; ++c) {
                if (this.menu_items[r][c] != item || this.num_menu_items[r][c] < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void remove_weapons(int building) {
        switch (building) {
            case 0: {
                this.add_item(0, -2);
                this.add_item(3, -2);
                this.add_item(7, -2);
                this.add_item(15, -2);
                break;
            }
            case 1: {
                this.add_item(4, -2);
                this.add_item(22, -2);
                this.add_item(9, -2);
                this.add_item(16, -2);
                this.add_item(20, -2);
                break;
            }
            case 2: {
                this.add_item(1, -2);
                this.add_item(2, -2);
                this.add_item(21, -2);
                break;
            }
            case 3: {
                this.add_item(5, -2);
                this.add_item(8, -2);
                this.add_item(18, -2);
                this.add_item(23, -2);
            }
        }
    }
}

