/*
 * Decompiled with CFR 0.152.
 */
class FGFont {
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int WIDTH_INFINITE = 10000;
    public static final int HEIGHT_INFINITE = 10000;
    FGImage m_font = new FGImage();
    private int[] m_xValues = new int[256];
    private int[] m_yValues = new int[256];
    private int[] m_widthValues = new int[256];
    private int m_lineHeight;
    private int m_spaceWidth;
    private int m_letterSpacing;
    private int m_lineSpacing;
    private int m_justify = 0;

    public boolean init(String string, String string2) {
        FGString fGString = new FGString("line");
        FGString fGString2 = new FGString("l");
        this.m_font.init(string);
        FGData fGData = FGEngine.getEngine().getFileSystem().getFile(string2);
        if (fGData == null) {
            FGEngine.fatal("Could not load font data file.");
            return false;
        }
        FGDataReader fGDataReader = new FGDataReader();
        fGDataReader.init(fGData);
        FGData fGData2 = new FGData();
        fGData2.init(6);
        fGDataReader.readRaw(fGData2, 6);
        FGString fGString3 = new FGString(fGData2);
        if (!fGString3.equals(new FGString("FGFONT"))) {
            FGEngine.fatal("non-font file told to load in FGFont");
            return false;
        }
        int n = fGDataReader.readInt();
        if (n != 1) {
            FGEngine.fatal("invalid font file version in FGFont");
            return false;
        }
        this.m_spaceWidth = fGDataReader.readInt();
        this.m_lineSpacing = fGDataReader.readInt();
        this.m_letterSpacing = fGDataReader.readInt();
        this.m_lineHeight = fGDataReader.readInt();
        int n2 = fGDataReader.readInt();
        for (int i = 0; i < n2; ++i) {
            int n3 = fGDataReader.readInt();
            if (n3 == -1) {
                fGDataReader.readInt();
                fGDataReader.readInt();
                fGDataReader.readInt();
                continue;
            }
            this.m_xValues[n3] = fGDataReader.readInt();
            this.m_yValues[n3] = fGDataReader.readInt();
            this.m_widthValues[n3] = fGDataReader.readInt();
        }
        this.m_widthValues[32] = this.m_spaceWidth;
        return true;
    }

    public void setJustify(int n) {
        this.m_justify = n;
    }

    public int getJustify() {
        return this.m_justify;
    }

    public void drawText(FGGraphics fGGraphics, String string, int n, int n2) {
        String string2 = string;
        int n3 = string2.length();
        int n4 = this.getDisplayLength(string2, 0, n3 - 1);
        int n5 = this.m_justify == 0 ? n : (this.m_justify == 1 ? n - n4 : n - n4 / 2);
        for (int i = 0; i < n3; ++i) {
            int n6 = this.getIdxForChar(string2.charAt(i));
            this.drawChar(fGGraphics, n6, n5, n2);
            n5 += this.m_widthValues[n6];
            n5 += this.m_letterSpacing;
        }
    }

    public void drawText(FGGraphics fGGraphics, String string, int n, int n2, int n3) {
        this.drawText(fGGraphics, string, n, n2, n3, 10000, 0);
    }

    public int getDisplayHeight(String string, int n) {
        String string2 = string;
        int n2 = string2.length();
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < n2) {
            int n6;
            int n7 = this.getLastFittingChar(string2, n3, n);
            int n8 = this.getDisplayLength(string2, n3, n7);
            int n9 = n3;
            while (this.isWhitespace(n6 = string2.charAt(n9)) && ++n9 < n2) {
            }
            for (n6 = n9; n6 <= n7; ++n6) {
                int n10 = this.getIdxForChar(string2.charAt(n6));
            }
            n5 += this.m_lineHeight;
            n5 += this.m_lineSpacing;
            n3 = n7 + 1;
            ++n4;
        }
        return n5 - this.m_lineSpacing;
    }

    public int getDisplayLength(String string) {
        return this.getDisplayLength(string, 0, string.length() - 1);
    }

    public int getDisplayLength(String string, int n) {
        int n2 = 0;
        String string2 = string;
        int n3 = string2.length();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 < n3) {
            int n7;
            int n8 = this.getLastFittingChar(string2, n4, n);
            int n9 = this.getDisplayLength(string2, n4, n8);
            int n10 = n4;
            while (this.isWhitespace(n7 = string2.charAt(n10)) && ++n10 < n3) {
            }
            n7 = 0;
            for (int i = n10; i <= n8; ++i) {
                int n11 = this.getIdxForChar(string2.charAt(i));
                n7 += this.m_widthValues[n11];
                n7 += this.m_letterSpacing;
            }
            if ((n7 -= this.m_letterSpacing) > n2) {
                n2 = n7;
            }
            n6 += this.m_lineHeight;
            n6 += this.m_lineSpacing;
            n4 = n8 + 1;
            ++n5;
        }
        return n2;
    }

    public int getDisplayLines(String string, int n) {
        int n2 = this.getDisplayHeight(string, n);
        int n3 = (n2 += this.m_lineSpacing) / (this.getHeight() + this.getLineSpacing());
        return n3;
    }

    public void drawText(FGGraphics fGGraphics, String string, int n, int n2, int n3, int n4, int n5) {
        String string2 = string;
        int n6 = n4 / (this.m_lineHeight + this.m_lineSpacing);
        int n7 = string2.length();
        int n8 = 0;
        int n9 = 0;
        int n10 = n5 + n6 - 1;
        while (n8 < n7) {
            int n11 = this.getLastFittingChar(string2, n8, n3);
            if (n9 >= n5) {
                int n12;
                int n13 = this.getDisplayLength(string2, n8, n11);
                int n14 = this.m_justify == 0 ? n : (this.m_justify == 1 ? n + n3 - n13 : n + (n3 - n13) / 2);
                int n15 = n8;
                while (this.isWhitespace(n12 = string2.charAt(n15)) && ++n15 < n7) {
                }
                for (n12 = n15; n12 <= n11; ++n12) {
                    int n16 = this.getIdxForChar(string2.charAt(n12));
                    this.drawChar(fGGraphics, n16, n14, n2);
                    n14 += this.m_widthValues[n16];
                    n14 += this.m_letterSpacing;
                }
                n2 += this.m_lineHeight;
                n2 += this.m_lineSpacing;
            }
            n8 = n11 + 1;
            if (++n9 <= n10) continue;
            return;
        }
    }

    FGString fitStringInWidth(String string, int n) {
        FGString fGString = new FGString(string);
        if (this.getDisplayLength(string) <= n) {
            return new FGString(string);
        }
        int n2 = fGString.length() - 1;
        while (true) {
            FGString fGString2;
            if (n2 <= 0) {
                fGString2 = new FGString();
                fGString2.set("...");
                return fGString2;
            }
            fGString2 = fGString.substring(0, n2);
            fGString2.add("...");
            if (this.getDisplayLength(fGString2.getNativeString()) <= n) {
                return fGString2;
            }
            --n2;
        }
    }

    private void drawChar(FGGraphics fGGraphics, int n, int n2, int n3) {
        if (n == 32) {
            return;
        }
        if (this.m_widthValues[n] == 0) {
            return;
        }
        this.m_font.drawSelf(fGGraphics, n2, n3, this.m_xValues[n], this.m_yValues[n], this.m_widthValues[n], this.m_lineHeight);
    }

    private int getLastFittingChar(String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        boolean bl = false;
        while (!bl && this.isWhitespace(n3 = this.getIdxForChar(string.charAt(n)))) {
            if (++n < n4) continue;
            return n4 - 1;
        }
        n3 = n;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n < n4) {
            int n6 = this.getIdxForChar(string.charAt(n));
            if ((n5 += this.m_widthValues[n6]) > n2) {
                return n3;
            }
            if (n6 == 10) {
                return n;
            }
            if (this.isWhitespace(n6)) {
                bl2 = true;
                if (bl3) {
                    n3 = n - 1;
                }
                bl3 = false;
            } else {
                if (!bl2) {
                    n3 = n;
                }
                bl3 = true;
            }
            n5 += this.m_letterSpacing;
            ++n;
        }
        return n4 - 1;
    }

    private int getDisplayLength(String string, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            int n4 = this.getIdxForChar(string.charAt(i));
            if (this.isWhitespace(n4)) {
                if (!bl) continue;
                n3 += this.m_widthValues[n4];
                n3 += this.m_letterSpacing;
                continue;
            }
            n3 += this.m_widthValues[n4];
            n3 += this.m_letterSpacing;
            bl = true;
        }
        if (n3 > 0) {
            n3 -= this.m_letterSpacing;
        }
        return n3;
    }

    private boolean isWhitespace(int n) {
        return n == 32 || n == 9;
    }

    private int getIdxForChar(char n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        if (this.m_widthValues[n2 &= 0xFF] == 0) {
            if (n >= 97 && n <= 122) {
                n2 = n - 97 + 65;
            } else if (n >= 65 && n <= 90) {
                n2 = n - 65 + 97;
            }
        }
        return n2;
    }

    public int getLineSpacing() {
        return this.m_lineSpacing;
    }

    public int getLetterSpacing() {
        return this.m_letterSpacing;
    }

    public int getSpaceWidth() {
        return this.m_spaceWidth;
    }

    public int getHeight() {
        return this.m_lineHeight;
    }
}

