/*
 * Decompiled with CFR 0.152.
 */
class FGGeometry {
    private FGGeometry() {
    }

    public static boolean ptInTriangle(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4) {
        if (!FGGeometry.sameSide(fGVector, fGVector2, fGVector3, fGVector4)) {
            return false;
        }
        if (!FGGeometry.sameSide(fGVector2, fGVector3, fGVector, fGVector4)) {
            return false;
        }
        return FGGeometry.sameSide(fGVector3, fGVector, fGVector2, fGVector4);
    }

    public static boolean sameSide(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4) {
        int n = FGGeometry.getFixUDenominator(fGVector, fGVector2, fGVector3, fGVector4);
        if (n == 0) {
            return true;
        }
        int n2 = FGGeometry.getFixUNumeratorB(fGVector, fGVector2, fGVector3, fGVector4);
        int n3 = FGFixed.divide(n2, n);
        if (n3 <= 0) {
            return true;
        }
        return n3 >= FGFixed.toFixed(1);
    }

    public static boolean getIntersectionPoint(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4, FGVector fGVector5) {
        int n = FGGeometry.getFixUDenominator(fGVector, fGVector2, fGVector3, fGVector4);
        if (n == 0) {
            return false;
        }
        int n2 = FGGeometry.getFixUNumeratorA(fGVector, fGVector2, fGVector3, fGVector4);
        int n3 = FGFixed.divide(n2, n);
        fGVector5.m_fixX = fGVector.m_fixX + FGFixed.multiply(n3, fGVector2.m_fixX - fGVector.m_fixX);
        fGVector5.m_fixY = fGVector.m_fixY + FGFixed.multiply(n3, fGVector2.m_fixY - fGVector.m_fixY);
        return true;
    }

    public static boolean forceInBounds(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4, FGVector fGVector5, FGVector fGVector6) {
        if (FGGeometry.sameSide(fGVector, fGVector2, fGVector5, fGVector4)) {
            fGVector6.set(fGVector4);
            return false;
        }
        boolean bl = FGGeometry.getIntersectionPoint(fGVector, fGVector2, fGVector3, fGVector4, fGVector6);
        if (!bl) {
            FGGeometry.projectToLine(fGVector, fGVector2, fGVector4, fGVector6);
            return true;
        }
        return true;
    }

    public static boolean forceInBoundsSlide(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4, FGVector fGVector5, FGVector fGVector6) {
        if (FGGeometry.sameSide(fGVector, fGVector2, fGVector5, fGVector4)) {
            fGVector6.set(fGVector4);
            return false;
        }
        FGGeometry.projectToLine(fGVector, fGVector2, fGVector4, fGVector6);
        return true;
    }

    public static void projectToLine(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4) {
        if (fGVector.equals(fGVector2)) {
            fGVector4.set(fGVector);
            return;
        }
        fGVector2.subtractVector(fGVector);
        fGVector3.subtractVector(fGVector);
        int n = fGVector2.getLength();
        int n2 = FGFixed.multiply(fGVector2.m_fixX, fGVector3.m_fixX) + FGFixed.multiply(fGVector2.m_fixY, fGVector3.m_fixY);
        int n3 = FGFixed.divide(n2, n);
        int n4 = FGFixed.divide(n3, n);
        fGVector4.m_fixX = FGFixed.multiply(fGVector2.m_fixX, n4);
        fGVector4.m_fixY = FGFixed.multiply(fGVector2.m_fixY, n4);
        fGVector2.addVector(fGVector);
        fGVector3.addVector(fGVector);
        fGVector4.addVector(fGVector);
    }

    public static int evenSpace(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            return 0;
        }
        int n5 = FGFixed.toFixed(n3);
        int n6 = FGFixed.toFixed(n4);
        int n7 = n - FGFixed.multiply(n2, n5);
        int n8 = n5 + 256;
        int n9 = FGFixed.divide(n7, n8);
        int n10 = n6 + 256;
        int n11 = FGFixed.multiply(n9, n10);
        int n12 = FGFixed.multiply(n6, n2);
        int n13 = n11 + n12;
        return n13;
    }

    public static int applyPPSVel(int n, int n2, int n3) {
        int n4 = FGFixed.multiply(n2, n3);
        n4 = FGFixed.divide(n4, FGFixed.toFixed(1000));
        return n + n4;
    }

    public static void applyPPSVel(FGVector fGVector, FGVector fGVector2, int n, FGVector fGVector3) {
        fGVector3.m_fixX = FGGeometry.applyPPSVel(fGVector.m_fixX, fGVector2.m_fixX, n);
        fGVector3.m_fixY = FGGeometry.applyPPSVel(fGVector.m_fixY, fGVector2.m_fixY, n);
    }

    public static int applyPPSVelToward(int n, int n2, int n3, int n4) {
        int n5 = n2;
        if (n3 - n < 0) {
            n5 = -n5;
        }
        int n6 = FGGeometry.applyPPSVel(n, n5, n4);
        boolean bl = false;
        if (n < n3 && n6 > n3) {
            bl = true;
        }
        if (n > n3 && n6 < n3) {
            bl = true;
        }
        if (bl) {
            return n3;
        }
        return n6;
    }

    public static void applyPPSVelToward(FGVector fGVector, int n, FGVector fGVector2, int n2, FGVector fGVector3) {
        int n3 = FGFixed.multiply(n, n2);
        n3 = FGFixed.divide(n3, FGFixed.toFixed(1000));
        fGVector3.set(fGVector2);
        fGVector3.subtractVector(fGVector);
        int n4 = fGVector3.getLength();
        if (n4 < n3) {
            fGVector3.set(fGVector2);
            return;
        }
        fGVector3.scalarMultiply(n3);
        fGVector3.scalarDivide(n4);
        fGVector3.addVector(fGVector);
    }

    public static int getFixDistance(FGVector fGVector, FGVector fGVector2) {
        int n = fGVector.m_fixX - fGVector2.m_fixX;
        int n2 = fGVector.m_fixY - fGVector2.m_fixY;
        int n3 = FGFixed.multiply(n, n) + FGFixed.multiply(n2, n2);
        int n4 = FGFixed.sqrt(n3);
        return n4;
    }

    public static int getFixPsuedoDistance(FGVector fGVector, FGVector fGVector2) {
        int n = fGVector.m_fixX - fGVector2.m_fixX;
        int n2 = fGVector.m_fixY - fGVector2.m_fixY;
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        int n3 = n + n2;
        return n3;
    }

    public static int getFixUNumeratorA(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4) {
        int n = FGFixed.multiply(fGVector4.m_fixX - fGVector3.m_fixX, fGVector.m_fixY - fGVector3.m_fixY);
        int n2 = FGFixed.multiply(fGVector4.m_fixY - fGVector3.m_fixY, fGVector.m_fixX - fGVector3.m_fixX);
        int n3 = n - n2;
        return n3;
    }

    public static int getFixUNumeratorB(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4) {
        int n = FGFixed.multiply(fGVector2.m_fixX - fGVector.m_fixX, fGVector.m_fixY - fGVector3.m_fixY);
        int n2 = FGFixed.multiply(fGVector2.m_fixY - fGVector.m_fixY, fGVector.m_fixX - fGVector3.m_fixX);
        int n3 = n - n2;
        return n3;
    }

    public static int getFixUDenominator(FGVector fGVector, FGVector fGVector2, FGVector fGVector3, FGVector fGVector4) {
        int n = FGFixed.multiply(fGVector4.m_fixY - fGVector3.m_fixY, fGVector2.m_fixX - fGVector.m_fixX);
        int n2 = FGFixed.multiply(fGVector4.m_fixX - fGVector3.m_fixX, fGVector2.m_fixY - fGVector.m_fixY);
        int n3 = n - n2;
        return n3;
    }
}

