/*
 * Decompiled with CFR 0.152.
 */
class FGResLoader {
    public static final int MAX_RESOURCES = 256;
    public static final int TYPE_UNDEFINED = -1;
    public static final int TYPE_IMAGE = 1;
    public static final int TYPE_SOUND = 2;
    public static final int PROGRESS_FILES = 0;
    public static final int PROGRESS_BYTES = 1;
    FGString[] m_resourceFilenames = new FGString[256];
    FGImage[] m_images = new FGImage[256];
    int[] m_resTypes = new int[256];
    int[] m_resIDs = new int[256];
    boolean[] m_tags = new boolean[256];
    int m_numResources;
    int m_numLoadedResources;

    public void clear() {
        for (int i = 0; i < 256; ++i) {
            this.m_images[i] = null;
            this.m_resourceFilenames[i] = null;
        }
        this.m_numResources = 0;
        this.m_numLoadedResources = 0;
    }

    void registerImage(String string) {
        this.registerResource(string, 1, -1);
    }

    void registerSound(String string, int n) {
        this.registerResource(string, 2, n);
    }

    void registerResource(String string, int n, int n2) {
        if (this.m_numResources >= 256) {
            FGEngine.fatal("Too many images registered for FGResLoader");
            return;
        }
        for (int i = 0; i < this.m_numResources; ++i) {
            if (!this.m_resourceFilenames[i].equals(string)) continue;
            this.m_tags[i] = true;
            return;
        }
        this.m_resourceFilenames[this.m_numResources] = new FGString();
        this.m_resourceFilenames[this.m_numResources].set(string);
        this.m_images[this.m_numResources] = null;
        this.m_resTypes[this.m_numResources] = n;
        this.m_resIDs[this.m_numResources] = n2;
        this.m_tags[this.m_numResources] = true;
        ++this.m_numResources;
    }

    boolean isResourceLoaded(String string) {
        for (int i = 0; i < this.m_numResources; ++i) {
            if (!this.m_resourceFilenames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    void registerImageSet(String string, String string2, int n, boolean bl, boolean bl2) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            if (!bl2) {
                ++n2;
            }
            FGString fGString = new FGString();
            fGString.add(string);
            if (bl && n2 < 10) {
                fGString.add("0");
            }
            fGString.add(n2);
            fGString.add(string2);
            this.registerImage(fGString.getNativeString());
        }
    }

    FGImage getImageFromSet(String string, String string2, int n, boolean bl, boolean bl2) {
        int n2 = n;
        if (!bl2) {
            ++n2;
        }
        FGString fGString = new FGString();
        fGString.add(string);
        if (bl && n2 < 10) {
            fGString.add("0");
        }
        fGString.add(n2);
        fGString.add(string2);
        return this.getImage(fGString.getNativeString());
    }

    public FGImage getImage(String string) {
        for (int i = 0; i < this.m_numResources; ++i) {
            if (!this.m_resourceFilenames[i].equals(string) || this.m_resTypes[i] != 1) continue;
            return this.m_images[i];
        }
        FGString fGString = new FGString();
        fGString.set("FGResLoader.getImage >>> requested image not registered:");
        fGString.add(string);
        FGEngine.fatal(fGString.getNativeString());
        return null;
    }

    void loadNextResource() {
        if (this.m_numLoadedResources >= this.m_numResources) {
            return;
        }
        if (this.m_resTypes[this.m_numLoadedResources] == 1) {
            this.m_images[this.m_numLoadedResources] = FGImage.createImage(this.m_resourceFilenames[this.m_numLoadedResources].getNativeString());
        } else {
            this.m_images[this.m_numLoadedResources] = null;
            FGEngine.getEngine().getSoundManager().registerSound(this.m_resourceFilenames[this.m_numLoadedResources].getNativeString(), this.m_resIDs[this.m_numLoadedResources]);
        }
        ++this.m_numLoadedResources;
    }

    int getNumResources() {
        return this.m_numResources;
    }

    int getNumLoadedResources() {
        return this.m_numLoadedResources;
    }

    boolean allResourcesLoaded() {
        return this.m_numResources <= this.m_numLoadedResources;
    }

    void loadAllResources() {
        while (!this.allResourcesLoaded()) {
            this.loadNextResource();
        }
    }

    public void debugOutputImageList() {
        int n;
        FGString[] fGStringArray = new FGString[this.m_numResources];
        for (n = 0; n < this.m_numResources; ++n) {
            fGStringArray[n] = this.m_resourceFilenames[n];
        }
        for (n = 0; n < this.m_numResources; ++n) {
            String string = fGStringArray[n].getNativeString();
            int n2 = n;
            for (int i = n + 1; i < this.m_numResources; ++i) {
                if (fGStringArray[i].getNativeString().compareTo(string) >= 0) continue;
                string = fGStringArray[i].getNativeString();
                n2 = i;
            }
            FGString fGString = fGStringArray[n];
            fGStringArray[n] = fGStringArray[n2];
            fGStringArray[n2] = fGString;
        }
        System.out.println("File list:");
        for (n = 0; n < this.m_numResources; ++n) {
            System.out.println(fGStringArray[n].getNativeString());
        }
    }

    int getProgress(int n) {
        int n2 = 0;
        if (this.getNumResources() == 0) {
            return 0;
        }
        n2 = 100 * this.getNumLoadedResources() / this.getNumResources();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        return n2;
    }

    public void beginRegistration() {
        for (int i = 0; i < this.m_numLoadedResources; ++i) {
            this.m_tags[i] = false;
        }
    }

    public void endRegistration() {
        int n;
        if (this.m_numLoadedResources == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.m_numResources; ++i) {
            if (this.m_tags[i]) {
                ++n2;
                if (this.m_images[i] == null) continue;
                ++n3;
                continue;
            }
            if (this.m_resTypes[i] == 2) {
                FGEngine.getEngine().getSoundManager().unregisterSound(this.m_resIDs[i]);
                continue;
            }
            if (this.m_resTypes[i] != 1) continue;
            this.m_images[i] = null;
        }
        FGString[] fGStringArray = new FGString[n2];
        FGImage[] fGImageArray = new FGImage[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int n4 = 0;
        for (n = 0; n < this.m_numResources; ++n) {
            if (!this.m_tags[n]) continue;
            fGStringArray[n4] = new FGString();
            fGStringArray[n4].set(this.m_resourceFilenames[n]);
            fGImageArray[n4] = this.m_images[n];
            nArray[n4] = this.m_resTypes[n];
            nArray2[n4] = this.m_resIDs[n];
            ++n4;
        }
        for (n = 0; n < n2; ++n) {
            this.m_resourceFilenames[n].set(fGStringArray[n]);
            this.m_images[n] = fGImageArray[n];
            this.m_resTypes[n] = nArray[n];
            this.m_resIDs[n] = nArray2[n];
            this.m_tags[n] = false;
        }
        this.m_numLoadedResources = n3;
        this.m_numResources = n2;
    }

    public FGString getFilename(int n) {
        return this.m_resourceFilenames[n];
    }

    public int getNumFiles() {
        return this.m_numResources;
    }

    public void setImage(FGImage fGImage, int n) {
        this.m_images[n] = fGImage;
        ++this.m_numLoadedResources;
    }

    public void setNumLoadedImages(int n) {
        this.m_numLoadedResources = n;
    }
}

