/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class FGSoundManager
implements Runnable {
    public static final boolean VERBOSE = false;
    public static final byte TYPE_WAV = 0;
    public static final byte TYPE_MIDI = 1;
    Vector m_sounds = new Vector();
    FGSoundData m_lastPlayedSound;
    Thread m_thread;
    public static final byte NEXT_ACTION_PLAY = 0;
    public static final byte NEXT_ACTION_STOP = 1;
    public static final byte NEXT_ACTION_TERMINATE = 3;
    private byte m_nextAction;
    private int m_nextActionID;
    public static final Object m_synch = new Object();
    private boolean m_bSoundOn = true;
    public String m_registerError;
    public String m_playError;
    private boolean m_bCreateNewPlayers = false;

    public void setNewPlayerCreation(boolean bl) {
        this.m_bCreateNewPlayers = bl;
    }

    public void init() {
        this.m_nextAction = (byte)-1;
        this.m_thread = new Thread(this);
        this.m_thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        this.doStop();
        Object object = m_synch;
        synchronized (object) {
            this.m_nextAction = (byte)3;
        }
    }

    public void registerSound(String string, int n) {
        byte by;
        FGString fGString = new FGString(string);
        FGEngine fGEngine = FGEngine.getEngine();
        FGFileSystem fGFileSystem = fGEngine.getFileSystem();
        FGData fGData = fGFileSystem.getFile(fGString.getNativeString());
        if (fGData == null) {
            return;
        }
        if (fGString.indexOf(new FGString(".wav")) != -1) {
            by = 0;
        } else if (fGString.indexOf(new FGString(".mid")) != -1) {
            by = 1;
        } else {
            this.registerSound(fGData, n, (byte)-1);
            return;
        }
        this.registerSound(fGData, n, by);
    }

    public void registerSound(FGData fGData, int n, byte by) {
        FGSoundData fGSoundData = new FGSoundData();
        fGSoundData.m_type = by;
        fGSoundData.m_id = n;
        this.m_registerError = "np";
        try {
            String string = "audio/midi";
            if (fGSoundData.m_type == 0) {
                string = "audio/x-wav";
            }
            if (this.m_bCreateNewPlayers) {
                fGSoundData.m_player = null;
                fGSoundData.m_soundData = fGData;
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fGData.m_data);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                fGSoundData.m_player = Manager.createPlayer((InputStream)dataInputStream, (String)string);
                fGSoundData.m_soundData = null;
            }
        }
        catch (Exception exception) {
            this.m_registerError = exception.toString();
            return;
        }
        this.m_sounds.addElement(fGSoundData);
    }

    public void unregisterSound(int n) {
        FGSoundData fGSoundData = this.getSound(n);
        if (fGSoundData == null) {
            return;
        }
        if (this.m_lastPlayedSound == fGSoundData) {
            this.stop();
            this.m_lastPlayedSound = null;
        }
        this.m_sounds.removeElement(fGSoundData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int n) {
        Object object = m_synch;
        synchronized (object) {
            this.m_nextAction = 0;
            this.m_nextActionID = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = m_synch;
        synchronized (object) {
            this.m_nextAction = 1;
        }
    }

    private FGSoundData getSound(int n) {
        for (int i = 0; i < this.m_sounds.size(); ++i) {
            FGSoundData fGSoundData = (FGSoundData)this.m_sounds.elementAt(i);
            if (fGSoundData.m_id != n) continue;
            return fGSoundData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.m_nextAction == -1) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
                continue;
            }
            Object object = m_synch;
            synchronized (object) {
                switch (this.m_nextAction) {
                    case 0: {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.doPlay(this.m_nextActionID);
                        break;
                    }
                    case 1: {
                        this.doStop();
                        break;
                    }
                    case 3: {
                        return;
                    }
                }
                this.m_nextAction = (byte)-1;
                this.m_nextActionID = -1;
            }
        }
    }

    public void doPlay(int n) {
        this.m_playError = "np";
        try {
            this.doStop();
            if (!this.m_bSoundOn) {
                return;
            }
            FGSoundData fGSoundData = this.getSound(n);
            if (fGSoundData == null) {
                return;
            }
            this.m_lastPlayedSound = fGSoundData;
            if (fGSoundData == null) {
                return;
            }
            if (this.m_bCreateNewPlayers) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fGSoundData.m_soundData.m_data);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                fGSoundData.m_player = Manager.createPlayer((InputStream)dataInputStream, (String)"audio/midi");
            }
            fGSoundData.m_player.prefetch();
            fGSoundData.m_player.realize();
            fGSoundData.m_player.start();
        }
        catch (Exception exception) {
            this.m_playError = exception.toString();
        }
    }

    public void startOverLastSoundPlayed() {
        try {
            if (this.m_lastPlayedSound != null) {
                this.m_lastPlayedSound.m_player.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doStop() {
        try {
            if (this.m_lastPlayedSound != null) {
                this.m_lastPlayedSound.m_player.stop();
                this.m_lastPlayedSound.m_player.deallocate();
                if (this.m_bCreateNewPlayers) {
                    this.m_lastPlayedSound.m_player = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSoundOn(boolean bl) {
        if (this.m_bSoundOn && !bl) {
            this.stop();
        }
        this.m_bSoundOn = bl;
    }

    public boolean getSoundOn() {
        return this.m_bSoundOn;
    }

    class FGSoundData {
        public Player m_player;
        public int m_id;
        public byte m_type;
        FGData m_soundData;

        FGSoundData() {
        }
    }
}

