/*
 * Decompiled with CFR 0.152.
 */
class CVGameMode
extends CVMode {
    public static final int MODE_UNINITTED = -1;
    public static final int MODE_TUTORIAL = 1;
    public static final int MODE_SMACKTALK = 2;
    public static final int MODE_PLAY = 3;
    public static final int MODE_ARTILLERY = 4;
    public static final int MODE_OVER = 5;
    public static final int MODE_INTRO = 6;
    public static final int MAX_TERRAIN_PIECES = 60;
    public static final int MAX_FORESTS = 20;
    public static final int CLOUD_TRAVERSE_TIME = 50000;
    public static final int SKIRMISH_OFFSET = 4;
    public static final int WALL_DISTANCE = 45;
    public static final int SIDE_PLAYER = 0;
    public static final int SIDE_ENEMY = 1;
    public static final int MAX_UNITS_PER_SIDE = 16;
    public static final int RESOURCE_DISTRIBUTION_TIME = 200;
    public static final int ANGLE_CHUNK = 5;
    public static final int DIFFICULTY_EASY = 0;
    public static final int DIFFICULTY_MEDIUM = 1;
    public static final int DIFFICULTY_HARD = 2;
    public static final int NUM_DIFFICULTIES = 3;
    public static final int TIME_POPUP_DURATION = 1500;
    public static final int TIME_INTRO = 3000;
    public static final int COLOR_WALLSFORTS = 0x959595;
    public static final int COLOR_PLAYER_UNIT = 29372;
    public static final int COLOR_ENEMY_UNIT = 15539236;
    public static final int COLOR_TERRAIN = 7687204;
    public static final int COLOR_SKY = 14085631;
    public static final int COLOR_INTRO_BOX = 0x7F7F7F;
    public static final int TECH_BRONZE = 0;
    public static final int TECH_ROADS = 1;
    public static final int TECH_ARCHERY = 2;
    public static final int TECH_IRON = 3;
    public static final int TECH_CIVIL = 4;
    public static final int TECH_TRADITION = 5;
    public static final int TECH_MEDICINE = 6;
    public static final int TECH_STEEL = 7;
    public static final int TECH_RADIO = 8;
    public static final int TECH_ADV_MUNITIONS = 9;
    public static final int TECH_AGRICULTURE = 10;
    public static final int TECH_MINING = 11;
    public static final int TECH_CURRENCY = 12;
    public static final int TECH_FEUDALISM = 13;
    public static final int TECH_GUILDS = 14;
    public static final int TECH_DEMOCRACY = 15;
    public static final int TECH_RIFLING = 16;
    public static final int TECH_INDUSTRIALISM = 17;
    public static final int TECH_CHEMISTRY = 18;
    public static final int TECH_MASSMEDIA = 19;
    public static final int TECH_MASONRY = 20;
    public static final int TECH_CONSTRUCTION = 21;
    public static final int TECH_MATH = 22;
    public static final int TECH_MACHINERY = 23;
    public static final int TECH_ENGINEERING = 24;
    public static final int TECH_GUNPOWDER = 25;
    public static final int TECH_STEAM = 26;
    public static final int TECH_RAILROAD = 27;
    public static final int TECH_PLASTICS = 28;
    public static final int TECH_SATELLITES = 29;
    public static final int NUM_TECHS = 30;
    public static final int TECH_TYPE_MILITARY = 0;
    public static final int TECH_TYPE_SCIENCE = 1;
    public static final int TECH_TYPE_ENGINEERING = 2;
    public static final int TECH_MAX_EASY = 7;
    public static final int TECH_MAX_MEDIUM = 8;
    public static final int TECH_MAX_HARD = 9;
    public static final int CASTLE_FLAT_LENGTH = 5;
    public static final int TERRAIN_DOWN45 = 0;
    public static final int TERRAIN_DOWN22 = 1;
    public static final int TERRAIN_FLAT = 2;
    public static final int TERRAIN_UP22 = 3;
    public static final int TERRAIN_UP45 = 4;
    public static final int TERRAIN_FILL = 5;
    public static final int TERRAIN_CLIPL = 6;
    public static final int TERRAIN_CLIPR = 7;
    public static final int NUM_TERRAINS = 8;
    public static final int HUDCOLOR_FOODBACK = 800268;
    public static final int HUDCOLOR_OREBACK = 5054208;
    public static final int HUDCOLOR_FOODFILL = 2733095;
    public static final int HUDCOLOR_OREFILL = 0xFF6600;
    public static final int HUDCOLOR_FAILBLINK = 16581385;
    public static final int TIME_HUDBLINK = 400;
    public static final int TIME_HUDBLINK_CYCLE = 100;
    public static final int TIME_IGNORE_INPUT = 300;
    public static final int MAX_ANGLE = 60;
    public static final int SCROLL_REASON_UNKNOWN = -1;
    public static final int SCROLL_REASON_WINLOSE = 0;
    public static final int SCROLL_REASON_RESOURCER = 1;
    public static final int SCROLL_REASON_FORTWALL = 2;
    public static final int SCROLL_REASON_UNITMAKE = 3;
    public static final int TABLE_PFARMS = 1;
    public static final int TABLE_PMINES = 2;
    public static final int TABLE_PFORTS = 3;
    public static final int TABLE_EFARMS = 4;
    public static final int TABLE_EMINES = 5;
    public static final int TABLE_EFORTS = 6;
    public static final int TABLE_FORESTS = 7;
    public static final int TABLE_FWIDTH = 8;
    public static final int TABLE_MWIDTH = 9;
    public static final int TABLE_FOOD_PRODUCE_DIFF = 10;
    public static final int TABLE_ORE_PRODUCE_DIFF = 11;
    public static final int TABLE_ARTILLERY_MISS_DIFF = 12;
    public static final int MAX_FLOATERS = 5;
    public static final int FLOATER_SCREEN_TRAVERSE = 6000;
    public static final int TECH_STRUCTURE_THRESHOLD = 4;
    public static final int MAX_QPTECH = 9;
    public static final int MAX_QPTECH_ADD = 3;
    public static final int MAX_QP_LEVEL_LINE = 10;
    public static final int SPARKLE_ANIM_TIME = 150;
    public static final int SMALL_POWERBAR_WIDTH = 71;
    public static final int SMALL_POWERBAR_HEIGHT = 6;
    public int TERRAIN_PIECE_WIDTH;
    public int STEEP_HILL_HEIGHT;
    public int NUM_EXPLOSION_FRAMES;
    public int NUM_SMOKE_FRAMES;
    public int clickcounter = 0;
    public boolean m_bIsCampaign;
    public int m_mode;
    public int m_subMode;
    public int m_winner;
    public int m_era;
    public int m_mapID;
    boolean m_bPaused;
    public FGLayout m_map = new FGLayout();
    public FGLayout m_background = new FGLayout();
    public FGLayout m_backgroundSky = new FGLayout();
    public FGLayout m_backgroundClouds = new FGLayout();
    public FGResLoader m_loader = new FGResLoader();
    int m_backgroundY;
    public int m_scroll;
    public boolean m_bTrackArtillery;
    public int m_scrollDistance;
    public int[] m_terrainLeftHeights = new int[60];
    public int[] m_terrainRightHeights = new int[60];
    public int[] m_terrainYValues = new int[60];
    public int[] m_terrainTypes = new int[60];
    public int[] m_cornerClipTypes = new int[60];
    public int m_numTerrainTiles;
    CVArmy[] m_armies = new CVArmy[2];
    public int m_numForests;
    public int[] m_fixForestStarts = new int[20];
    public int[] m_fixForestEnds = new int[20];
    public int m_skirmishUnitType;
    public int m_fixSkirmishX1;
    public int m_fixSkirmishX2;
    public boolean m_bSkirmishExists;
    public int m_fixSkirmishCenter;
    int m_fixBorderX;
    boolean m_bBorderMoved;
    FGTimer m_engineeringTimer = new FGTimer();
    FGTimer m_resourceGainTimer = new FGTimer();
    int m_aiDesiredUnitType;
    int m_maxPower;
    int m_power;
    int m_angle;
    int m_lastPower;
    int m_lastAngle;
    FGVector w_workingVector = new FGVector();
    FGTimer m_artilleryUITimer = new FGTimer();
    boolean m_bSelectingAngle;
    boolean m_bEnemyCanBuild;
    boolean m_bEnemyCanFire;
    boolean m_bShowingPopup;
    FGString m_popupStr = new FGString();
    FGTimer m_popupTimer = new FGTimer();
    FGImage m_flag;
    FGLayout m_hud = new FGLayout();
    FGImage m_powerBarEmpty;
    FGImage m_powerBarFull;
    FGImage m_lastPowerImg;
    FGImage[] m_terrainTileImages = new FGImage[8];
    FGImage m_angleImg;
    FGImage m_angleCapImg;
    FGImage m_angleSelectImg;
    FGImage m_lastAngleImg;
    FGImage m_tutorialArrowUpImg;
    FGImage m_tutorialArrowDownImg;
    FGImage m_tutorialParchmentFill;
    FGImage m_tutorialParchmentTop;
    FGImage m_tutorialParchmentBottom;
    FGImage m_milStructure;
    FGImage m_sciStructure;
    FGImage m_engStructure;
    FGImage m_skullImg;
    FGImage m_infIconOff;
    FGImage m_infIconOn;
    FGImage m_ranIconOff;
    FGImage m_ranIconOn;
    FGImage m_mobIconOff;
    FGImage m_mobIconOn;
    FGImage m_artIconOff;
    FGImage m_artIconOn;
    FGImage m_infIconGlow;
    FGImage m_ranIconGlow;
    FGImage m_mobIconGlow;
    FGImage m_artIconGlow;
    FGImage m_strongWall;
    FGImage m_strongFort;
    FGImage m_dottedLine;
    FGImage m_sky;
    int m_angleSelectLength;
    int m_angleCapOffsetX;
    FGLayout m_redFrameLayout = new FGLayout();
    FGLayout m_blueFrameLayout = new FGLayout();
    FGTimer m_uiBlinkTimer = new FGTimer();
    boolean m_bBlinkingFoodBar;
    int m_blinkPct;
    int m_blinkIcon;
    FGTimer m_iconBlinkTimer = new FGTimer();
    FGString[] m_terrainTileFileNames = new FGString[8];
    FGAnimation m_explosion = new FGAnimation();
    boolean m_bRedrawFull;
    boolean m_bArtilleryStutter;
    FGTweaks m_tutorial = new FGTweaks();
    String m_tutorialText;
    int m_numTutorialSteps;
    int m_tutorialPointAtX;
    int m_tutorialPointAtY;
    int m_tutorialBoxY;
    int m_tutorialBoxH;
    boolean m_bPointingUp;
    FGImage m_tutorialImage;
    int m_tutorialStep;
    boolean[] m_bFloaterExists = new boolean[5];
    FGVector[] m_floaterPos = new FGVector[5];
    FGImage[] m_floaterImage = new FGImage[5];
    int m_diffProduceFood;
    int m_diffProduceOre;
    int m_diffMiss;
    int m_difficulty;
    int[] m_techMax = new int[3];
    boolean m_bGameInProgress;
    boolean m_bExternalTutorial;
    boolean m_bTutorialReturnToHelpMenu;
    FGTimer m_ignoreInputTimer = new FGTimer();
    FGAnimation m_sparkleAnim = new FGAnimation();
    FGString m_introMsg = new FGString();
    FGTimer m_introTimer = new FGTimer();
    int m_fixCloudOffset;

    public CVGameMode() {
        int n;
        for (n = 0; n < 2; ++n) {
            this.m_armies[n] = new CVArmy();
        }
        for (n = 0; n < 5; ++n) {
            this.m_floaterPos[n] = new FGVector();
        }
        this.m_terrainTileFileNames[0] = new FGString("terrain_down45.png");
        this.m_terrainTileFileNames[1] = new FGString("terrain_down22.png");
        this.m_terrainTileFileNames[2] = new FGString("terrain_flat.png");
        this.m_terrainTileFileNames[3] = new FGString("terrain_up22.png");
        this.m_terrainTileFileNames[4] = new FGString("terrain_up45.png");
        this.m_terrainTileFileNames[5] = new FGString("terrain_fill1.png");
        this.m_terrainTileFileNames[6] = new FGString("terrain_clipl.png");
        this.m_terrainTileFileNames[7] = new FGString("terrain_clipr.png");
        this.m_bGameInProgress = false;
        this.m_bExternalTutorial = false;
        this.m_techMax[0] = 7;
        this.m_techMax[1] = 8;
        this.m_techMax[2] = 9;
        if (CVEngine.isLarge()) {
            this.TERRAIN_PIECE_WIDTH = 24;
            this.NUM_EXPLOSION_FRAMES = 4;
            this.NUM_SMOKE_FRAMES = 5;
        } else if (CVEngine.isMedium()) {
            this.TERRAIN_PIECE_WIDTH = 18;
            this.NUM_EXPLOSION_FRAMES = 4;
            this.NUM_SMOKE_FRAMES = 5;
        } else if (CVEngine.isSmall()) {
            this.TERRAIN_PIECE_WIDTH = 12;
            this.NUM_EXPLOSION_FRAMES = 2;
            this.NUM_SMOKE_FRAMES = 2;
        }
        this.STEEP_HILL_HEIGHT = this.TERRAIN_PIECE_WIDTH / 2 + 1;
    }

    public void init() {
        super.init();
        this.m_scrollDistance = this.m_engine.getScreenWidth() / 4;
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].init(this, i);
        }
        this.m_bPaused = false;
    }

    public void tick() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.m_mode == -1) {
            this.doStartNewGame();
            return;
        }
        if (this.m_mode == 6) {
            if (this.m_introTimer.isOver()) {
                this.advanceFromIntro();
            }
            return;
        }
        if (this.m_mode == 1 || this.m_mode == 2) {
            return;
        }
        CVGameMode cVGameMode = this;
        if (!cVGameMode.m_engine.isSmall() && !this.m_bPaused) {
            n7 = FGFixed.toFixed(this.m_engine.getTickTime());
            n6 = this.m_engine.getScreenWidth() * 1000 / 50000;
            n5 = FGFixed.toFixed(n6);
            this.m_fixCloudOffset = FGGeometry.applyPPSVel(this.m_fixCloudOffset, n5, n7);
            n4 = FGFixed.toFixed(this.m_backgroundClouds.getWidth());
            if (this.m_fixCloudOffset > n4) {
                this.m_fixCloudOffset -= n4;
            }
        }
        this.m_armies[0].tick();
        this.m_armies[1].tick();
        if (this.m_mode == 5) {
            return;
        }
        if (this.m_mode == 4) {
            this.tickArtillery();
            return;
        }
        this.tickFloaters();
        this.m_bBorderMoved = false;
        if (this.m_bShowingPopup && this.m_popupTimer.isOver()) {
            this.m_bShowingPopup = false;
        }
        if (this.m_resourceGainTimer.isOver()) {
            n7 = this.m_engine.m_foodBase;
            if (this.hasTech(0, 14)) {
                n7 = this.percentifyTech(n7, 0, 14);
            } else if (this.hasTech(0, 10)) {
                n7 = this.percentifyTech(n7, 0, 10);
            }
            n6 = this.m_engine.m_foodBase;
            if (this.hasTech(1, 14)) {
                n6 = this.percentifyTech(n6, 1, 14);
            } else if (this.hasTech(1, 10)) {
                n6 = this.percentifyTech(n6, 1, 10);
            }
            n5 = this.m_engine.m_oreBase;
            if (this.hasTech(0, 23)) {
                n5 = this.percentifyTech(n5, 0, 23);
            } else if (this.hasTech(0, 11)) {
                n5 = this.percentifyTech(n5, 0, 11);
            }
            n4 = this.m_engine.m_oreBase;
            if (this.hasTech(1, 23)) {
                n4 = this.percentifyTech(n4, 1, 23);
            } else if (this.hasTech(1, 11)) {
                n4 = this.percentifyTech(n4, 1, 11);
            }
            n3 = FGFixed.toInt(this.m_fixBorderX);
            n7 += this.m_engine.m_foodPerFarm * this.m_armies[0].m_farmsControlled;
            n6 += this.m_engine.m_foodPerFarm * this.m_armies[1].m_farmsControlled;
            n5 += this.m_engine.m_orePerMine * this.m_armies[0].m_minesControlled;
            n4 += this.m_engine.m_orePerMine * this.m_armies[1].m_minesControlled;
            n7 = n7 * 200 / 1000;
            n6 = n6 * 200 / 1000;
            n5 = n5 * 200 / 1000;
            n4 = n4 * 200 / 1000;
            n6 = this.getEnemyProduction(n6, true);
            n4 = this.getEnemyProduction(n4, false);
            this.m_armies[0].m_food += n7;
            this.m_armies[0].m_ore += n5;
            this.m_armies[1].m_food += n6;
            this.m_armies[1].m_ore += n4;
            this.m_armies[0].capResources();
            this.m_armies[1].capResources();
            this.m_resourceGainTimer.start(200);
        }
        if (this.m_engineeringTimer.isOver()) {
            for (n7 = 0; n7 < 2; ++n7) {
                if (!this.hasTech(n7, 24)) continue;
                n6 = this.getStartHP(3, n7);
                n5 = this.getStartHP(4, n7);
                for (n4 = 0; n4 < 16; ++n4) {
                    CVUnit cVUnit = this.m_armies[n7].m_units[n4];
                    if (!cVUnit.mechanicallyExists() || !cVUnit.isFortOrWall()) continue;
                    ++cVUnit.m_hp;
                    n2 = 1;
                    n = n6;
                    if (cVUnit.m_type == 4) {
                        n = n5;
                    }
                    if (cVUnit.m_hp > n) {
                        cVUnit.m_hp = n;
                        n2 = 0;
                    }
                    if (n2 == 0) continue;
                    cVUnit.addFloater(2);
                }
            }
            this.m_engineeringTimer.start(this.m_engine.m_techValues[24]);
        }
        this.ai();
        this.m_armies[0].m_fixForwardMost = -1L;
        this.m_armies[1].m_fixForwardMost = -1L;
        CVUnit cVUnit = this.getForwardMostUnit(-1, 0);
        if (cVUnit != null) {
            this.m_armies[0].m_fixForwardMost = cVUnit.m_fixX;
        }
        if ((cVUnit = this.getForwardMostUnit(-1, 1)) != null) {
            this.m_armies[1].m_fixForwardMost = cVUnit.m_fixX;
        }
        for (n6 = 0; n6 < 16; ++n6) {
            if (!this.m_armies[0].m_units[n6].isValid()) continue;
            this.m_armies[0].m_units[n6].tick();
        }
        for (n6 = 0; n6 < 16; ++n6) {
            if (!this.m_armies[1].m_units[n6].isValid()) continue;
            this.m_armies[1].m_units[n6].tick();
        }
        this.tickSkirmish();
        if (this.m_mode == 5) {
            return;
        }
        n6 = this.m_armies[0].m_minesControlled;
        n5 = this.m_armies[0].m_farmsControlled;
        this.updateFarmsAndMines();
        n4 = FGFixed.toInt(this.m_fixBorderX);
        if (n6 > this.m_armies[0].m_minesControlled) {
            this.popup(this.m_engine.m_strings.getString("STR_ALERT_LOSE_MINE"));
            if (this.hasTech(1, 26)) {
                this.addSteamOre(1);
            }
        }
        if (n6 < this.m_armies[0].m_minesControlled) {
            this.popup(this.m_engine.m_strings.getString("STR_ALERT_GET_MINE"));
            if (this.hasTech(0, 26)) {
                this.addSteamOre(0);
            }
        }
        if (n5 > this.m_armies[0].m_farmsControlled) {
            this.popup(this.m_engine.m_strings.getString("STR_ALERT_LOSE_FARM"));
            if (this.hasTech(1, 15)) {
                this.addDemocracyArmy(1);
            }
        }
        if (n5 < this.m_armies[0].m_farmsControlled) {
            this.popup(this.m_engine.m_strings.getString("STR_ALERT_GET_FARM"));
            if (this.hasTech(0, 15)) {
                this.addDemocracyArmy(0);
            }
        }
        n3 = 0;
        if (this.m_armies[0].m_artillery.m_bActive) {
            n3 = 1;
        }
        this.m_armies[0].m_artillery.tick();
        this.m_armies[1].m_artillery.tick();
        if (n3 != 0 && this.m_bTrackArtillery) {
            if (this.m_armies[0].m_artillery.m_bActive) {
                n2 = FGFixed.toInt(this.m_armies[0].m_artillery.m_pos.m_fixX);
                this.centerScroll(n2);
            } else {
                this.m_bTrackArtillery = false;
            }
        }
        if (!this.m_bBorderMoved) {
            n2 = this.m_engine.m_techValues[19];
            n = 0;
            if (this.hasTech(0, 19)) {
                n = FGFixed.toFixed(n2);
            }
            if (this.hasTech(1, 19)) {
                n -= FGFixed.toFixed(n2);
            }
            if (n != 0) {
                int n8 = FGFixed.toFixed(this.m_engine.getTickTime());
                this.m_fixBorderX = FGGeometry.applyPPSVel(this.m_fixBorderX, n, n8);
                this.boundsCheckBorder();
            }
        }
    }

    public void addDemocracyArmy(int n) {
        int n2 = FGFixed.toInt(this.m_fixBorderX);
        n2 = n == 0 ? (n2 -= 4) : (n2 += 4);
        this.addUnit(0, n, n2);
        this.addTechFloater(n2, 1);
    }

    public void addSteamOre(int n) {
        if (this.m_armies[n].m_ore > this.m_engine.m_artilleryCost) {
            return;
        }
        this.m_armies[n].m_ore = this.m_engine.m_artilleryCost;
        int n2 = FGFixed.toInt(this.m_fixBorderX);
        this.addTechFloater(n2, 2);
    }

    public void autoScroll(int n, int n2) {
        if (n2 == 0) {
            this.m_bTrackArtillery = false;
            this.centerScroll(n);
            return;
        }
        if (this.m_bTrackArtillery) {
            return;
        }
        if (n > this.m_scroll && n < this.m_scroll + this.m_engine.getScreenWidth()) {
            return;
        }
        this.centerScroll(n);
    }

    public void boundsCheckBorder() {
        int n = FGFixed.toInt(this.m_fixBorderX);
        if (n < this.m_armies[0].m_unitsStart) {
            this.m_fixBorderX = FGFixed.toFixed(this.m_armies[0].m_unitsStart);
            return;
        }
        if (n > this.m_armies[1].m_unitsStart) {
            this.m_fixBorderX = FGFixed.toFixed(this.m_armies[1].m_unitsStart);
        }
    }

    public void updateFarmsAndMines() {
        this.m_armies[0].m_minesControlled = 0;
        this.m_armies[1].m_minesControlled = 0;
        this.m_armies[0].m_farmsControlled = 0;
        this.m_armies[1].m_farmsControlled = 0;
        int n = FGFixed.toInt(this.m_fixBorderX);
        for (int i = 0; i < this.m_map.m_numElements; ++i) {
            int n2 = 1;
            int n3 = this.m_map.m_xValues[i] + this.m_map.m_widths[i] / 2;
            if (n >= n3) {
                n2 = 0;
            }
            if (FGString.nativeEquals(this.m_map.getElementIDString(i), "farm")) {
                ++this.m_armies[n2].m_farmsControlled;
                this.m_map.m_images[i] = this.m_armies[n2].m_farmImg;
            }
            if (!FGString.nativeEquals(this.m_map.getElementIDString(i), "mine")) continue;
            ++this.m_armies[n2].m_minesControlled;
            this.m_map.m_images[i] = this.m_armies[n2].m_mineImg;
        }
    }

    public void castleHit(int n) {
        int n2 = this.percentifyTech(this.m_engine.m_artilleryFoodDestroy, n, 21);
        int n3 = this.percentifyTech(this.m_engine.m_artilleryOreDestroy, n, 21);
        this.m_armies[n].m_food -= n2;
        this.m_armies[n].m_ore -= n3;
        this.m_armies[n].capResources();
        this.m_armies[n].startCastleHitAnim();
    }

    public void ai() {
        if (this.m_armies[1].m_food >= this.getUnitCost(1, this.m_aiDesiredUnitType) && this.m_bEnemyCanBuild) {
            this.buildUnit(this.m_aiDesiredUnitType, 1);
            this.m_armies[1].m_food -= this.getUnitCost(1, this.m_aiDesiredUnitType);
            this.m_aiDesiredUnitType = this.m_engine.rand() % 3;
        }
        if (this.canFireArtillery(1)) {
            CVUnit cVUnit;
            int n;
            int n2 = FGFixed.toInt(this.m_armies[1].m_artilleryStart.m_fixX);
            int n3 = -1;
            CVUnit cVUnit2 = this.getForwardWall(1);
            if (cVUnit2 != null) {
                for (n = 0; n < 16; ++n) {
                    cVUnit = this.m_armies[0].m_units[n];
                    if (!cVUnit.isValid() || cVUnit.m_fixX != cVUnit2.m_fixX) continue;
                    n3 = FGFixed.toInt(cVUnit.m_fixX);
                }
            }
            if (this.m_bSkirmishExists && n3 == -1 && this.m_armies[0].m_numUnitsInSkirmish == this.m_armies[1].m_numUnitsInSkirmish) {
                n3 = FGFixed.toInt(this.m_fixSkirmishCenter);
            }
            if (n3 == -1) {
                n = this.m_engine.rand() % 3;
                if (n == 0) {
                    n3 = this.m_armies[0].m_unitsStart;
                } else if (n == 1 && (cVUnit = this.getForwardWall(0)) != null) {
                    n3 = FGFixed.toInt(cVUnit.m_fixX);
                }
                if (n3 == -1) {
                    n3 = this.m_engine.rand() % this.m_map.getWidth();
                }
            }
            n = n2 - n3;
            int n4 = this.getEnemyDeviance();
            if (n4 > 0 && n > n4 * 2) {
                int n5 = this.m_engine.rand() % (2 * n4) - n4;
                if ((n += n4) < 0) {
                    n = 0;
                }
            }
            this.m_armies[1].m_artillery.fire(n);
            this.m_armies[1].m_ore -= this.m_engine.m_artilleryCost;
            this.playArtilleryFire(1);
        }
    }

    public int getOtherSide(int n) {
        if (n == 0) {
            return 1;
        }
        return 0;
    }

    public CVUnit getForwardMostUnit(int n, int n2) {
        CVUnit cVUnit = null;
        for (int i = 0; i < 16; ++i) {
            CVUnit cVUnit2 = this.m_armies[n2].m_units[i];
            if (!cVUnit2.mechanicallyExists() || n != -1 && cVUnit2.m_type != n) continue;
            if (cVUnit == null) {
                cVUnit = cVUnit2;
                continue;
            }
            if (!this.passed(cVUnit2.m_fixX, cVUnit.m_fixX, n2)) continue;
            cVUnit = cVUnit2;
        }
        return cVUnit;
    }

    public CVUnit getForwardMostNonWallUnit(int n) {
        CVUnit cVUnit = null;
        for (int i = 0; i < 16; ++i) {
            CVUnit cVUnit2 = this.m_armies[n].m_units[i];
            if (!cVUnit2.mechanicallyExists() || cVUnit2.isFortOrWall()) continue;
            if (cVUnit == null) {
                cVUnit = cVUnit2;
                continue;
            }
            if (!this.passed(cVUnit2.m_fixX, cVUnit.m_fixX, n)) continue;
            cVUnit = cVUnit2;
        }
        return cVUnit;
    }

    public boolean passed(int n, int n2, int n3) {
        if (n3 == 0) {
            return n > n2;
        }
        return n < n2;
    }

    public void drawSelf(FGGraphics fGGraphics) {
        try {
            this.doDrawSelf(fGGraphics);
        }
        catch (Exception exception) {
            this.m_engine.m_mainFont.drawText(fGGraphics, exception.toString(), 0, 0, this.m_engine.getScreenWidth());
        }
    }

    public void doDrawSelf(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3;
        if (this.m_mode == -1) {
            return;
        }
        if (this.m_mode == 4) {
            if (!this.m_bRedrawFull) {
                this.drawArtilleryUI(fGGraphics);
                return;
            }
            this.m_bRedrawFull = false;
        }
        int n4 = this.m_engine.getScreenWidth();
        int n5 = this.m_engine.getScreenHeight();
        this.drawBackground(fGGraphics);
        int n6 = this.m_scroll / this.TERRAIN_PIECE_WIDTH;
        int n7 = (this.m_scroll + n4) / this.TERRAIN_PIECE_WIDTH;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n7 >= this.m_numTerrainTiles) {
            n7 = this.m_numTerrainTiles - 1;
        }
        FGImage fGImage = this.getTerrainTileImage(5);
        for (n3 = n6; n3 <= n7; ++n3) {
            n2 = n3 * this.TERRAIN_PIECE_WIDTH - this.m_scroll;
            n = this.m_terrainYValues[n3];
            FGImage fGImage2 = this.getTerrainTileImage(this.m_terrainTypes[n3]);
            fGImage2.drawSelf(fGGraphics, n2, n);
            n += fGImage2.getHeight();
            if (this.m_cornerClipTypes[n3] != -1) {
                FGImage fGImage3 = this.getTerrainTileImage(this.m_cornerClipTypes[n3]);
                fGImage3.drawSelf(fGGraphics, n2, n);
                n += fGImage3.getHeight();
            }
            fGImage.drawTiled(fGGraphics, n2, n, this.TERRAIN_PIECE_WIDTH, n5 - n);
        }
        this.m_map.drawSelf(fGGraphics, -this.m_scroll, 0);
        this.m_armies[0].drawCastle(fGGraphics);
        this.m_armies[1].drawCastle(fGGraphics);
        n3 = FGFixed.toInt(this.m_fixBorderX);
        n2 = this.getTerrainY(n3);
        n3 -= this.m_scroll;
        n2 -= this.m_flag.getHeight();
        this.m_flag.drawSelf(fGGraphics, n3 -= this.m_flag.getWidth() / 2, n2 += this.m_armies[0].m_unitOffsetY);
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 16; ++i) {
                if (!this.m_armies[n].m_units[i].isValid() || !this.m_armies[n].m_units[i].isEarlyDrawer()) continue;
                this.m_armies[n].m_units[i].drawSelf(fGGraphics);
            }
        }
        for (n = 0; n < 2; ++n) {
            for (int i = 0; i < 16; ++i) {
                if (!this.m_armies[n].m_units[i].isValid() || this.m_armies[n].m_units[i].isEarlyDrawer()) continue;
                this.m_armies[n].m_units[i].drawSelf(fGGraphics);
            }
        }
        this.m_armies[0].drawBurn(fGGraphics);
        this.m_armies[1].drawBurn(fGGraphics);
        this.m_armies[0].m_artillery.drawSelf(fGGraphics, -this.m_scroll, 0);
        this.m_armies[1].m_artillery.drawSelf(fGGraphics, -this.m_scroll, 0);
        if (this.m_mode == 5) {
            FGString fGString = new FGString();
            if (this.m_winner == 0) {
                fGString.set(this.m_engine.m_strings.getString("STR_YOU_WIN"));
            } else {
                fGString.set(this.m_engine.m_strings.getString("STR_YOU_LOSE"));
            }
            FGFont fGFont = this.m_engine.m_mainFont;
            int n8 = this.m_hud.getHeight() + fGFont.getHeight() / 2;
            fGFont.setJustify(2);
            fGFont.drawText(fGGraphics, fGString.getNativeString(), 0, n8, n4);
            fGFont.setJustify(0);
            return;
        }
        if (this.m_mode == 4) {
            this.drawArtilleryUI(fGGraphics);
        }
        if (this.m_mode == 2) {
            this.drawSmacktalk(fGGraphics);
        } else if (this.m_mode == 6) {
            this.drawIntro(fGGraphics);
        } else {
            this.drawHud(fGGraphics);
        }
        if (this.m_bShowingPopup && this.m_mode == 3) {
            FGFont fGFont = this.m_engine.m_mainFont;
            int n9 = this.m_hud.getHeight() + fGFont.getHeight() / 2;
            fGFont.setJustify(2);
            fGFont.drawText(fGGraphics, this.m_popupStr.getNativeString(), 0, n9, this.m_engine.getScreenWidth());
            fGFont.setJustify(0);
        }
        this.drawFloaters(fGGraphics);
        if (this.m_mode == 1) {
            this.drawTutorial(fGGraphics);
        }
    }

    public void drawBackground(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isLarge()) {
            fGGraphics.setColor(this.m_background.m_backgroundColor);
            fGGraphics.fillRect(0, 0, n, n2);
            int n3 = this.m_map.getWidth() - n;
            int n4 = this.m_background.getWidth() - n;
            int n5 = this.m_scroll * n4 / n3;
            this.m_backgroundSky.drawSelf(fGGraphics, -n5, this.m_backgroundY);
            int n6 = FGFixed.toInt(this.m_fixCloudOffset) - n5;
            this.m_backgroundClouds.drawSelf(fGGraphics, n6, this.m_backgroundY);
            this.m_backgroundClouds.drawSelf(fGGraphics, n6 -= this.m_backgroundClouds.getWidth(), this.m_backgroundY);
            this.m_background.drawSelf(fGGraphics, -n5, this.m_backgroundY);
        } else {
            CVGameMode cVGameMode2 = this;
            if (cVGameMode2.m_engine.isMedium()) {
                this.m_sky.drawTiled(fGGraphics, 0, 0, n, this.m_sky.getHeight());
                int n7 = this.m_map.getWidth() - n;
                int n8 = this.m_backgroundClouds.getWidth() - n;
                int n9 = this.m_scroll * n8 / n7;
                int n10 = FGFixed.toInt(this.m_fixCloudOffset) - n9;
                this.m_backgroundClouds.drawSelf(fGGraphics, n10, this.m_backgroundY);
                this.m_backgroundClouds.drawSelf(fGGraphics, n10 -= this.m_backgroundClouds.getWidth(), this.m_backgroundY);
            } else {
                fGGraphics.setColor(14085631);
                fGGraphics.fillRect(0, 0, n, n2);
            }
        }
    }

    public void drawIntro(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        FGFont fGFont = this.m_engine.m_mainFont;
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            String string = this.m_engine.m_strings.getString("STR_VS");
            FGString fGString = new FGString();
            fGString.add(this.m_armies[0].m_civName.getNativeString());
            fGString.add(" ");
            fGString.add(string);
            fGString.add(" ");
            fGString.add(this.m_armies[1].m_civName.getNativeString());
            int n3 = (n2 - fGFont.getHeight()) / 2;
            fGFont.setJustify(2);
            fGFont.drawText(fGGraphics, fGString.getNativeString(), 0, n3, n);
            fGFont.setJustify(0);
        } else {
            FGFont fGFont2 = this.m_engine.m_titleFont;
            int n4 = this.getPortraitWidth();
            int n5 = this.getPortraitHeight();
            int n6 = fGFont.getHeight();
            String string = this.m_engine.m_strings.getString("STR_VS");
            int n7 = fGFont2.getDisplayLength(string) * 2;
            int n8 = n7 + n4 * 2;
            int n9 = (n - n8) / 2;
            int n10 = n9 + n4 + n7;
            this.drawPortrait(fGGraphics, n9, n6, this.m_armies[0].m_civID, 0);
            this.drawPortrait(fGGraphics, n10, n6, this.m_armies[1].m_civID, 1);
            int n11 = n6 + (n5 - fGFont2.getHeight()) / 2;
            fGFont2.setJustify(2);
            fGFont2.drawText(fGGraphics, string, n / 2, n11);
            fGFont2.setJustify(0);
            n6 += n5;
            int n12 = n9 + n4 / 2;
            int n13 = n10 + n4 / 2;
            fGFont.setJustify(2);
            fGFont.drawText(fGGraphics, this.m_armies[0].m_civName.getNativeString(), n12, n6 += fGFont.getHeight() / 4);
            fGFont.drawText(fGGraphics, this.m_armies[1].m_civName.getNativeString(), n13, n6);
            fGFont.drawText(fGGraphics, this.m_introMsg.getNativeString(), 0, n6 += fGFont.getHeight() * 2, n);
            fGFont.setJustify(0);
        }
    }

    public void drawSmacktalk(FGGraphics fGGraphics) {
        int n = this.m_engine.getScreenWidth();
        int n2 = this.m_engine.getScreenHeight();
        String string = null;
        String string2 = null;
        switch (this.m_armies[1].m_civID) {
            case 0: {
                string = "STR_SMACKTALK_0";
                string2 = "STR_BATTLE_ROME";
                break;
            }
            case 1: {
                string = "STR_SMACKTALK_1";
                string2 = "STR_BATTLE_TOKYO";
                break;
            }
            case 2: {
                string = "STR_SMACKTALK_2";
                string2 = "STR_BATTLE_MOSCOW";
                break;
            }
            case 3: {
                string = "STR_SMACKTALK_3";
                string2 = "STR_BATTLE_WASHINGTON";
            }
        }
        FGFont fGFont = this.m_engine.m_mainFont;
        String string3 = this.m_engine.m_strings.getString(string);
        String string4 = this.m_engine.m_strings.getString(string2);
        int n3 = 5;
        this.m_engine.drawScreenTitle(fGGraphics, string4);
        int n4 = this.getPortraitWidth();
        int n5 = this.getPortraitHeight();
        int n6 = this.m_engine.getScreenTitleHeight(string4);
        int n7 = (n - n4) / 2;
        this.drawPortrait(fGGraphics, n7, n6, this.m_armies[1].m_civID, 1);
        int n8 = n6 + n5 + n3;
        int n9 = n - n3 * 2;
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, string3, n3, n8, n9);
        fGFont.setJustify(0);
    }

    public void drawTutorial(FGGraphics fGGraphics) {
        int n;
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            return;
        }
        int n2 = this.m_engine.getScreenWidth();
        int n3 = this.m_engine.getScreenHeight();
        FGFont fGFont = this.m_engine.m_mainFont;
        int n4 = this.m_tutorialBoxY;
        this.m_tutorialParchmentTop.drawTiled(fGGraphics, 0, n4, n2, this.m_tutorialParchmentTop.getHeight());
        int n5 = n4 += this.m_tutorialParchmentTop.getHeight();
        int n6 = this.m_tutorialBoxH - this.m_tutorialParchmentTop.getHeight() - this.m_tutorialParchmentBottom.getHeight();
        this.m_tutorialParchmentFill.drawTiled(fGGraphics, 0, n4, n2, n6);
        this.m_tutorialParchmentBottom.drawTiled(fGGraphics, 0, n4 += n6, n2, this.m_tutorialParchmentBottom.getHeight());
        int n7 = fGFont.getSpaceWidth();
        int n8 = this.m_engine.getScreenWidth() - n7 * 2;
        if (this.m_tutorialImage != null) {
            n = (n2 - this.m_tutorialImage.getWidth()) / 2;
            this.m_tutorialImage.drawSelf(fGGraphics, n, n5);
            n5 += this.m_tutorialImage.getHeight();
            n5 += n7;
        }
        fGFont.setJustify(2);
        fGFont.drawText(fGGraphics, this.m_tutorialText, 0, n5, n8);
        fGFont.setJustify(0);
        if (this.m_tutorialPointAtX != -1) {
            if (this.m_bPointingUp) {
                n = this.m_tutorialPointAtX - this.m_tutorialArrowUpImg.getWidth() / 2;
                int n9 = this.m_tutorialPointAtY;
                this.m_tutorialArrowUpImg.drawSelf(fGGraphics, n, n9);
            } else {
                n = this.m_tutorialPointAtX - this.m_tutorialArrowDownImg.getWidth() / 2;
                int n10 = this.m_tutorialPointAtY - this.m_tutorialArrowDownImg.getHeight();
                this.m_tutorialArrowDownImg.drawSelf(fGGraphics, n, n10);
            }
        }
    }

    public void drawArtilleryUI(FGGraphics fGGraphics) {
        int n = FGFixed.toInt(this.m_armies[0].m_artilleryStart.m_fixX);
        int n2 = FGFixed.toInt(this.m_armies[0].m_artilleryStart.m_fixY);
        int n3 = n2 - this.m_angleImg.getHeight();
        this.m_angleImg.drawSelf(fGGraphics, n, n3);
        this.m_angleCapImg.drawSelf(fGGraphics, n + this.m_angleCapOffsetX, n2);
        this.drawArtilleryIndicator(fGGraphics, this.m_lastAngleImg, this.m_lastAngle);
        this.drawArtilleryIndicator(fGGraphics, this.m_angleSelectImg, this.m_angle);
        if (!this.m_bSelectingAngle) {
            int n4;
            int n5;
            int n6;
            CVGameMode cVGameMode = this;
            if (cVGameMode.m_engine.isSmall()) {
                n6 = 71;
                n5 = 6;
                n4 = n3 - 6 - 3;
            } else {
                n6 = this.m_powerBarEmpty.getWidth();
                n5 = this.m_powerBarEmpty.getHeight();
                n4 = n3 - this.m_powerBarEmpty.getHeight() - this.m_powerBarEmpty.getHeight() / 2;
            }
            int n7 = (this.m_engine.getScreenWidth() - n6) / 2;
            int n8 = n6 * this.m_power / this.m_maxPower;
            CVGameMode cVGameMode2 = this;
            if (cVGameMode2.m_engine.isSmall()) {
                fGGraphics.setColor(0x7F7F7F);
                fGGraphics.fillRect(n7, n4, n6, n5);
                fGGraphics.setColor(0xFF0000);
                fGGraphics.fillRect(n7, n4, n8, n5);
                fGGraphics.setColor(0);
                fGGraphics.drawRect(n7, n4, n6, n5);
            } else {
                this.m_powerBarEmpty.drawSelf(fGGraphics, n7, n4);
                this.m_powerBarFull.drawTiled(fGGraphics, n7, n4, n8, this.m_powerBarFull.getHeight());
            }
            if (this.m_lastPower != -1) {
                int n9 = n4 + (n5 - this.m_lastPowerImg.getHeight()) / 2;
                int n10 = n7 + n6 * this.m_lastPower / this.m_maxPower;
                int n11 = n10 - this.m_lastPowerImg.getWidth() / 2;
                this.m_lastPowerImg.drawSelf(fGGraphics, n11, n9);
            }
        }
    }

    public void drawArtilleryIndicator(FGGraphics fGGraphics, FGImage fGImage, int n) {
        if (n == -1) {
            return;
        }
        int n2 = FGFixed.toInt(this.m_armies[0].m_artilleryStart.m_fixX);
        int n3 = FGFixed.toInt(this.m_armies[0].m_artilleryStart.m_fixY);
        int n4 = -n;
        this.w_workingVector.setRTheta(FGFixed.toFixed(this.m_angleSelectLength), FGFixed.toFixedFourkays(n4));
        this.w_workingVector.addVector(this.m_armies[0].m_artilleryStart);
        int n5 = FGFixed.toInt(this.w_workingVector.m_fixX);
        int n6 = FGFixed.toInt(this.w_workingVector.m_fixY);
        fGImage.drawSelf(fGGraphics, n5 - this.m_angleSelectImg.getWidth() / 2, n6 - this.m_angleSelectImg.getHeight() / 2);
    }

    public int getNumRecourcersControlled(int n, String string) {
        int n2 = 0;
        int n3 = FGFixed.toInt(this.m_fixBorderX);
        for (int i = 0; i < this.m_map.m_numElements; ++i) {
            if (!FGString.nativeEquals(this.m_map.getElementIDString(i), string)) continue;
            int n4 = this.m_map.m_xValues[i] + this.m_map.m_widths[i] / 2;
            if (n3 >= n4) {
                if (n != 0) continue;
                ++n2;
                continue;
            }
            if (n != 1) continue;
            ++n2;
        }
        return n2;
    }

    public int getFoodBarMax() {
        return this.m_engine.m_unitCosts[2];
    }

    public int getOreBarMax() {
        return this.m_engine.m_artilleryCost;
    }

    public int getPortraitHeight() {
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            return 0;
        }
        return this.m_redFrameLayout.getWidth();
    }

    public int getPortraitWidth() {
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            return 0;
        }
        return this.m_redFrameLayout.getHeight();
    }

    public void drawPortrait(FGGraphics fGGraphics, int n, int n2, int n3, int n4) {
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            return;
        }
        int n5 = this.m_redFrameLayout.getElementHeight("top");
        int n6 = this.m_redFrameLayout.getElementWidth("left");
        if (n4 == 1) {
            this.m_redFrameLayout.drawSelf(fGGraphics, n, n2);
        } else {
            this.m_blueFrameLayout.drawSelf(fGGraphics, n, n2);
        }
        FGImage fGImage = this.m_engine.m_portraits[n3];
        fGImage.drawSelf(fGGraphics, n + n5, n2 + n6);
    }

    public int getHudX() {
        int n = (this.m_engine.getScreenWidth() - this.m_hud.getWidth()) / 2;
        return n;
    }

    public void drawHud(FGGraphics fGGraphics) {
        int n;
        int n2;
        int n3 = this.getHudX();
        this.m_hud.drawSelf(fGGraphics, n3, 0);
        int n4 = this.getFoodBarMax();
        int n5 = this.getOreBarMax();
        this.fillHudBar(fGGraphics, "food", 100, 800268);
        this.fillHudBar(fGGraphics, "ore", 100, 5054208);
        if (!this.m_uiBlinkTimer.isOver()) {
            n2 = this.m_uiBlinkTimer.elapsedTime();
            n = n2 / 100;
            if (this.m_bBlinkingFoodBar) {
                this.fillHudBar(fGGraphics, "food", this.m_blinkPct, 16581385);
            } else {
                this.fillHudBar(fGGraphics, "ore", this.m_blinkPct, 16581385);
            }
        }
        n2 = this.m_armies[0].m_food;
        n = this.m_armies[0].m_ore;
        int n6 = n2 * 100 / n4;
        int n7 = this.m_armies[0].m_ore * 100 / n5;
        this.fillHudBar(fGGraphics, "food", n6, 2733095);
        this.fillHudBar(fGGraphics, "ore", n7, 0xFF6600);
        int n8 = this.m_hud.getFirstIdx("food");
        int n9 = this.m_hud.m_xValues[n8] + n3;
        int n10 = this.m_hud.m_yValues[n8];
        int n11 = this.m_hud.m_widths[n8];
        int n12 = this.m_hud.m_heights[n8];
        int n13 = n10 + n12;
        int n14 = this.m_hud.getFirstIdx("ore");
        int n15 = this.m_hud.m_xValues[n14] + n3;
        int n16 = this.m_hud.m_yValues[n14];
        int n17 = this.m_hud.m_widths[n14];
        int n18 = this.m_hud.m_heights[n14];
        int n19 = n16 + n18;
        int n20 = this.getUnitCost(0, 0);
        int n21 = this.getUnitCost(0, 1);
        int n22 = this.getUnitCost(0, 2);
        int n23 = this.m_engine.m_artilleryCost;
        int n24 = n9 + n20 * n11 / n4;
        int n25 = n9 + n21 * n11 / n4;
        int n26 = n9 + n22 * n11 / n4;
        this.m_dottedLine.drawTiled(fGGraphics, n24, n10, this.m_dottedLine.getWidth(), n12);
        this.m_dottedLine.drawTiled(fGGraphics, n25, n10, this.m_dottedLine.getWidth(), n12);
        this.m_dottedLine.drawTiled(fGGraphics, n26, n10, this.m_dottedLine.getWidth(), n12);
        FGImage fGImage = null;
        fGImage = this.m_infIconOff;
        if (n2 >= n20) {
            fGImage = this.m_infIconOn;
        }
        CVGameMode cVGameMode = this;
        if (!cVGameMode.m_engine.isSmall() && !this.m_iconBlinkTimer.isOver() && this.m_blinkIcon == 0) {
            fGImage = this.m_infIconGlow;
        }
        this.drawHudComponent(fGGraphics, fGImage, n9, n24, n10, n13);
        fGImage = this.m_ranIconOff;
        if (n2 >= n21) {
            fGImage = this.m_ranIconOn;
        }
        CVGameMode cVGameMode2 = this;
        if (!cVGameMode2.m_engine.isSmall() && !this.m_iconBlinkTimer.isOver() && this.m_blinkIcon == 1) {
            fGImage = this.m_ranIconGlow;
        }
        this.drawHudComponent(fGGraphics, fGImage, n24, n25, n10, n13);
        fGImage = this.m_mobIconOff;
        if (n2 >= n22) {
            fGImage = this.m_mobIconOn;
        }
        CVGameMode cVGameMode3 = this;
        if (!cVGameMode3.m_engine.isSmall() && !this.m_iconBlinkTimer.isOver() && this.m_blinkIcon == 2) {
            fGImage = this.m_mobIconGlow;
        }
        this.drawHudComponent(fGGraphics, fGImage, n25, n26, n10, n13);
        fGImage = this.m_artIconOff;
        if (n >= n23) {
            fGImage = this.m_artIconOn;
        }
        CVGameMode cVGameMode4 = this;
        if (!cVGameMode4.m_engine.isSmall() && !this.m_iconBlinkTimer.isOver() && this.m_blinkIcon == -1) {
            fGImage = this.m_artIconGlow;
        }
        this.drawHudComponent(fGGraphics, fGImage, n15, n15 + n17, n16, n19);
        CVGameMode cVGameMode5 = this;
        if (!cVGameMode5.m_engine.isSmall()) {
            int n27 = this.m_hud.getElementX("portrait_player");
            int n28 = this.m_hud.getElementY("portrait_player");
            int n29 = this.m_hud.getElementX("portrait_enemy");
            int n30 = this.m_hud.getElementY("portrait_enemy");
            this.drawPortrait(fGGraphics, n27 += n3, n28, this.m_armies[0].m_civID, 0);
            this.drawPortrait(fGGraphics, n29 += n3, n30, this.m_armies[1].m_civID, 1);
        }
    }

    public void fillHudBar(FGGraphics fGGraphics, String string, int n, int n2) {
        int n3 = this.m_hud.getFirstIdx(string);
        if (n3 == -1) {
            return;
        }
        int n4 = this.m_hud.m_xValues[n3];
        int n5 = this.m_hud.m_yValues[n3];
        int n6 = this.m_hud.m_widths[n3];
        int n7 = this.m_hud.m_heights[n3];
        int n8 = n6 * n / 100;
        if (n8 > n6) {
            n8 = n6;
        }
        fGGraphics.setColor(n2);
        fGGraphics.fillRect(n4 += this.getHudX(), n5, n8, n7);
    }

    public void drawHudComponent(FGGraphics fGGraphics, FGImage fGImage, int n, int n2, int n3, int n4) {
        int n5 = n + (n2 - n - fGImage.getWidth()) / 2;
        int n6 = n3 + (n4 - n3 - fGImage.getHeight()) / 2;
        fGImage.drawSelf(fGGraphics, n5, n6);
    }

    public void toTutorial() {
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            this.finishTutorial();
            return;
        }
        this.setMode(1);
        this.m_bTutorialReturnToHelpMenu = false;
    }

    public void pause() {
    }

    public void resume() {
    }

    public void setSoftkeys() {
        if (this.m_mode == 4) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_CANCEL"));
        } else if (this.m_mode == 1) {
            if (!this.m_bExternalTutorial && !this.m_engine.m_bShowedTutorial) {
                this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_NEXT"), null, this.m_engine.m_strings.getString("STR_QUIT"));
            } else {
                this.m_engine.setSoftkeys(this.m_engine.m_strings.getString("STR_NEXT"), null, this.m_engine.m_strings.getString("STR_FINISH"));
            }
        } else if (this.m_mode == 6) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_QUIT"));
        } else if (this.m_mode == 2) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_NEXT"));
        } else if (this.m_mode == 5) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_NEXT"));
        } else if (this.m_mode == 3) {
            this.m_engine.setSoftkeys(null, null, this.m_engine.m_strings.getString("STR_PAUSE"));
        } else {
            this.m_engine.setSoftkeys(null, null, null);
        }
    }

    public void keyPressed(int n) {
        block32: {
            block34: {
                block33: {
                    if (this.m_mode == -1) {
                        return;
                    }
                    if (!this.m_ignoreInputTimer.isOver()) {
                        return;
                    }
                    if (this.m_mode != 1) break block32;
                    if (n == this.m_engine.AVK_RIGHT_SOFT) {
                        this.backFromtutorial();
                        return;
                    }
                    if (n == 42) {
                        this.m_engine.m_bShowedTutorial = true;
                        this.finishTutorial();
                        return;
                    }
                    if (n == 2) {
                        this.backUpTutorialStep();
                        return;
                    }
                    if (n == this.m_engine.AVK_LEFT_SOFT) break block33;
                    if (n != 5) break block34;
                }
                this.advanceTutorialStep();
                return;
            }
            return;
        }
        if (this.m_mode == 2) {
            this.beginGameplay();
            return;
        }
        if (this.m_mode == 5) {
            if (n == this.m_engine.AVK_RIGHT_SOFT || n == this.m_engine.AVK_FIRE) {
                if (this.m_bIsCampaign) {
                    if (this.m_winner == 0) {
                        boolean bl = this.m_engine.nextWar();
                        if (bl) {
                            this.m_engine.m_UIMode.takeControlTech();
                        } else {
                            this.m_engine.m_UIMode.takeControl(2);
                        }
                    } else {
                        this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_defeatMenu);
                    }
                } else {
                    this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_mainMenu);
                }
            }
            return;
        }
        if (this.m_mode == 6) {
            if (n == this.m_engine.AVK_RIGHT_SOFT) {
                this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_mainMenu);
                return;
            }
            this.advanceFromIntro();
            return;
        }
        if (this.m_engine.m_bCheats) {
            if (n == 42) {
                this.m_armies[0].m_food += 1000;
                this.m_armies[0].m_ore += 1000;
                this.m_armies[0].capResources();
            }
            if (n == 35) {
                if (this.m_bIsCampaign) {
                    this.m_engine.m_campaignLevel = 19;
                }
                this.win(0);
                return;
            }
            if (n == 48) {
                this.win(0);
                return;
            }
        }
        if (this.m_mode == 4) {
            this.keyArtillery(n);
            return;
        }
        if (n == this.m_engine.AVK_RIGHT_SOFT) {
            this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_pauseMenu);
            return;
        }
        int n2 = this.m_engine.getScreenWidth();
        int n3 = this.m_engine.getScreenHeight();
        this.checkScrollKeys(n);
        if (n == 49) {
            this.playerTriesToBuildUnit(0);
        }
        if (n == 50) {
            this.playerTriesToBuildUnit(1);
        }
        if (n == 51) {
            this.playerTriesToBuildUnit(2);
        }
        if (n == this.m_engine.AVK_FIRE) {
            if (this.canFireArtillery(0)) {
                this.setMode(4);
                this.m_bRedrawFull = true;
                this.m_bArtilleryStutter = false;
            } else {
                this.blinkUI(false, this.m_engine.m_artilleryCost);
            }
        }
    }

    private void advanceFromIntro() {
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            this.doSmackTalk();
            return;
        }
        if (!this.m_engine.m_bShowedTutorial || this.m_bExternalTutorial) {
            this.toTutorial();
        } else {
            this.doSmackTalk();
        }
    }

    public boolean checkScrollKeys(int n) {
        boolean bl = false;
        if (n == 5) {
            this.setScroll(this.m_scroll + this.m_scrollDistance);
            this.m_bTrackArtillery = false;
            bl = true;
        } else if (n == 2) {
            this.setScroll(this.m_scroll - this.m_scrollDistance);
            bl = true;
        } else if (n == 55) {
            this.centerScroll(this.m_armies[0].m_unitsStart);
            bl = true;
        } else if (n == 56) {
            CVUnit cVUnit = this.getForwardMostNonWallUnit(0);
            if (cVUnit != null) {
                int n2 = FGFixed.toInt(cVUnit.m_fixX);
                this.centerScroll(n2);
                bl = true;
            }
        } else if (n == 57) {
            this.centerScroll(this.m_armies[1].m_unitsStart);
            bl = true;
        }
        if (bl) {
            this.m_bTrackArtillery = false;
        }
        return bl;
    }

    public void playerTriesToBuildUnit(int n) {
        int n2 = this.getUnitCost(0, n);
        if (this.m_armies[0].m_food >= n2) {
            boolean bl = this.buildUnit(n, 0);
            if (!bl) {
                return;
            }
            this.m_armies[0].m_food -= n2;
            this.blinkIcon(n);
            this.playSound(this.m_armies[0].m_unitsStart, 6);
        } else {
            this.blinkUI(true, n2);
        }
    }

    public boolean buildUnit(int n, int n2) {
        if (n == 0 && this.hasTech(n2, 17)) {
            return this.addTwoUnits(n, n2);
        }
        int n3 = this.addUnit(n, n2);
        return n3 != -1;
    }

    public int addUnit(int n, int n2) {
        int n3 = this.getAvailableUnit(n2);
        if (n3 == -1) {
            return -1;
        }
        this.m_armies[n2].m_units[n3].init(n, n2);
        return n3;
    }

    public int addUnit(int n, int n2, int n3) {
        int n4 = this.getAvailableUnit(n2);
        if (n4 == -1) {
            return -1;
        }
        this.m_armies[n2].m_units[n4].init(n, n2, n3);
        return n4;
    }

    public boolean addTwoUnits(int n, int n2) {
        int n3 = this.m_armies[n2].m_unitsStart;
        int n4 = n3 - 10;
        int n5 = n3 + 10;
        this.addUnit(n, n2, n4);
        int n6 = this.addUnit(n, n2, n5);
        if (n6 == -1) {
            return false;
        }
        this.m_armies[n2].m_units[n6].addFloater(1);
        return true;
    }

    public void unitDisappears(CVUnit cVUnit) {
    }

    public void keyReleased(int n) {
    }

    public void registerNeededResources(FGResLoader fGResLoader) {
        this.m_hud.init("hud.lyt");
        this.m_hud.registerNoteName("portrait_player");
        this.m_hud.registerNoteName("portrait_enemy");
        this.m_hud.registerNoteName("food");
        this.m_hud.registerNoteName("ore");
        this.m_hud.registerNoteName("vs");
        this.m_hud.registerNeededImages(fGResLoader);
        fGResLoader.registerImage("dottedLine.png");
        CVGameMode cVGameMode = this;
        if (!cVGameMode.m_engine.isSmall()) {
            CVGameMode cVGameMode2 = this;
            if (cVGameMode2.m_engine.isLarge()) {
                this.m_backgroundSky.init("back_back.lyt");
                this.m_backgroundSky.registerNeededImages(fGResLoader);
            }
            this.m_backgroundClouds.init("back_clouds.lyt");
            this.m_backgroundClouds.registerNeededImages(fGResLoader);
            fGResLoader.registerImage("bg1a.png");
        }
        CVGameMode cVGameMode3 = this;
        if (!cVGameMode3.m_engine.isSmall()) {
            this.m_redFrameLayout.init("redframe.lyt");
            this.m_redFrameLayout.registerNeededImages(fGResLoader);
            this.m_blueFrameLayout.init("blueframe.lyt");
            this.m_blueFrameLayout.registerNeededImages(fGResLoader);
        }
        fGResLoader.registerImageSet("explosion", ".png", this.NUM_EXPLOSION_FRAMES, false, false);
        FGLayout fGLayout = new FGLayout();
        fGLayout.init("arc.lyt");
        int n = fGLayout.getElementX("arc");
        int n2 = fGLayout.getElementX("ball");
        int n3 = fGLayout.getElementWidth("ball");
        int n4 = n2 + n3 / 2 + 1;
        this.m_angleSelectLength = n4 - n;
        this.m_angleCapOffsetX = fGLayout.getElementX("cap") - n;
        fGResLoader.registerImage("arc.png");
        fGResLoader.registerImage("arc_cap.png");
        fGResLoader.registerImage("arc_ball.png");
        fGResLoader.registerImage("arc_tic.png");
        CVGameMode cVGameMode4 = this;
        if (!cVGameMode4.m_engine.isSmall()) {
            fGResLoader.registerImage("powerBarEmpty.png");
            fGResLoader.registerImage("powerBarFull.png");
        }
        fGResLoader.registerImage("powerBarTic.png");
        fGResLoader.registerImage("flag.png");
        for (int i = 0; i < 8; ++i) {
            fGResLoader.registerImage(this.getTerrainTileFileName(i));
        }
        fGResLoader.registerImage("arrowUp.png");
        fGResLoader.registerImage("arrowDown.png");
        CVGameMode cVGameMode5 = this;
        if (!cVGameMode5.m_engine.isSmall()) {
            fGResLoader.registerImage("parchment_fill.png");
            fGResLoader.registerImage("parchment_top.png");
            fGResLoader.registerImage("parchment_bot.png");
        }
        fGResLoader.registerImage("skull.png");
        fGResLoader.registerImage("iconInfantry_off.png");
        fGResLoader.registerImage("iconInfantry_on.png");
        fGResLoader.registerImage("iconRanged_off.png");
        fGResLoader.registerImage("iconRanged_on.png");
        fGResLoader.registerImage("iconMobile_off.png");
        fGResLoader.registerImage("iconMobile_on.png");
        fGResLoader.registerImage("iconShot_off.png");
        fGResLoader.registerImage("iconShot_on.png");
        CVGameMode cVGameMode6 = this;
        if (!cVGameMode6.m_engine.isSmall()) {
            fGResLoader.registerImage("iconInfantry_glow.png");
            fGResLoader.registerImage("iconRanged_glow.png");
            fGResLoader.registerImage("iconMobile_glow.png");
            fGResLoader.registerImage("iconShot_glow.png");
        }
        CVGameMode cVGameMode7 = this;
        if (cVGameMode7.m_engine.isLarge()) {
            fGResLoader.registerImageSet("sparkle", ".png", 5, false, false);
            fGResLoader.registerImage("structure_wep.png");
            fGResLoader.registerImage("structure_sci.png");
            fGResLoader.registerImage("structure_eng.png");
        }
        fGResLoader.registerImage("wallStrong.png");
        fGResLoader.registerImage("fortStrong.png");
    }

    public void getNeededResources(FGResLoader fGResLoader) {
        int n;
        this.m_hud.getNeededImages(fGResLoader);
        this.m_dottedLine = fGResLoader.getImage("dottedLine.png");
        CVGameMode cVGameMode = this;
        if (!cVGameMode.m_engine.isSmall()) {
            CVGameMode cVGameMode2 = this;
            if (cVGameMode2.m_engine.isLarge()) {
                this.m_backgroundSky.getNeededImages(fGResLoader);
            }
            this.m_backgroundClouds.getNeededImages(fGResLoader);
        }
        for (n = 0; n < this.m_hud.getNumElements(); ++n) {
            FGString fGString = new FGString(this.m_hud.getElementIDString(n));
            if (!fGString.startsWith("filled")) continue;
            this.m_hud.setNote(n, true);
        }
        CVGameMode cVGameMode3 = this;
        if (!cVGameMode3.m_engine.isSmall()) {
            this.m_redFrameLayout.getNeededImages(fGResLoader);
            this.m_blueFrameLayout.getNeededImages(fGResLoader);
        }
        CVGameMode cVGameMode4 = this;
        if (!cVGameMode4.m_engine.isSmall()) {
            this.m_sky = fGResLoader.getImage("bg1a.png");
        }
        this.m_explosion.init(25);
        this.m_explosion.addFrameSet(fGResLoader, "explosion", ".png", this.NUM_EXPLOSION_FRAMES, false, false);
        this.m_angleImg = fGResLoader.getImage("arc.png");
        this.m_angleCapImg = fGResLoader.getImage("arc_cap.png");
        this.m_angleSelectImg = fGResLoader.getImage("arc_ball.png");
        this.m_lastAngleImg = fGResLoader.getImage("arc_tic.png");
        CVGameMode cVGameMode5 = this;
        if (!cVGameMode5.m_engine.isSmall()) {
            this.m_powerBarEmpty = fGResLoader.getImage("powerBarEmpty.png");
            this.m_powerBarFull = fGResLoader.getImage("powerBarFull.png");
        }
        this.m_lastPowerImg = fGResLoader.getImage("powerBarTic.png");
        this.m_flag = fGResLoader.getImage("flag.png");
        for (n = 0; n < 8; ++n) {
            this.m_terrainTileImages[n] = fGResLoader.getImage(this.getTerrainTileFileName(n));
        }
        this.m_tutorialArrowUpImg = fGResLoader.getImage("arrowUp.png");
        this.m_tutorialArrowDownImg = fGResLoader.getImage("arrowDown.png");
        this.languageChanged();
        CVGameMode cVGameMode6 = this;
        if (!cVGameMode6.m_engine.isSmall()) {
            this.m_tutorialParchmentFill = fGResLoader.getImage("parchment_fill.png");
            this.m_tutorialParchmentTop = fGResLoader.getImage("parchment_top.png");
            this.m_tutorialParchmentBottom = fGResLoader.getImage("parchment_bot.png");
            this.m_numTutorialSteps = this.m_tutorial.getIntTweak("NUM_STEPS");
        }
        CVGameMode cVGameMode7 = this;
        if (cVGameMode7.m_engine.isLarge()) {
            this.m_milStructure = fGResLoader.getImage("structure_wep.png");
            this.m_sciStructure = fGResLoader.getImage("structure_sci.png");
            this.m_engStructure = fGResLoader.getImage("structure_eng.png");
        }
        this.m_skullImg = fGResLoader.getImage("skull.png");
        this.m_infIconOff = fGResLoader.getImage("iconInfantry_off.png");
        this.m_infIconOn = fGResLoader.getImage("iconInfantry_on.png");
        this.m_ranIconOff = fGResLoader.getImage("iconRanged_off.png");
        this.m_ranIconOn = fGResLoader.getImage("iconRanged_on.png");
        this.m_mobIconOff = fGResLoader.getImage("iconMobile_off.png");
        this.m_mobIconOn = fGResLoader.getImage("iconMobile_on.png");
        this.m_artIconOff = fGResLoader.getImage("iconShot_off.png");
        this.m_artIconOn = fGResLoader.getImage("iconShot_on.png");
        CVGameMode cVGameMode8 = this;
        if (!cVGameMode8.m_engine.isSmall()) {
            this.m_infIconGlow = fGResLoader.getImage("iconInfantry_glow.png");
            this.m_ranIconGlow = fGResLoader.getImage("iconRanged_glow.png");
            this.m_mobIconGlow = fGResLoader.getImage("iconMobile_glow.png");
            this.m_artIconGlow = fGResLoader.getImage("iconShot_glow.png");
        }
        CVGameMode cVGameMode9 = this;
        if (cVGameMode9.m_engine.isLarge()) {
            this.m_sparkleAnim.init(150);
            this.m_sparkleAnim.addFrameSet(fGResLoader, "sparkle", ".png", 5, false, false);
        }
        this.m_strongWall = fGResLoader.getImage("wallStrong.png");
        this.m_strongFort = fGResLoader.getImage("fortStrong.png");
    }

    public void activate() {
        super.activate();
        if (this.m_mode == 3) {
            this.resumeAction();
        }
        this.setSoftkeys();
    }

    public void deactivate() {
        super.deactivate();
        if (this.m_mode == 3) {
            this.pauseAction();
        }
    }

    public void adoptTechsFromCampaign() {
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].m_militaryTechLevel = this.m_engine.m_campaignMTech[i];
            this.m_armies[i].m_scienceTechLevel = this.m_engine.m_campaignSTech[i];
            this.m_armies[i].m_engineeringTechLevel = this.m_engine.m_campaignETech[i];
        }
    }

    public void startNewGame(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        this.m_bIsCampaign = bl;
        if (this.m_bIsCampaign) {
            n6 = this.m_engine.m_campaignLevel + 1;
            this.m_diffProduceFood = this.m_engine.m_levelTable.getTableValue(10, n6);
            this.m_diffProduceOre = this.m_engine.m_levelTable.getTableValue(10, n6);
            this.m_diffMiss = this.m_engine.m_levelTable.getTableValue(12, n6);
        } else {
            this.m_diffProduceFood = this.m_engine.m_qpFProd;
            this.m_diffProduceOre = this.m_engine.m_qpOProd;
            this.m_diffMiss = this.m_engine.m_qpArtMiss;
        }
        n6 = this.m_engine.m_difficultyLevels[n2];
        this.m_difficulty = n2;
        this.m_diffProduceFood = n6 * this.m_diffProduceFood / 100;
        this.m_diffProduceOre = n6 * this.m_diffProduceOre / 100;
        this.m_diffMiss = this.m_diffMiss * (200 - n6) / n6;
        if (this.m_diffMiss < 0) {
            this.m_diffMiss = 0;
        }
        this.m_diffMiss = this.m_diffMiss * this.TERRAIN_PIECE_WIDTH / 100;
        this.m_era = n3;
        this.m_armies[1].m_civID = n5;
        this.m_armies[0].m_civID = n4;
        this.m_mapID = n;
        this.m_lastPower = -1;
        this.m_lastAngle = -1;
        this.m_armies[0].m_militaryTechLevel = this.m_engine.m_playerMTechStart;
        this.m_armies[0].m_scienceTechLevel = this.m_engine.m_playerSTechStart;
        this.m_armies[0].m_engineeringTechLevel = this.m_engine.m_playerETechStart;
        this.m_armies[1].m_militaryTechLevel = this.m_engine.m_enemyMTechStart;
        this.m_armies[1].m_scienceTechLevel = this.m_engine.m_enemySTechStart;
        this.m_armies[1].m_engineeringTechLevel = this.m_engine.m_enemyETechStart;
        this.m_mode = -1;
        if (!this.m_bIsCampaign) {
            int n7;
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            int[] nArray3 = new int[2];
            for (n7 = 0; n7 < 2; ++n7) {
                nArray[n7] = this.m_engine.m_campaignMTech[n7];
                nArray2[n7] = this.m_engine.m_campaignSTech[n7];
                nArray3[n7] = this.m_engine.m_campaignETech[n7];
            }
            this.m_engine.setUpTechForCiv(0, this.m_armies[0].m_civID);
            this.m_engine.setUpTechForCiv(1, this.m_armies[1].m_civID);
            this.adoptTechsFromCampaign();
            for (n7 = 0; n7 < 2; ++n7) {
                this.m_engine.m_campaignMTech[n7] = nArray[n7];
                this.m_engine.m_campaignSTech[n7] = nArray2[n7];
                this.m_engine.m_campaignETech[n7] = nArray3[n7];
            }
            n7 = this.m_engine.rand() % 10;
            this.QPTechAdvances(0, n7);
            this.QPTechAdvances(1, n7);
        }
        this.m_bExternalTutorial = false;
    }

    public void QPTechAdvances(int n, int n2) {
        int n3;
        if (9 < n2) {
            FGEngine.fatal("MAX_QPTECH_ADD is too small for the numAdvances sent in");
            return;
        }
        int[] nArray = new int[3];
        for (n3 = 0; n3 < 3; ++n3) {
            nArray[n3] = 0;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            boolean bl = false;
            while (!bl) {
                int n4 = this.m_engine.rand() % 3;
                if (nArray[n4] >= 3) continue;
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
                bl = true;
            }
        }
        this.m_armies[n].m_militaryTechLevel += nArray[0];
        this.m_armies[n].m_scienceTechLevel += nArray[1];
        this.m_armies[n].m_engineeringTechLevel += nArray[2];
    }

    public void doStartNewGame() {
        this.clearSkirmish();
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].clear();
        }
        this.m_bEnemyCanBuild = true;
        this.m_bEnemyCanFire = true;
        this.m_bShowingPopup = false;
        this.m_bTrackArtillery = false;
        this.clearGameArt();
        this.m_loader.beginRegistration();
        this.registerNeededGameResources(this.m_loader);
        this.m_loader.endRegistration();
        this.clearFloaters();
        this.m_engine.m_loadingMode.takeControl(this.m_loader, 1);
    }

    public void postEraLoad() {
        this.getNeededGameResources(this.m_loader);
        if (this.m_mapID == -1) {
            this.m_mapID = this.m_engine.rand();
        }
        this.m_engine.srand(this.m_mapID);
        int n = this.m_engine.m_campaignLevel;
        if (!this.m_bIsCampaign) {
            n = this.m_engine.rand() % 10;
        }
        int n2 = n + 1;
        int n3 = this.m_engine.m_levelTable.getTableValue(1, n2);
        int n4 = this.m_engine.m_levelTable.getTableValue(2, n2);
        int n5 = this.m_engine.m_levelTable.getTableValue(3, n2);
        int n6 = this.m_engine.m_levelTable.getTableValue(4, n2);
        int n7 = this.m_engine.m_levelTable.getTableValue(5, n2);
        int n8 = this.m_engine.m_levelTable.getTableValue(6, n2);
        int n9 = this.m_engine.m_levelTable.getTableValue(7, n2);
        int n10 = this.m_engine.m_levelTable.getTableValue(8, n2);
        int n11 = this.m_engine.m_levelTable.getTableValue(9, n2);
        this.randomizeMap(this.m_loader, n3, n6, n4, n7, n5, n8, n11, n9, n10);
        this.m_engine.srand();
        this.m_map.registerNoteName("forest");
        this.m_map.registerNoteName("wall");
        this.m_map.registerNoteName("fort");
        this.m_map.registerNoteName("castle_player");
        this.m_map.registerNoteName("castle_enemy");
        this.m_map.getNeededImages(this.m_loader);
        this.processMap(this.m_loader);
        this.setScroll(0);
        this.m_fixBorderX = FGFixed.toFixed(this.m_map.getWidth() / 2);
        this.m_bBorderMoved = false;
        this.m_resourceGainTimer.start(200);
        this.m_engineeringTimer.start(this.m_engine.m_techValues[24]);
        this.m_aiDesiredUnitType = this.m_engine.rand() % 3;
        this.updateFarmsAndMines();
        for (int i = 0; i < 2; ++i) {
            int n12;
            if (!this.hasTech(i, 0) || (n12 = this.addUnit(0, i)) == -1) continue;
            this.m_armies[i].m_units[n12].addFloater(0);
        }
        if (this.m_bExternalTutorial) {
            this.toTutorial();
        } else {
            this.setMode(6);
        }
    }

    public void toExternalTutorialMode() {
        this.m_bExternalTutorial = true;
    }

    public void doSmackTalk() {
        if (!this.m_bIsCampaign) {
            this.beginGameplay();
            return;
        }
        if (this.m_engine.getCampaignEra(this.m_engine.m_campaignLevel) != this.m_engine.getCampaignEra(this.m_engine.m_campaignLevel + 1)) {
            this.setMode(2);
        } else {
            this.beginGameplay();
        }
    }

    public void beginGameplay() {
        this.setMode(3);
        this.m_engine.save();
        this.m_engine.m_campaignPlayTime.resume();
    }

    public void win(int n) {
        this.m_winner = n;
        int n2 = this.getOtherSide(this.m_winner);
        this.m_armies[n2].startLoseBattleAnim();
        this.autoScroll(this.m_armies[n2].m_unitsStart, 0);
        this.setMode(5);
        this.m_engine.m_campaignPlayTime.pause();
        if (this.m_winner == 0) {
            this.playSound(9);
        } else {
            this.playSound(8);
        }
    }

    public void setMode(int n) {
        this.m_mode = n;
        if (this.m_mode == 4) {
            int n2 = this.m_engine.m_artilleryGravity * this.m_map.getWidth();
            int n3 = FGFixed.toFixed(n2);
            int n4 = FGFixed.sqrt(n3);
            this.m_maxPower = FGFixed.toInt(n4);
            this.centerScroll(this.m_armies[0].m_unitsStart);
            this.m_power = this.m_maxPower;
            this.m_angle = 0;
            this.m_bSelectingAngle = true;
            this.m_bRedrawFull = true;
            this.m_bArtilleryStutter = false;
        } else if (this.m_mode == 1) {
            this.setTutorialStep(0);
        } else if (this.m_mode == 5) {
            this.m_bGameInProgress = false;
            this.m_ignoreInputTimer.start(300);
        } else if (this.m_mode == 6) {
            this.m_introMsg.set("");
            if (this.m_bIsCampaign) {
                int n5 = this.m_engine.m_campaignLevel % 5 + 1;
                this.m_introMsg.add(this.m_engine.m_strings.getString("STR_BATTLE"));
                this.m_introMsg.add(" ");
                this.m_introMsg.add(n5);
                this.m_introMsg.add("\n\n");
            }
            switch (this.m_era) {
                case 0: {
                    this.m_introMsg.add(this.m_engine.m_strings.getString("STR_ANCIENT_ERA"));
                    break;
                }
                case 1: {
                    this.m_introMsg.add(this.m_engine.m_strings.getString("STR_FEUDAL_ERA"));
                    break;
                }
                case 2: {
                    this.m_introMsg.add(this.m_engine.m_strings.getString("STR_REN_ERA"));
                    break;
                }
                case 3: {
                    this.m_introMsg.add(this.m_engine.m_strings.getString("STR_MODERN_ERA"));
                }
            }
            this.m_introTimer.start(3000);
            this.playSound(10);
        }
        if (this.m_mode == 3) {
            this.m_bGameInProgress = true;
            this.resumeAction();
        } else {
            this.pauseAction();
        }
        this.setSoftkeys();
    }

    public void centerScroll(int n) {
        this.setScroll(n - this.m_engine.getScreenWidth() / 2);
    }

    public void setScroll(int n) {
        int n2 = this.m_engine.getScreenWidth();
        this.m_scroll = n;
        if (this.m_scroll < 0) {
            this.m_scroll = 0;
        }
        if (this.m_scroll > this.m_map.getWidth() - n2) {
            this.m_scroll = this.m_map.getWidth() - n2;
        }
    }

    public void pauseAction() {
        int n;
        this.m_bPaused = true;
        for (n = 0; n < 16; ++n) {
            this.m_armies[0].m_units[n].pause();
            this.m_armies[1].m_units[n].pause();
        }
        this.m_armies[0].m_artillery.pause();
        this.m_armies[1].m_artillery.pause();
        this.m_resourceGainTimer.pause();
        for (n = 0; n < 2; ++n) {
            this.m_armies[n].pause();
        }
        this.m_engine.m_campaignPlayTime.pause();
        this.m_bShowingPopup = false;
    }

    public void resumeAction() {
        int n;
        this.m_bPaused = false;
        for (n = 0; n < 16; ++n) {
            this.m_armies[0].m_units[n].resume();
            this.m_armies[1].m_units[n].resume();
        }
        this.m_armies[0].m_artillery.resume();
        this.m_armies[1].m_artillery.resume();
        this.m_resourceGainTimer.resume();
        for (n = 0; n < 2; ++n) {
            this.m_armies[n].resume();
        }
        this.m_engine.m_campaignPlayTime.resume();
    }

    public void processMap(FGResLoader fGResLoader) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.m_numTerrainTiles; ++n4) {
            n3 = this.m_terrainTypes[n4];
            FGImage fGImage = this.getTerrainTileImage(n3);
            n2 = this.m_terrainYValues[n4];
            n = n2 + fGImage.getHeight();
            switch (n3) {
                case 3: 
                case 4: {
                    this.m_terrainLeftHeights[n4] = n;
                    this.m_terrainRightHeights[n4] = n2;
                    break;
                }
                case 0: 
                case 1: {
                    this.m_terrainLeftHeights[n4] = n2;
                    this.m_terrainRightHeights[n4] = n;
                    break;
                }
                default: {
                    this.m_terrainLeftHeights[n4] = n2;
                    this.m_terrainRightHeights[n4] = n2;
                }
            }
            if (n5 >= n) continue;
            n5 = n;
        }
        this.m_armies[0].m_unitsStart = -1;
        this.m_armies[1].m_unitsStart = -1;
        this.m_numForests = 0;
        for (n4 = 0; n4 < this.m_map.getNumElements(); ++n4) {
            int n6;
            if (FGString.nativeEquals(this.m_map.getElementIDString(n4), "castle_player")) {
                n3 = this.m_map.m_xValues[n4];
                n6 = this.m_map.m_widths[n4];
                this.m_armies[0].m_unitsStart = n3 + n6 / 2;
                this.m_armies[0].m_castleDrawLocX = this.m_armies[0].m_unitsStart - this.m_armies[0].m_castleGFX.getWidth() / 2;
                this.m_armies[0].m_castleDrawLocY = this.m_map.m_yValues[n4] + this.m_map.m_heights[n4] - this.m_armies[0].m_castleGFX.getHeight();
                continue;
            }
            if (FGString.nativeEquals(this.m_map.getElementIDString(n4), "castle_enemy")) {
                n3 = this.m_map.m_xValues[n4];
                n6 = this.m_map.m_widths[n4];
                this.m_armies[1].m_unitsStart = n3 + n6 / 2;
                this.m_armies[1].m_castleDrawLocX = this.m_armies[1].m_unitsStart - this.m_armies[1].m_castleGFX.getWidth() / 2;
                this.m_armies[1].m_castleDrawLocY = this.m_map.m_yValues[n4] + this.m_map.m_heights[n4] - this.m_armies[1].m_castleGFX.getHeight();
                continue;
            }
            if (!FGString.nativeEquals(this.m_map.getElementIDString(n4), "forest")) continue;
            if (this.m_numForests >= 20) {
                FGEngine.fatal("too many forests in map");
                return;
            }
            this.m_fixForestStarts[this.m_numForests] = FGFixed.toFixed(this.m_map.m_xValues[n4]);
            this.m_fixForestEnds[this.m_numForests] = this.m_fixForestStarts[this.m_numForests] + FGFixed.toFixed(this.m_map.m_widths[n4]);
            ++this.m_numForests;
        }
        for (n4 = 0; n4 < this.m_map.getNumElements(); ++n4) {
            n3 = -1;
            if (FGString.nativeEquals(this.m_map.getElementIDString(n4), "wall")) {
                n3 = 3;
            }
            if (FGString.nativeEquals(this.m_map.getElementIDString(n4), "fort")) {
                n3 = 4;
            }
            if (n3 == -1) continue;
            int n7 = 0;
            n2 = this.m_map.m_xValues[n4];
            if (this.m_map.m_xValues[n4] > this.m_map.getWidth() / 2) {
                n7 = 1;
            } else {
                n2 += this.m_map.m_widths[n4];
            }
            this.addUnit(n3, n7, n2);
        }
        for (n4 = 0; n4 < this.m_map.getNumElements(); ++n4) {
            FGString fGString;
            n3 = 0;
            int n8 = this.m_armies[0].m_unitOffsetY;
            if (FGString.nativeEquals(this.m_map.getElementIDString(n4), "mine")) {
                n3 = 1;
            }
            if (FGString.nativeEquals(this.m_map.getElementIDString(n4), "farm")) {
                n3 = 1;
            }
            if ((fGString = new FGString(this.m_map.getElementName(n4))).startsWith("tree")) {
                n3 = 1;
                n8 *= 2;
            }
            if (n3 == 0) continue;
            n = this.m_map.m_xValues[n4] + this.m_map.m_widths[n4] / 2;
            this.m_map.m_yValues[n4] = this.getTerrainY(n) - this.m_map.m_heights[n4] + n8;
        }
        n4 = this.m_armies[0].m_unitsStart;
        n3 = this.m_armies[0].m_castleDrawLocY;
        this.m_armies[0].m_artilleryStart.setXY(FGFixed.toFixed(n4), FGFixed.toFixed(n3));
        n4 = this.m_armies[1].m_unitsStart;
        n3 = this.m_armies[1].m_castleDrawLocY;
        this.m_armies[1].m_artilleryStart.setXY(FGFixed.toFixed(n4), FGFixed.toFixed(n3));
        CVGameMode cVGameMode = this;
        this.m_backgroundY = cVGameMode.m_engine.isLarge() ? n5 - this.m_background.getHeight() : 0;
    }

    public int getTerrainY(int n) {
        int n2 = this.getGridX(n);
        if (n2 < 0) {
            return this.m_terrainLeftHeights[0];
        }
        if (n2 >= this.m_numTerrainTiles) {
            return this.m_terrainRightHeights[0];
        }
        int n3 = n - n2 * this.TERRAIN_PIECE_WIDTH;
        int n4 = this.m_terrainRightHeights[n2] - this.m_terrainLeftHeights[n2];
        int n5 = this.m_terrainLeftHeights[n2] + n3 * n4 / this.TERRAIN_PIECE_WIDTH;
        return n5;
    }

    public int getGridX(int n) {
        int n2 = n / this.TERRAIN_PIECE_WIDTH;
        return n2;
    }

    public int getAvailableUnit(int n) {
        for (int i = 0; i < 16; ++i) {
            if (this.m_armies[n].m_units[i].isValid()) continue;
            return i;
        }
        return -1;
    }

    public CVUnit getForwardWall(int n) {
        CVUnit cVUnit = null;
        int n2 = 0;
        if (n == 1) {
            n2 = FGFixed.toFixed(this.m_map.getWidth());
        }
        for (int i = 0; i < 16; ++i) {
            CVUnit cVUnit2 = this.m_armies[n].m_units[i];
            if (!cVUnit2.mechanicallyExists() || !cVUnit2.isFortOrWall() || !this.passed(cVUnit2.m_fixX, n2, n)) continue;
            n2 = cVUnit2.m_fixX;
            cVUnit = cVUnit2;
        }
        return cVUnit;
    }

    public void clearSkirmish() {
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].clearSkirmish();
        }
        this.m_skirmishUnitType = -1;
        this.m_fixSkirmishX1 = -1;
        this.m_fixSkirmishX2 = -1;
        this.m_bSkirmishExists = false;
        this.m_fixSkirmishCenter = -1;
    }

    public void beginSkirmish(CVUnit cVUnit, CVUnit cVUnit2) {
        if (this.m_bSkirmishExists) {
            FGEngine.fatal("beginSkirmish called with skirmish in progress");
            return;
        }
        if (cVUnit.m_side == cVUnit2.m_side) {
            FGEngine.fatal("beginSkirmish called with two units that are on the same side");
            return;
        }
        if (cVUnit.m_type != cVUnit2.m_type) {
            FGEngine.fatal("beginSkirmish called with two units that are not the same type");
            return;
        }
        this.m_armies[cVUnit.m_side].m_skirmishers[0] = cVUnit;
        this.m_armies[cVUnit2.m_side].m_skirmishers[0] = cVUnit2;
        cVUnit.m_bInSkirmish = true;
        cVUnit2.m_bInSkirmish = true;
        this.m_armies[0].m_numUnitsInSkirmish = 1;
        this.m_armies[1].m_numUnitsInSkirmish = 1;
        this.m_skirmishUnitType = cVUnit.m_type;
        this.m_fixSkirmishCenter = cVUnit.m_fixX;
        this.m_bSkirmishExists = true;
        this.positionSkirmishers();
    }

    public void addToSkirmish(CVUnit cVUnit) {
        if (!this.m_bSkirmishExists) {
            FGEngine.fatal("addToSkirmish called with no skirmish in progress");
            return;
        }
        if (cVUnit.m_type != this.m_skirmishUnitType) {
            FGEngine.fatal("addToSkirmish called with a unit that is not the skirmish type");
            return;
        }
        int n = cVUnit.m_side;
        this.m_armies[n].m_skirmishers[this.m_armies[n].m_numUnitsInSkirmish] = cVUnit;
        ++this.m_armies[n].m_numUnitsInSkirmish;
        cVUnit.m_bInSkirmish = true;
        cVUnit.m_mode = 0;
        this.positionSkirmishers();
    }

    public void removeFromSkirmish(CVUnit cVUnit) {
        int n;
        int n2 = cVUnit.m_side;
        int n3 = -1;
        for (n = 0; n < this.m_armies[n2].m_numUnitsInSkirmish; ++n) {
            if (this.m_armies[n2].m_skirmishers[n] != cVUnit) continue;
            n3 = n;
        }
        if (n3 == -1) {
            return;
        }
        for (n = n3; n < this.m_armies[n2].m_numUnitsInSkirmish; ++n) {
            this.m_armies[n2].m_skirmishers[n].m_bInSkirmish = false;
            this.m_armies[n2].m_skirmishers[n] = null;
        }
        this.m_armies[n2].m_numUnitsInSkirmish = n3;
        if (this.m_armies[n2].m_numUnitsInSkirmish == 0) {
            this.clearSkirmish();
        }
    }

    public void positionSkirmishers() {
        int n;
        int n2;
        if (!this.m_bSkirmishExists) {
            return;
        }
        for (n2 = 0; n2 < this.m_armies[0].m_numUnitsInSkirmish; ++n2) {
            n = n2 * 4;
            this.m_armies[0].m_skirmishers[n2].m_fixX = this.m_fixSkirmishCenter - FGFixed.toFixed(n);
        }
        for (n2 = 0; n2 < this.m_armies[1].m_numUnitsInSkirmish; ++n2) {
            n = n2 * 4;
            this.m_armies[1].m_skirmishers[n2].m_fixX = this.m_fixSkirmishCenter + FGFixed.toFixed(n);
        }
        this.m_fixSkirmishX1 = this.m_fixSkirmishCenter - FGFixed.toFixed(this.m_armies[0].m_numUnitsInSkirmish * 4);
        this.m_fixSkirmishX2 = this.m_fixSkirmishCenter + FGFixed.toFixed(this.m_armies[1].m_numUnitsInSkirmish * 4);
    }

    public boolean intersectsSkirmish(int n, int n2) {
        if (!this.m_bSkirmishExists) {
            return false;
        }
        int n3 = n2 == 0 ? this.m_fixSkirmishX1 : this.m_fixSkirmishX2;
        return this.passed(n, n3, n2);
    }

    public void tickSkirmish() {
        int n;
        int n2;
        int n3;
        if (!this.m_bSkirmishExists) {
            return;
        }
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 0; n2 < this.m_armies[n3].m_numUnitsInSkirmish; ++n2) {
                CVUnit cVUnit = this.m_armies[n3].m_skirmishers[0];
                if (cVUnit.mechanicallyExists()) continue;
                this.removeFromSkirmish(cVUnit);
            }
        }
        if (!this.m_bSkirmishExists) {
            return;
        }
        n3 = 0;
        n2 = this.m_armies[0].m_numUnitsInSkirmish;
        int n4 = this.m_armies[1].m_numUnitsInSkirmish;
        if (n2 >= n4 + 2) {
            n3 = this.m_armies[0].m_skirmishers[0].getFixDesiredMovement();
        } else if (n2 == n4 + 1) {
            n3 = this.m_armies[0].m_skirmishers[0].getFixDesiredMovement();
            n3 = FGFixed.multiply(n3, FGFixed.toFixed(this.m_engine.m_pushPct));
            n3 = FGFixed.divide(n3, FGFixed.toFixed(100));
        } else if (n4 == n2 + 1) {
            n3 = -this.m_armies[1].m_skirmishers[0].getFixDesiredMovement();
            n3 = FGFixed.multiply(n3, FGFixed.toFixed(this.m_engine.m_pushPct));
            n3 = FGFixed.divide(n3, FGFixed.toFixed(100));
        } else if (n4 >= n2 + 2) {
            n3 = -this.m_armies[1].m_skirmishers[0].getFixDesiredMovement();
        }
        int n5 = FGFixed.toFixed(this.m_engine.getTickTime());
        this.m_fixSkirmishCenter = FGGeometry.applyPPSVel(this.m_fixSkirmishCenter, n3, n5);
        CVUnit cVUnit = this.getForwardWall(0);
        CVUnit cVUnit2 = this.getForwardWall(1);
        if (cVUnit != null && this.m_fixSkirmishCenter < cVUnit.m_fixX) {
            this.m_fixSkirmishCenter = cVUnit.m_fixX;
            for (n = 0; n < this.m_armies[1].m_numUnitsInSkirmish; ++n) {
                this.m_armies[1].m_skirmishers[n].tryAttack();
            }
        }
        if (cVUnit2 != null && this.m_fixSkirmishCenter > cVUnit2.m_fixX) {
            this.m_fixSkirmishCenter = cVUnit2.m_fixX;
            for (n = 0; n < this.m_armies[0].m_numUnitsInSkirmish; ++n) {
                this.m_armies[0].m_skirmishers[n].tryAttack();
            }
        }
        n = FGFixed.toFixed(this.m_armies[0].m_unitsStart);
        int n6 = FGFixed.toFixed(this.m_armies[1].m_unitsStart);
        if (this.passed(this.m_fixSkirmishCenter, n, 1)) {
            this.win(1);
        }
        if (this.passed(this.m_fixSkirmishCenter, n6, 0)) {
            this.win(0);
        }
        if (this.m_skirmishUnitType == 0) {
            if (this.passed(this.m_fixSkirmishCenter, this.m_fixBorderX, 1)) {
                this.m_fixBorderX = this.m_fixSkirmishCenter;
                this.m_bBorderMoved = true;
            }
            if (this.passed(this.m_fixSkirmishCenter, this.m_fixBorderX, 0)) {
                this.m_fixBorderX = this.m_fixSkirmishCenter;
                this.m_bBorderMoved = true;
            }
        }
        this.positionSkirmishers();
    }

    public void tickArtillery() {
        int n = this.getArtilleryUITime(this.m_bSelectingAngle);
        if (this.m_artilleryUITimer.isOver()) {
            if (this.m_bArtilleryStutter) {
                this.m_bArtilleryStutter = false;
                this.m_artilleryUITimer.start(n * 2);
            } else {
                this.m_bArtilleryStutter = true;
                this.m_bRedrawFull = true;
            }
        }
        int n2 = this.m_artilleryUITimer.elapsedTime();
        int n3 = 0;
        n3 = n2 >= this.m_artilleryUITimer.totalTime() / 2 ? this.m_artilleryUITimer.totalTime() - n2 : n2;
        if (this.m_bSelectingAngle) {
            this.m_angle = n3 * 60 / n;
            if (this.m_angle < 0) {
                this.m_angle = 0;
            }
            if (this.m_angle > 60) {
                this.m_angle = 60;
            }
        } else {
            this.m_power = n3 * this.m_maxPower / n;
            if (this.m_power < 0) {
                this.m_power = 0;
            }
            if (this.m_power > this.m_maxPower) {
                this.m_power = this.m_maxPower;
            }
        }
    }

    public void keyArtillery(int n) {
        boolean bl;
        if (n == this.m_engine.AVK_RIGHT_SOFT) {
            this.setMode(3);
            this.m_bTrackArtillery = false;
            return;
        }
        if (n == this.m_engine.AVK_FIRE) {
            if (this.m_bSelectingAngle) {
                this.m_power = 0;
                this.m_artilleryUITimer.start(0);
                this.m_bSelectingAngle = false;
                this.m_bRedrawFull = true;
                this.m_bArtilleryStutter = false;
            } else {
                this.m_lastPower = this.m_power;
                this.m_lastAngle = this.m_angle;
                this.m_bTrackArtillery = true;
                this.m_armies[0].m_artillery.fireAP(this.m_angle, this.m_power);
                this.m_armies[0].m_ore -= this.m_engine.m_artilleryCost;
                this.setMode(3);
                this.blinkIcon(-1);
                this.playArtilleryFire(0);
            }
        }
        if (bl = this.checkScrollKeys(n)) {
            this.m_bRedrawFull = true;
        }
    }

    public boolean canFireArtillery(int n) {
        if (!this.m_bEnemyCanFire && n == 1) {
            return false;
        }
        if (this.m_armies[n].m_artillery.m_bActive) {
            return false;
        }
        return this.m_armies[n].m_ore >= this.m_engine.m_artilleryCost;
    }

    public boolean isInForest(int n) {
        for (int i = 0; i < this.m_numForests; ++i) {
            if (n < this.m_fixForestStarts[i] || n > this.m_fixForestEnds[i]) continue;
            return true;
        }
        return false;
    }

    public int getEnemyProduction(int n, boolean bl) {
        if (bl) {
            return n * this.m_diffProduceFood / 100;
        }
        return n * this.m_diffProduceOre / 100;
    }

    public int getEnemyDeviance() {
        int n = this.m_diffMiss;
        if (this.hasTech(1, 8)) {
            n = this.m_diffMiss * 100 / this.m_engine.m_techValues[8];
        }
        return n;
    }

    public void popup(String string) {
        this.m_bShowingPopup = true;
        this.m_popupStr.set(string);
        this.m_popupTimer.start(1500);
    }

    public void blinkUI(boolean bl, int n) {
        this.m_bBlinkingFoodBar = bl;
        this.m_blinkPct = this.m_bBlinkingFoodBar ? n * 100 / this.getFoodBarMax() : n * 100 / this.getOreBarMax();
        this.m_uiBlinkTimer.start(400);
    }

    public void blinkIcon(int n) {
        this.m_blinkIcon = n;
        this.m_iconBlinkTimer.start(400);
    }

    public void registerNeededGameResources(FGResLoader fGResLoader) {
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].registerNeededResources(fGResLoader);
        }
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isLarge()) {
            FGString fGString = new FGString();
            fGString.add("back_");
            fGString.add(this.m_era);
            fGString.add(".lyt");
            this.m_background.init(fGString.getNativeString());
            this.m_background.registerNeededImages(fGResLoader);
        }
        CVGameMode cVGameMode2 = this;
        if (cVGameMode2.m_engine.isSmall()) {
            fGResLoader.registerImage("tree2.png");
        } else {
            fGResLoader.registerImage("tree1.png");
            fGResLoader.registerImage("tree2.png");
            fGResLoader.registerImage("tree3.png");
        }
        fGResLoader.registerImageSet("smoke", ".png", this.NUM_SMOKE_FRAMES, false, false);
    }

    public void getNeededGameResources(FGResLoader fGResLoader) {
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isLarge()) {
            this.m_background.getNeededImages(fGResLoader);
        }
        this.m_fixCloudOffset = 0;
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].getNeededResources(fGResLoader);
        }
    }

    public void clearGameArt() {
        this.m_map.clearArt();
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isLarge()) {
            this.m_background.clearArt();
        }
        for (int i = 0; i < 2; ++i) {
            this.m_armies[i].clearArt();
        }
    }

    public String getCivName(int n) {
        FGString fGString = new FGString();
        fGString.set("STR_CIVNAME_");
        fGString.add(n);
        return this.m_engine.m_strings.getString(fGString.getNativeString());
    }

    private int getTerrainMaxY() {
        int n = this.m_map.getHeight() - 2 * this.TERRAIN_PIECE_WIDTH;
        return n;
    }

    private void randomizeMap(FGResLoader fGResLoader, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        String string;
        String string2;
        String string3;
        String string4;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        FGImage fGImage;
        int n20 = n7 * this.m_engine.getScreenWidth() / 100;
        int n21 = 5;
        int n22 = 80;
        int n23 = this.TERRAIN_PIECE_WIDTH;
        int n24 = n20 / n23;
        int n25 = n9 * this.TERRAIN_PIECE_WIDTH;
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            fGImage = fGResLoader.getImage("tree2.png");
            n19 = fGImage.getWidth();
        } else {
            fGImage = fGResLoader.getImage("tree1.png");
            n19 = fGImage.getWidth() / 2;
        }
        int n26 = n25 / n19;
        int n27 = n + n2 + n3 + n4 + n5 + n6 + n8 + n8 * n26 + 2 + 2;
        this.m_map.initManual(n27, 0xFF00FF, n20, this.m_engine.getScreenHeight());
        int n28 = n22 * this.m_map.getHeight() / 100;
        int n29 = this.getTerrainMaxY();
        if (n28 == n29) {
            n29 = (n22 + 10) * this.m_map.getHeight() / 100;
        }
        int n30 = n29 - n28;
        int n31 = n28 + this.m_engine.rand() % n30;
        for (n18 = 0; n18 < 60; ++n18) {
            this.m_cornerClipTypes[n18] = -1;
        }
        n18 = 0;
        for (int i = 0; i < n21; ++i) {
            this.m_terrainTypes[n18] = 2;
            this.m_terrainYValues[n18] = n31;
            ++n18;
        }
        int[] nArray = new int[5];
        int n32 = n24 - n21 * 2 + 1;
        int n33 = 2;
        for (n17 = 0; n17 < n32; ++n17) {
            if (n18 == 33) {
                n16 = 5;
            }
            switch (n33) {
                case 2: {
                    nArray[0] = 20;
                    nArray[1] = 20;
                    nArray[2] = 20;
                    nArray[3] = 20;
                    nArray[4] = 20;
                    break;
                }
                case 3: 
                case 4: {
                    nArray[0] = 10;
                    nArray[1] = 10;
                    nArray[2] = 30;
                    nArray[3] = 25;
                    nArray[4] = 25;
                    break;
                }
                case 0: 
                case 1: {
                    nArray[0] = 25;
                    nArray[1] = 25;
                    nArray[2] = 30;
                    nArray[3] = 10;
                    nArray[4] = 10;
                }
            }
            n16 = this.m_terrainYValues[n18 - 1];
            if (n16 < n28) {
                nArray[3] = 0;
                nArray[4] = 0;
            }
            if (n16 > n29) {
                nArray[1] = 0;
                nArray[0] = 0;
                if (n33 == 1 || n33 == 0) {
                    nArray[2] = 0;
                }
            }
            if (n33 == 0) {
                nArray[4] = 0;
            }
            n15 = 0;
            for (n14 = 0; n14 < 5; ++n14) {
                n15 += nArray[n14];
            }
            n14 = this.m_engine.rand() % n15;
            int n34 = 2;
            for (n13 = 0; n13 < 5; ++n13) {
                if ((n14 -= nArray[n13]) >= 0) continue;
                n34 = n13;
                break;
            }
            n33 = n34;
            this.addTerrainCell(fGResLoader, n18, n34);
            ++n18;
        }
        for (n17 = 0; n17 < n21; ++n17) {
            this.addTerrainCell(fGResLoader, n18, 2);
            ++n18;
        }
        this.m_numTerrainTiles = n18;
        n17 = this.m_terrainYValues[this.m_numTerrainTiles - 1];
        n16 = 0;
        this.addCastle(0, n31, n16);
        this.addCastle(1, n17, ++n16);
        ++n16;
        n15 = n21 * this.TERRAIN_PIECE_WIDTH;
        n14 = this.m_map.getWidth() - n15 * 2;
        FGString fGString = new FGString();
        for (n13 = 0; n13 < n8; ++n13) {
            int n35 = n15 + this.m_engine.rand() % n14;
            n12 = n35 - n25 / 2;
            int n36 = n25;
            this.m_map.setImage(n16, n12, 0, true, n36, 5, "invalid", "forest", false);
            ++n16;
            n11 = n26 * n19;
            int n37 = n12 + (n36 - n11) / 2;
            for (int i = 0; i < n26; ++i) {
                fGString.set("tree");
                int n38 = this.m_engine.rand() % 3 + 1;
                CVGameMode cVGameMode2 = this;
                if (cVGameMode2.m_engine.isSmall()) {
                    n38 = 2;
                }
                fGString.add(n38);
                fGString.add(".png");
                FGImage fGImage2 = fGResLoader.getImage(fGString.getNativeString());
                this.m_map.setImage(n16, n37, 0, false, fGImage2.getWidth(), fGImage2.getHeight(), fGString.getNativeString(), "", false);
                ++n16;
                n37 += n19;
            }
        }
        n13 = n + n3 + n5;
        boolean[] blArray = new boolean[n13];
        for (n12 = 0; n12 < n13; ++n12) {
            blArray[n12] = false;
        }
        n12 = n2 + n4 + n6;
        boolean[] blArray2 = new boolean[n12];
        for (n11 = 0; n11 < n12; ++n11) {
            blArray2[n11] = false;
        }
        CVGameMode cVGameMode3 = this;
        if (cVGameMode3.m_engine.isSmall()) {
            string4 = "farmBlue.png";
            string3 = "mineBlue.png";
            string2 = string4;
            string = string3;
        } else {
            string2 = "farmRed.png";
            string4 = "farmBlue.png";
            string = "mineRed.png";
            string3 = "mineBlue.png";
        }
        for (n10 = 0; n10 < n; ++n10) {
            n16 += this.addPartitionedElement(n16, fGResLoader, string2, "farm", 0, n13, blArray);
        }
        for (n10 = 0; n10 < n3; ++n10) {
            n16 += this.addPartitionedElement(n16, fGResLoader, string, "mine", 0, n13, blArray);
        }
        for (n10 = 0; n10 < n5; ++n10) {
            n16 += this.addPartitionedElement(n16, fGResLoader, "invalid", "fort", 0, n13, blArray);
        }
        for (n10 = 0; n10 < n2; ++n10) {
            n16 += this.addPartitionedElement(n16, fGResLoader, string4, "farm", 1, n12, blArray2);
        }
        for (n10 = 0; n10 < n4; ++n10) {
            n16 += this.addPartitionedElement(n16, fGResLoader, string3, "mine", 1, n12, blArray2);
        }
        for (n10 = 0; n10 < n6; ++n10) {
            n16 += this.addPartitionedElement(n16, fGResLoader, "invalid", "fort", 1, n12, blArray2);
        }
        n10 = this.TERRAIN_PIECE_WIDTH * (n21 - 1);
        this.m_map.setImage(n16, n10, 0, false, 8, 8, "invalid", "wall", false);
        this.m_map.setImage(++n16, this.m_map.getWidth() - n10 - 8, 0, false, 8, 8, "invalid", "wall", false);
        if (this.m_map.m_numElements != ++n16) {
            FGString fGString2 = new FGString();
            fGString2.add("element count mismatch in randomizeMap: ");
            fGString2.add(this.m_map.m_numElements);
            fGString2.add(" != ");
            fGString2.add(n16);
        }
    }

    private int addPartitionedElement(int n, FGResLoader fGResLoader, String string, String string2, int n2, int n3, boolean[] blArray) {
        int n4;
        int n5 = 5 * this.TERRAIN_PIECE_WIDTH;
        int n6 = this.m_map.getWidth() / 2 - n5;
        int n7 = n5;
        if (n2 == 1) {
            n7 = this.m_map.getWidth() / 2;
        }
        boolean bl = false;
        for (n4 = 0; n4 < n3; ++n4) {
            if (blArray[n4]) continue;
            bl = true;
        }
        if (!bl) {
            return 0;
        }
        n4 = 0;
        int n8 = 0;
        do {
            if (++n8 <= 50) continue;
            return 0;
        } while (blArray[n4 = this.m_engine.rand() % n3]);
        blArray[n4] = true;
        int n9 = 8;
        int n10 = 8;
        if (fGResLoader.isResourceLoaded(string)) {
            FGImage fGImage = fGResLoader.getImage(string);
            n9 = fGImage.getWidth();
            n10 = fGImage.getHeight();
        }
        int n11 = n7 + n4 * n6 / n3;
        int n12 = n6 / n3;
        int n13 = n11 + this.m_engine.rand() % n12;
        int n14 = n13 - n9 / 2;
        this.m_map.setImage(n, n14, 0, false, n9, n10, string, string2, false);
        return 1;
    }

    private void addCastle(int n, int n2, int n3) {
        String string;
        int n4;
        FGImage fGImage = this.m_armies[n].m_castleGFX;
        if (n == 0) {
            n4 = 0;
            string = "castle_player";
        } else {
            n4 = this.m_map.getWidth() - fGImage.getWidth();
            string = "castle_enemy";
        }
        int n5 = n2 - fGImage.getHeight();
        this.m_map.setImage(n3, n4, n5 += 4, false, fGImage.getWidth(), fGImage.getHeight(), "invalid", string, true);
    }

    private void addTerrainCell(FGResLoader fGResLoader, int n, int n2) {
        this.doAddTerrainCell(fGResLoader, n, n2, true);
    }

    private void doAddTerrainCell(FGResLoader fGResLoader, int n, int n2, boolean bl) {
        int n3 = this.getTerrainMaxY();
        int n4 = n - 1;
        int n5 = this.m_terrainTypes[n4];
        FGImage fGImage = this.getTerrainTileImage(n2);
        FGImage fGImage2 = this.getTerrainTileImage(n5);
        int n6 = 0;
        boolean bl2 = true;
        switch (n2) {
            case 0: 
            case 1: {
                if (n5 != 0 && n5 != 1) break;
                n6 = 1;
                break;
            }
            case 2: {
                if (n5 != 0 && n5 != 1) break;
                n6 = 1;
                break;
            }
            case 3: 
            case 4: {
                if (n5 == 0 || n5 == 1) {
                    n6 = 0;
                    bl2 = false;
                    break;
                }
                n6 = -1;
                break;
            }
            default: {
                FGEngine.fatal("Unknown terrain type sent to addTerrainTile");
                return;
            }
        }
        int n7 = this.m_terrainYValues[n4];
        if (n6 == -1) {
            n7 -= fGImage.getHeight();
        } else if (n6 == 1) {
            n7 += fGImage2.getHeight();
        } else if (!bl2) {
            int n8 = fGImage2.getHeight() - fGImage.getHeight();
            n7 += n8;
        }
        if (bl && n7 >= n3) {
            this.doAddTerrainCell(fGResLoader, n, 3, false);
            return;
        }
        this.m_terrainTypes[n] = n2;
        this.m_terrainYValues[n] = n7;
        if (n6 == -1) {
            this.m_cornerClipTypes[n] = 6;
        } else if (n6 == 1) {
            this.m_cornerClipTypes[n4] = 7;
        }
    }

    public void setMapImage(int n, int n2, int n3, boolean bl, int n4, int n5, String string, String string2, boolean bl2) {
        this.m_map.setImage(n, n2, n3, bl, n4, n5, string, string2, bl2);
    }

    public String getTerrainTileFileName(int n) {
        return this.m_terrainTileFileNames[n].getNativeString();
    }

    public FGImage getTerrainTileImage(int n) {
        return this.m_terrainTileImages[n];
    }

    public boolean hasTech(int n, int n2) {
        if (n2 < 10) {
            return this.m_armies[n].m_militaryTechLevel >= n2;
        }
        if (n2 < 20) {
            return this.m_armies[n].m_scienceTechLevel >= n2 - 10;
        }
        return this.m_armies[n].m_engineeringTechLevel >= n2 - 20;
    }

    public int percentifyTech(int n, int n2, int n3) {
        if (!this.hasTech(n2, n3)) {
            return n;
        }
        int n4 = this.percentify(n, this.m_engine.m_techValues[n3]);
        return n4;
    }

    public int percentify(int n, int n2) {
        int n3 = n * n2 / 100;
        return n3;
    }

    public int getStartHP(int n, int n2) {
        if (n != 3 && n != 4) {
            return 1;
        }
        int n3 = n2 == 0 ? this.m_engine.m_plrWallHPs[this.m_difficulty] : this.m_engine.m_enemyWallHPs[this.m_difficulty];
        if (n == 4) {
            n3 = this.percentify(n3, this.m_engine.m_fortHPPct);
        }
        if (this.hasTech(n2, 28)) {
            return this.percentifyTech(n3, n2, 28);
        }
        return this.percentifyTech(n3, n2, 20);
    }

    public int getArtilleryImpactWidth(int n) {
        int n2 = this.percentifyTech(this.m_engine.m_artilleryImpactWidth, n, 18);
        return n2;
    }

    public int getUnitCost(int n, int n2) {
        int n3 = this.m_engine.m_unitCosts[n2];
        if (n2 == 0) {
            n3 = this.percentifyTech(n3, n, 3);
        }
        if (n2 == 1) {
            n3 = this.percentifyTech(n3, n, 4);
        }
        if (n2 == 2) {
            n3 = this.percentifyTech(n3, n, 13);
        }
        if (this.m_armies[n].m_civID == 1) {
            if (n2 == 2) {
                n3 = this.percentify(n3, this.m_engine.m_japanMobileCost);
            } else if (n2 == 1) {
                n3 = this.percentify(n3, this.m_engine.m_japanRangedCost);
            }
        }
        if (this.m_armies[n].m_civID == 2) {
            if (n2 == 0) {
                n3 = this.percentify(n3, this.m_engine.m_russiaInfantryCost);
            } else if (n2 == 2) {
                n3 = this.percentify(n3, this.m_engine.m_russiaMobileCost);
            }
        }
        if (this.m_armies[n].m_civID == 3 && n2 == 1) {
            n3 = this.percentify(n3, this.m_engine.m_usaRangedCost);
        }
        return n3;
    }

    public int getArtilleryUITime(boolean bl) {
        int n = bl ? this.m_engine.m_artilleryAnglePeriod : this.m_engine.m_artilleryPowerPeriod;
        int n2 = this.percentifyTech(n, 0, 8);
        return n2;
    }

    public void addTechFloater(int n, int n2) {
        FGImage fGImage = null;
        switch (n2) {
            case 0: {
                fGImage = this.m_engine.m_UIMode.m_milTechIcon;
                break;
            }
            case 1: {
                fGImage = this.m_engine.m_UIMode.m_sciTechIcon;
                break;
            }
            case 2: {
                fGImage = this.m_engine.m_UIMode.m_engTechIcon;
            }
        }
        if (fGImage == null) {
            return;
        }
        this.addFloater(n, fGImage);
    }

    public void addFloater(int n, FGImage fGImage) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < 5; ++n2) {
            if (this.m_bFloaterExists[n2]) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return;
        }
        this.m_floaterImage[n3] = fGImage;
        n2 = n - fGImage.getWidth() / 2;
        this.m_floaterPos[n3].m_fixX = FGFixed.toFixed(n2);
        int n4 = this.getTerrainY(n);
        n4 -= this.m_armies[0].m_unitWalkGFX[3].getFrame(0).getHeight();
        this.m_floaterPos[n3].m_fixY = FGFixed.toFixed(n4 -= fGImage.getHeight());
        this.m_bFloaterExists[n3] = true;
    }

    public void clearFloaters() {
        for (int i = 0; i < 5; ++i) {
            this.m_bFloaterExists[i] = false;
            this.m_floaterImage[i] = null;
        }
    }

    public void tickFloaters() {
        int n = FGFixed.toFixed(this.m_engine.getTickTime());
        int n2 = this.m_engine.getScreenHeight() * 1000 / 6000;
        int n3 = -FGFixed.toFixed(n2);
        for (int i = 0; i < 5; ++i) {
            if (!this.m_bFloaterExists[i]) continue;
            this.m_floaterPos[i].m_fixY = FGGeometry.applyPPSVel(this.m_floaterPos[i].m_fixY, n3, n);
            int n4 = FGFixed.toInt(this.m_floaterPos[i].m_fixY);
            if (n4 >= this.m_engine.getScreenHeight() / 2) continue;
            this.m_bFloaterExists[i] = false;
            this.m_floaterImage[i] = null;
        }
    }

    public void drawFloaters(FGGraphics fGGraphics) {
        for (int i = 0; i < 5; ++i) {
            if (!this.m_bFloaterExists[i]) continue;
            int n = FGFixed.toInt(this.m_floaterPos[i].m_fixX) - this.m_scroll;
            int n2 = FGFixed.toInt(this.m_floaterPos[i].m_fixY);
            this.m_floaterImage[i].drawSelf(fGGraphics, n, n2);
        }
    }

    void advanceTutorialStep() {
        ++this.m_tutorialStep;
        if (this.m_tutorialStep >= this.m_numTutorialSteps) {
            this.m_engine.m_bShowedTutorial = true;
            this.finishTutorial();
            return;
        }
        this.setTutorialStep(this.m_tutorialStep);
    }

    void backUpTutorialStep() {
        --this.m_tutorialStep;
        if (this.m_tutorialStep < 0) {
            this.m_tutorialStep = 0;
            return;
        }
        this.setTutorialStep(this.m_tutorialStep);
    }

    private void finishTutorial() {
        if (this.m_bExternalTutorial) {
            this.m_bGameInProgress = false;
            this.m_bExternalTutorial = false;
            this.m_engine.m_UIMode.m_helpMenuReturn = this.m_engine.m_UIMode.m_mainMenu;
            this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_helpMenu);
        } else {
            this.setMode(3);
            if (this.m_bTutorialReturnToHelpMenu) {
                this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_helpMenu);
            }
        }
    }

    private void backFromtutorial() {
        if (this.m_bExternalTutorial) {
            this.m_bGameInProgress = false;
            this.m_bExternalTutorial = false;
            this.m_engine.m_UIMode.m_helpMenuReturn = this.m_engine.m_UIMode.m_mainMenu;
            this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_helpMenu);
        } else if (this.m_engine.m_bShowedTutorial) {
            this.setMode(3);
            this.m_engine.m_UIMode.m_helpMenuReturn = this.m_engine.m_UIMode.m_pauseMenu;
            this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_helpMenu);
        } else {
            this.m_engine.m_UIMode.takeControl(this.m_engine.m_UIMode.m_mainMenu);
        }
    }

    void setTutorialStep(int n) {
        int n2;
        int n3;
        Object object;
        CVGameMode cVGameMode = this;
        if (cVGameMode.m_engine.isSmall()) {
            return;
        }
        this.m_tutorialStep = n;
        FGString fGString = new FGString();
        fGString.add("TEXT_");
        fGString.add(this.m_tutorialStep);
        this.m_tutorialText = this.m_tutorial.getStrTweak(fGString.getNativeString()).getNativeString();
        this.m_tutorialPointAtX = -1;
        this.m_tutorialPointAtY = -1;
        int n4 = 4;
        fGString.set("POINT_");
        fGString.add(this.m_tutorialStep);
        if (this.m_tutorial.tweakExists(fGString.getNativeString())) {
            object = this.m_tutorial.getStrTweak(fGString.getNativeString());
            n3 = -1;
            n2 = 0;
            this.m_bPointingUp = false;
            if (((FGString)object).equals("border")) {
                n2 = 1;
                n3 = FGFixed.toInt(this.m_fixBorderX);
                this.m_tutorialPointAtY = this.getTerrainY(n3) - this.m_flag.getHeight() - n4;
            } else if (((FGString)object).equals("fmeter")) {
                int n5 = this.m_hud.getFirstIdx("food");
                this.m_tutorialPointAtX = this.m_hud.m_xValues[n5] + this.m_hud.m_widths[n5] / 2;
                this.m_tutorialPointAtY = this.m_hud.m_yValues[n5] + this.m_hud.m_heights[n5] - n4;
                this.m_bPointingUp = true;
            } else if (((FGString)object).equals("ameter")) {
                int n6 = this.m_hud.getFirstIdx("ore");
                this.m_tutorialPointAtX = this.m_hud.m_xValues[n6] + this.m_hud.m_widths[n6] / 2;
                this.m_tutorialPointAtY = this.m_hud.m_yValues[n6] + this.m_hud.m_heights[n6] - n4;
                this.m_bPointingUp = true;
            } else {
                int n7 = this.m_map.getFirstIdx(((FGString)object).getNativeString());
                if (n7 != -1) {
                    n2 = 1;
                    n3 = this.m_map.m_xValues[n7] + this.m_map.m_widths[n7] / 2;
                    this.m_tutorialPointAtY = this.m_map.m_yValues[n7] - n4;
                }
            }
            if (n2 != 0) {
                this.centerScroll(n3);
                this.m_tutorialPointAtX = n3 - this.m_scroll;
            }
        }
        this.m_tutorialImage = null;
        fGString.set("PIC_");
        fGString.add(this.m_tutorialStep);
        if (this.m_tutorial.tweakExists(fGString.getNativeString())) {
            object = this.m_tutorial.getStrTweak(fGString.getNativeString());
            this.m_tutorialImage = this.m_armies[0].m_unitGFX.getElementImage(((FGString)object).getNativeString());
        }
        object = this.m_engine.m_mainFont;
        n3 = ((FGFont)object).getSpaceWidth();
        n2 = this.m_engine.getScreenWidth() - n3 * 2;
        this.m_tutorialBoxH = ((FGFont)object).getDisplayHeight(this.m_tutorialText, n2);
        if (this.m_tutorialImage != null) {
            this.m_tutorialBoxH += this.m_tutorialImage.getHeight();
            this.m_tutorialBoxH += n3;
        }
        this.m_tutorialBoxH += this.m_tutorialParchmentTop.getHeight();
        this.m_tutorialBoxH += this.m_tutorialParchmentBottom.getHeight();
        this.m_tutorialBoxY = this.m_tutorialPointAtX == -1 ? (this.m_engine.getScreenHeight() - this.m_tutorialBoxH) / 2 : (this.m_bPointingUp ? this.m_tutorialPointAtY + this.m_tutorialArrowUpImg.getHeight() + n4 : this.m_tutorialPointAtY - this.m_tutorialArrowDownImg.getHeight() - n4 - this.m_tutorialBoxH);
    }

    public void languageChanged() {
        CVGameMode cVGameMode = this;
        if (!cVGameMode.m_engine.isSmall()) {
            this.m_tutorial.init(this.m_engine.getLanguageFilename("tutorial").getNativeString());
        }
        this.m_bShowingPopup = false;
    }

    public void playArtilleryFire(int n) {
        int n2 = this.m_armies[n].m_unitsStart;
        this.playSound(n2, 3);
    }

    public void playSound(int n) {
        this.doPlaySound(n);
    }

    public void playSound(int n, int n2) {
        this.playSound(n, n, n2);
        this.clickcounter = 0;
    }

    public void playSound(int n, int n2, int n3) {
        if (n == -1) {
            this.doPlaySound(n3);
        } else {
            boolean bl = true;
            boolean bl2 = true;
            if (n < this.m_scroll) {
                bl = false;
            }
            if (n > this.m_scroll + this.m_engine.getScreenWidth()) {
                bl = false;
            }
            if (n2 < this.m_scroll) {
                bl2 = false;
            }
            if (n2 > this.m_scroll + this.m_engine.getScreenWidth()) {
                bl2 = false;
            }
            if (bl || bl2) {
                this.doPlaySound(n3);
            }
        }
    }

    private void doPlaySound(int n) {
        this.m_engine.playSound(n);
    }
}

