/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class Form {
    Vector mButtonList;
    Vector mOverlayList;
    String mFormName;
    MapScreen mView;
    UserInterface mUserInterface;
    Button mActiveButton;
    Button mPressedButton;
    long mTextureID;
    Image mTextureImage;
    tFormOrientation mFormOrientation;
    tFormType mFormType;
    float mCenterX;
    float mCenterY;
    float mHalfWidth;
    float mHalfHeight;
    float xMin = 0.0f;
    float xMax = 0.0f;
    float yMin = 0.0f;
    float yMax = 0.0f;

    public Form() {
        this.mView = null;
        this.mActiveButton = null;
        this.mFormName = null;
        this.mUserInterface = null;
        this.mTextureID = 0L;
        this.mTextureImage = null;
        this.mButtonList = new Vector();
        this.mOverlayList = new Vector();
    }

    public Form(String string, MapScreen mapScreen, UserInterface userInterface, String string2) {
        this.mView = mapScreen;
        this.mActiveButton = null;
        this.mFormName = string2;
        this.mUserInterface = userInterface;
        this.mTextureID = 0L;
        this.mButtonList = new Vector();
        this.mOverlayList = new Vector();
    }

    public void initFromFile(String string, MapScreen mapScreen, UserInterface userInterface, String string2) {
        try {
            this.mView = mapScreen;
            this.mFormName = string2;
            this.mUserInterface = userInterface;
            this.loadFromFile(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean loadFromFile(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        KXmlParser kXmlParser = new KXmlParser();
        try {
            kXmlParser.setInput(inputStream, null);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        this.mCenterX = 0.5f;
        this.mCenterY = 0.5f;
        this.mHalfWidth = 1.0f;
        this.mHalfHeight = 1.0f;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        int n = 0;
        try {
            kXmlParser.nextTag();
            string3 = kXmlParser.getName();
            for (int i = 0; i < kXmlParser.getAttributeCount(); ++i) {
                String string5 = kXmlParser.getAttributeName(i);
                if (string5.compareTo("image") == 0) {
                    string4 = kXmlParser.getAttributeValue(i);
                    if (string4.compareTo("/hom_splash.png") == 0) {
                        stringBuffer.append(string4);
                    } else {
                        stringBuffer.append("/UserInterface/");
                        stringBuffer.append(string4);
                    }
                    string2 = stringBuffer.toString();
                    n = stringBuffer.length();
                    stringBuffer.delete(0, n);
                    continue;
                }
                if (string5.compareTo("centerx") == 0) {
                    this.mCenterX = Float.parseFloat(kXmlParser.getAttributeValue(i));
                    continue;
                }
                if (string5.compareTo("centery") == 0) {
                    this.mCenterY = Float.parseFloat(kXmlParser.getAttributeValue(i));
                    continue;
                }
                if (string5.compareTo("width") == 0) {
                    this.mHalfWidth = Float.parseFloat(kXmlParser.getAttributeValue(i));
                    continue;
                }
                if (string5.compareTo("height") == 0) {
                    this.mHalfHeight = Float.parseFloat(kXmlParser.getAttributeValue(i));
                    continue;
                }
                if (string5.compareTo("orientation") == 0) {
                    this.mFormOrientation = kXmlParser.getAttributeValue(i).compareTo("landscape") == 0 ? tFormOrientation.kFormOrientation_Landscape : tFormOrientation.kFormOrientation_Portrait;
                    continue;
                }
                if (string5.compareTo("type") != 0) continue;
                String string6 = kXmlParser.getAttributeValue(i);
                this.mFormType = string6.compareTo("popup") == 0 ? tFormType.kFormType_Popup : (string6.compareTo("overlay") == 0 ? tFormType.kFormType_Overlay : tFormType.kFormType_Background);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mHalfWidth *= 0.5f;
        this.mHalfHeight *= 0.5f;
        try {
            kXmlParser.nextTag();
            while (string3.compareTo(kXmlParser.getName()) != 0 && kXmlParser.getEventType() != 3) {
                Object object;
                Object object2;
                int n2;
                String string7 = kXmlParser.getName();
                if (string7.compareTo("Buttons") == 0) {
                    n2 = kXmlParser.getDepth();
                    kXmlParser.nextTag();
                    while (kXmlParser.getDepth() > n2) {
                        int n3 = kXmlParser.getDepth();
                        object2 = new Button(this.mView, kXmlParser, null);
                        kXmlParser.nextTag();
                        while (kXmlParser.getDepth() > n3) {
                            if (kXmlParser.getEventType() == 2) {
                                object = new Button(this.mView, kXmlParser, (Button)object2);
                                this.mButtonList.addElement(object);
                            }
                            kXmlParser.nextTag();
                        }
                        this.mButtonList.addElement(object2);
                        kXmlParser.nextTag();
                    }
                } else if (string7.compareTo("Overlays") == 0) {
                    n2 = kXmlParser.getDepth();
                    kXmlParser.nextTag();
                    while (kXmlParser.getDepth() > n2) {
                        if (kXmlParser.getEventType() == 2) {
                            int n4;
                            Overlay overlay = new Overlay();
                            object2 = new Color();
                            ((Color)object2).setR(255);
                            ((Color)object2).setG(255);
                            ((Color)object2).setB(255);
                            ((Color)object2).setA(255);
                            overlay.mColor = object2;
                            overlay.mHalfWidth = 0.0f;
                            overlay.mHalfHeight = 0.0f;
                            overlay.mName = kXmlParser.getName();
                            overlay.mIsHidden = false;
                            object = null;
                            for (n4 = 0; n4 < kXmlParser.getAttributeCount(); ++n4) {
                                String string8 = kXmlParser.getAttributeName(n4);
                                if (string8.compareTo("image") == 0) {
                                    stringBuffer.append("/UserInterface/");
                                    string4 = kXmlParser.getAttributeValue(n4);
                                    stringBuffer.append(string4);
                                    object = stringBuffer.toString();
                                    n = stringBuffer.length();
                                    stringBuffer.delete(0, n);
                                    continue;
                                }
                                if (string8.compareTo("centerx") == 0) {
                                    overlay.mCenterX = Float.parseFloat(kXmlParser.getAttributeValue(n4));
                                    continue;
                                }
                                if (string8.compareTo("centery") == 0) {
                                    overlay.mCenterY = Float.parseFloat(kXmlParser.getAttributeValue(n4));
                                    continue;
                                }
                                if (string8.compareTo("width") == 0) {
                                    overlay.mHalfWidth = Float.parseFloat(kXmlParser.getAttributeValue(n4));
                                    continue;
                                }
                                if (string8.compareTo("height") == 0) {
                                    overlay.mHalfHeight = Float.parseFloat(kXmlParser.getAttributeValue(n4));
                                    continue;
                                }
                                if (string8.compareTo("isHidden") != 0) continue;
                                overlay.mIsHidden = kXmlParser.getAttributeValue(n4).compareTo("yes") == 0;
                            }
                            n4 = 0;
                            boolean bl = false;
                            if (object != null) {
                                try {
                                    overlay.mTextureImage = Image.createImage((String)object);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                            if (overlay.mHalfWidth <= 0.001f || overlay.mHalfHeight <= 0.001f) {
                                overlay.mHalfWidth = (float)n4 / (float)this.mView.mCanvas.getWidth();
                                overlay.mHalfHeight = (float)bl / (float)this.mView.mCanvas.getHeight();
                            }
                            overlay.mHalfWidth *= 0.5f;
                            overlay.mHalfHeight *= 0.5f;
                            this.mOverlayList.addElement(overlay);
                        }
                        kXmlParser.nextTag();
                    }
                }
                kXmlParser.nextTag();
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string2 != null) {
            try {
                this.mTextureImage = string2.equals("/UserInterface/Default.png") ? this.mView.mBackground : Image.createImage((String)string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mHalfWidth *= 0.5f;
        this.mHalfHeight *= 0.5f;
        kXmlParser = null;
        System.gc();
        return true;
    }

    public void onFormClose() {
    }

    public void onFormOpen() {
    }

    public void renderForm(Graphics graphics) {
        if (this.mTextureImage != null) {
            graphics.setColor(0, 0, 0);
            int n = (int)((double)Fieldrunners.mCanvas.getWidth() * 0.5);
            int n2 = (int)((double)Fieldrunners.mCanvas.getHeight() * 0.5);
            graphics.setGrayScale(255);
            graphics.drawImage(this.mTextureImage, n, n2, 3);
        }
    }

    public void renderButtonsWithElapsedTime(Graphics graphics, float f) {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            button.renderWithElapsedTime(graphics, f);
        }
    }

    public void renderOverlays(Graphics graphics) {
        if (!this.mOverlayList.isEmpty()) {
            int n = this.mOverlayList.size();
            for (int i = 0; i < n; ++i) {
                Overlay overlay = (Overlay)this.mOverlayList.elementAt(i);
                if (overlay.mIsHidden || overlay.mTextureImage == null) continue;
                int n2 = (int)((float)Fieldrunners.mCanvas.getWidth() * overlay.mCenterX);
                int n3 = (int)((float)Fieldrunners.mCanvas.getHeight() * overlay.mCenterY);
                graphics.drawImage(overlay.mTextureImage, n2, n3, 3);
            }
        }
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        if (Can.SOUNDPLAYER.mNeedSoundRestart && Can.SOUNDPLAYER.mNeedSoundRestartCount-- <= 0) {
            Can.SOUNDPLAYER.mNeedSoundRestart = false;
            Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_TITLE_THEME);
        }
        if (this.mFormType != tFormType.kFormType_Overlay) {
            this.renderForm(graphics);
        }
        this.renderButtonsWithElapsedTime(graphics, f);
        this.renderOverlays(graphics);
    }

    public void touchStart(Point point) {
        try {
            CGPoint cGPoint = new CGPoint(point.x, point.y);
            this.mPressedButton = null;
            cGPoint.x /= (float)this.mView.width();
            cGPoint.y /= (float)this.mView.height();
            this.mActiveButton = null;
            for (int i = 0; i < this.mButtonList.size(); ++i) {
                Button button = (Button)this.mButtonList.elementAt(i);
                this.xMin = button.mCurrentCenterX - button.mHalfHitRegionWidth;
                this.xMax = button.mCurrentCenterX + button.mHalfHitRegionWidth;
                this.yMin = button.mCurrentCenterY - button.mHalfHitRegionHeight;
                this.yMax = button.mCurrentCenterY + button.mHalfHitRegionHeight;
                if (!(cGPoint.x >= button.mCurrentCenterX - button.mHalfHitRegionWidth) || !(cGPoint.x <= button.mCurrentCenterX + button.mHalfHitRegionWidth) || !(cGPoint.y >= button.mCurrentCenterY - button.mHalfHitRegionHeight) || !(cGPoint.y <= button.mCurrentCenterY + button.mHalfHitRegionHeight) || button.mIsHidden || button.mIsDisabled || !(button.mTrackTimer >= 0.999f)) continue;
                this.mPressedButton = button;
                this.mActiveButton = button;
                if (button.mPressSelector != null) {
                    this.handleButtonPressAction(button, point);
                    if (button.mIsToggleable) {
                        button.mIsToggled = !button.mIsToggled;
                    }
                }
                button.mState = tButtonState.kButtonState_Pressed;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void touchDrag(Point point) {
        try {
            CGPoint cGPoint = new CGPoint(point.x, point.y);
            cGPoint.x /= (float)this.mView.width();
            cGPoint.y /= (float)this.mView.height();
            if (this.mActiveButton != null) {
                this.xMin = this.mActiveButton.mCurrentCenterX - this.mActiveButton.mHalfHitRegionWidth;
                this.xMax = this.mActiveButton.mCurrentCenterX + this.mActiveButton.mHalfHitRegionWidth;
                this.yMin = this.mActiveButton.mCurrentCenterY - this.mActiveButton.mHalfHitRegionHeight;
                this.yMax = this.mActiveButton.mCurrentCenterY + this.mActiveButton.mHalfHitRegionHeight;
                if (cGPoint.x < this.xMax || cGPoint.x > this.xMin || cGPoint.y < this.yMax || cGPoint.y > this.yMin) {
                    if (!this.mActiveButton.mIsHidden && !this.mActiveButton.mIsDisabled && this.mActiveButton.mTrackTimer >= 0.999f && this.mActiveButton.mExitSelector != null) {
                        this.handleButtonExitAction(this.mActiveButton, point);
                    }
                    this.mActiveButton.mState = tButtonState.kButtonState_Enabled;
                    this.mActiveButton = null;
                }
            }
            if (this.mActiveButton == null) {
                for (int i = 0; i < this.mButtonList.size(); ++i) {
                    Button button = (Button)this.mButtonList.elementAt(i);
                    if (!(cGPoint.x >= button.mCurrentCenterX - button.mHalfHitRegionWidth) || !(cGPoint.x <= button.mCurrentCenterX + button.mHalfHitRegionWidth) || !(cGPoint.y >= button.mCurrentCenterY - button.mHalfHitRegionHeight) || !(cGPoint.y <= button.mCurrentCenterY + button.mHalfHitRegionHeight) || button.mIsHidden || button.mIsDisabled || !(button.mTrackTimer >= 0.999f)) continue;
                    if (button == this.mPressedButton) {
                        this.mActiveButton = button;
                        if (button.mEnterSelector != null) {
                            this.handleButtonEnterAction(this.mActiveButton, point);
                        }
                    }
                    if (this.mActiveButton == null) continue;
                    this.mActiveButton.mState = tButtonState.kButtonState_Pressed;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void touchEnd(Point point) {
        try {
            CGPoint cGPoint = new CGPoint(point.x, point.y);
            cGPoint.x /= (float)this.mView.width();
            cGPoint.y /= (float)this.mView.height();
            for (int i = 0; i < this.mButtonList.size(); ++i) {
                Button button = (Button)this.mButtonList.elementAt(i);
                if (!(cGPoint.x >= button.mCurrentCenterX - button.mHalfHitRegionWidth) || !(cGPoint.x <= button.mCurrentCenterX + button.mHalfHitRegionWidth) || !(cGPoint.y >= button.mCurrentCenterY - button.mHalfHitRegionHeight) || !(cGPoint.y <= button.mCurrentCenterY + button.mHalfHitRegionHeight) || button.mIsHidden || button.mIsDisabled || !(button.mTrackTimer >= 0.999f)) continue;
                if (button.mReleaseSelector != null && button == this.mPressedButton) {
                    this.handleButtonReleaseAction(this.mActiveButton, point);
                    button.mState = tButtonState.kButtonState_Enabled;
                    if (!button.mIsToggleable) break;
                    button.mIsToggled = !button.mIsToggled;
                    break;
                }
                button.mState = tButtonState.kButtonState_Enabled;
            }
            this.mActiveButton = null;
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleButtonPressAction(Button button, Point point) {
    }

    public void handleButtonExitAction(Button button, Point point) {
    }

    public void handleButtonEnterAction(Button button, Point point) {
    }

    public void handleButtonReleaseAction(Button button, Point point) {
    }

    public void updateWithElapsedTime(float f) {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            button.updateWithElapsedTime(f);
        }
    }
}

