/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class HelpForm
extends Form {
    WrapText mDescription;
    String mTitle = "HELP";
    int mTitlex = 85;
    int mPhase;
    static int kMaxPages = 8;

    HelpForm() {
    }

    public void onFormOpen() {
        this.mPhase = 0;
        this.mDescription = new WrapText(" ", 52, 60, Can.HELP_TEXT_WIDTH, 8);
        this.setWrapText();
    }

    public void setWrapText() {
        switch (this.mPhase) {
            default: {
                this.mDescription.changeText("^Keys\nMovement: D-Pad\nSelection: OK\nPause Play:\n^Left Soft Key\nEnd Game:\n^Right Soft Key\n\n\n^Goal:\nBuild defense towers to keep fieldrunners from getting into your base and draining your health.");
                break;
            }
            case 1: {
                this.mDescription.changeText("^Tower Building\n^Shortcuts:\n^Keypad 1-6\n\n^Upgrade Shortcut:\n^Keypad 9\n\n^Fast Forward:\n^Keypad 0");
                break;
            }
            case 2: {
                this.mDescription.changeText("^Building Towers:\nYou can place towers in two ways. The first is by using the popup menu. The second is by using shortcut keys.\n\nTo use the popup menu, move to where you would like to place the tower, then hit OK.");
                break;
            }
            case 3: {
                this.mDescription.changeText("Push Left and Right on the D-Pad to cycle through the available selections, and press OK to select the one you want.\n\nYou can move the selected tower using the D-Pad. Once you've chosen the final placement, press OK to confirm.");
                break;
            }
            case 4: {
                this.mDescription.changeText("Pressing Clr will cancel the placement. To use a shortcut, press the shortcut key for the tower you would like to choose.\n\nThen press OK to confirm it. You must have enough money to purchase the tower before you will be able to select it.");
                break;
            }
            case 5: {
                this.mDescription.changeText("Tower placement will change the course of ground units. Air unit paths are not affected by tower placement.\n\nTry different configurations, to better suit tower type and placement.\n\nYou may place towers while the game is paused.");
                break;
            }
            case 6: {
                this.mDescription.changeText("^Upgrade/Sell\n^Towers:\nYou can upgrade or sell a tower by putting the cursor over it and pressing OK to bring up a popup menu and manipulating it like the purchase menu. You can press the shortcut key 9 to immediately upgrade the tower under the cursor.");
                break;
            }
            case 7: {
                this.mDescription.changeText("There is a limit on the number of upgrades available, so choose wisely.\n\n^Money:\nEach unit you destroy will increase the amount of money that you have. You can use money to build/upgrade towers.");
                break;
            }
            case 8: {
                this.mDescription.changeText("^Towers:\nGatling Tower: Continuous Attack\nGoo Tower: Slows Enemies\nMissile Tower: Splash Damage\nTesla Tower: Massive Damage\nFlame Tower: Area of Effect Damage\nMortar Tower: Massive Splash Damage");
            }
        }
    }

    public void onButtonReleaseX(Button button, Point point) {
        this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kInGameOptionsFormNameID);
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        super.renderWithElapsedTime(graphics, f);
        if (this.mDescription != null) {
            this.mDescription.renderText(graphics);
        }
        if (this.mView.mSoftLeft != null) {
            graphics.drawImage(this.mView.mSoftLeft, this.mView.mAtL.x, this.mView.mAtL.y, 3);
        }
        if (this.mView.mSoftRight != null && this.mPhase != kMaxPages) {
            graphics.drawImage(this.mView.mSoftRight, this.mView.mAtR.x, this.mView.mAtR.y, 3);
        }
        Map.mArtFont.DrawString(graphics, this.mTitle, this.mTitlex, 20);
    }

    public void touchStart(Point point) {
        try {
            this.mPressedButton = null;
            this.mActiveButton = null;
            if (Key.mPressed != 32768) {
                if (Key.mPressed == 0x100000 || Key.mPressed == 0x400000) {
                    ++this.mPhase;
                    if (this.mPhase > kMaxPages) {
                        this.mPhase = kMaxPages;
                    }
                    this.setWrapText();
                } else if (Key.mPressed == 0x200000) {
                    --this.mPhase;
                }
            }
            if (this.mPhase < 0) {
                this.mPhase = 0;
                this.onButtonReleaseX(this.mActiveButton, point);
                this.mActiveButton = null;
            } else {
                this.setWrapText();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

