/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class NewOrResumeGameForm
extends Form {
    boolean shouldShowLoadingBarNow = false;
    boolean mShowIt = false;
    long loadingBarStartTime = 0L;
    String mTitle = "SELECT GAME";
    Button mResumeButton;
    Button mNewGameButton;
    int mButtonPos = 1;

    NewOrResumeGameForm() {
    }

    public void onFormOpen() {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mName.compareTo("Resume") == 0) {
                this.mResumeButton = button;
                if (Map.doesSaveGameExist()) {
                    this.mResumeButton.mIsDisabled = false;
                    this.mResumeButton.mLabelText.mRed = 255;
                    this.mResumeButton.mLabelText.mGreen = 255;
                    this.mResumeButton.mLabelText.mBlue = 26;
                    this.mResumeButton.mYOffset = -0.01f;
                    continue;
                }
                this.mResumeButton.mIsDisabled = true;
                this.mResumeButton.mLabelText.mRed = 124;
                this.mResumeButton.mLabelText.mGreen = 121;
                this.mResumeButton.mLabelText.mBlue = 118;
                this.mResumeButton.mYOffset = -0.01f;
                continue;
            }
            if (button.mName.compareTo("NewGame") != 0) continue;
            this.mNewGameButton = button;
            this.mNewGameButton.mIsToggled = true;
            this.mNewGameButton.mLabelText.mRed = 255;
            this.mNewGameButton.mLabelText.mGreen = 255;
            this.mNewGameButton.mLabelText.mBlue = 26;
            this.mNewGameButton.mYOffset = -0.01f;
        }
    }

    public void onButtonReleaseNewGame() {
        if (Map.doesSaveGameExist()) {
            try {
                Form form = this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kConfirmNewGameFormNameID);
                if (form != null) {
                    form.onFormOpen();
                }
                this.mView.mMap.mRestoringGameState = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            Form form = this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kMapSelectionFormNameID);
            if (form != null) {
                form.onFormOpen();
            }
            this.mView.mMap.mRestoringGameState = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onButtonReleaseResume() {
        this.shouldShowLoadingBarNow = true;
        this.loadingBarStartTime = System.currentTimeMillis();
    }

    public void doResumeGame() {
        if (Map.doesSaveGameExist()) {
            if (this.mView.mMap != null) {
                this.mView.mMap = null;
                System.gc();
            }
            this.mView.mMap = new Map(this.mView, Fieldrunners.mCanvas.mApp);
            this.mView.mMap.setMapNameFromSaveFile();
            this.mView.mMap.mRestoringGameState = true;
            try {
                this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kLoadingFormNameID);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void onButtonReleaseX() {
        this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kTitleScreenFormNameID);
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        super.renderWithElapsedTime(graphics, f);
        graphics.drawImage(this.mView.mSoftLeft, this.mView.mAtL.x, this.mView.mAtL.y, 3);
        graphics.drawImage(this.mView.mSoftRight, this.mView.mAtR.x, this.mView.mAtR.y, 3);
        Map.mArtFont.DrawString(graphics, this.mTitle, 35, 20);
        if (this.shouldShowLoadingBarNow) {
            int n = (Fieldrunners.mCanvas.getWidth() - this.mView.mLoadingImage.getWidth()) / 2;
            int n2 = (Fieldrunners.mCanvas.getHeight() - this.mView.mLoadingImage.getHeight()) / 2;
            int n3 = n;
            int n4 = n2;
            graphics.drawImage(this.mView.mLoadingImage, n, n2, 0);
            long l = System.currentTimeMillis() - this.loadingBarStartTime;
            float f2 = (float)l / 270.0f;
            graphics.setClip(n + 25, n2 + 17, (int)((float)(n + 25) + 150.0f * f2), n2 + 27);
            if (this.mShowIt) {
                graphics.drawImage(this.mView.mLoadingBar, n3, n4, 0);
                this.mShowIt = false;
            } else {
                graphics.drawImage(this.mView.mLoadingBar2, n3, n4, 0);
                this.mShowIt = true;
            }
            graphics.setClip(0, 0, Can.VIEW_X, Can.VIEW_Y);
        }
        if (this.loadingBarStartTime != 0L && System.currentTimeMillis() - this.loadingBarStartTime > 270L) {
            this.shouldShowLoadingBarNow = false;
            this.loadingBarStartTime = 0L;
            this.doResumeGame();
        }
    }

    public void touchStart(Point point) {
        try {
            CGPoint cGPoint = new CGPoint(point.x, point.y);
            this.mPressedButton = null;
            cGPoint.x /= (float)this.mView.width();
            cGPoint.y /= (float)this.mView.height();
            this.mActiveButton = null;
            if (Key.mPressed == 0x400000 || Key.mPressed == 0x100000) {
                if (this.mButtonPos == 0) {
                    this.onButtonReleaseResume();
                } else {
                    this.onButtonReleaseNewGame();
                }
            } else if (Key.mPressed == 0x200000) {
                this.onButtonReleaseX();
            } else if (!(Key.mPressed != 131072 && Key.mPressed != 65536 || this.mResumeButton.mIsDisabled)) {
                if (this.mButtonPos == 0) {
                    this.mButtonPos = 1;
                    this.mNewGameButton.mIsToggled = true;
                    this.mResumeButton.mIsToggled = false;
                } else if (this.mButtonPos == 1) {
                    this.mNewGameButton.mIsToggled = false;
                    this.mResumeButton.mIsToggled = true;
                    this.mButtonPos = 0;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

