/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class TowerClass
extends EntityClass {
    public static int kRangeIndicatorVertexCount = 74;
    public static int kMaxTechLevels = 3;
    public static float[] gRangeIndicatorVertexPositions = new float[kRangeIndicatorVertexCount * 2];
    public static int[] gRangeIndicatorVertexColors = new int[kRangeIndicatorVertexCount * 4];
    public static int[] gRangeIndicatorOutlineVertexColors = new int[kRangeIndicatorVertexCount * 4];
    public static int[] gInvalidRangeIndicatorVertexColors = new int[kRangeIndicatorVertexCount * 4];
    public static int[] gInvalidRangeIndicatorOutlineVertexColors = new int[kRangeIndicatorVertexCount * 4];
    Vector mTechLevels = null;
    boolean mMirrorHorizontal = true;
    boolean mHasAttackAnimation;
    public int mID;

    public TowerClass(String string, Vector vector) {
        Object object;
        String string2 = null;
        if (string.equals("/Towers/tower_gatling.tower")) {
            this.mID = 0;
        } else if (string.equals("/Towers/tower_goo.tower")) {
            this.mID = 1;
        } else if (string.equals("/Towers/tower_missile.tower")) {
            this.mID = 2;
        } else if (string.equals("/Towers/tower_lightning.tower")) {
            this.mID = 4;
        } else if (string.equals("/Towers/tower_flame.tower")) {
            this.mID = 3;
        } else if (string.equals("/Towers/tower_mortar.tower")) {
            this.mID = 5;
        }
        this.mTechLevels = new Vector();
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        KXmlParser kXmlParser = new KXmlParser();
        try {
            kXmlParser.setInput(inputStream, null);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        try {
            kXmlParser.nextTag();
            int n = kXmlParser.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                object = kXmlParser.getAttributeName(i);
                String string3 = kXmlParser.getAttributeValue(i);
                if (((String)object).compareTo("sprite") == 0) {
                    string2 = string3;
                    continue;
                }
                if (((String)object).compareTo("attackSound") == 0 || ((String)object).compareTo("attackSoundVolume") == 0 || ((String)object).compareTo("mirrorHorizontal") != 0) continue;
                this.mMirrorHorizontal = string3.compareTo("no") != 0;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        try {
            kXmlParser.nextTag();
            kXmlParser.require(2, null, "TechLevels");
            kXmlParser.nextTag();
            while (kXmlParser.getName() != "TechLevels") {
                Object object2;
                int n;
                String string4 = null;
                String string5 = null;
                object = new TechLevel();
                int n2 = kXmlParser.getAttributeCount();
                for (n = 0; n < n2; ++n) {
                    object2 = kXmlParser.getAttributeName(n);
                    String string6 = kXmlParser.getAttributeValue(n);
                    if (((String)object2).compareTo("projectile") == 0) {
                        string4 = string6;
                        continue;
                    }
                    if (((String)object2).compareTo("fireDisplayTime") == 0) {
                        ((TechLevel)object).mFireDisplayTime = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("minDamage") == 0) {
                        ((TechLevel)object).mMinDamage = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("maxDamage") == 0) {
                        ((TechLevel)object).mMaxDamage = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("turnSpeed") == 0) {
                        ((TechLevel)object).mTurnSpeed = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("reloadSpeed") == 0) {
                        ((TechLevel)object).mReloadSpeed = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("attackRadius") == 0) {
                        ((TechLevel)object).mAttackRadius = Float.parseFloat(string6);
                        ((TechLevel)object).mAttackRadiusSquared = ((TechLevel)object).mAttackRadius * ((TechLevel)object).mAttackRadius;
                        continue;
                    }
                    if (((String)object2).compareTo("fieldOfView") == 0) {
                        ((TechLevel)object).mFieldOfView = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("minAttackRadius") == 0) {
                        ((TechLevel)object).mMinAttackRadius = Float.parseFloat(string6);
                        ((TechLevel)object).mMinAttackRadiusSquared = ((TechLevel)object).mMinAttackRadius * ((TechLevel)object).mMinAttackRadius;
                        continue;
                    }
                    if (((String)object2).compareTo("projectileSpawnDelay") == 0) {
                        ((TechLevel)object).mProjectileSpawnDelay = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("cost") == 0) {
                        ((TechLevel)object).mCost = Integer.parseInt(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("splashDamageModifier") == 0) {
                        ((TechLevel)object).mSplashDamageModifier = Float.parseFloat(string6);
                        continue;
                    }
                    if (((String)object2).compareTo("splashDamageRange") == 0) {
                        ((TechLevel)object).mSplashDamageRange = Float.parseFloat(string6) * Can.BASE_SIZE_FOR_ART_RESOURCES;
                        continue;
                    }
                    if (((String)object2).compareTo("particleSystem") == 0) {
                        string5 = string6;
                        continue;
                    }
                    if (((String)object2).compareTo("particleSystem") == 0) {
                        string5 = string6;
                        continue;
                    }
                    if (((String)object2).compareTo("fireWhenEnemyEnters") != 0) continue;
                    ((TechLevel)object).mFireTrigger = string6.compareTo("attackRange") == 0 ? 1 : 0;
                }
                if (string4 != null) {
                    for (n = 0; n < vector.size(); ++n) {
                        object2 = (ProjectileClass)vector.elementAt(n);
                        if (object2 == null || ((ProjectileClass)object2).mName == null || ((ProjectileClass)object2).mName.compareTo(string4) != 0) continue;
                        ((TechLevel)object).mProjectileClass = object2;
                        break;
                    }
                    if (((TechLevel)object).mProjectileClass != null && ((TechLevel)object).mProjectileClass.mType == 3) {
                        ((TechLevel)object).mMinDamage /= Can.FPS;
                        ((TechLevel)object).mMaxDamage /= Can.FPS;
                    }
                }
                this.mTechLevels.addElement(object);
                object = null;
                kXmlParser.nextTag();
                kXmlParser.nextTag();
                n = kXmlParser.getEventType();
                if (kXmlParser.getName().compareTo("TechLevels") != 0 || n != 3) continue;
                break;
            }
            System.gc();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        String string7 = "/Towers/";
        this.mSprite = new Sprite(string2, string7);
        this.mHasAttackAnimation = this.mSprite.doesContainAnimationWithID(13);
        kXmlParser = null;
        System.gc();
        this.mTechLevels.trimToSize();
    }

    public int getAttackAnimationIdForTechLevel(int n) {
        if (!this.mHasAttackAnimation) {
            return this.getIdleAnimationIdForTechLevel(n);
        }
        return 13 + n;
    }

    public int getIdleAnimationIdForTechLevel(int n) {
        return 10 + n;
    }

    public static void initRangeIndicatorVertexBuffersWithTower(Tower tower) {
        int n = tower.mTechLevel.mMinAttackRadius > 0.001f ? kRangeIndicatorVertexCount : kRangeIndicatorVertexCount / 2;
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            if (tower.mTechLevel.mMinAttackRadius < 0.001f) {
                f = 360.0f / (float)(kRangeIndicatorVertexCount / 2 - 2) * (float)i;
                if (i == 0) {
                    TowerClass.gRangeIndicatorVertexPositions[0] = 0.0f;
                    TowerClass.gRangeIndicatorVertexPositions[1] = 0.0f;
                } else {
                    TowerClass.gRangeIndicatorVertexPositions[i * 2] = (float)(Math.cos(Math.toRadians(f)) * (double)tower.mTechLevel.mAttackRadius);
                    TowerClass.gRangeIndicatorVertexPositions[i * 2 + 1] = (float)(Math.sin(Math.toRadians(f)) * (double)tower.mTechLevel.mAttackRadius);
                }
            } else {
                f = 360.0f / (float)(kRangeIndicatorVertexCount / 2 - 2) * (float)(i / 2);
                if (i % 2 == 0) {
                    TowerClass.gRangeIndicatorVertexPositions[i * 2] = (float)(Math.cos(Math.toRadians(f)) * (double)tower.mTechLevel.mAttackRadius);
                    TowerClass.gRangeIndicatorVertexPositions[i * 2 + 1] = (float)(Math.sin(Math.toRadians(f)) * (double)tower.mTechLevel.mAttackRadius);
                } else {
                    TowerClass.gRangeIndicatorVertexPositions[i * 2] = (float)(Math.cos(Math.toRadians(f)) * (double)tower.mTechLevel.mMinAttackRadius);
                    TowerClass.gRangeIndicatorVertexPositions[i * 2 + 1] = (float)(Math.sin(Math.toRadians(f)) * (double)tower.mTechLevel.mMinAttackRadius);
                }
            }
            TowerClass.gRangeIndicatorVertexColors[i * 4] = 32;
            TowerClass.gRangeIndicatorVertexColors[i * 4 + 1] = 160;
            TowerClass.gRangeIndicatorVertexColors[i * 4 + 2] = 56;
            TowerClass.gRangeIndicatorVertexColors[i * 4 + 3] = 255;
            TowerClass.gRangeIndicatorOutlineVertexColors[i * 4] = 128;
            TowerClass.gRangeIndicatorOutlineVertexColors[i * 4 + 1] = 255;
            TowerClass.gRangeIndicatorOutlineVertexColors[i * 4 + 2] = 128;
            TowerClass.gRangeIndicatorOutlineVertexColors[i * 4 + 3] = 255;
            TowerClass.gInvalidRangeIndicatorVertexColors[i * 4] = 192;
            TowerClass.gInvalidRangeIndicatorVertexColors[i * 4 + 1] = 0;
            TowerClass.gInvalidRangeIndicatorVertexColors[i * 4 + 2] = 0;
            TowerClass.gInvalidRangeIndicatorVertexColors[i * 4 + 3] = 255;
            TowerClass.gInvalidRangeIndicatorOutlineVertexColors[i * 4] = 255;
            TowerClass.gInvalidRangeIndicatorOutlineVertexColors[i * 4 + 1] = 92;
            TowerClass.gInvalidRangeIndicatorOutlineVertexColors[i * 4 + 2] = 92;
            TowerClass.gInvalidRangeIndicatorOutlineVertexColors[i * 4 + 3] = 255;
        }
    }

    public static void renderFieldOfViewWithTower(Tower tower, float f, boolean bl) {
        for (int i = 0; i < kRangeIndicatorVertexCount; ++i) {
            if (!bl) {
                TowerClass.gRangeIndicatorVertexColors[i * 4 + 3] = (int)(128.0f * f);
                continue;
            }
            TowerClass.gInvalidRangeIndicatorVertexColors[i * 4 + 3] = (int)(128.0f * f);
        }
    }

    public static void renderRangeIndicatorWithPosition(MapGraphics mapGraphics, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        if (f6 <= 0.001f) {
            return;
        }
        String string = "";
        string = (double)f4 == 54.0 ? (bl ? "/Towers/RedCircle54.png" : "/Towers/GreenCircle54.png") : ((double)f4 == 90.0 ? (bl ? "/Towers/RedCircle90.png" : "/Towers/GreenCircle90.png") : ((double)f4 == 109.0 ? (bl ? "/Towers/RedCircle109.png" : "/Towers/GreenCircle109.png") : (bl ? "/Towers/RedCircle.png" : "/Towers/GreenCircle.png")));
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (image != null) {
            mapGraphics.drawImage(image, (int)f, (int)f2, 3);
        }
        if (f3 > 0.001f) {
            // empty if block
        }
    }

    public static void renderRangeIndicatorWithTower(MapGraphics mapGraphics, Tower tower, float f, boolean bl) {
        float f2 = tower.mTechLevel.mMinAttackRadius;
        float f3 = tower.mTechLevel.mAttackRadius;
        float f4 = tower.mX;
        float f5 = tower.mY;
        TowerClass.renderRangeIndicatorWithPosition(mapGraphics, f4, f5, f2, f3, 1.0f, 1.0f, bl);
    }
}

