/*
 * Decompiled with CFR 0.152.
 */
package mw.util;

import mw.util.ColorSet;
import mw.util.ColorUtil;
import mw.util.Rnd;

public class ColorPalette
extends ColorUtil {
    public int num = 0;
    public int alloc = 100;
    public int numSet;
    ColorSet[] set;
    public int[] c = new int[this.alloc];
    public static float[] hsb;

    public ColorPalette() {
        this.set = new ColorSet[20];
        if (ColorUtil.rnd == null) {
            ColorUtil.rnd = new Rnd();
        }
    }

    public void empty() {
        this.num = 0;
    }

    public void addSet(ColorSet _set) {
        if (this.numSet == this.set.length) {
            ColorSet[] tmp = new ColorSet[this.numSet * 2];
            System.arraycopy(this.set, 0, tmp, 0, this.numSet);
            this.set = tmp;
        }
        this.set[this.numSet++] = _set;
    }

    public void initPalette() {
        this.num = 0;
        int choice = ColorUtil.rnd.rndInt(this.numSet);
        this.set[choice].getPalette(this);
    }

    public void initPalette(int choice) {
        this.num = 0;
        this.set[choice].getPalette(this);
    }

    public int getRandomCol() {
        return this.c[ColorUtil.rnd.rndInt(this.num)];
    }

    public void scramblePalette() {
        if (this.num > 2) {
            int i = 0;
            while (i < this.num * 3) {
                int b;
                int a = (int)Math.floor(ColorUtil.rnd.rndInt(this.num));
                while (a == (b = (int)Math.floor(ColorUtil.rnd.rndInt(this.num)))) {
                }
                int tmp = this.c[a];
                this.c[a] = this.c[b];
                this.c[b] = tmp;
                ++i;
            }
        }
    }

    public void add(int col) {
        if (this.num == this.alloc) {
            this.alloc *= 2;
            int[] tmp = new int[this.alloc];
            int i = 0;
            while (i < this.num) {
                tmp[i] = this.c[i];
                ++i;
            }
            this.c = tmp;
        }
        this.c[this.num] = col;
        ++this.num;
    }

    public void add(int col, int numcol) {
        int i = 0;
        while (i < numcol) {
            this.add(col);
            ++i;
        }
    }

    public void add(float r, float g, float b) {
        this.add(ColorUtil.color(r, g, b));
    }

    public void add(float r, float g, float b, float a) {
        this.add(ColorUtil.color(r, g, b, a));
    }

    public void add(String hex, int num) {
        int i = 0;
        while (i < num) {
            this.add(ColorUtil.color(hex));
            ++i;
        }
    }

    public void add(String hex) {
        this.add(ColorUtil.color(hex));
    }

    public void addRange(float numrange, float r, float g, float b, float r2, float g2, float b2) {
        r2 -= r;
        g2 -= g;
        b2 -= b;
        float i = 0.0f;
        while (i < numrange) {
            float fract = i / (numrange - 1.0f);
            this.add(ColorUtil.color(r + r2 * fract, g + g2 * fract, b + b2 * fract));
            i += 1.0f;
        }
    }

    public void addRange(float numrange, float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        r2 -= r;
        g2 -= g;
        b2 -= b;
        a2 -= a;
        float i = 0.0f;
        while (i < numrange) {
            float fract = i / (numrange - 1.0f);
            this.add(ColorUtil.color(r + r2 * fract, g + g2 * fract, b + b2 * fract, a + a2 * fract));
            i += 1.0f;
        }
    }

    public void addRange(float numrange, int c1, int c2) {
        this.addRange(numrange, c1 >> 16 & 0xFF, c1 >> 8 & 0xFF, c1 & 0xFF, c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF);
    }

    public void addRange(float numrange, String hex1, String hex2) {
        int col1 = ColorUtil.color(hex1);
        int col2 = ColorUtil.color(hex2);
        this.addRange(numrange, col1, col2);
    }
}

