/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PMIDlet;

public class PCanvas
extends Canvas {
    private PMIDlet midlet;
    public Image buffer;
    public Graphics bufferg;
    private int width;
    private int height;
    private int colorMode;
    private boolean colorModeRGB255;
    private int colorMaxX;
    private int colorMaxY;
    private int colorMaxZ;
    private int colorMaxA;
    private boolean stroke;
    private int strokeWidth;
    private int strokeColor;
    private boolean fill;
    private int fillColor;
    private int rectMode;
    private int ellipseMode;
    protected static int imageMode;
    private int shapeMode;
    public int[] vertex;
    public int vertexIndex;
    private int[] curveVertex;
    private int curveVertexIndex;
    private int[] stack;
    private int stackIndex;
    private int translateX;
    private int translateY;
    private PFont textFont;
    private int textAlign;
    private static final int EDGE_X = 0;
    private static final int EDGE_DX = 1;
    private static final int EDGE_DY = 2;
    private static final int EDGE_X1 = 3;
    private static final int EDGE_Y1 = 4;
    private static final int EDGE_X2 = 5;
    private static final int EDGE_Y2 = 6;
    private static final int EDGE_ARRAY_SIZE = 7;

    public PCanvas(PMIDlet midlet) {
        this.midlet = midlet;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.buffer = Image.createImage((int)this.width, (int)this.height);
        this.bufferg = this.buffer.getGraphics();
        this.colorMode = 0;
        this.colorModeRGB255 = true;
        this.colorMaxA = 255;
        this.colorMaxZ = 255;
        this.colorMaxY = 255;
        this.colorMaxX = 255;
        this.stroke = true;
        this.strokeColor = 0;
        this.strokeWidth = 1;
        this.fill = true;
        this.fillColor = 0xFFFFFF;
        this.rectMode = 2;
        this.ellipseMode = 0;
        imageMode = 2;
        this.shapeMode = -1;
        this.vertex = new int[16];
        this.vertexIndex = 0;
        this.curveVertex = new int[8];
        this.curveVertexIndex = 0;
        this.stack = new int[4];
        this.textAlign = 2;
        this.background(200);
    }

    protected void paint(Graphics g) {
        g.drawImage(this.buffer, 0, 0, 20);
    }

    protected void keyPressed(int keyCode) {
        this.midlet.enqueueEvent((byte)1, keyCode, null);
    }

    protected void keyReleased(int keyCode) {
        this.midlet.enqueueEvent((byte)2, keyCode, null);
    }

    protected void pointerPressed(int x, int y) {
        int value = x << 16 | y & 0xFFFF;
        this.midlet.enqueueEvent((byte)5, value, null);
    }

    protected void pointerDragged(int x, int y) {
        int value = x << 16 | y & 0xFFFF;
        this.midlet.enqueueEvent((byte)6, value, null);
    }

    protected void pointerReleased(int x, int y) {
        int value = x << 16 | y & 0xFFFF;
        this.midlet.enqueueEvent((byte)7, value, null);
    }

    public void point(int x1, int y1) {
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawLine(x1, y1, x1, y1);
        }
    }

    public void line(int x1, int y1, int x2, int y2) {
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawLine(x1, y1, x2, y2);
        }
    }

    public void triangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.shapeMode = 8;
        this.vertex[0] = x1;
        this.vertex[1] = y1;
        this.vertex[2] = x2;
        this.vertex[3] = y2;
        this.vertex[4] = x3;
        this.vertex[5] = y3;
        this.vertexIndex = 6;
        this.endShape();
    }

    public void quad(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.shapeMode = 8;
        this.vertex[0] = x1;
        this.vertex[1] = y1;
        this.vertex[2] = x2;
        this.vertex[3] = y2;
        this.vertex[4] = x3;
        this.vertex[5] = y3;
        this.vertex[6] = x4;
        this.vertex[7] = y4;
        this.vertexIndex = 8;
        this.endShape();
    }

    public void rect(int x, int y, int width, int height) {
        switch (this.rectMode) {
            case 3: {
                int temp = x;
                x = Math.min(x, width);
                width = Math.abs(x - temp);
                temp = y;
                y = Math.min(y, height);
                height = Math.abs(y - temp);
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height / 2;
            }
        }
        if (this.fill) {
            this.bufferg.setColor(this.fillColor);
            this.bufferg.fillRect(x, y, width, height);
        }
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawRect(x, y, width, height);
        }
    }

    public void rectMode(int MODE) {
        if (MODE >= 0 && MODE <= 2) {
            this.rectMode = MODE;
        }
    }

    public void ellipse(int x, int y, int width, int height) {
        switch (this.ellipseMode) {
            case 3: {
                int temp = x;
                x = Math.min(x, width);
                width = Math.abs(x - temp);
                temp = y;
                y = Math.min(y, height);
                height = Math.abs(y - temp);
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 1: {
                x -= width;
                y -= height;
                width *= 2;
                height *= 2;
            }
        }
        if (this.fill) {
            this.bufferg.setColor(this.fillColor);
            this.bufferg.fillArc(x, y, width, height, 0, 360);
        }
        if (this.stroke) {
            this.bufferg.setColor(this.strokeColor);
            this.bufferg.drawArc(x, y, width, height, 0, 360);
        }
    }

    public void ellipseMode(int MODE) {
        if (MODE >= 0 && MODE <= 3) {
            this.ellipseMode = MODE;
        }
    }

    public void curve(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.beginShape(2);
        this.curveVertex(x1, y1);
        this.curveVertex(x1, y1);
        this.curveVertex(x2, y2);
        this.curveVertex(x3, y3);
        this.curveVertex(x4, y4);
        this.curveVertex(x4, y4);
        this.endShape();
    }

    public void bezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.beginShape(2);
        this.vertex(x1, y1);
        this.bezierVertex(x2, y2, x3, y3, x4, y4);
        this.endShape();
    }

    public void strokeWeight(int width) {
        this.strokeWidth = width;
    }

    public void beginShape(int MODE) {
        this.shapeMode = MODE >= 0 && MODE <= 8 ? MODE : 0;
        this.vertexIndex = 0;
        this.curveVertexIndex = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void endShape() {
        switch (this.shapeMode) {
            case 0: {
                i = 0;
                step = 2;
                ** GOTO lbl49
            }
            case 1: {
                i = 2;
                step = 4;
                ** GOTO lbl49
            }
            case 2: 
            case 3: {
                i = 2;
                step = 2;
                ** GOTO lbl49
            }
            case 4: {
                i = 4;
                step = 6;
                ** GOTO lbl49
            }
            case 5: {
                i = 4;
                step = 2;
                ** GOTO lbl49
            }
            case 6: {
                i = 6;
                step = 8;
                ** GOTO lbl49
            }
            case 7: {
                i = 6;
                step = 4;
                if (true) ** GOTO lbl49
            }
            case 8: {
                this.polygon(0, this.vertexIndex - 2);
                return;
            }
            default: {
                return;
            }
        }
        do {
            switch (this.shapeMode) {
                case 0: {
                    this.point(this.vertex[i], this.vertex[i + 1]);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.line(this.vertex[i - 2], this.vertex[i - 1], this.vertex[i], this.vertex[i + 1]);
                    break;
                }
                case 4: 
                case 5: {
                    this.polygon(i - 4, i);
                    break;
                }
                case 6: 
                case 7: {
                    this.polygon(i - 6, i);
                }
            }
            i += step;
lbl49:
            // 8 sources

        } while (i < this.vertexIndex);
        if (this.shapeMode == 3 && this.vertexIndex >= 2) {
            this.line(this.vertex[this.vertexIndex - 2], this.vertex[this.vertexIndex - 1], this.vertex[0], this.vertex[1]);
        }
        this.vertexIndex = 0;
    }

    private void polygon(int startIndex, int endIndex) {
        if (endIndex >= startIndex + 2) {
            if (endIndex >= startIndex + 4 && this.fill) {
                int[] e2;
                int j;
                int[] e1;
                this.bufferg.setColor(this.fillColor);
                Vector<int[]> edges = new Vector<int[]>();
                int edgeCount = 0;
                int yMin = Integer.MAX_VALUE;
                int yMax = Integer.MIN_VALUE;
                int i = startIndex;
                while (i <= endIndex) {
                    e1 = new int[7];
                    if (i == startIndex) {
                        if (this.vertex[startIndex + 1] < this.vertex[endIndex + 1]) {
                            e1[3] = this.vertex[startIndex];
                            e1[4] = this.vertex[startIndex + 1];
                            e1[5] = this.vertex[endIndex];
                            e1[6] = this.vertex[endIndex + 1];
                        } else {
                            e1[3] = this.vertex[endIndex];
                            e1[4] = this.vertex[endIndex + 1];
                            e1[5] = this.vertex[startIndex];
                            e1[6] = this.vertex[startIndex + 1];
                        }
                    } else if (this.vertex[i - 1] < this.vertex[i + 1]) {
                        e1[3] = this.vertex[i - 2];
                        e1[4] = this.vertex[i - 1];
                        e1[5] = this.vertex[i];
                        e1[6] = this.vertex[i + 1];
                    } else {
                        e1[3] = this.vertex[i];
                        e1[4] = this.vertex[i + 1];
                        e1[5] = this.vertex[i - 2];
                        e1[6] = this.vertex[i - 1];
                    }
                    e1[0] = e1[3];
                    e1[1] = e1[5] - e1[3];
                    e1[2] = e1[6] - e1[4];
                    yMin = Math.min(e1[4], yMin);
                    yMax = Math.max(e1[6], yMax);
                    j = 0;
                    while (j < edgeCount) {
                        e2 = (int[])edges.elementAt(j);
                        if (e1[4] < e2[4]) {
                            edges.insertElementAt(e1, j);
                            e1 = null;
                            break;
                        }
                        if (e1[4] == e2[4] && e1[3] < e2[3]) {
                            edges.insertElementAt(e1, j);
                            e1 = null;
                            break;
                        }
                        ++j;
                    }
                    if (e1 != null) {
                        edges.addElement(e1);
                    }
                    ++edgeCount;
                    i += 2;
                }
                Vector<int[]> active = new Vector<int[]>();
                int activeCount = 0;
                int y = yMin;
                while (y <= yMax) {
                    i = activeCount - 1;
                    while (i >= 0) {
                        e1 = (int[])active.elementAt(i);
                        if (e1[6] <= y) {
                            active.removeElementAt(i);
                            --activeCount;
                        } else {
                            e1[0] = (y - e1[4]) * e1[1] / e1[2] + e1[3];
                        }
                        --i;
                    }
                    Vector<int[]> newActive = new Vector<int[]>();
                    i = 0;
                    while (i < activeCount) {
                        e1 = (int[])active.elementAt(i);
                        j = 0;
                        while (j < i) {
                            e2 = (int[])newActive.elementAt(j);
                            if (e1[0] < e2[0]) {
                                newActive.insertElementAt(e1, j);
                                e1 = null;
                                break;
                            }
                            ++j;
                        }
                        if (e1 != null) {
                            newActive.addElement(e1);
                        }
                        ++i;
                    }
                    active = newActive;
                    i = 0;
                    while (i < edgeCount) {
                        e1 = (int[])edges.elementAt(i);
                        if (e1[4] != y) break;
                        j = 0;
                        while (j < activeCount) {
                            e2 = (int[])active.elementAt(j);
                            if (e1[0] < e2[0]) {
                                active.insertElementAt(e1, j);
                                e1 = null;
                                break;
                            }
                            ++j;
                        }
                        if (e1 != null) {
                            active.addElement(e1);
                        }
                        ++activeCount;
                        edges.removeElementAt(i);
                        --edgeCount;
                        --i;
                        ++i;
                    }
                    i = 1;
                    while (i < activeCount) {
                        e1 = (int[])active.elementAt(i - 1);
                        e2 = (int[])active.elementAt(i);
                        this.bufferg.drawLine(e1[0], y, e2[0], y);
                        i += 2;
                    }
                    ++y;
                }
            }
            if (this.stroke) {
                this.bufferg.setColor(this.strokeColor);
                int i = startIndex + 2;
                while (i <= endIndex) {
                    this.line(this.vertex[i - 2], this.vertex[i - 1], this.vertex[i], this.vertex[i + 1]);
                    i += 2;
                }
                this.line(this.vertex[endIndex], this.vertex[endIndex + 1], this.vertex[startIndex], this.vertex[startIndex + 1]);
            }
        }
    }

    public int[] getVertexArray() {
        return this.vertex;
    }

    public void vertex(int x, int y) {
        this.vertex[this.vertexIndex] = x;
        ++this.vertexIndex;
        this.vertex[this.vertexIndex] = y;
        ++this.vertexIndex;
        int length = this.vertex.length;
        if (this.vertexIndex == length) {
            int[] old = this.vertex;
            this.vertex = new int[length * 2];
            System.arraycopy(old, 0, this.vertex, 0, length);
        }
    }

    public void curveVertex(int x, int y) {
        this.curveVertex[this.curveVertexIndex] = x << 8;
        ++this.curveVertexIndex;
        this.curveVertex[this.curveVertexIndex] = y << 8;
        ++this.curveVertexIndex;
        if (this.curveVertexIndex == 8) {
            int tension = 128;
            int dx0 = (this.curveVertex[4] - this.curveVertex[0]) * tension >> 8;
            int dx1 = (this.curveVertex[6] - this.curveVertex[2]) * tension >> 8;
            int dy0 = (this.curveVertex[5] - this.curveVertex[1]) * tension >> 8;
            int dy1 = (this.curveVertex[7] - this.curveVertex[3]) * tension >> 8;
            this.plotCurveVertices(this.curveVertex[2], this.curveVertex[3], this.curveVertex[4], this.curveVertex[5], dx0, dx1, dy0, dy1);
            int i = 0;
            while (i < 6) {
                this.curveVertex[i] = this.curveVertex[i + 2];
                ++i;
            }
            this.curveVertexIndex = 6;
        }
    }

    public void bezierVertex(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.vertexIndex -= 2;
        int x0 = this.vertex[this.vertexIndex] << 8;
        int y0 = this.vertex[this.vertexIndex + 1] << 8;
        int tension = 768;
        int dx0 = ((x1 <<= 8) - x0) * tension >> 8;
        int dx1 = ((x3 <<= 8) - (x2 <<= 8)) * tension >> 8;
        int dy0 = ((y1 <<= 8) - y0) * tension >> 8;
        int dy1 = ((y3 <<= 8) - (y2 <<= 8)) * tension >> 8;
        this.plotCurveVertices(x0, y0, x3, y3, dx0, dx1, dy0, dy1);
    }

    private void plotCurveVertices(int x0, int y0, int x1, int y1, int dx0, int dx1, int dy0, int dy1) {
        this.vertex(x0 >> 8, y0 >> 8);
        int t = 0;
        while (t < 256) {
            int t2 = t * t >> 8;
            int t3 = t * t2 >> 8;
            int h0 = (512 * t3 >> 8) - (768 * t2 >> 8) + 256;
            int h1 = (-512 * t3 >> 8) + (768 * t2 >> 8);
            int h2 = t3 - (512 * t2 >> 8) + t;
            int h3 = t3 - t2;
            int x = (h0 * x0 >> 8) + (h1 * x1 >> 8) + (h2 * dx0 >> 8) + (h3 * dx1 >> 8);
            int y = (h0 * y0 >> 8) + (h1 * y1 >> 8) + (h2 * dy0 >> 8) + (h3 * dy1 >> 8);
            this.vertex(x >> 8, y >> 8);
            t += 26;
        }
        this.vertex(x1 >> 8, y1 >> 8);
    }

    public void translate(int x, int y) {
        this.translateX += x;
        this.translateY += y;
        this.bufferg.translate(x, y);
    }

    public void pushMatrix() {
        if (this.stackIndex == this.stack.length) {
            int[] old = this.stack;
            this.stack = new int[this.stackIndex * 2];
            System.arraycopy(old, 0, this.stack, 0, this.stackIndex);
        }
        this.stack[this.stackIndex] = this.translateX;
        this.stack[this.stackIndex + 1] = this.translateY;
        this.stackIndex += 2;
    }

    public void popMatrix() {
        if (this.stackIndex > 0) {
            this.stackIndex -= 2;
            this.translateX = this.stack[this.stackIndex];
            this.translateY = this.stack[this.stackIndex + 1];
            this.bufferg.translate(this.translateX - this.bufferg.getTranslateX(), this.translateY - this.bufferg.getTranslateY());
        }
    }

    public void resetMatrix() {
        this.stackIndex = 0;
        this.translateX = 0;
        this.translateY = 0;
        this.bufferg.translate(-this.bufferg.getTranslateX(), -this.bufferg.getTranslateY());
    }

    public void background(int gray) {
        if ((gray & 0xFF000000) == 0 && gray <= this.colorMaxX) {
            this.background(gray, gray, gray);
        } else {
            this.bufferg.setColor(gray);
            this.bufferg.fillRect(0, 0, this.width, this.height);
        }
    }

    public void background(int value1, int value2, int value3) {
        this.bufferg.setColor(this.color(value1, value2, value3));
        this.bufferg.fillRect(0, 0, this.width, this.height);
    }

    public void background(PImage img) {
        this.image(img, this.width - img.width >> 1, this.height - img.height >> 1);
    }

    public void image(PImage img, int x, int y) {
        this.bufferg.drawImage(img.image, x, y, 20);
    }

    public void image(PImage img, int sx, int sy, int swidth, int sheight, int dx, int dy) {
        if (imageMode == 3) {
            swidth -= sx;
            sheight -= sy;
        }
        this.bufferg.setClip(dx, dy, swidth, sheight);
        this.bufferg.drawImage(img.image, dx - sx, dy - sy, 20);
        this.bufferg.setClip(0, 0, this.width, this.height);
    }

    public void imageMode(int mode) {
        if (mode != 2 && mode != 3) {
            throw new RuntimeException("Invalid imageMode");
        }
        imageMode = mode;
    }

    public void textFont(PFont font) {
        this.textFont = font;
    }

    public void colorMode(int mode) {
        if (mode == 0 || mode == 1) {
            this.colorMode = mode;
        }
        this.colorModeRGB255 = false;
        if (this.colorMode == 0 && this.colorMaxX == 255 && this.colorMaxY == 255 && this.colorMaxZ == 255) {
            this.colorModeRGB255 = true;
        }
    }

    public void colorMode(int mode, int range1, int range2, int range3) {
        this.colorMaxX = range1;
        this.colorMaxY = range2;
        this.colorMaxZ = range3;
        this.colorMode(mode);
    }

    public void colorMode(int mode, int range1, int range2, int range3, int range4) {
        this.colorMode(mode, range1, range2, range3);
        this.colorMaxA = range4;
    }

    public int color(int gray) {
        return this.color(gray, this.colorMaxA);
    }

    public int color(int gray, int alpha) {
        if (gray < 0) {
            gray = 0;
        }
        if (gray > this.colorMaxX) {
            gray = this.colorMaxX;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > this.colorMaxA) {
            alpha = this.colorMaxA;
        }
        if (!this.colorModeRGB255) {
            gray = gray * 255 / this.colorMaxX;
        }
        if (this.colorMaxA != 255) {
            alpha = alpha * 255 / this.colorMaxA;
        }
        return alpha << 24 | gray << 16 | gray << 8 | gray;
    }

    public int color(int value1, int value2, int value3) {
        return this.color(value1, value2, value3, this.colorMaxA);
    }

    public int color(int value1, int value2, int value3, int alpha) {
        if (value1 < 0) {
            value1 = 0;
        }
        if (value1 > this.colorMaxX) {
            value1 = this.colorMaxX;
        }
        if (value2 < 0) {
            value2 = 0;
        }
        if (value2 > this.colorMaxY) {
            value2 = this.colorMaxY;
        }
        if (value3 < 0) {
            value3 = 0;
        }
        if (value3 > this.colorMaxZ) {
            value3 = this.colorMaxZ;
        }
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > this.colorMaxA) {
            alpha = this.colorMaxA;
        }
        if (!this.colorModeRGB255) {
            if (this.colorMode == 0) {
                value1 = value1 * 255 / this.colorMaxX;
                value2 = value2 * 255 / this.colorMaxY;
                value3 = value3 * 255 / this.colorMaxZ;
            } else if (value2 == 0) {
                value1 = value3 * 255 / this.colorMaxZ;
                value2 = value3 * 255 / this.colorMaxZ;
                value3 = value3 * 255 / this.colorMaxZ;
            } else {
                int y = (value2 << 8) / this.colorMaxY;
                int z = (value3 << 8) / this.colorMaxZ;
                int h = value1 * 6 / this.colorMaxX % 6;
                int f = (value1 << 8) * 6 / this.colorMaxX - (h << 8);
                int p = this.midlet.mul(z, 256 - y);
                int q = this.midlet.mul(z, 256 - this.midlet.mul(y, f));
                int t = this.midlet.mul(z, 256 - this.midlet.mul(y, 256 - f));
                switch (h) {
                    case 0: {
                        value1 = z * 255 >> 8;
                        value2 = t * 255 >> 8;
                        value3 = p * 255 >> 8;
                        break;
                    }
                    case 1: {
                        value1 = q * 255 >> 8;
                        value2 = z * 255 >> 8;
                        value3 = p * 255 >> 8;
                        break;
                    }
                    case 2: {
                        value1 = p * 255 >> 8;
                        value2 = z * 255 >> 8;
                        value3 = t * 255 >> 8;
                        break;
                    }
                    case 3: {
                        value1 = p * 255 >> 8;
                        value2 = q * 255 >> 8;
                        value3 = z * 255 >> 8;
                        break;
                    }
                    case 4: {
                        value1 = t * 255 >> 8;
                        value2 = p * 255 >> 8;
                        value3 = z * 255 >> 8;
                        break;
                    }
                    case 5: {
                        value1 = z * 255 >> 8;
                        value2 = p * 255 >> 8;
                        value3 = q * 255 >> 8;
                    }
                }
            }
        }
        if (alpha != 255) {
            alpha = alpha * 255 / this.colorMaxA;
        }
        return alpha << 24 | value1 << 16 | value2 << 8 | value3;
    }

    public void stroke(int gray) {
        if ((gray & 0xFF000000) == 0 && gray <= this.colorMaxX) {
            this.stroke(gray, gray, gray);
        } else {
            this.stroke = true;
            this.strokeColor = gray;
        }
    }

    public void stroke(int value1, int value2, int value3) {
        this.stroke = true;
        this.strokeColor = this.color(value1, value2, value3);
    }

    public void noStroke() {
        this.stroke = false;
    }

    public void fill(int gray) {
        if ((gray & 0xFF000000) == 0 && gray <= this.colorMaxX) {
            this.fill(gray, gray, gray);
        } else {
            this.fill = true;
            this.fillColor = gray;
        }
    }

    public void fill(int value1, int value2, int value3) {
        this.fill = true;
        this.fillColor = this.color(value1, value2, value3);
    }

    public void noFill() {
        this.fill = false;
    }

    public void text(String data, int x, int y) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        if (this.textFont.font != null) {
            this.bufferg.setColor(this.fillColor);
            this.bufferg.setFont(this.textFont.font);
            int align = 16;
            align = this.textAlign == 0 ? (align |= 1) : (this.textAlign == 5 ? (align |= 8) : (align |= 4));
            this.bufferg.drawString(data, x, y - this.textFont.font.getBaselinePosition(), align);
        } else {
            if (this.textAlign != 2) {
                int width = this.textWidth(data);
                if (this.textAlign == 0) {
                    x -= width >> 1;
                } else if (this.textAlign == 5) {
                    x -= width;
                }
            }
            int i = 0;
            int length = data.length();
            while (i < length) {
                char c = data.charAt(i);
                int index = this.textFont.getIndex(c);
                if (index >= 0) {
                    this.bufferg.drawImage(this.textFont.images[index].image, x + this.textFont.leftExtent[index], y - this.textFont.topExtent[index], 20);
                    x += this.textFont.setWidth[index];
                } else {
                    x += this.textFont.setWidth[this.textFont.ascii[105]];
                }
                ++i;
            }
        }
    }

    public int textWidth(char data) {
        return this.textWidth(String.valueOf(data));
    }

    public int textWidth(String data) {
        if (this.textFont == null) {
            throw new RuntimeException("The current font has not yet been set with textFont()");
        }
        int width = 0;
        if (this.textFont.font != null) {
            width = this.textFont.font.stringWidth(data);
        } else {
            int i = 0;
            int length = data.length();
            while (i < length) {
                char c = data.charAt(i);
                int index = this.textFont.getIndex(c);
                width = index >= 0 ? (width += this.textFont.setWidth[index]) : (width += this.textFont.setWidth[this.textFont.ascii[105]]);
                ++i;
            }
        }
        return width;
    }

    public void textAlign(int MODE) {
        if (MODE != 2 && MODE != 0 && MODE != 5) {
            throw new IllegalArgumentException("Invalid textAlign MODE value");
        }
        this.textAlign = MODE;
    }

    protected void showNotify() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.width != width || this.height != height) {
            this.sizeChanged(width, height);
        }
    }

    protected void sizeChanged(int width, int height) {
        this.width = this.midlet.width = width;
        this.height = this.midlet.height = height;
        this.buffer = Image.createImage((int)width, (int)height);
        this.bufferg = this.buffer.getGraphics();
    }
}

