/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import processing.core.PImage;
import processing.core.PMIDlet;

public class PFont {
    public int charCount;
    public PImage[] images;
    public char[] value;
    public byte[] heights;
    public byte[] width;
    public byte[] setWidth;
    public byte[] topExtent;
    public byte[] leftExtent;
    protected int[] ascii;
    public final int baseline;
    public final int height;
    public Font font;

    public PFont(Font font) {
        this.font = font;
        this.height = font.getHeight();
        this.baseline = font.getBaselinePosition();
    }

    public PFont(InputStream is, int color, int bgcolor) {
        try {
            DataInputStream dis = new DataInputStream(is);
            this.charCount = dis.readInt();
            int version = dis.readInt();
            this.value = new char[this.charCount];
            this.heights = new byte[this.charCount];
            this.width = new byte[this.charCount];
            this.setWidth = new byte[this.charCount];
            this.topExtent = new byte[this.charCount];
            this.leftExtent = new byte[this.charCount];
            this.ascii = new int[128];
            int i = 0;
            while (i < 128) {
                this.ascii[i] = -1;
                ++i;
            }
            int baseline = 0;
            int height = 0;
            int i2 = 0;
            while (i2 < this.charCount) {
                this.value[i2] = dis.readChar();
                this.heights[i2] = dis.readByte();
                this.width[i2] = dis.readByte();
                this.setWidth[i2] = dis.readByte();
                this.topExtent[i2] = dis.readByte();
                this.leftExtent[i2] = dis.readByte();
                if (this.value[i2] < '\u0080') {
                    this.ascii[this.value[i2]] = i2;
                }
                baseline = Math.max(baseline, this.topExtent[i2]);
                height = Math.max(height, baseline + this.heights[i2] - this.topExtent[i2]);
                ++i2;
            }
            this.baseline = baseline;
            this.height = height;
            this.images = new PImage[this.charCount];
            byte[] palette = null;
            int i3 = 0;
            while (i3 < this.charCount) {
                int pngSize = dis.readInt();
                if (pngSize > 0) {
                    byte[] pngData = new byte[pngSize];
                    dis.readFully(pngData);
                    if (color != 0 || bgcolor != 0xFFFFFF) {
                        int offset = 41;
                        if (palette == null) {
                            int r = (bgcolor & 0xFF0000) >> 16;
                            int g = (bgcolor & 0xFF00) >> 8;
                            int b = bgcolor & 0xFF;
                            int dr = ((color & 0xFF0000) >> 16) - r;
                            int dg = ((color & 0xFF00) >> 8) - g;
                            int db = (color & 0xFF) - b;
                            int index = 41;
                            int j = 0;
                            while (j < 256) {
                                pngData[index++] = (byte)(r + j * dr / 255);
                                pngData[index++] = (byte)(g + j * dg / 255);
                                pngData[index++] = (byte)(b + j * db / 255);
                                ++j;
                            }
                            int crc = PMIDlet.crc(pngData, 37, 772);
                            pngData[809] = (byte)((crc & 0xFF000000) >> 24);
                            pngData[810] = (byte)((crc & 0xFF0000) >> 16);
                            pngData[811] = (byte)((crc & 0xFF00) >> 8);
                            pngData[812] = (byte)(crc & 0xFF);
                            palette = new byte[772];
                            System.arraycopy(pngData, 41, palette, 0, 772);
                        } else {
                            System.arraycopy(palette, 0, pngData, 41, 772);
                        }
                    }
                    this.images[i3] = new PImage(pngData);
                }
                ++i3;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public int getIndex(char c) {
        if (c < '\u0080') {
            return this.ascii[c];
        }
        return this.getIndex(c, 0, this.charCount - 1);
    }

    private int getIndex(int c, int start, int stop) {
        int pivot = (start + stop) / 2;
        if (c == this.value[pivot]) {
            return pivot;
        }
        if (start >= stop) {
            return -1;
        }
        if (c < this.value[pivot]) {
            return this.getIndex(c, start, pivot - 1);
        }
        return this.getIndex(c, pivot + 1, stop);
    }
}

