/*
 * Decompiled with CFR 0.152.
 */
package toxi.image;

import javax.microedition.lcdui.Image;
import toxi.image.TBlendMode;
import toxi.image.TBlendModeAdditive;
import toxi.image.TBlendModeLinear;
import toxi.image.TBlendModeSubtract;

public class TImage {
    public int[] pixels;
    public int width;
    public int height;
    public int width1;
    public int height1;
    int[] x_array;
    int[] y_array;
    int[] r_array;
    int[] g_array;
    int[] b_array;
    int[] a_array;
    public static final TBlendMode BLEND = new TBlendModeLinear();
    public static final TBlendMode ADD = new TBlendModeAdditive();
    public static final TBlendMode SUBTRACT = new TBlendModeSubtract();
    private TBlendMode blendMode = BLEND;

    private TImage() {
        this.x_array = new int[2];
        this.y_array = new int[2];
        this.r_array = new int[2];
        this.g_array = new int[2];
        this.b_array = new int[2];
        this.a_array = new int[2];
    }

    public TImage(int w, int h) {
        this();
        this.width = w;
        this.height = h;
        this.width1 = w - 1;
        this.height1 = h - 1;
        this.pixels = new int[w * h];
    }

    public TImage(Image img) {
        this(img.getWidth(), img.getHeight());
        img.getRGB(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    public void blendMode(TBlendMode mode) {
        if (mode != null) {
            this.blendMode = mode;
        }
    }

    public void set(int x, int y, int col) {
        if (x >= 0 && x < this.width && y >= 0 & y < this.height) {
            int idx = y * this.width + x;
            this.pixels[idx] = this.blendMode.blend(this.pixels[idx], col);
        }
    }

    public void line(float x, float y, float x2, float y2, int col) {
        this.line((int)x, (int)y, (int)x2, (int)y2, col);
    }

    public void line(int x, int y, int x2, int y2, int col) {
        int code2;
        int code1 = this.lineClipCode(x, y);
        if ((code1 & (code2 = this.lineClipCode(x2, y2))) != 0) {
            return;
        }
        boolean yLonger = false;
        int shortLen = y2 - y;
        int longLen = x2 - x;
        if (Math.abs(shortLen) > Math.abs(longLen)) {
            int swap = shortLen;
            shortLen = longLen;
            longLen = swap;
            yLonger = true;
        }
        int decInc = longLen == 0 ? 0 : (shortLen << 16) / longLen;
        if (yLonger) {
            if (longLen > 0) {
                longLen += y;
                int j = 32768 + (x << 16);
                while (y <= longLen) {
                    this.set(j >> 16, y, col);
                    j += decInc;
                    ++y;
                }
                return;
            }
            longLen += y;
            int j = 32768 + (x << 16);
            while (y >= longLen) {
                this.set(j >> 16, y, col);
                j -= decInc;
                --y;
            }
            return;
        }
        if (longLen > 0) {
            longLen += x;
            int j = 32768 + (y << 16);
            while (x <= longLen) {
                this.set(x, j >> 16, col);
                j += decInc;
                ++x;
            }
            return;
        }
        longLen += x;
        int j = 32768 + (y << 16);
        while (x >= longLen) {
            this.set(x, j >> 16, col);
            j -= decInc;
            --x;
        }
    }

    private int lineClipCode(int xi, int yi) {
        return (yi < 0 ? 8 : 0) | (yi > this.height1 ? 4 : 0) | (xi < 0 ? 2 : 0) | (xi > this.width1 ? 1 : 0);
    }

    private int lineSlope(int x1, int y1, int x2, int y2, int border) {
        switch (border) {
            case 4: {
                return -((y1 << 8) / (y2 - y1));
            }
            case 3: {
                return (this.height1 - y1 << 8) / (y2 - y1);
            }
            case 2: {
                return -((x1 << 8) / (x2 - x1));
            }
            case 1: {
                return (this.width1 - x1 << 8) / (x2 - x1);
            }
        }
        return -1;
    }

    public boolean lineClipping() {
        int code1 = this.lineClipCode(this.x_array[0], this.y_array[0]);
        int code2 = this.lineClipCode(this.x_array[1], this.y_array[1]);
        int dip = code1 | code2;
        if ((code1 & code2) != 0) {
            return false;
        }
        if (dip != 0) {
            int a0 = 0;
            int a1 = 1;
            int a = 0;
            int i = 0;
            while (i < 4) {
                if ((dip >> i) % 2 == 1) {
                    a = this.lineSlope(this.x_array[0], this.y_array[0], this.x_array[1], this.y_array[1], i + 1);
                    if ((code1 >> i) % 2 == 1) {
                        a0 = a > a0 ? a : a0;
                    } else {
                        a1 = a < a1 ? a : a1;
                    }
                }
                ++i;
            }
            if (a0 > a1) {
                return false;
            }
            int xt = this.x_array[0];
            int yt = this.y_array[0];
            this.x_array[0] = xt + a0 * (this.x_array[1] - xt) >> 8;
            this.y_array[0] = yt + a0 * (this.y_array[1] - yt) >> 8;
            this.x_array[1] = xt + a1 * (this.x_array[1] - xt) >> 8;
            this.y_array[1] = yt + a1 * (this.y_array[1] - yt) >> 8;
        }
        return true;
    }
}

