/*
 * Decompiled with CFR 0.152.
 */
package mw;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.pim.FieldFullException;
import processing.core.PImage;
import processing.core.PMIDlet;

public class PixelFont {
    PMIDlet p;
    Graphics g;
    PImage img;
    public String filename;
    public int fontHeight = 12;
    public int fontSpace = 5;
    int[] offs;
    int[] w = new int[]{5, 5, 5, 5, 4, 4, 5, 5, 1, 5, 5, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 5, 5, 5, 3, 5, 3, 5, 5, 5, 5, 5, 4, 5, 5, 1, 2, 2, 2, 2, 3, 3, 5, 3, 1, 1, 2, 1, 5, 3, 5};
    public String fntdata = "abcdefghijklmnopqrstuvwxyz 0123456789!()[]<>@}|.,:+-*";
    public int charNum;
    public int[] lookup;

    public PixelFont(PMIDlet _p) {
        this.p = _p;
        this.g = this.p.canvas.bufferg;
    }

    public void readFont() {
        int i = 0;
        try {
            this.img = new PImage(Image.createImage((String)("/" + this.filename)));
        }
        catch (Exception ex) {
            this.img = null;
            System.out.println("Exception: " + ex.toString());
            ex.printStackTrace();
        }
        try {
            this.charNum = this.fntdata.length();
            this.lookup = new int[256];
            i = 0;
            while (i < this.lookup.length) {
                this.lookup[i] = -1;
                ++i;
            }
            int pos = 0;
            this.offs = new int[this.w.length];
            i = 0;
            while (i < this.offs.length) {
                this.offs[i] = pos;
                pos += this.w[i];
                ++i;
            }
            i = 0;
            while (i < this.charNum) {
                this.lookup[this.fntdata.charAt((int)i)] = i;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(String.valueOf(i) + " " + e.toString());
        }
    }

    public void setColor(int col) {
        Image tmp;
        int w = 0;
        w = this.img.image.getWidth();
        int h = this.img.image.getHeight();
        int[] px = new int[w * h];
        this.img.image.getRGB(px, 0, w, 0, 0, w, h);
        int i = 0;
        while (i < px.length) {
            int a = px[i] >> 24 & 0xFF;
            if (a > 0) {
                px[i] = col;
            }
            ++i;
        }
        this.img.getClass();
        this.img.image = tmp = Image.createRGBImage((int[])px, (int)w, (int)h, (boolean)true);
    }

    public void draw(Graphics g, int c, int x, int y) {
        g.clipRect(x, y, this.w[c], this.fontHeight);
        this.p.image(this.img, x - this.offs[c], y);
        g.setClip(0, 0, this.p.width, this.p.height);
    }

    public void draw(Graphics g, String s, int x, int y) {
        g.setClip(0, 0, this.p.width, this.p.height);
        try {
            int i = 0;
            while (i < s.length()) {
                int ch = s.charAt(i);
                if (ch == 32) {
                    x += this.fontSpace;
                } else {
                    if (this.fntdata.indexOf(ch) == -1) {
                        ch = -1;
                    }
                    if (ch > -1) {
                        int c = this.lookup[ch];
                        g.clipRect(x, y, this.w[c], this.fontHeight);
                        this.p.image(this.img, x - this.offs[c], y);
                        x += this.w[c];
                        g.setClip(0, 0, this.p.width, this.p.height);
                    }
                }
                ++i;
            }
        }
        catch (FieldFullException ex) {
            ex.printStackTrace();
        }
    }

    public int getWidth(String s) {
        int pw = 0;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == ' ') {
                pw += this.fontSpace;
            }
            if (this.fntdata.indexOf(ch) != -1) {
                pw += this.w[this.lookup[ch]];
            }
            ++i;
        }
        return pw;
    }

    public void draw(String s, int x, int y) {
        this.draw(this.p.canvas.bufferg, s, x, y);
    }
}

