/*
 * Decompiled with CFR 0.152.
 */
package mw;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mw.NokiaSketch;
import mw.PixelFont;
import toxi.math.noise.SimplexNoise;

public class TypoAnim {
    NokiaSketch p;
    Image fntImg;
    int n;
    int fntH;
    int pwidth;
    int pheight;
    int TOPLEFT = 20;
    Letter[] l;
    PixelFont fnt;
    SimplexNoise noise;
    float mod;

    public TypoAnim(NokiaSketch _p, PixelFont _fnt) {
        this.p = _p;
        this.fnt = _fnt;
        this.fntImg = this.fnt.img.image;
        this.fntH = this.fnt.fontHeight;
        this.pwidth = this.p.p.width;
        this.pheight = this.p.p.height;
        this.noise = new SimplexNoise();
    }

    public void reinit() {
        int x = 0;
        this.n = 0;
        int y = (this.pheight - this.fntH) / 2;
        String in = this.p.p.inputTxt;
        this.l = new Letter[in.length()];
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            if (ch == ' ') {
                x += this.fnt.fontSpace;
            } else if (this.fnt.fntdata.indexOf(ch) != -1) {
                this.l[this.n] = new Letter(ch, x, y);
                x += this.l[this.n].w;
                ++this.n;
            }
            ++i;
        }
        int xmod = (int)((float)(this.pwidth - x) * 0.5f);
        double start = this.p.rnd.rndDouble(200.0);
        int i2 = 0;
        while (i2 < this.n) {
            this.l[i2].setPos(this.l[i2].x2 + xmod, (int)((double)this.l[i2].y2 + SimplexNoise.noise(start + (double)i2 * 0.05, 0.0, 0.0) * 40.0));
            ++i2;
        }
    }

    public void draw() {
        this.draw(this.p.p.canvas.bufferg);
    }

    public void draw(Graphics gr) {
        int px = 0;
        int py = 0;
        int i = 0;
        while (i < this.n) {
            Letter lett = this.l[i];
            if (lett.cnt < lett.goal) {
                this.mod = lett.cnt / lett.goal;
                if (!(this.mod < 0.0f)) {
                    px = (int)((float)lett.x + lett.xD * this.mod);
                    py = (int)((float)lett.y + lett.yD * this.mod);
                }
                lett.cnt += 1.0f;
                if (lett.cnt == lett.goal) {
                    lett.done = true;
                    lett.x = (int)((float)lett.x + lett.xD);
                    lett.y = (int)((float)lett.y + lett.yD);
                }
            } else {
                px = lett.x;
                py = lett.y;
            }
            if (lett.cnt > 0.0f) {
                gr.clipRect(px, py, lett.w, this.fntH);
                gr.drawImage(this.fntImg, px - lett.offs, py, this.TOPLEFT);
                gr.setClip(0, 0, this.pwidth, this.pheight);
            }
            ++i;
        }
    }

    public void setFont(PixelFont newFont) {
        this.fnt = newFont;
        this.fntImg = this.fnt.img.image;
    }

    public void setFontColor(int c) {
        this.fnt.setColor(c);
        this.fntImg = this.fnt.img.image;
    }

    class Letter {
        float cnt;
        float goal;
        float yD;
        float xD;
        float tOffs;
        float tMult;
        int x2;
        int y2;
        int x;
        int y;
        int c;
        int w;
        int offs;
        char ch;
        boolean done = false;

        Letter(int _c, int _x, int _y) {
            this.ch = (char)_c;
            this.c = TypoAnim.this.fnt.lookup[this.ch];
            this.x2 = _x;
            this.y2 = _y;
            this.x = TypoAnim.this.p.rnd.rndInt(TypoAnim.this.pwidth);
            this.y = -(TypoAnim.this.fntH + TypoAnim.this.p.rnd.rndInt(20));
            if (TypoAnim.this.p.rnd.rndBool()) {
                this.y = TypoAnim.this.pheight + TypoAnim.this.p.rnd.rndInt(20);
            }
            this.xD = this.x2 - this.x;
            this.yD = this.y2 - this.y;
            this.w = TypoAnim.this.fnt.w[this.c];
            this.offs = TypoAnim.this.fnt.offs[this.c];
            this.tOffs = 0.0f;
            this.tMult = 1.0f;
            if (TypoAnim.this.p.rnd.probGt(30.0f)) {
                this.tOffs = TypoAnim.this.p.rnd.rndFloat(0.5f);
                this.tMult = 1.0f / (1.0f - this.tOffs);
            }
            this.cnt = -TypoAnim.this.p.rnd.rndInt(50);
            this.goal = TypoAnim.this.p.rnd.rndInt(80, 120);
        }

        void setPos(int _x, int _y) {
            this.x2 = _x;
            this.y2 = _y;
            this.xD = this.x2 - this.x;
            this.yD = this.y2 - this.y;
        }
    }
}

