/*
 * Decompiled with CFR 0.152.
 */
package mw.util;

import mw.util.Rnd;

public class ColorUtil {
    public static Rnd rnd;

    public static final int colorBlended(float fract, float r, float g, float b, float r2, float g2, float b2) {
        return ColorUtil.color(r + (r2 -= r) * fract, g + (g2 -= g) * fract, b + (b2 -= b) * fract);
    }

    public static final int colorMult(int c, float m) {
        int cr = (int)((float)(c >> 16 & 0xFF) * m);
        int cg = (int)((float)(c >> 8 & 0xFF) * m);
        int cb = (int)((float)(c & 0xFF) * m);
        if (cr > 255) {
            cr = 255;
        }
        if (cg > 255) {
            cg = 255;
        }
        if (cb > 255) {
            cb = 255;
        }
        return ColorUtil.color(cr, cg, cb);
    }

    public static final int colorBlended(float fract, float r, float g, float b, float a, float r2, float g2, float b2, float a2) {
        return ColorUtil.color(r + (r2 -= r) * fract, g + (g2 -= g) * fract, b + (b2 -= b) * fract, a + (a2 -= a) * fract);
    }

    public static final int colorBlended(float fract, int col1, int col2) {
        float r = col1 >> 16 & 0xFF;
        float r2 = (float)(col2 >> 16 & 0xFF) - r;
        float g = col1 >> 8 & 0xFF;
        float g2 = (float)(col2 >> 8 & 0xFF) - g;
        float b = col1 & 0xFF;
        float b2 = (float)(col2 & 0xFF) - b;
        return ColorUtil.color(r + r2 * fract, g + g2 * fract, b + b2 * fract);
    }

    public static final int colorBlended(float fract, String c1, String c2) {
        int col1 = ColorUtil.color(c1);
        int col2 = ColorUtil.color(c2);
        return ColorUtil.colorBlended(fract, col1 >> 16 & 0xFF, col1 >> 8 & 0xFF, col1 & 0xFF, col2 >> 16 & 0xFF, col2 >> 8 & 0xFF, col2 & 0xFF);
    }

    public static final int color(String hex) {
        return 0xFF000000 | Integer.parseInt(hex, 16);
    }

    public static final String colorToString(int c) {
        return "rgba=(" + (c >> 16 & 0xFF) + "," + (c >> 8 & 0xFF) + "," + (c & 0xFF) + "," + (c >> 24 & 0xFF) + ")";
    }

    public String colorToHex(int col) {
        String s = String.valueOf(Integer.toHexString(col >> 16 & 0xFF)) + Integer.toHexString(col >> 8 & 0xFF) + Integer.toHexString(col & 0xFF);
        s = s.toUpperCase();
        return s;
    }

    public static final int color(int x, int y, int z, int a) {
        return (a & 0xFF) << 24 | (x & 0xFF) << 16 | (y & 0xFF) << 8 | z & 0xFF;
    }

    public static final int color(float x, float y, float z, float a) {
        return ((int)a & 0xFF) << 24 | ((int)x & 0xFF) << 16 | ((int)y & 0xFF) << 8 | (int)z & 0xFF;
    }

    public static final int color(int x, int y, int z) {
        return 0xFF000000 | (x & 0xFF) << 16 | (y & 0xFF) << 8 | z & 0xFF;
    }

    public static final int color(float x, float y, float z) {
        return 0xFF000000 | ((int)x & 0xFF) << 16 | ((int)y & 0xFF) << 8 | (int)z & 0xFF;
    }

    public static final int getAlpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static final int getRed(int c) {
        return c >> 16 & 0xFF;
    }

    public static final int getBlue(int c) {
        return c & 0xFF;
    }

    public static final int getGreen(int c) {
        return c >> 8 & 0xFF;
    }

    public static final int setAlpha(int c, float alpha) {
        return (int)alpha << 24 | 0xFFFFFF & c;
    }

    public boolean isWhite(int c) {
        return (c & 0xFFFFFF) == 0xFFFFFF;
    }
}

