/*
 * Decompiled with CFR 0.152.
 */
package mw.util;

import java.util.Date;

public class Rnd {
    public static long seedCnt;
    public long seed;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;

    public Rnd() {
        this.setSeed(seedCnt);
        ++seedCnt;
    }

    public Rnd(long seed) {
        this.setSeed(seed);
    }

    public Rnd(Date d) {
        this.setSeed(d.getTime());
    }

    public Rnd(int[] array) {
        this.setSeed(array);
    }

    private void setSeed(long _seed) {
        this.seed = _seed;
        this.mt = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.mt[0] = (int)(this.seed & 0xFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
        }
    }

    private void setSeed(int[] array) {
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        int k = 624 > array.length ? 624 : array.length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525) + array[j] + j;
            int n = i++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
            ++j;
            if (i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        k = 623;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
            int n = i++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
            if (i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            --k;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    public final double raw() {
        int z;
        int y;
        int kk;
        if (this.mti >= 624) {
            kk = 0;
            while (kk < 227) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ this.mag01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ this.mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        if (this.mti >= 624) {
            kk = 0;
            while (kk < 227) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            while (kk < 623) {
                z = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ z >>> 1 ^ this.mag01[z & 1];
                ++kk;
            }
            z = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ z >>> 1 ^ this.mag01[z & 1];
            this.mti = 0;
        }
        z = this.mt[this.mti++];
        z ^= z >>> 11;
        z ^= z << 7 & 0x9D2C5680;
        z ^= z << 15 & 0xEFC60000;
        z ^= z >>> 18;
        return (double)(((long)(y >>> 6) << 27) + (long)(z >>> 5)) / 9.007199254740992E15;
    }

    public boolean probGt(float f) {
        return this.rndFloat(100.0f) > f;
    }

    public double rndDouble() {
        return this.raw();
    }

    public double rndDouble(double range) {
        return range * this.raw();
    }

    public double rndDouble(double min, double max) {
        return (max - min) * this.raw() + min;
    }

    public float rndFloat() {
        return (float)this.raw();
    }

    public float rndFloat(float range) {
        return range * (float)this.raw();
    }

    public float rndFloat(float min, float max) {
        return (max - min) * (float)this.raw() + min;
    }

    public int rndInt(int range) {
        int r = (int)Math.floor(this.raw() * (double)range);
        if (r == range) {
            --r;
        }
        return r;
    }

    public int rndInt(int min, int max) {
        return (int)Math.floor((double)(max - min) * this.raw()) + min;
    }

    public boolean rndBool() {
        return this.raw() >= 0.5;
    }
}

