/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import processing.core.PCanvas;

public class PImage {
    public Image image;
    public final int width;
    public final int height;
    public final boolean mutable;

    public PImage(int width, int height) {
        this.image = Image.createImage((int)width, (int)height);
        this.width = width;
        this.height = height;
        this.mutable = true;
    }

    public PImage(int width, int height, int color) {
        this(width, height);
        Graphics g = this.image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
    }

    public PImage(Image img) {
        this.image = img;
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.mutable = false;
    }

    public PImage(byte[] png) {
        this(png, 0, png.length);
    }

    public PImage(byte[] png, int offset, int length) {
        try {
            this.image = Image.createImage((byte[])png, (int)offset, (int)length);
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.mutable = false;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void copy(int sx, int sy, int swidth, int sheight, int dx, int dy, int dwidth, int dheight) {
        if (PCanvas.imageMode == 3) {
            swidth -= sx;
            sheight -= sy;
        }
        Image image = Image.createImage((int)swidth, (int)sheight);
        Graphics g = image.getGraphics();
        g.drawImage(this.image, -sx, -sy, 20);
        this.copy(image, 0, 0, swidth, sheight, dx, dy, dwidth, dheight);
    }

    public void copy(PImage source, int sx, int sy, int swidth, int sheight, int dx, int dy, int dwidth, int dheight) {
        this.copy(source.image, sx, sy, swidth, sheight, dx, dy, dwidth, dheight);
    }

    private void copy(Image source, int sx, int sy, int swidth, int sheight, int dx, int dy, int dwidth, int dheight) {
        if (!this.mutable) {
            throw new RuntimeException("this image cannot be overwritten");
        }
        if (PCanvas.imageMode == 3) {
            swidth -= sx;
            sheight -= sy;
            dwidth -= dx;
            dheight -= dy;
        }
        Graphics g = this.image.getGraphics();
        if (dwidth == swidth && dheight == sheight) {
            g.setClip(dx, dy, dwidth, dheight);
            g.drawImage(source, dx - sx, dy - sy, 20);
        } else if (dwidth == swidth) {
            int scaleY = dy - sy;
            int y = 0;
            while (y < dheight) {
                g.setClip(dx, dy + y, dwidth, 1);
                g.drawImage(source, dx - sx, scaleY, 20);
                scaleY = dy - sy - y * sheight / dheight + y;
                ++y;
            }
        } else if (dheight == sheight) {
            int scaleX = dx - sx;
            int x = 0;
            while (x < dwidth) {
                g.setClip(dx + x, dy, 1, dheight);
                g.drawImage(source, scaleX, dy - sy, 20);
                scaleX = dx - sx - x * swidth / dwidth + x;
                ++x;
            }
        } else {
            int scaleY = dy - sy;
            int y = 0;
            while (y < dheight) {
                int scaleX = dx - sx;
                int x = 0;
                while (x < dwidth) {
                    g.setClip(dx + x, dy + y, 1, 1);
                    g.drawImage(source, scaleX, scaleY, 20);
                    scaleX = dx - sx - x * swidth / dwidth + x;
                    ++x;
                }
                scaleY = dy - sy - y * sheight / dheight + y;
                ++y;
            }
        }
    }
}

