/*
 * Decompiled with CFR 0.152.
 */
package processing.phone;

import javax.microedition.lcdui.Display;
import processing.core.PCanvas;
import processing.core.PMIDlet;

public class Phone {
    private PMIDlet midlet;
    private PCanvas canvas;
    private Display display;

    public Phone(PMIDlet midlet) {
        this.midlet = midlet;
        this.canvas = midlet.canvas;
        this.display = midlet.display;
    }

    public void fullscreen() {
        this.canvas.removeCommand(this.midlet.cmdExit);
        this.canvas.removeCommand(this.midlet.cmdCustom);
        this.canvas.setCommandListener(null);
        this.canvas.setFullScreenMode(true);
        this.midlet.width = this.canvas.getWidth();
        this.midlet.height = this.canvas.getHeight();
    }

    public void noFullscreen() {
        this.canvas.setFullScreenMode(false);
        this.midlet.width = this.canvas.getWidth();
        this.midlet.height = this.canvas.getHeight();
        this.canvas.addCommand(this.midlet.cmdExit);
        this.canvas.addCommand(this.midlet.cmdCustom);
        this.canvas.setCommandListener(this.midlet);
    }

    public boolean vibrate(int duration) {
        return this.display.vibrate(duration);
    }

    public boolean flash(int duration) {
        return this.display.flashBacklight(duration);
    }

    public boolean call(String number) {
        return this.launch("tel:" + number);
    }

    public boolean launch(String url) {
        try {
            return this.midlet.platformRequest(url);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

