/*
 * Decompiled with CFR 0.152.
 */
package toxi;

import processing.core.PImage;
import processing.core.PMIDlet;
import processing.phone.Phone;
import toxi.image.TImage;

public class ExploreMIDlet
extends PMIDlet {
    TImage img;
    PImage bg;
    Phone p;
    Particle[] particles;
    int numParticles = 150;
    int pCount = 0;
    int framecount = 0;
    int emitterAngle = 325;

    public void setup() {
        this.size(128, 128);
        try {
            this.p = new Phone(this);
            this.bg = this.loadImage("explore_320x240.png");
            this.img = new TImage(this.width, this.height);
            this.img.blendMode(TImage.ADD);
            this.particles = new Particle[this.numParticles];
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void draw() {
        if (this.keyPressed) {
            if (this.keyCode == 2) {
                this.emitterAngle = this.max(this.emitterAngle - 2, 270);
            }
            if (this.keyCode == 5) {
                this.emitterAngle = this.min(this.emitterAngle + 2, 359);
            }
        }
        if (this.pCount < this.numParticles) {
            this.addDrop();
        }
        this.background(this.bg);
        int i = 0;
        while (i < this.pCount) {
            this.particles[i].draw();
            ++i;
        }
        if (this.width > 240) {
            this.canvas.bufferg.drawRGB(this.img.pixels, 0, this.height, 0, 0, this.img.width, this.min(this.width, this.img.height), false);
            this.canvas.bufferg.drawRGB(this.img.pixels, 0, this.height, 240, 0, this.img.width, this.min(this.width, this.img.height), false);
        } else {
            this.canvas.bufferg.drawRGB(this.img.pixels, 0, this.height, 0, 0, this.img.width, this.min(this.width, this.img.height), false);
        }
        i = 0;
        while (i < 50) {
            this.canvas.stroke(this.random(150, 255), this.random(200, 255), 0);
            this.canvas.bezier(0, 0, this.random(this.width), this.random(this.height), this.random(this.width), this.random(this.height), this.width, this.height);
            ++i;
        }
    }

    public void addDrop() {
        if (this.pCount < this.numParticles) {
            this.particles[this.pCount++] = new Particle(0, this.bg.height);
        }
    }

    public void background(PImage bg) {
        bg.image.getRGB(this.img.pixels, 0, this.img.width, 0, 0, this.min(bg.width, this.width), this.min(bg.height, this.height));
    }

    public void ellipse(int x, int y, int rx, int ry, int col) {
        int px = x + rx;
        int py = y;
        int res = 15;
        int cx = 0;
        int cy = 0;
        int i = res;
        while (i < 360) {
            cx = x + this.fptoi(rx * PMIDlet.sin[(i + 90) % 360]);
            cy = y + this.fptoi(ry * PMIDlet.sin[i]);
            this.img.line(px += cx > px ? 1 : (cx < px ? -1 : 0), py += cy > py ? 1 : (cy < py ? -1 : 0), cx, cy, col);
            px = cx;
            py = cy;
            i += res;
        }
        this.img.line(px += cx > px ? 1 : (cx < px ? -1 : 0), py += cy > py ? 1 : (cy < py ? -1 : 0), x + rx, y, col);
    }

    class Particle {
        int x;
        int y;
        int ox;
        int oy;
        int dx;
        int dy;
        int scale;
        int maxScale;
        int theta;
        int dt;

        Particle(int xx, int yy) {
            this.ox = xx << 8;
            this.oy = yy << 8;
            this.init();
        }

        void init() {
            this.x = this.ox;
            this.y = this.oy;
            this.dx = ExploreMIDlet.this.random(128, 1024);
            this.dy = -ExploreMIDlet.this.random(64, 1024);
            int alpha = ExploreMIDlet.this.random(ExploreMIDlet.this.emitterAngle - 15, ExploreMIDlet.this.emitterAngle + 15);
            int s = ExploreMIDlet.this.random(128, 1024);
            this.dx = PMIDlet.sin[(alpha + 90) % 360] * s >> 8;
            this.dy = PMIDlet.sin[alpha % 360] * s >> 8;
            this.scale = 256;
            this.maxScale = ExploreMIDlet.this.random(128, 1280);
            this.theta = ExploreMIDlet.this.random(360);
            this.dt = ExploreMIDlet.this.random(10);
        }

        void draw() {
            this.x += this.dx;
            this.y += this.dy;
            this.theta = (this.theta + this.dt) % 360;
            this.scale += (this.maxScale - this.scale) / 8;
            int s = 3 * this.scale >> 8;
            int cx = this.x >> 8;
            int cy = this.y >> 8;
            int cs = s * PMIDlet.sin[(this.theta + 90) % 360] >> 8;
            int si = s * PMIDlet.sin[this.theta] >> 8;
            ExploreMIDlet.this.img.line(cx - cs, cy - si, cx + cs, cy + si, 0x40FFFFFF);
            ExploreMIDlet.this.img.line(cx + si, cy - cs, cx - si, cy + cs, 0x40FFFFFF);
            if (cx > ExploreMIDlet.this.width + s || cy < -s) {
                this.init();
            }
        }
    }
}

