/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.bluetooth;

import fr.uha.ensisa.ir.walther.milcityblue.core.Config;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Commands;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.CommandsIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClientServer {
    private InputStream inputStream;
    private OutputStream outputStream;

    public ClientServer(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public void send(String message) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(1);
                byte[] data = message.getBytes();
                this.outputStream.write(data.length);
                this.outputStream.write(data);
                this.outputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void send(Command command) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(2);
                this.outputStream.write(command.getPlayerSender());
                this.outputStream.write(command.getPlayerTarget());
                this.outputStream.write(command.getCommandType());
                this.outputStream.write(command.getParameters().length);
                int i = 0;
                while (i < command.getParameters().length) {
                    this.outputStream.write(command.getParameters()[i]);
                    ++i;
                }
                this.outputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void send(Commands commands) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(4);
                this.outputStream.write(commands.count());
                CommandsIterator it = new CommandsIterator(commands);
                while (it.hasNext()) {
                    this.send(it.next());
                }
                this.outputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void send(Grid grid) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(3);
                this.outputStream.write(grid.getMaxX());
                this.outputStream.write(grid.getMaxY());
                int sizeX = grid.getMaxX();
                int sizeY = grid.getMaxY();
                byte[] data = new byte[sizeX * sizeY];
                int y = 0;
                while (y < sizeY) {
                    int x = 0;
                    while (x < sizeX) {
                        data[y * sizeY + x] = (byte)grid.getCell(x, y);
                        ++x;
                    }
                    ++y;
                }
                this.outputStream.write(data);
                this.outputStream.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String receiveString() {
        byte[] data = null;
        if (this.inputStream != null) {
            try {
                if (this.inputStream.read() == 1) {
                    int length = this.inputStream.read();
                    System.out.println("LENGTH = " + length);
                    data = new byte[length];
                    length = 0;
                    int readed = 0;
                    while (length != data.length) {
                        readed = this.inputStream.read(data, length, data.length - length);
                        if (readed == -1) {
                            throw new IOException("Cannot read byte");
                        }
                        length += readed;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("DATA = " + new String(data));
        return new String(data);
    }

    public Command receiveCommand() {
        int type = 0;
        int sender = 100;
        int target = 100;
        int[] parameters = null;
        if (this.inputStream != null) {
            try {
                if (this.inputStream.read() == 2) {
                    sender = this.inputStream.read();
                    target = this.inputStream.read();
                    type = this.inputStream.read();
                    int length = this.inputStream.read();
                    parameters = new int[length];
                    length = 0;
                    while (length != parameters.length) {
                        parameters[length] = this.inputStream.read();
                        ++length;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new Command(sender, target, type, parameters);
    }

    public Commands receiveCommands() {
        Commands commands = new Commands();
        if (this.inputStream != null) {
            try {
                if (this.inputStream.read() == 4) {
                    int length = this.inputStream.read();
                    int i = 0;
                    while (i < length) {
                        commands.push(this.receiveCommand());
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return commands;
    }

    public Grid receiveGrid() {
        Grid grid = new Grid(Config.DEFAULT_GRID_SIZE_X, Config.DEFAULT_GRID_SIZE_Y, 0);
        if (this.inputStream != null) {
            try {
                if (this.inputStream.read() == 3) {
                    int sizeX = this.inputStream.read();
                    int sizeY = this.inputStream.read();
                    int[][] gridint = new int[sizeX][sizeY];
                    int y = 0;
                    while (y < sizeY) {
                        int x = 0;
                        while (x < sizeX) {
                            gridint[x][y] = this.inputStream.read();
                            ++x;
                        }
                        ++y;
                    }
                    grid = new Grid(sizeX, sizeY, gridint);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return grid;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }
}

