/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cells;
import fr.uha.ensisa.ir.walther.milcityblue.core.CellsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;

public abstract class Building {
    public static final int BUILDING_NULL = 100;
    public static final int BUILDING_MISSILESILO = 101;
    public static final int BUILDING_SHIELDGENERATOR = 102;
    public static final int BUILDING_POWERPLANT = 103;
    public static final int BUILDING_AIRFIELD = 104;
    public static final int BUILDING_LABORATORY = 105;
    public static final int BUILDING_FACTORY = 106;
    public static final int BUILDING_HOUSE = 107;
    public static final int BUILDING_COMMERCIAL = 108;
    public static final int BUILDING_NUKESILO = 109;
    public static final int ANGLE_0 = 0;
    public static final int ANGLE_90 = 90;
    public static final int ANGLE_180 = 180;
    public static final int ANGLE_270 = 270;
    public static final int STATE_CONSTRUCTION = 0;
    public static final int STATE_OPERATIONAL = 1;
    public static final int STATE_DESTROYED = 2;
    public static final int SIZE_MISSILESILO_X = 1;
    public static final int SIZE_MISSILESILO_Y = 1;
    public static final int SIZE_SHIELDGENERATOR_X = 1;
    public static final int SIZE_SHIELDGENERATOR_Y = 1;
    public static final int SIZE_POWERPLANT_X = 2;
    public static final int SIZE_POWERPLANT_Y = 1;
    public static final int SIZE_AIRFIELD_X = 1;
    public static final int SIZE_AIRFIELD_Y = 3;
    public static final int SIZE_LABORATORY_X = 2;
    public static final int SIZE_LABORATORY_Y = 1;
    public static final int SIZE_FACTORY_X = 2;
    public static final int SIZE_FACTORY_Y = 2;
    public static final int SIZE_HOUSE_X = 1;
    public static final int SIZE_HOUSE_Y = 1;
    public static final int SIZE_COMMERCIAL_X = 1;
    public static final int SIZE_COMMERCIAL_Y = 1;
    public static final int SIZE_NUKESILO_X = 3;
    public static final int SIZE_NUKESILO_Y = 3;
    protected Cells cells = new Cells();
    protected int state = 0;
    protected long createdOn = System.currentTimeMillis();
    protected long updatedOn = System.currentTimeMillis();

    public void update(PlayerAbstract player) {
        if (this.state != 2) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.updatedOn >= (long)(1000 * this.getProductionTime() - 10 * this.getProductionTime() * player.getAccelerationFactor())) {
                this.updatedOn = currentTime;
                if (this.state == 1) {
                    player.updateProduction(this);
                }
            }
            if (this.state == 0 && currentTime - this.createdOn >= (long)(1000 * this.getConstructionTime() - 10 * this.getConstructionTime() * player.getAccelerationFactor())) {
                this.state = 1;
                player.updateConstruction(this);
            }
        }
    }

    public boolean isHit(int x, int y) {
        return this.cells.isHit(x, y);
    }

    public boolean isDestroyed() {
        if (this.cells.isDestroyed()) {
            this.state = 2;
            return true;
        }
        return false;
    }

    public Grid draw(Grid grid) {
        CellsIterator it = new CellsIterator(this.cells);
        while (it.hasNext()) {
            Cell cell = it.next();
            grid.setCell(cell.getType(), cell.getX(), cell.getY());
        }
        return grid;
    }

    public Cells getCells() {
        return this.cells;
    }

    public int getState() {
        if (this.state != 2) {
            this.isDestroyed();
        }
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public long getUpdatedOn() {
        return this.updatedOn;
    }

    public void setUpdatedOn(long updatedOn) {
        this.updatedOn = updatedOn;
    }

    public abstract int getType();

    public abstract int getEnergy();

    public abstract int getConstructionTime();

    public abstract int getConstructionCost();

    public abstract int getProductionType();

    public abstract int getProductionTime();

    public abstract Size getSize();
}

