/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.Grid;
import fr.uha.ensisa.ir.walther.milcityblue.core.Size;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.AirField;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.Commercial;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.Factory;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.House;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.Laboratory;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.MissileSilo;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.NukeSilo;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.PowerPlant;
import fr.uha.ensisa.ir.walther.milcityblue.core.buildings.ShieldGenerator;

public class BuildingFactory {
    private Grid grid;

    public BuildingFactory(Grid grid) {
        this.grid = grid;
    }

    public boolean canCreateBuilding(int type, int x, int y, int r) {
        Building building = this.typeToBuilding(type, x, y, r);
        return this.canCreateBuilding(building, x, y, r);
    }

    public boolean canCreateBuilding(Building building, int x, int y, int r) {
        return building.getSize().isFreeAt(this.grid, x, y, r);
    }

    public Building createBuilding(int type, int x, int y, int r) {
        Building building = this.typeToBuilding(type, x, y, r);
        if (building == null) {
            System.out.println("Unreconized building #" + type);
            return null;
        }
        if (!this.canCreateBuilding(building, x, y, r)) {
            System.out.println("Cannot create here");
            return null;
        }
        return building;
    }

    private Building typeToBuilding(int type, int x, int y, int r) {
        switch (type) {
            case 101: {
                return new MissileSilo(x, y, r);
            }
            case 102: {
                return new ShieldGenerator(x, y, r);
            }
            case 103: {
                return new PowerPlant(x, y, r);
            }
            case 104: {
                return new AirField(x, y, r);
            }
            case 105: {
                return new Laboratory(x, y, r);
            }
            case 106: {
                return new Factory(x, y, r);
            }
            case 107: {
                return new House(x, y, r);
            }
            case 108: {
                return new Commercial(x, y, r);
            }
            case 109: {
                return new NukeSilo(x, y, r);
            }
        }
        System.out.println("Unreconized building #" + type);
        return null;
    }

    public Size getSizeOfBuilding(int type) {
        return this.typeToBuilding(type, 0, 0, 0).getSize();
    }

    public int getCostOfBuilding(int type) {
        return this.typeToBuilding(type, 0, 0, 0).getConstructionCost();
    }

    public int getEnergyOfBuilding(int type) {
        return this.typeToBuilding(type, 0, 0, 0).getEnergy();
    }
}

