/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Engine;
import fr.uha.ensisa.ir.walther.milcityblue.core.GameListener;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerAbstract;
import fr.uha.ensisa.ir.walther.milcityblue.core.PlayerInterface;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Command;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Commander;
import fr.uha.ensisa.ir.walther.milcityblue.core.commands.Commands;
import java.util.Enumeration;
import java.util.Vector;

public class Game
implements Engine {
    private Vector players = new Vector(2, 1);
    private int localPlayerIndex = -1;
    private Commander commander = new Commander(this);
    private Engine engine = new Engine(){

        public void pause() {
        }

        public void resume() {
        }

        public void start() {
        }

        public void stop() {
        }
    };
    private GameListener gameListener = new GameListener(){

        public void notifyGameEvent(Game sender, byte eventType, int arg) {
        }
    };
    private int winnerIndex = -1;
    private int winnerScore = -1;
    private byte status = 0;
    public static final byte STATUS_INIT = 0;
    public static final byte STATUS_PLAY = 1;
    public static final byte STATUS_PAUSE = 2;
    public static final byte STATUS_END = 3;
    public static final byte STATUS_STOP = 4;

    public int registerLocalPlayer(PlayerAbstract localPlayer) {
        if (this.localPlayerIndex == -1) {
            this.players.addElement(localPlayer);
        } else {
            this.players.setElementAt(localPlayer, this.localPlayerIndex);
        }
        this.localPlayerIndex = this.players.indexOf(localPlayer);
        return this.localPlayerIndex;
    }

    public int registerRemotePlayer(PlayerInterface remotePlayer) {
        this.players.addElement(remotePlayer);
        remotePlayer.setPlayerIndex(this.players.indexOf(remotePlayer));
        return this.players.indexOf(remotePlayer);
    }

    public PlayerAbstract getLocalPlayer() {
        if (this.localPlayerIndex != -1) {
            return (PlayerAbstract)this.players.elementAt(this.localPlayerIndex);
        }
        return null;
    }

    public PlayerInterface getRemotePlayer(int remotePlayerIndex) {
        if (remotePlayerIndex >= 0 && remotePlayerIndex < this.players.size()) {
            return (PlayerInterface)this.players.elementAt(remotePlayerIndex);
        }
        return null;
    }

    public int getNumberOfPlayers() {
        return this.players.size();
    }

    public void removePlayer(int playerIndex) {
        if (playerIndex >= 0 && playerIndex < this.players.size()) {
            this.players.removeElementAt(playerIndex);
        }
    }

    public void removePlayer(PlayerInterface player) {
        this.players.removeElement(player);
    }

    public int getIndexOfPlayer(PlayerInterface player) {
        return this.players.indexOf(player);
    }

    public int getLocalPlayerIndex() {
        return this.localPlayerIndex;
    }

    public void execute(Commands commands) {
        this.commander.execute(commands);
    }

    public void execute(Command command) {
        this.commander.execute(command);
    }

    public void setStatus(byte status) {
        if (this.status == 0 && status == 1) {
            this.status = status;
            int i = 0;
            while (i < this.players.size()) {
                ((PlayerInterface)this.players.elementAt(i)).start();
                ++i;
            }
            this.engine.start();
            this.gameListener.notifyGameEvent(this, (byte)1, 0);
        } else {
            if (this.status == 2 && status == 1) {
                int i = 0;
                while (i < this.players.size()) {
                    ((PlayerInterface)this.players.elementAt(i)).start();
                    ++i;
                }
                this.engine.resume();
                this.gameListener.notifyGameEvent(this, (byte)3, 0);
            }
            if (status == 2 && this.status != 2) {
                this.engine.pause();
                this.gameListener.notifyGameEvent(this, (byte)2, 0);
            }
            if (status == 4 && this.status != 4) {
                this.engine.stop();
                this.gameListener.notifyGameEvent(this, (byte)4, 0);
            }
            if (status == 3 && this.status != 3) {
                this.engine.stop();
                this.gameListener.notifyGameEvent(this, (byte)5, 0);
            }
            if (this.status != status) {
                int commandType = 2;
                if (status == 2) {
                    commandType = 3;
                } else if (status == 3 || status == 4) {
                    commandType = 12;
                }
                Command command = new Command(this.localPlayerIndex, 200, commandType, new int[0]);
                if (this.isServer()) {
                    int playersCount = this.getNumberOfPlayers();
                    int i = 0;
                    while (i < playersCount) {
                        if (i != this.getServerIndex()) {
                            this.getRemotePlayer(i).sendCommand(command);
                        }
                        ++i;
                    }
                } else {
                    this.getRemotePlayer(this.getServerIndex()).sendCommand(command);
                }
            }
            this.status = status;
        }
    }

    public byte getStatus() {
        return this.status;
    }

    public PlayerInterface getPlayerAt(int playerIndex) {
        if (playerIndex >= 0 && playerIndex < this.players.size()) {
            return (PlayerInterface)this.players.elementAt(playerIndex);
        }
        return null;
    }

    public boolean isServer() {
        return this.localPlayerIndex == 0;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void pause() {
        this.setStatus((byte)2);
    }

    public void resume() {
        this.setStatus((byte)1);
    }

    public void start() {
        this.setStatus((byte)1);
    }

    public void stop() {
        this.setStatus((byte)4);
    }

    public void end() {
        this.setStatus((byte)3);
    }

    public int getServerIndex() {
        if (this.localPlayerIndex > 0) {
            return 0;
        }
        return -1;
    }

    public Enumeration getPlayers() {
        return this.players.elements();
    }

    public GameListener getGameListener() {
        return this.gameListener;
    }

    public void setGameListener(GameListener gameListener) {
        this.gameListener = gameListener;
    }

    public void vibrate(int ms) {
        this.gameListener.notifyGameEvent(this, (byte)10, ms);
    }

    public int getOtherPlayerIndex(int playerIndex) {
        if (playerIndex == 0) {
            return 1;
        }
        return 0;
    }

    public int getWinnerIndex() {
        return this.winnerIndex;
    }

    public void setWinnerIndex(int winnerIndex) {
        this.winnerIndex = winnerIndex;
    }

    public int getWinnerScore() {
        return this.winnerScore;
    }

    public void setWinnerScore(int winnerScore) {
        this.winnerScore = winnerScore;
    }
}

