/*
 * Decompiled with CFR 0.152.
 */
package fr.uha.ensisa.ir.walther.milcityblue.core;

import fr.uha.ensisa.ir.walther.milcityblue.core.Building;
import fr.uha.ensisa.ir.walther.milcityblue.core.BuildingFactory;
import fr.uha.ensisa.ir.walther.milcityblue.core.Buildings;
import fr.uha.ensisa.ir.walther.milcityblue.core.BuildingsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cell;
import fr.uha.ensisa.ir.walther.milcityblue.core.Cells;
import fr.uha.ensisa.ir.walther.milcityblue.core.CellsIterator;
import fr.uha.ensisa.ir.walther.milcityblue.core.WeaponFactory;

public class Grid {
    private int[][] grid;
    private Buildings buildings;
    private int maxX;
    private int maxY;
    private BuildingFactory buildingFactory;
    private WeaponFactory weaponFactory;
    private Cells shieldedCells;

    public Grid(int x, int y, int cellType) {
        this.grid = new int[x][y];
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                this.grid[i][j] = cellType;
                ++j;
            }
            ++i;
        }
        this.buildings = new Buildings();
        this.maxX = x;
        this.maxY = y;
        this.buildingFactory = new BuildingFactory(this);
        this.weaponFactory = new WeaponFactory(this);
        this.shieldedCells = new Cells();
    }

    public Grid(int x, int y, int[][] grid) {
        this.grid = new int[x][y];
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                this.grid[i][j] = grid[i][j];
                ++j;
            }
            ++i;
        }
        this.buildings = new Buildings();
        this.maxX = x;
        this.maxY = y;
        this.buildingFactory = new BuildingFactory(this);
        this.weaponFactory = new WeaponFactory(this);
        this.shieldedCells = new Cells();
    }

    public void setCell(int type, int x, int y) {
        if (x >= 0 && x < this.maxX && y >= 0 && y < this.maxY) {
            this.grid[x][y] = type;
        }
    }

    public int getCell(int x, int y) {
        if (x >= 0 && x < this.maxX && y >= 0 && y < this.maxY) {
            return this.grid[x][y];
        }
        return 0;
    }

    private boolean construct(Building building) {
        this.buildings.push(building);
        CellsIterator it = new CellsIterator(building.getCells());
        while (it.hasNext()) {
            Cell cell = it.next();
            this.setCell(3, cell.getX(), cell.getY());
        }
        return true;
    }

    public boolean construct(int type, int x, int y, int r) {
        Building building = this.buildingFactory.createBuilding(type, x, y, r);
        if (building == null) {
            return false;
        }
        return this.construct(building);
    }

    public boolean isHit(int x, int y) {
        if (this.grid[x][y] != 1 && this.grid[x][y] > 0 && this.grid[x][y] != 28 && this.grid[x][y] != 29) {
            return this.buildings.isHit(x, y);
        }
        return false;
    }

    public int countBuildingsType(int type) {
        int count = 0;
        BuildingsIterator it = new BuildingsIterator(this.buildings);
        while (it.hasNext()) {
            Building building = it.next();
            if (building.getType() != type || building.isDestroyed()) continue;
            ++count;
        }
        return count;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public String toWaterAndGrassMap() {
        StringBuffer tmp = new StringBuffer();
        int y = 0;
        while (y < this.maxY) {
            int x = 0;
            while (x < this.maxX) {
                switch (this.grid[x][y]) {
                    case 1: {
                        tmp.append('~');
                        break;
                    }
                    case 2: {
                        tmp.append('#');
                        break;
                    }
                    default: {
                        tmp.append('?');
                    }
                }
                ++x;
            }
            tmp.append("\n");
            ++y;
        }
        return tmp.toString();
    }

    public int[][] getGrid() {
        return this.grid;
    }

    public Buildings getBuildings() {
        return this.buildings;
    }

    public BuildingFactory getBuildingFactory() {
        return this.buildingFactory;
    }

    public WeaponFactory getWeaponFactory() {
        return this.weaponFactory;
    }

    public Cells getShieldedCells() {
        return this.shieldedCells;
    }

    public void setShieldedCells(Cells shieldedCells) {
        this.shieldedCells = shieldedCells;
    }
}

